/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bscfg.equipment;

import com.huawei.nglct.bscfg.equipment.TEBoardViewSlot;
import com.huawei.nglct.bscfg.equipment.TEConfigUtil;
import com.huawei.nglct.bscfg.equipment.TEEquipmentRecord;
import com.huawei.nglct.bscfg.equipment.TEInstallCPDependcyKey;
import com.huawei.nglct.bscfg.equipment.TEInstallCPDependcyRecord;
import com.huawei.nglct.bscfg.equipment.TENEIconKey;
import com.huawei.nglct.bscfg.equipment.TENENMCPTypeMapRecord;
import com.huawei.nglct.bscfg.equipment.TENENMSlotMapRecord;
import com.huawei.nglct.bscfg.installcp.TECPOccupySlot;
import com.huawei.nglct.bscfg.installcp.TEInstallCPKey;
import com.huawei.nglct.bscfg.installcp.TENECircuitPackInstall;
import com.huawei.nglct.cbb.pnp.TENEPNPMgr;
import com.huawei.nglct.cbb.pnp.TESDMgrInterface;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.mo.AID;
import com.huawei.nglct.mo.TENESubAIDRecord;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESDContianMOCount;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TEEquipmentDescription
implements TESDMgrInterface {
    private TIntObjectHashMap<List<TENESubAIDRecord>> m_subAID = new TIntObjectHashMap();
    private TIntObjectHashMap<TEEquipmentRecord> m_NEMap = new TIntObjectHashMap();
    private TIntArrayList alreadyInterTypeList = new TIntArrayList();
    private Map<TEInstallCPKey, List<TECPOccupySlot>> m_InstallCPMap = new Hashtable<TEInstallCPKey, List<TECPOccupySlot>>();
    private Map<TEInstallCPKey, List<TECPOccupySlot>> m_OccupyCPMap = new Hashtable<TEInstallCPKey, List<TECPOccupySlot>>();
    private Map<TENEIconKey, String> m_neIconMap = new Hashtable<TENEIconKey, String>();
    private Map<TEInstallCPDependcyKey, List<TEInstallCPDependcyRecord>> m_InstallCPDependcyMap = new Hashtable<TEInstallCPDependcyKey, List<TEInstallCPDependcyRecord>>();
    private TIntObjectHashMap<List<TENENMCPTypeMapRecord>> m_NENMCPTypeMap = new TIntObjectHashMap();
    private TIntObjectHashMap<List<TESDContianMOCount>> m_ContainMOMap = new TIntObjectHashMap();
    private List<TENENMSlotMapRecord> m_NENMSlotMapList = new ArrayList<TENENMSlotMapRecord>();
    private Map<TEInstallCPDependcyKey, TIntArrayList> m_SlotMap = new Hashtable<TEInstallCPDependcyKey, TIntArrayList>();
    private TIntIntHashMap m_Ver2NEMap = new TIntIntHashMap();
    private Map<TEInstallCPDependcyKey, TIntArrayList> m_NEVerMap = new Hashtable<TEInstallCPDependcyKey, TIntArrayList>();
    private Map<Integer, Map<Integer, List<TEBoardViewSlot>>> boardviewMap = new Hashtable<Integer, Map<Integer, List<TEBoardViewSlot>>>();
    private static TEEquipmentDescription instance = null;

    private TEEquipmentDescription() {
    }

    public static synchronized TEEquipmentDescription getInstance() {
        if (null == instance) {
            instance = new TEEquipmentDescription();
        }
        return instance;
    }

    public void addInstallCPRecord(int equipmentType, int shelfType, int cpType, List<TECPOccupySlot> record) {
        TEInstallCPKey key = new TEInstallCPKey(equipmentType, shelfType, cpType);
        if (this.m_InstallCPMap.containsKey(key)) {
            this.m_InstallCPMap.get(key).addAll(record);
        } else {
            this.m_InstallCPMap.put(key, record);
        }
    }

    public void addOccupyCPRecord(int equipmentType, int shelfType, int cpType, List<TECPOccupySlot> record) {
        TEInstallCPKey key = new TEInstallCPKey(equipmentType, shelfType, cpType);
        if (this.m_OccupyCPMap.containsKey(key)) {
            this.m_OccupyCPMap.get(key).addAll(record);
        } else {
            this.m_OccupyCPMap.put(key, record);
        }
    }

    public void addInstallCPDependcyRecord(int equipmentType, int shelfType, TEInstallCPDependcyRecord record) {
        List<Object> list = null;
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(equipmentType, shelfType);
        if (this.m_InstallCPDependcyMap.containsKey(key)) {
            list = this.m_InstallCPDependcyMap.get(key);
            list.add(record);
        } else {
            list = new ArrayList<TEInstallCPDependcyRecord>();
            list.add(record);
            this.m_InstallCPDependcyMap.put(key, list);
        }
    }

    public void addNENMSlotMapRecord(int equipmentType, int shelfType, int nmSlotID, int neSlotID, TIntArrayList cpTypeList) {
        TENENMSlotMapRecord record = new TENENMSlotMapRecord(equipmentType, shelfType, nmSlotID, neSlotID, cpTypeList);
        this.m_NENMSlotMapList.add(record);
    }

    public void addNENMTypeMapRecord(int equipmentType, int neCPType, int nmCPType) {
        List<TENENMCPTypeMapRecord> list = null;
        TENENMCPTypeMapRecord record = new TENENMCPTypeMapRecord(neCPType, nmCPType);
        if (this.m_NENMCPTypeMap.containsKey(equipmentType)) {
            list = (List)this.m_NENMCPTypeMap.get(equipmentType);
            list.add(record);
        } else {
            list = new ArrayList<TENENMCPTypeMapRecord>();
            list.add(record);
            this.m_NENMCPTypeMap.put(equipmentType, list);
        }
    }

    public void addNETypeRecord(int optixType, int platType) {
    }

    public void addMOCount(int equipmentType, String moName, int moCount) {
        List<TESDContianMOCount> list = null;
        TESDContianMOCount record = new TESDContianMOCount(moName, moCount);
        if (this.m_ContainMOMap.containsKey(equipmentType)) {
            list = (List)this.m_ContainMOMap.get(equipmentType);
            list.add(record);
        } else {
            list = new ArrayList<TESDContianMOCount>();
            list.add(record);
            this.m_ContainMOMap.put(equipmentType, list);
        }
    }

    public void addNERecord(TEEquipmentRecord record) {
        this.m_NEMap.put(record.m_NEType, (Object)record);
        int verKey = record.m_DefaultVer >> 16 & 0xFFFF;
        this.m_Ver2NEMap.put(verKey, record.m_NEType);
    }

    public void addInstallSlotList(int neType, int shelf, TIntArrayList slotList) {
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelf);
        this.m_SlotMap.put(key, slotList);
    }

    public void addSubAID(int neType, TENESubAIDRecord recorder) {
        if (this.m_subAID.containsKey(neType)) {
            ((List)this.m_subAID.get(neType)).add(recorder);
        } else {
            ArrayList<TENESubAIDRecord> list = new ArrayList<TENESubAIDRecord>();
            list.add(recorder);
            this.m_subAID.put(neType, list);
        }
    }

    public void addNEVerRecord(int neType, int shelf, int floor, int ceil) {
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelf);
        TIntArrayList list = null;
        if (this.m_NEVerMap.containsKey(key)) {
            list = this.m_NEVerMap.get(key);
            list.add(floor);
            list.add(ceil);
        } else {
            list = new TIntArrayList();
            list.add(floor);
            list.add(ceil);
            this.m_NEVerMap.put(key, list);
        }
    }

    public void addNEShelfIcon(int neType, int shelfType, String iconName) {
        this.m_neIconMap.put(new TENEIconKey(neType, shelfType), iconName);
    }

    public List<AID> getSubAID(int neType) {
        ArrayList<AID> listAID = new ArrayList<AID>();
        if (this.m_subAID.containsKey(neType)) {
            List list = (List)this.m_subAID.get(neType);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                listAID.add(((TENESubAIDRecord)list.get((int)i)).m_AID);
            }
        }
        return listAID;
    }

    public List<AID> getSubAID(int neType, int version) {
        ArrayList<AID> listAID = new ArrayList<AID>();
        if (this.m_subAID.containsKey(neType)) {
            TENESubAIDRecord record = null;
            List list = (List)this.m_subAID.get(neType);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                record = (TENESubAIDRecord)list.get(i);
                if (version < record.m_lVersionFrom || version >= record.m_lVersionTo) continue;
                listAID.add(record.m_AID);
            }
        }
        return listAID;
    }

    public boolean isValidEquipmentType(int neType) {
        this.loadEquipmentDes(neType);
        return this.m_NEMap.containsKey(neType);
    }

    public int getEquipmentClass(int equipType) {
        this.loadEquipmentDes(equipType);
        if (this.m_NEMap.containsKey(equipType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)equipType)).m_EquClass;
        }
        return 255;
    }

    public TIntArrayList getNEDomainList(int neType) {
        TIntArrayList domainList = new TIntArrayList();
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            domainList.add(((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_DomainList.toNativeArray());
        }
        return domainList;
    }

    public boolean isContainDomain(int neType, int speDomain) {
        return this.getNEDomainList(neType).contains(speDomain);
    }

    public String getTypeName(int neType) {
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_TypeName;
        }
        return "";
    }

    public String getTopoTypeName(int neType) {
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_topoTypeName;
        }
        return "";
    }

    public String getNEIcon(int neType, int shelfType) {
        TENEIconKey iconKey = new TENEIconKey(neType, shelfType);
        if (this.m_neIconMap.containsKey(iconKey)) {
            return this.m_neIconMap.get(iconKey);
        }
        iconKey = new TENEIconKey(neType, 255);
        if (this.m_neIconMap.containsKey(iconKey)) {
            return this.m_neIconMap.get(iconKey);
        }
        return this.getTypeName(neType);
    }

    public void getAllNESupportShelf(Map<Integer, List<Integer>> neToShelfMap) {
        Map<TENEIconKey, String> neIconMapRef = this.m_neIconMap;
        Map.Entry<TENEIconKey, String> entry2 = null;
        for (Map.Entry<TENEIconKey, String> entry2 : neIconMapRef.entrySet()) {
            List<Object> neShelfRef;
            TENEIconKey tmp = entry2.getKey();
            if (neToShelfMap.containsKey(tmp.getM_neType())) {
                neShelfRef = neToShelfMap.get(tmp.getM_neType());
                neShelfRef.add(tmp.getM_shelfType());
                continue;
            }
            neShelfRef = new ArrayList<Integer>();
            neShelfRef.add(tmp.getM_shelfType());
            neToShelfMap.put(tmp.getM_neType(), neShelfRef);
        }
    }

    public String getTypeDefineName(int neType) {
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_TypeDefineName;
        }
        return "";
    }

    public int getDefaultNEVer(int neType) {
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_DefaultVer;
        }
        return 0;
    }

    public int[] getDefaultShelfSCCSlot(int neType) {
        this.loadEquipmentDes(neType);
        int[] retValue = new int[4];
        if (this.m_NEMap.containsKey(neType)) {
            TEEquipmentRecord record = (TEEquipmentRecord)this.m_NEMap.get(neType);
            retValue[0] = 0;
            retValue[1] = record.m_DefaultShelf;
            retValue[2] = record.m_DefaultSCC;
            retValue[3] = record.m_DefalutSCCSlot;
            return retValue;
        }
        retValue[0] = 1090593054;
        return retValue;
    }

    public boolean validate(int equipmentType, int shelfType, int cpType, int slotID) {
        TEInstallCPKey key = new TEInstallCPKey(equipmentType, shelfType, cpType);
        if (!this.m_InstallCPMap.containsKey(key)) {
            key.setShelfType(255);
        }
        if (this.m_InstallCPMap.containsKey(key)) {
            List<TECPOccupySlot> slotList = this.m_InstallCPMap.get(key);
            int m = slotList.size();
            for (int i = 0; i < m; ++i) {
                if (slotList.get(i).getM_SlotID() != slotID) continue;
                return true;
            }
        }
        return false;
    }

    public int slotIDE2Qx(int neType, int shelfType, int ems, int cpType) {
        int qx = ems;
        TENENMSlotMapRecord record = null;
        int m = this.m_NENMSlotMapList.size();
        for (int i = 0; i < m; ++i) {
            record = this.m_NENMSlotMapList.get(i);
            if (neType != record.m_EquipmentType || shelfType != record.m_ShelfType || ems != record.m_NMSlotID || record.m_CPTypeList.size() != 0 && !record.m_CPTypeList.contains(cpType)) continue;
            qx = record.m_NESlotID;
            break;
        }
        return qx;
    }

    public int slotIDQx2E(int neType, int shelfType, int qx) {
        int ems = qx;
        TENENMSlotMapRecord record = null;
        int m = this.m_NENMSlotMapList.size();
        for (int i = 0; i < m; ++i) {
            record = this.m_NENMSlotMapList.get(i);
            if (neType != record.m_EquipmentType || shelfType != record.m_ShelfType || qx != record.m_NESlotID) continue;
            ems = record.m_NMSlotID;
            break;
        }
        return ems;
    }

    public int cpTypeNE2NM(int neType, int neCPType) {
        int nmCPType = neCPType;
        if (this.m_NENMCPTypeMap.containsKey(neType)) {
            TENENMCPTypeMapRecord record = null;
            List recordList = (List)this.m_NENMCPTypeMap.get(neType);
            int m = recordList.size();
            for (int i = 0; i < m; ++i) {
                record = (TENENMCPTypeMapRecord)recordList.get(i);
                if (record.m_NECPType != neCPType) continue;
                nmCPType = record.m_NMCPType;
                break;
            }
        }
        return nmCPType;
    }

    public int cpTypeNM2NE(int neType, int nmCPType) {
        int neCPType = nmCPType;
        if (this.m_NENMCPTypeMap.containsKey(neType)) {
            TENENMCPTypeMapRecord record = null;
            List recordList = (List)this.m_NENMCPTypeMap.get(neType);
            int m = recordList.size();
            for (int i = 0; i < m; ++i) {
                record = (TENENMCPTypeMapRecord)recordList.get(i);
                if (record.m_NMCPType != neCPType) continue;
                neCPType = record.m_NECPType;
                break;
            }
        }
        return neCPType;
    }

    public int getICPDependcyInfo(int neType, int shelfType, int icpSlotID, int icpType, int[] slot, int neID) {
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelfType);
        if (this.m_InstallCPDependcyMap.containsKey(key)) {
            TEInstallCPDependcyRecord record = null;
            List<TEInstallCPDependcyRecord> list = this.m_InstallCPDependcyMap.get(key);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                int pcpSlot;
                record = list.get(i);
                if (record.m_ICPSlot != icpSlotID || !record.m_ICPTypeList.contains(icpType)) continue;
                slot[0] = pcpSlot = record.m_PCPSlot;
                slot[1] = record.m_RelativeSlot;
                if (0 == neID) {
                    return 0;
                }
                int pcpType = TEConfigurationDataMgr.getInstance().getBoardType(neID, pcpSlot);
                if (pcpType == -1 || !record.m_PCPTypeList.contains(pcpType)) continue;
                return 0;
            }
        }
        return 1090593053;
    }

    public int getICPDependcyPCPList(int neType, int shelfType, int icpSlotID, int icpType, List<TEInstallCPDependcyRecord> pcpSlotVec) {
        int retCode = 0;
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelfType);
        if (this.m_InstallCPDependcyMap.containsKey(key)) {
            TEInstallCPDependcyRecord record = null;
            List<TEInstallCPDependcyRecord> list = this.m_InstallCPDependcyMap.get(key);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                record = list.get(i);
                if (!(record.m_ICPSlot == icpSlotID & record.m_ICPTypeList.contains(icpType))) continue;
                pcpSlotVec.add(record);
            }
        }
        if (pcpSlotVec.isEmpty()) {
            retCode = 1090593053;
        }
        return retCode;
    }

    public int[] getICPRelaSlot(int neType, int shelfType, int icpSlotID, int icpType, int pcpSlot) {
        int[] ret = new int[2];
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelfType);
        if (this.m_InstallCPDependcyMap.containsKey(key)) {
            TEInstallCPDependcyRecord record = null;
            List<TEInstallCPDependcyRecord> list = this.m_InstallCPDependcyMap.get(key);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                record = list.get(i);
                if (record.m_ICPSlot != icpSlotID || !record.m_ICPTypeList.contains(icpType) || pcpSlot != record.m_PCPSlot) continue;
                ret[0] = 0;
                ret[1] = record.m_RelativeSlot;
                return ret;
            }
        }
        ret[0] = 1090593053;
        return ret;
    }

    public int[] getICPSlot(int neType, int shelfType, int pcpSlot, int pcpType, int relaSlot) {
        int[] rValue = new int[2];
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelfType);
        if (this.m_InstallCPDependcyMap.containsKey(key)) {
            TEInstallCPDependcyRecord record = null;
            List<TEInstallCPDependcyRecord> list = this.m_InstallCPDependcyMap.get(key);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                record = list.get(i);
                if (record.m_PCPSlot != pcpSlot || pcpType != 0 && !record.m_PCPTypeList.contains(pcpType) || record.m_RelativeSlot != relaSlot) continue;
                rValue[0] = 0;
                rValue[1] = record.m_ICPSlot;
                return rValue;
            }
        }
        rValue[0] = 1090593053;
        return rValue;
    }

    public int getPCPInfo(int neType, int shelfType, int icpSlotID, int icpType, List<TENECircuitPackInstall> pcpList) {
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelfType);
        if (this.m_InstallCPDependcyMap.containsKey(key)) {
            TENECircuitPackInstall cp = null;
            TEInstallCPDependcyRecord record = null;
            List<TEInstallCPDependcyRecord> list = this.m_InstallCPDependcyMap.get(key);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                record = list.get(i);
                if (record.m_ICPSlot != icpSlotID || !record.m_ICPTypeList.contains(icpType)) continue;
                int n = record.m_PCPTypeList.size();
                for (int j = 0; j < n; ++j) {
                    cp = new TENECircuitPackInstall();
                    cp.setM_CircuitPackType(record.m_PCPTypeList.get(j));
                    cp.setM_SlotID(record.m_PCPSlot);
                    pcpList.add(cp);
                }
            }
        }
        if (pcpList.isEmpty()) {
            return 1090593053;
        }
        return 0;
    }

    public void getContainMONameList(int neType, List<String> strClassNameList) {
        strClassNameList.clear();
        if (this.m_ContainMOMap.containsKey(neType)) {
            TESDContianMOCount moCount = null;
            List list = (List)this.m_ContainMOMap.get(neType);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                moCount = (TESDContianMOCount)list.get(i);
                strClassNameList.add(moCount.moName);
            }
        }
    }

    public int getInstallSlotList(int neType, int shelfType, TIntArrayList slotList) {
        TEInstallCPDependcyKey key = new TEInstallCPDependcyKey(neType, shelfType);
        if (!this.m_SlotMap.containsKey(key)) {
            key.setM_shelfType(255);
        }
        if (this.m_SlotMap.containsKey(key)) {
            slotList.add(this.m_SlotMap.get(key).toNativeArray());
            return 0;
        }
        return 1090593054;
    }

    public boolean isNESupportIDModify(int neType) {
        this.loadEquipmentDes(neType);
        boolean isSupport = false;
        if (this.m_NEMap.containsKey(neType)) {
            isSupport = ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_NEIDModifiable;
        }
        return isSupport;
    }

    public boolean isNECanBeUsedBYONE(int neType) {
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_BeUsedBYONE;
        }
        return false;
    }

    public int getSlotRelation(int neType) {
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_SlotRelation;
        }
        return 0;
    }

    public boolean getDefaultInfoFromVer(int ver, int[] rValue) {
        int neType = 2047;
        int shelf = 255;
        HashSet<Integer> neTypeSet = new HashSet<Integer>();
        TIntArrayList list = null;
        Map.Entry<TEInstallCPDependcyKey, TIntArrayList> entry2 = null;
        for (Map.Entry<TEInstallCPDependcyKey, TIntArrayList> entry2 : this.m_NEVerMap.entrySet()) {
            list = entry2.getValue();
            int m = list.size();
            for (int i = 0; i < m; i += 2) {
                if (ver < list.get(i) || ver > list.get(i + 1)) continue;
                neTypeSet.add(entry2.getKey().getM_neType());
                neType = entry2.getKey().getM_neType();
                shelf = entry2.getKey().getM_shelfType();
            }
        }
        if (neTypeSet.size() == 1) {
            rValue[0] = neType;
            rValue[1] = shelf;
            return true;
        }
        rValue[0] = 2047;
        rValue[1] = 255;
        return false;
    }

    public boolean isVersionValid(int neType, int ver) {
        Map.Entry<TEInstallCPDependcyKey, TIntArrayList> entry2 = null;
        for (Map.Entry<TEInstallCPDependcyKey, TIntArrayList> entry2 : this.m_NEVerMap.entrySet()) {
            if (neType != entry2.getKey().getM_neType()) continue;
            TIntArrayList list = entry2.getValue();
            int m = list.size();
            for (int i = 0; i < m; i += 2) {
                if (ver < list.get(i) || ver > list.get(i + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public int getInstallSlotByCPType(int equipmentType, int shelfType, int cpType, List<TECPOccupySlot> occupySlotList) {
        this.loadEquipmentDes(equipmentType);
        occupySlotList.clear();
        TEInstallCPKey key = new TEInstallCPKey(equipmentType, shelfType, cpType);
        if (!this.m_InstallCPMap.containsKey(key)) {
            key.setShelfType(255);
        }
        if (this.m_InstallCPMap.containsKey(key)) {
            occupySlotList.addAll((Collection<TECPOccupySlot>)this.m_InstallCPMap.get(key));
            return 0;
        }
        return 1090593579;
    }

    public int getOccupySlotByCPType(int equipmentType, int shelfType, int cpType, List<TECPOccupySlot> occupySlotList) {
        TEInstallCPKey key = new TEInstallCPKey(equipmentType, shelfType, cpType);
        if (!this.m_OccupyCPMap.containsKey(key)) {
            key.setShelfType(255);
        }
        if (this.m_OccupyCPMap.containsKey(key)) {
            occupySlotList.addAll((Collection<TECPOccupySlot>)this.m_OccupyCPMap.get(key));
            return 0;
        }
        return 1090593054;
    }

    public TIntObjectHashMap<TECPOccupySlot> getInstallCPsBySlot(int equipmentType, int shelfType, int slotID, int neVersion) {
        TIntObjectHashMap occupyCPs = new TIntObjectHashMap();
        TEInstallCPKey cpKey = null;
        List<TECPOccupySlot> occupySlotList = null;
        TECPOccupySlot occupySlot = null;
        Map.Entry<TEInstallCPKey, List<TECPOccupySlot>> entry2 = null;
        for (Map.Entry<TEInstallCPKey, List<TECPOccupySlot>> entry2 : this.m_InstallCPMap.entrySet()) {
            cpKey = entry2.getKey();
            occupySlotList = entry2.getValue();
            if (cpKey.getEquipmentType() != equipmentType || cpKey.getShelfType() != shelfType && cpKey.getShelfType() != 255) continue;
            int m = occupySlotList.size();
            for (int i = 0; i < m; ++i) {
                occupySlot = occupySlotList.get(i);
                if (occupySlot.getM_SlotID() != slotID || !occupySlot.isWithInRange(neVersion)) continue;
                occupyCPs.put(cpKey.getCPType(), (Object)occupySlot);
            }
        }
        return occupyCPs;
    }

    public void getInstallCPTypeBySlot(int equipmentType, int shelfType, int slotID, TIntArrayList cpTypeList1) {
        cpTypeList1.clear();
        TEInstallCPKey cpKey = null;
        List<TECPOccupySlot> occupySlotList = null;
        TECPOccupySlot occupySlot = null;
        Map.Entry<TEInstallCPKey, List<TECPOccupySlot>> entry2 = null;
        for (Map.Entry<TEInstallCPKey, List<TECPOccupySlot>> entry2 : this.m_InstallCPMap.entrySet()) {
            cpKey = entry2.getKey();
            occupySlotList = entry2.getValue();
            if (cpKey.getEquipmentType() != equipmentType || cpKey.getShelfType() != shelfType && cpKey.getShelfType() != 255) continue;
            int m = occupySlotList.size();
            for (int i = 0; i < m; ++i) {
                occupySlot = occupySlotList.get(i);
                if (occupySlot.getM_SlotID() != slotID) continue;
                cpTypeList1.add(cpKey.getCPType());
            }
        }
        if (cpTypeList1.size() > 0) {
            TreeMap<String, Integer> brdMap = new TreeMap<String, Integer>();
            String tmpName = "";
            int n = cpTypeList1.size();
            for (int j = 0; j < n; ++j) {
                int cpType = cpTypeList1.get(j);
                tmpName = TECircuitPackDescription.getInstance().getTypeName(cpType);
                brdMap.put(tmpName, cpType);
            }
            cpTypeList1.clear();
            Iterator it = brdMap.entrySet().iterator();
            while (it.hasNext()) {
                cpTypeList1.add(((Integer)it.next().getValue()).intValue());
            }
        }
    }

    public void getOccupyCPTypeBySlot(int equipmentType, int shelfType, int slotID, TIntArrayList cpTypeList) {
        cpTypeList.clear();
        TEInstallCPKey cpKey = null;
        List<TECPOccupySlot> occupySlotList = null;
        TECPOccupySlot occupySlot = null;
        Map.Entry<TEInstallCPKey, List<TECPOccupySlot>> entry2 = null;
        for (Map.Entry<TEInstallCPKey, List<TECPOccupySlot>> entry2 : this.m_OccupyCPMap.entrySet()) {
            cpKey = entry2.getKey();
            occupySlotList = entry2.getValue();
            if (cpKey.getEquipmentType() != equipmentType || cpKey.getShelfType() != shelfType && cpKey.getShelfType() != 255) continue;
            int m = occupySlotList.size();
            for (int i = 0; i < m; ++i) {
                occupySlot = occupySlotList.get(i);
                if (occupySlot.getM_SlotID() != slotID) continue;
                cpTypeList.add(cpKey.getCPType());
            }
        }
        if (cpTypeList.size() > 0) {
            TreeMap<String, Integer> brdMap = new TreeMap<String, Integer>();
            String tmpName = "";
            int n = cpTypeList.size();
            for (int j = 0; j < n; ++j) {
                int cpType = cpTypeList.get(j);
                tmpName = TECircuitPackDescription.getInstance().getTypeName(cpType);
                brdMap.put(tmpName, cpType);
            }
            cpTypeList.clear();
            Iterator it = brdMap.entrySet().iterator();
            while (it.hasNext()) {
                cpTypeList.add(((Integer)it.next().getValue()).intValue());
            }
        }
    }

    public int getInstallICPPortList(int neID, int icpType, int icpSlot, List<TEInstallCPPortRecord> portList) {
        int retCode = 0;
        int[] rValue = TEConfigUtil.getNEPara(neID);
        if (0 != rValue[0]) {
            return 1090646274;
        }
        int neType = rValue[1];
        int shelfType = rValue[2];
        int[] slotes = new int[2];
        portList.clear();
        retCode = this.getICPDependcyInfo(neType, shelfType, icpSlot, icpType, slotes, 0);
        if (retCode != 0) {
            return retCode;
        }
        int relativeSlot = slotes[1];
        int pcpType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotes[0]);
        int[] startPortID = new int[]{0};
        retCode = TECircuitPackDescription.getInstance().getICPStartPortID(pcpType, icpType, relativeSlot, startPortID);
        if (retCode != 0) {
            return retCode;
        }
        portList = TECircuitPackDescription.getInstance().getInstallCPPort(icpType);
        TEInstallCPPortRecord record = null;
        int m = portList.size();
        for (int i = 0; i < m; ++i) {
            record = portList.get(i);
            int n = record.portIDList.size();
            for (int j = 0; j < n; ++j) {
                int portID = (Integer)record.portIDList.get(j);
                record.portIDList.set(j, portID + startPortID[0]);
            }
        }
        return 0;
    }

    public int getInstallSlotByCPType(int neID, int cpType, List<TECPOccupySlot> occupySlotList) {
        int[] ret = TEConfigUtil.getNEPara(neID);
        if (0 != ret[0]) {
            return ret[0];
        }
        return this.getInstallSlotByCPType(ret[1], ret[2], cpType, occupySlotList);
    }

    public int[] cpTypeNE2NMByNEID(int neID, int neCPType) {
        int[] ret = TEConfigUtil.getNEType(neID);
        if (0 != ret[0]) {
            return ret;
        }
        int nmCPType = neCPType;
        int neType = ret[1];
        if (this.m_NENMCPTypeMap.containsKey(neType)) {
            TENENMCPTypeMapRecord record = null;
            List list = (List)this.m_NENMCPTypeMap.get(neType);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                record = (TENENMCPTypeMapRecord)list.get(i);
                if (record.m_NECPType != neCPType) continue;
                nmCPType = record.m_NMCPType;
                break;
            }
        }
        ret[1] = nmCPType;
        return ret;
    }

    public int[] cpTypeNM2NEByNEID(int neID, int nmCPType) {
        int[] ret = TEConfigUtil.getNEType(neID);
        if (0 != ret[0]) {
            return ret;
        }
        int neCPType = nmCPType;
        int neType = ret[1];
        if (this.m_NENMCPTypeMap.containsKey(neType)) {
            TENENMCPTypeMapRecord record = null;
            List list = (List)this.m_NENMCPTypeMap.get(neType);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                record = (TENENMCPTypeMapRecord)list.get(i);
                if (record.m_NMCPType != nmCPType) continue;
                neCPType = record.m_NECPType;
                break;
            }
        }
        ret[1] = neCPType;
        return ret;
    }

    public int getCPTypeFromName(String strCPName, int neID, int slotID) {
        int[] rValue = TEConfigUtil.getNEPara(neID);
        if (0 != rValue[0]) {
            return 0;
        }
        int neType = rValue[1];
        int shelfType = rValue[2];
        String strBoardName = "";
        TIntArrayList cpTypeList = new TIntArrayList();
        this.getInstallCPTypeBySlot(neType, shelfType, slotID, cpTypeList);
        TECircuitPackDescription pCPD = TECircuitPackDescription.getInstance();
        int m = cpTypeList.size();
        for (int i = 0; i < m; ++i) {
            strBoardName = pCPD.getTypeName(cpTypeList.get(i));
            if (!strBoardName.equalsIgnoreCase(strCPName)) continue;
            return cpTypeList.get(i);
        }
        return 0;
    }

    public boolean isSupportSlaveShelf(int neType) {
        this.loadEquipmentDes(neType);
        if (this.m_NEMap.containsKey(neType)) {
            return ((TEEquipmentRecord)this.m_NEMap.get((int)neType)).m_bSupportSlaveShelf;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEquipmentDes(int logicNEType) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        TIntObjectHashMap<TEEquipmentRecord> tIntObjectHashMap = this.m_NEMap;
        synchronized (tIntObjectHashMap) {
            if (!this.m_NEMap.containsKey(logicNEType)) {
                int neType = TEGetNEDomainVersion.getInstance().getNeType(logicNEType);
                if (0 == neType || -1 == neType) {
                    return;
                }
                this.alreadyInterTypeList.add(logicNEType);
                String domainName = TEGetNEDomainVersion.getInstance().getDomain(neType);
                String fileName = TEResourceManager.getPath() + "nemgr/device/" + domainName + "/ne_" + neType + "/conf/ne_" + neType + ".xml";
                String bundleName = TEGetNEDomainVersion.getInstance().getBundleName(neType);
                TENEPNPMgr.getInstance().addNEFile(fileName);
                SDXMLInterpreterMgr.getInstance().parseXMLFile(bundleName, fileName);
            }
        }
    }

    public boolean isDeviceConfIntered(int neLogicType) {
        boolean intered;
        boolean bl = intered = !TESysManagerBean.getInstance().isIntegratedStatus();
        if (!intered) {
            intered = this.alreadyInterTypeList.contains(neLogicType);
        }
        return intered;
    }

    public String getDeviceTypeName(int netype) {
        String deviceTypeStr = "";
        String dtPath = TEPathManager.RESOURCE_PROFILE_PATH + "devicetype.ini";
        TEResourceUtil res = TEResourceUtil.getInstance(dtPath);
        deviceTypeStr = res.getString(String.valueOf(netype));
        if (netype > 0 && String.valueOf(netype).equals(deviceTypeStr)) {
            deviceTypeStr = this.getTopoTypeName(TEGetNEDomainVersion.getInstance().getDevType(netype));
        }
        return deviceTypeStr;
    }

    public Map<Integer, Map<Integer, List<TEBoardViewSlot>>> getBoardviewMap() {
        return this.boardviewMap;
    }

    public void setBoardviewMap(Map<Integer, Map<Integer, List<TEBoardViewSlot>>> boardviewMap) {
        this.boardviewMap = boardviewMap;
    }

    public List<TEBoardViewSlot> getBoardView(int neType, int shelfType) {
        List<TEBoardViewSlot> boardViewList = null;
        Map<Integer, List<TEBoardViewSlot>> shelfBoardViewMap = this.boardviewMap.get(neType);
        if (shelfBoardViewMap != null) {
            boardViewList = shelfBoardViewMap.get(shelfType);
        }
        return boardViewList;
    }

    @Override
    public void clear() {
        this.alreadyInterTypeList.clear();
        this.m_NEMap.clear();
        this.m_InstallCPMap.clear();
        this.m_OccupyCPMap.clear();
        this.m_neIconMap.clear();
        this.m_InstallCPDependcyMap.clear();
        this.m_NENMCPTypeMap.clear();
        this.m_ContainMOMap.clear();
        this.m_NENMSlotMapList.clear();
        this.m_SlotMap.clear();
        this.m_Ver2NEMap.clear();
        this.boardviewMap.clear();
    }
}

