/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bscfg.equipment;

import com.huawei.nglct.bscfg.TEIndexOfNEID;
import com.huawei.nglct.bscfg.TENEIDType;
import com.huawei.nglct.bscfg.equipment.TECommuMgr;
import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.bscfg.equipment.TENEVerChgEvtPrm;
import com.huawei.nglct.bscfg.equipment.iMAPNECommuInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.event.EventManager;
import com.huawei.nglct.core.necoordinator.TENEIDCacheMgr;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.util.convertor.TEVersionConvertUtil;
import gnu.trove.TIntArrayList;

public class TEConfigUtil {
    public static boolean isVNE(int type) {
        return type == 1894;
    }

    public static boolean isSDHNE(int type) {
        return TEConfigUtil.isNEInDomain(type, 1);
    }

    public static boolean isSONETNE(int type) {
        return TEConfigUtil.isNEInDomain(type, 2);
    }

    public static boolean IsDWDMNEShelf(int neType) {
        return TEConfigUtil.isNEInDomain(neType, 3);
    }

    public static boolean IsNECanBeUsedBYONE(int type) {
        return TEEquipmentDescription.getInstance().isNECanBeUsedBYONE(type);
    }

    public static boolean IsTL1NE(int neID) {
        int phyID = TENEIDCacheMgr.getInstance().getPhyID(neID);
        return 0 != (phyID & 0x4000000);
    }

    public static boolean IsGateWay(int neID) {
        int phyID = TENEIDCacheMgr.getInstance().getPhyID(neID);
        iMAPNECommuInfo neCommuInfo = new iMAPNECommuInfo();
        TECommuMgr.getInstance().getNeCommuInfo(phyID, neCommuInfo, false, false);
        return neCommuInfo.m_nGateWayType != 0;
    }

    public static boolean isNEInDomain(int type, int domain) {
        TIntArrayList domainList = TEEquipmentDescription.getInstance().getNEDomainList(type);
        return domainList.contains(domain);
    }

    public static boolean isInEquipmentClass(int equipType, int equipClass) {
        return TEEquipmentDescription.getInstance().getEquipmentClass(equipType) == equipClass;
    }

    public static String[] getNEName(int neID) {
        String[] ret = new String[2];
        int retCode = 0;
        String sName = "";
        TENEPO pNE = (TENEPO)CommonDaoService.getById(TENEPO.class, new Integer(neID));
        if (null == pNE) {
            retCode = 1090646281;
        } else {
            sName = pNE.getName();
        }
        ret[0] = String.valueOf(retCode);
        ret[1] = sName;
        return ret;
    }

    public static int[] getNEType(int neID) {
        int[] ret = new int[2];
        int retCode = 0;
        int neType = 2047;
        TENEIDType neIDType = TEIndexOfNEID.getInstance().getValue(neID);
        if (null == neIDType) {
            retCode = 1090646281;
        } else {
            neType = neIDType.getNeType();
        }
        ret[0] = retCode;
        ret[1] = neType;
        return ret;
    }

    public static int[] getNEPara(int neID) {
        int[] result = new int[4];
        result[0] = 0;
        TENEPO pNE = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
        if (null != pNE) {
            result[1] = pNE.getType();
            result[2] = pNE.getShelfType();
            result[3] = pNE.getVersion();
        } else {
            result[0] = 0x41010001;
        }
        return result;
    }

    public static boolean isPreConfigNe(int neID) {
        boolean bIsPre = false;
        TENEPO pNE = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
        if (pNE != null) {
            bIsPre = pNE.isPreConfig();
        }
        return bIsPre;
    }

    public static boolean isCPInDomain(TECircuitPack cp, int domain) {
        if (cp == null) {
            return false;
        }
        TIntArrayList fbs = new TIntArrayList();
        TEFuncBlockDescription.getInstance().getDomainContainFB(domain, fbs);
        int m = fbs.size();
        for (int i = 0; i < m; ++i) {
            if (!cp.isSupportFB(fbs.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTENEExist(int nNEID) {
        int devID = TENEIDCacheMgr.getInstance().getDevID(nNEID);
        return devID != 0;
    }

    public static int getNEVersion(int neID) {
        TENEPO pNE = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(neID));
        if (pNE != null) {
            return pNE.getVersion();
        }
        return 0;
    }

    public static void setNEVersion(int neVersion, int neID) {
        TENEPO pNE;
        int devID;
        if (neVersion == 0 || neVersion == TEVersionConvertUtil.never(4, 0, 0, 0) || neVersion == TEVersionConvertUtil.never(5, 0, 0, 0)) {
            TELogFactory.getNormalLogger().error("ERROR - TEConfigUtil.setNEVersion with version: " + neVersion);
        }
        if ((devID = TENEIDCacheMgr.getInstance().getDevID(neID)) == 0) {
            devID = neID;
        }
        if (null != (pNE = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(devID))) && !pNE.isPreConfig() && pNE.getVersion() != neVersion && (2047 == pNE.getType() || 256 == pNE.getType() || TEEquipmentDescription.getInstance().isVersionValid(pNE.getType(), neVersion))) {
            int oldVER = pNE.getVersion();
            TENEVerChgEvtPrm pParam = new TENEVerChgEvtPrm();
            pParam.m_neID = neID;
            pParam.m_eEquipType = pNE.getType();
            pParam.m_oldVER = oldVER;
            pParam.m_newVER = neVersion;
            EventManager.getInstance().postEvent(new Event(185, 0, pParam));
        }
    }

    public static int getNeProtocolType(int neID) {
        int eProtocal = -1;
        eProtocal = (neID & 0x4000000) != 0 ? 10 : 3;
        return eProtocal;
    }
}

