/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bscfg.equipment;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.bscfg.commutype.SAppSetAutoParaReq;
import com.huawei.nglct.bscfg.commutype.SNeLoginItem;
import com.huawei.nglct.bscfg.commutype.SNeLoginStateSyn;
import com.huawei.nglct.bscfg.equipment.BakGneCommuState;
import com.huawei.nglct.bscfg.equipment.SCommuNeData;
import com.huawei.nglct.bscfg.equipment.SOneReturn;
import com.huawei.nglct.bscfg.equipment.TECommuGlobal;
import com.huawei.nglct.bscfg.equipment.TEConfigUtil;
import com.huawei.nglct.bscfg.equipment.TEGneConnStateEvent;
import com.huawei.nglct.bscfg.equipment.TENEStateChangedMgr;
import com.huawei.nglct.bscfg.equipment.iMAPNECommuInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.necommu.TEBakGneCommuState;
import com.huawei.nglct.cbb.necommu.TECommuUtil;
import com.huawei.nglct.consts.system.TESystemVariable;
import com.huawei.nglct.core.communication.DebugTracer;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.event.EventManager;
import com.huawei.nglct.core.mdp.TECommUtil;
import com.huawei.nglct.core.necoordinator.SPParameter;
import com.huawei.nglct.core.necoordinator.TENEIDCacheMgr;
import com.huawei.nglct.core.necoordinator.TENESPTransaction;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.core.neproxy.TEProxyUtil;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.core.taskmgr.TEAppMgr;
import com.huawei.nglct.core.taskmgr.TEITaskMgrConts;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.NECommuStateNoticeReceiver;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.dcn.AsnCommuNeTestReq;
import com.huawei.nglct.nemgr.f_interface.emf.common.AsnIntID;
import com.huawei.nglct.po.TECommuNe;
import com.huawei.nglct.po.TEEthGne;
import com.huawei.nglct.po.TEGne;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.NEStateNoticeHandle;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntIterator;
import gnu.trove.TIntObjectHashMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.commustru.fstru.FStruct;

public class TECommuMgr {
    private static TECommuMgr instance = null;
    private TIntIntHashMap m_mapGneUsed = new TIntIntHashMap();
    private Lock m_mutexMapGneUsed = new ReentrantLock();
    public TIntArrayList m_listLoginningNE = new TIntArrayList();
    public Lock m_mutexLoginNEList = new ReentrantLock();
    public TIntArrayList m_listLoginReqNEs = new TIntArrayList();
    public Lock m_mutexLoginReqNEs = new ReentrantLock();
    private Lock m_MutexMapBakGneState = new ReentrantLock();
    private TIntObjectHashMap<BakGneCommuState> m_MapBakGneCommuState = new TIntObjectHashMap();

    private TECommuMgr() {
    }

    public static synchronized TECommuMgr getInstance() {
        if (null == instance) {
            instance = new TECommuMgr();
        }
        return instance;
    }

    private static int getHandleByNeId(int ulNeId) {
        int handle = 0;
        TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNE(ulNeId);
        if (pCommuNe == null) {
            return handle;
        }
        int ulGneId = pCommuNe.getCurGneId();
        if (ulGneId == -1) {
            return handle;
        }
        handle = TECommuMgr.GetGneHandle(ulGneId, 0);
        if (handle == 0) {
            pCommuNe.setConnState(ulGneId, 2);
        }
        return handle;
    }

    private static int GetGneHandle(int ulGneId, int nType) {
        TEProcID procID;
        int handle = -1;
        int ulNeId = TENEIDCacheMgr.getInstance().getDevID(ulGneId);
        int result = TEProxyUtil.getProcessInfoFromNEID(ulNeId, procID = new TEProcID());
        if (0 == result) {
            handle = procID.getProcHandle().charValue();
        }
        return handle;
    }

    public int getNeCommuInfo(int ulNeId, iMAPNECommuInfo neCommuInfo, boolean bGetLogicGneid, boolean bIsLogicNeId) {
        TEGne pGne;
        int ulPhyNeId = ulNeId;
        if (bIsLogicNeId && 0 == (ulPhyNeId = TENEIDCacheMgr.getInstance().getPhyID(ulNeId))) {
            return 1090646020;
        }
        neCommuInfo.m_nGateWayType = 0;
        neCommuInfo.m_ulComBaudrate = 1200;
        neCommuInfo.m_ucGneToNMCom = 0;
        neCommuInfo.m_GneID = 0;
        neCommuInfo.m_ulIPAddress = 0L;
        neCommuInfo.m_usIPPort = 0;
        neCommuInfo.m_strTP4Address = "";
        neCommuInfo.m_strTP4SAP = "";
        TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNeByPhyID(ulPhyNeId);
        if (null == pCommuNe) {
            return 1090609156;
        }
        neCommuInfo.m_GneID = pCommuNe.getCurGneId();
        neCommuInfo.m_LogicGneID = 0;
        if (0 != neCommuInfo.m_GneID && bGetLogicGneid) {
            neCommuInfo.m_LogicGneID = TENEIDCacheMgr.getInstance().getDevID(neCommuInfo.m_GneID);
            if (0 == neCommuInfo.m_LogicGneID) {
                return 1090646020;
            }
        }
        if (null != (pGne = this.getGne(ulPhyNeId))) {
            switch (pGne.getGneType()) {
                case 1: {
                    neCommuInfo.m_nGateWayType = 1;
                    neCommuInfo.m_ulIPAddress = ((TEEthGne)pGne).getIp();
                    neCommuInfo.m_usIPPort = ((TEEthGne)pGne).getPort();
                    break;
                }
                case 2: {
                    neCommuInfo.m_nGateWayType = 2;
                    break;
                }
                case 3: {
                    neCommuInfo.m_nGateWayType = 3;
                    break;
                }
            }
        }
        return 0;
    }

    public boolean getNeCommuAndLoginState(int ulNeId, boolean[] commuLogin) {
        boolean bCommuOk = false;
        boolean bLoginOK = false;
        if (TEConfigUtil.isPreConfigNe(ulNeId)) {
            bCommuOk = true;
            bLoginOK = true;
            commuLogin[0] = bCommuOk;
            commuLogin[1] = bLoginOK;
            return true;
        }
        boolean bRtn = false;
        int handle = TECommuMgr.getHandleByNeId(ulNeId);
        if (handle == 0) {
            commuLogin[0] = bCommuOk;
            commuLogin[1] = bLoginOK;
            return true;
        }
        TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNE(ulNeId);
        bCommuOk = 1 == pCommuNe.getCurConnState();
        bLoginOK = pCommuNe.getLogined() > 0;
        bRtn = true;
        if (!bCommuOk && bLoginOK) {
            bLoginOK = false;
            bRtn = false;
        }
        commuLogin[0] = bCommuOk;
        commuLogin[1] = bLoginOK;
        return bRtn;
    }

    public int deleteCommuNe(int ulNeId) {
        TECommuNe pCommuNe = (TECommuNe)CommonDaoService.getById(TECommuNe.class, Integer.valueOf(ulNeId));
        if (pCommuNe == null) {
            return 1090609156;
        }
        int ulMainGneId = pCommuNe.getMainGneId();
        int ulBak1GneId = pCommuNe.getBackup1gneId();
        int ulBak2GneId = pCommuNe.getBackup2gneId();
        int ulBak3GneId = pCommuNe.getBackup3gneId();
        int errorCode = CommonDaoService.delete(pCommuNe);
        if (errorCode != 0) {
            return 1090609163;
        }
        TECommuNEMgr.getInstance().deleteCommuNE(ulNeId);
        this.UpdateGneUsedCount(ulMainGneId, -1);
        this.UpdateGneUsedCount(ulBak1GneId, -1);
        this.UpdateGneUsedCount(ulBak2GneId, -1);
        this.UpdateGneUsedCount(ulBak3GneId, -1);
        ArrayList<Integer> lstGneId = new ArrayList<Integer>();
        lstGneId.add(ulMainGneId);
        lstGneId.add(ulBak1GneId);
        lstGneId.add(ulBak2GneId);
        lstGneId.add(ulBak3GneId);
        this.delUnusedGne(lstGneId);
        this.GneSocketResumeRpt(ulNeId);
        return 0;
    }

    public int deleteGne(int ulNeId, int nType, boolean bIsLogicNeId) {
        int ulPhyNeId = ulNeId;
        if (bIsLogicNeId && 0 == (ulPhyNeId = TECommuGlobal.CommuNePhyIDandDevIDConvert(ulNeId, bIsLogicNeId, true))) {
            return 1090609157;
        }
        TEEthGne pGne = (TEEthGne)CommonDaoService.getById(TEEthGne.class, Integer.valueOf(ulPhyNeId));
        if (pGne == null) {
            return 1090609157;
        }
        int errorCode = CommonDaoService.delete(pGne);
        if (errorCode != 0) {
            return 1090609162;
        }
        pGne.setGneIfOnDelete(true);
        this.SetRelatedNeConnectState(ulPhyNeId, false, false);
        this.deleteGneMaintain(ulPhyNeId, nType);
        this.delNoExistGneFromGneMap(ulPhyNeId);
        this.GneSocketResumeRpt(ulPhyNeId);
        return 0;
    }

    public int deleteNe(int ulNeId) {
        int errorCode = this.deleteCommuNe(ulNeId);
        if (errorCode != 0 && errorCode != 1090609156) {
            return errorCode;
        }
        return this.deleteGne(ulNeId, 0, true);
    }

    public void deleteGneMaintain(int ulGneId, int nType) {
        if (nType != 0) {
            return;
        }
        Collection commuNes = TECommuNEMgr.getInstance().getAllCommuNE();
        if (commuNes != null) {
            TECommuNe pCommuNe2 = null;
            for (TECommuNe pCommuNe2 : commuNes) {
                if (pCommuNe2.getMainGneId() == ulGneId) {
                    pCommuNe2.setMainGneId(-1);
                    pCommuNe2.setMainConnState(2);
                    pCommuNe2.setMainUnReachTimeCount(0);
                    if (pCommuNe2.getNeGneState() == 0) {
                        pCommuNe2.setNeGneState(4);
                    }
                }
                if (pCommuNe2.getBackup1gneId() == ulGneId) {
                    pCommuNe2.setBackup1gneId(-1);
                    pCommuNe2.setBackupConnState(2, 1);
                    pCommuNe2.setBackupUnReachTimeCount(0, 1);
                    if (pCommuNe2.getNeGneState() == 1) {
                        pCommuNe2.setNeGneState(4);
                    }
                }
                if (pCommuNe2.getBackup2gneId() == ulGneId) {
                    pCommuNe2.setBackup2gneId(-1);
                    pCommuNe2.setBackupConnState(2, 2);
                    pCommuNe2.setBackupUnReachTimeCount(0, 2);
                    if (pCommuNe2.getNeGneState() == 2) {
                        pCommuNe2.setNeGneState(4);
                    }
                }
                if (pCommuNe2.getBackup3gneId() == ulGneId) {
                    pCommuNe2.setBackup3gneId(-1);
                    pCommuNe2.setBackupConnState(2, 3);
                    pCommuNe2.setBackupUnReachTimeCount(0, 3);
                    if (pCommuNe2.getNeGneState() == 3) {
                        pCommuNe2.setNeGneState(4);
                    }
                }
                CommonDaoService.update(pCommuNe2);
            }
        }
    }

    public boolean isNeIdofGne(int neId, boolean bIsLogicNeId) {
        int ulPhyNeId = neId;
        if (bIsLogicNeId && 0 == (ulPhyNeId = TENEIDCacheMgr.getInstance().getPhyID(neId))) {
            return false;
        }
        TEGne gne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(ulPhyNeId));
        return gne != null;
    }

    public boolean isNeAccessible(int neId) {
        int state;
        TECommuNe pCommuNe;
        if (TEConfigUtil.isPreConfigNe(neId)) {
            return true;
        }
        boolean bRtn = false;
        int handle = TECommuMgr.getHandleByNeId(neId);
        if (handle != 0 && (pCommuNe = TECommuNEMgr.getInstance().getCommuNE(neId)) != null && (state = pCommuNe.getCurConnState()) == 1) {
            bRtn = true;
        }
        return bRtn;
    }

    public boolean IsGneExist(int type, long ulIp, int usPort, int ucDeviceID, int ulBaudrate, String strTP4Address, String strTP4TSAP, int neId, boolean bIsLogicNeId, int iExistCheckMode) {
        switch (iExistCheckMode) {
            case 1: {
                return this.IsGneExistInProc(type, ulIp, usPort, ucDeviceID, ulBaudrate, strTP4Address, strTP4TSAP, neId, bIsLogicNeId);
            }
            case 2: {
                return this.IsGneExistInSystem(type, ulIp, usPort, ucDeviceID, ulBaudrate, strTP4Address, strTP4TSAP, bIsLogicNeId);
            }
        }
        return false;
    }

    private boolean IsGneExistInProc(int type, long ulIp, int usPort, int ucDeviceID, int ulBaudrate, String strTP4Address, String strTP4TSAP, int neId, boolean bIsLogicNeId) {
        boolean bFind = false;
        int tmpNeId = 0;
        List gneList = null;
        switch (type) {
            case 1: {
                gneList = CommonDaoService.findAll(TEEthGne.class);
                if (gneList == null) break;
                int m = gneList.size();
                for (int i = 0; i < m; ++i) {
                    TEEthGne gne = (TEEthGne)gneList.get(i);
                    tmpNeId = gne.getNeId();
                    if (gne.getIp() != ulIp) continue;
                    bFind = true;
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        if (bFind) {
            neId = tmpNeId;
        }
        if (neId != 0 && bIsLogicNeId) {
            neId = TECommuGlobal.CommuNePhyIDandDevIDConvert(neId, bIsLogicNeId, true);
        }
        return 0 != neId;
    }

    private boolean IsGneExistInSystem(int type, long ulIp, int usPort, int ucDeviceID, int ulBaudrate, String strTP4Address, String strTP4TSAP, boolean bIsLogicNeId) {
        int neId = 0;
        TENESPTransaction trans = new TENESPTransaction();
        ArrayList<SPParameter> spParameters = new ArrayList<SPParameter>();
        SPParameter para = null;
        if (1 == type) {
            para = new SPParameter(4, (int)ulIp);
            spParameters.add(para);
            para = new SPParameter(12, "");
            spParameters.add(para);
            para = new SPParameter(4, 0);
            spParameters.add(para);
        } else if (3 == type) {
            para = new SPParameter(4, 0);
            spParameters.add(para);
            para = new SPParameter(12, strTP4Address);
            spParameters.add(para);
            para = new SPParameter(4, 0);
            spParameters.add(para);
        } else if (2 == type) {
            para = new SPParameter(4, 0);
            spParameters.add(para);
            para = new SPParameter(12, "");
            spParameters.add(para);
            para = new SPParameter(4, ucDeviceID);
            spParameters.add(para);
        } else {
            return false;
        }
        trans.addNESP("p_GetNeidByAddr", (ArrayList)spParameters.clone());
        int errCode = trans.exec();
        if (0 != errCode) {
            return false;
        }
        if (0 != trans.getLastExecResult().size()) {
            ArrayList<TIntObjectHashMap<Object>> list = trans.getLastExecResult();
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                TIntObjectHashMap<Object> rsMap = list.get(i);
                int v2 = (Integer)rsMap.get(2);
                if (0 == v2) continue;
                neId = v2;
            }
        }
        if (neId != 0 && bIsLogicNeId) {
            neId = TECommuGlobal.CommuNePhyIDandDevIDConvert(neId, bIsLogicNeId, true);
        }
        return 0 != neId;
    }

    public int CreateEthGne(int ulNeId, int ulLogicId, long ulIp, int usPort, boolean bIsConnectGne) {
        this.deleteNe(ulLogicId);
        int errorCode = 1090609153;
        TEEthGne gne = new TEEthGne();
        gne.initialize(ulNeId, ulLogicId, ulIp, usPort);
        int ecode = CommonDaoService.save(gne);
        if (0 == ecode) {
            errorCode = ecode;
        }
        return errorCode;
    }

    public int neLoginForCfg(TENEPO nepo, String strNeUser, byte[] strPwd, iMAPNECommuInfo gneCommuInfo) {
        TENEListMgr neMgr = TENEListMgr.getInstance();
        TENE ne = new TENE(nepo.getNeid(), gneCommuInfo.m_nGateWayType, TEConvertUtil.ipToString(gneCommuInfo.m_ulIPAddress), gneCommuInfo.m_usIPPort + "", gneCommuInfo.m_ulComBaudrate + "", strNeUser, strPwd);
        ne.setRealNEID(nepo.getPhyId());
        ne.setShelfType(nepo.getShelfType());
        ne.setNEType(TEGetNEDomainVersion.getInstance().getNeType(nepo.getType()));
        int neID = nepo.getPhyId();
        int logicNEID = nepo.getNeid();
        TENECommMgr.getInstance().putLogicNEID((long)neID, (long)logicNEID);
        int rtnCode = neMgr.addNE(ne);
        if (rtnCode == 0) {
            TECommuNEMgr.getInstance().getCommuNE(logicNEID).setCurConnState(1);
            rtnCode = ne.login(strNeUser, strPwd, 1);
            if (rtnCode == 0) {
                TECommuNEMgr.getInstance().getCommuNE(logicNEID).setLogined(true);
                int neVersion = TENECommMgr.getInstance().getNeVersion((long)logicNEID);
                String neVer = TEConvertUtil.neVersionToString(neVersion);
                ne.setNeVersion(neVersion);
                ne.setHostVersion(neVer);
                ne.setShowNEVersion(neVer);
                new TENELdDevPkgNoticeReceiver().handleNotice(logicNEID);
            }
        }
        if (rtnCode != 0) {
            TECommuNEMgr.getInstance().deleteCommuNE(ne.getNEID());
            neMgr.deleteNE(ne);
        }
        strPwd = null;
        return rtnCode;
    }

    public int neLogoutForCfg(int ulNeId) {
        TENEListMgr neMgr = TENEListMgr.getInstance();
        TENE ne = neMgr.getNE(ulNeId);
        if (ne == null) {
            return 1090646020;
        }
        int rtnCode = 0;
        if (ne.getLogStatus() == 1) {
            rtnCode = ne.logout();
            if (rtnCode == 0 || rtnCode == 37926) {
                rtnCode = neMgr.deleteNE(ne);
            }
        } else {
            rtnCode = neMgr.deleteNE(ne);
        }
        return rtnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int delUnusedGne(List lstGneAssigned) {
        ArrayList<Integer> lstGnetoDel = new ArrayList<Integer>();
        int ulGneId = -1;
        this.m_mutexMapGneUsed.lock();
        try {
            if (lstGneAssigned != null) {
                for (int i = lstGneAssigned.size() - 1; i >= 0; --i) {
                    ulGneId = (Integer)lstGneAssigned.get(i);
                    if (-1 == ulGneId || !this.m_mapGneUsed.containsKey(ulGneId)) continue;
                    this.m_mapGneUsed.remove(ulGneId);
                    lstGnetoDel.add(ulGneId);
                }
            } else {
                TIntIntIterator iter = this.m_mapGneUsed.iterator();
                while (iter.hasNext()) {
                    iter.advance();
                    if (0 != iter.value()) continue;
                    lstGnetoDel.add(iter.key());
                    iter.remove();
                }
            }
        }
        finally {
            this.m_mutexMapGneUsed.unlock();
        }
        int errCode = 0;
        int nRet = 0;
        int n = lstGnetoDel.size();
        for (int j = 0; j < n; ++j) {
            errCode = this.deleteGne((Integer)lstGnetoDel.get(j), 0, false);
            if (0 == errCode || 0 != nRet) continue;
            nRet = errCode;
        }
        return nRet;
    }

    public void NeConnBreakRpt(int ulNeId, boolean bIsGne) {
        if (-1 == ulNeId) {
            return;
        }
        int ulLogicNeId = TENEIDCacheMgr.getInstance().getDevID(ulNeId);
        if (ulLogicNeId != 0 && TEConfigUtil.isPreConfigNe(ulLogicNeId)) {
            EventManager.getInstance().postEvent(new Event(8205, ulLogicNeId));
        }
    }

    public void NeConnResumeRpt(int ulNeId, boolean bIsGne) {
        if (-1 == ulNeId) {
            return;
        }
        int ulLogicNeId = TENEIDCacheMgr.getInstance().getDevID(ulNeId);
        if (ulLogicNeId != 0 && !TEConfigUtil.isPreConfigNe(ulLogicNeId)) {
            EventManager.getInstance().postEvent(new Event(8207, ulLogicNeId));
        }
    }

    public void GneSocketResumeRpt(int ulNeId) {
        if (-1 == ulNeId) {
            return;
        }
        int logicNeId = TENEIDCacheMgr.getInstance().getDevID(ulNeId);
        if (!TEConfigUtil.isPreConfigNe(logicNeId) && ulNeId != -1) {
            TEGneConnStateEvent pParam = new TEGneConnStateEvent();
            pParam.ulGneDevId = ulNeId;
            pParam.strNemgrName = SystemConfiguration.getProcName();
            int eventId = 8213;
            Event event = new Event(eventId, logicNeId, pParam);
            EventManager.getInstance().postEvent(event);
        }
    }

    public void GneSocketBreakRpt(int ulNeId) {
        TEGne pGne;
        if (-1 == ulNeId) {
            return;
        }
        int logicNeId = TENEIDCacheMgr.getInstance().getDevID(ulNeId);
        if (!TEConfigUtil.isPreConfigNe(logicNeId) && null != (pGne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(ulNeId))) && !pGne.getGneIfOnDelete()) {
            TEGneConnStateEvent pParam = new TEGneConnStateEvent();
            pParam.ulGneDevId = ulNeId;
            pParam.strNemgrName = SystemConfiguration.getProcName();
            EventManager.getInstance().postEvent(new Event(8212, logicNeId, pParam));
        }
    }

    public void NeLoginResumeRpt(int ulNeId) {
        if (-1 == ulNeId) {
            return;
        }
        if (!TEConfigUtil.isPreConfigNe(ulNeId)) {
            EventManager.getInstance().postEvent(new Event(8208, ulNeId));
        }
    }

    public void NeLogoutRpt(int ulNeId) {
        if (-1 == ulNeId) {
            return;
        }
        if (!TEConfigUtil.isPreConfigNe(ulNeId)) {
            EventManager.getInstance().postEvent(new Event(8209, ulNeId));
        }
    }

    public boolean GetCurrNEUser(int neID, String[] str) {
        TECommuNe pSecuNE = TECommuNEMgr.getInstance().getCommuNE(neID);
        if (pSecuNE == null) {
            return false;
        }
        str[0] = pSecuNE.getNeuser();
        str[1] = pSecuNE.getEncryptPassword();
        return true;
    }

    public void SetRelatedNeConnectState(int ulGneId, boolean bConnect, boolean bIsLogicNeId) {
        int ulPhyGneId = ulGneId;
        if (bIsLogicNeId && 0 == (ulPhyGneId = TENEIDCacheMgr.getInstance().getPhyID(ulGneId))) {
            return;
        }
        int state = 2;
        if (bConnect) {
            state = 1;
        } else {
            this.setNeLoginState(ulPhyGneId, false);
        }
        boolean bFind = false;
        Collection pMM = TECommuNEMgr.getInstance().getAllCommuNE();
        Iterator iter = pMM.iterator();
        while (iter.hasNext()) {
            bFind = false;
            TECommuNe pCommuNe = (TECommuNe)iter.next();
            int neId = pCommuNe.getNeId();
            pCommuNe.setConnState(ulPhyGneId, state);
            if (pCommuNe.getCurGneId() == ulPhyGneId) {
                bFind = true;
            }
            if (!bFind) continue;
            if (bConnect) {
                this.neLogin(neId, false, false);
                continue;
            }
            this.setNeLoginState(neId, false);
        }
    }

    public int getNeLoginItem(int ulNeId, SNeLoginItem loginItem, boolean bIsLogicNeId) {
        int ulPhyNeId = ulNeId;
        if (bIsLogicNeId && 0 == (ulPhyNeId = TENEIDCacheMgr.getInstance().getPhyID(ulNeId))) {
            return 1090646020;
        }
        int ulResult = 0;
        TECommuNe pNE = TECommuNEMgr.getInstance().getCommuNeByPhyID(ulPhyNeId);
        if (pNE != null) {
            int dwVersion;
            loginItem.ulLoginNeId = bIsLogicNeId ? pNE.getLogicNeId() : pNE.getNeId();
            loginItem.strNeUser = pNE.getNeuser();
            loginItem.strPwd = pNE.getPassword();
            loginItem.bIsLogined = pNE.getLogined() > 0;
            loginItem.ulVersion = dwVersion = TENEListMgr.getInstance().getPhyNE(ulPhyNeId).getNEVersion();
        } else {
            ulResult = 1090650111;
        }
        return ulResult;
    }

    public int setNeLoginItem(int ulNeId, SNeLoginItem loginItem) {
        TENE ne = TENEListMgr.getInstance().getNE(ulNeId);
        int oldVersion = ne.getNEVersion();
        if (loginItem.ulVersion != 0 && oldVersion != loginItem.ulVersion) {
            ne.setNeVersion(loginItem.ulVersion);
        }
        int ulResult = 0;
        TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNE(ulNeId);
        if (pCommuNe != null) {
            pCommuNe.setNeuser(loginItem.strNeUser);
            pCommuNe.setEncryptPassword(loginItem.strPwd);
            pCommuNe.setLogined(loginItem.bIsLogined);
            CommonDaoService.update(pCommuNe);
        } else {
            ulResult = 1090650111;
        }
        return ulResult;
    }

    public int setNeLoginRet(int ulNeId, int ulVersion, boolean bIsLogined) {
        int logicNeId = TENEIDCacheMgr.getInstance().getDevID(ulNeId);
        TENE ne = TENEListMgr.getInstance().getNE(logicNeId);
        int oldVersion = ne.getNEVersion();
        int ulResult = 0;
        if (ulVersion != 0) {
            if (oldVersion != 0 && oldVersion != ulVersion && (oldVersion & 0xFF000000) != (ulVersion & 0xFF000000)) {
                AsnIntID asnReq = new AsnIntID();
                asnReq.iID = ulNeId;
                MSGPacketExt pRspMsg = new MSGPacketExt();
                if (!TECommUtil.setASNData(pRspMsg, (FStruct)asnReq)) {
                    return 1090646025;
                }
                pRspMsg.mheader.cmdCode = 20992;
                pRspMsg.mheader.receiverModule = (byte)15;
                TEAppMgr.instance().imapOutSendMsg(pRspMsg, 15);
                return 0;
            }
            TECommuNe pNe = TECommuNEMgr.getInstance().getCommuNE(logicNeId);
            if (pNe != null) {
                pNe.setLogined(bIsLogined);
                if (!TESystemVariable.g_bImapNoNeLogin) {
                    pNe.setAutoLogin(true);
                }
            }
            if (oldVersion != ulVersion) {
                ne.setNeVersion(ulVersion);
            }
        }
        return ulResult;
    }

    public void setNeLoginState(int ulNeId, boolean bIsLogined) {
        TECommuNe pNe = TECommuNEMgr.getInstance().getCommuNeByPhyID(ulNeId);
        if (null != pNe) {
            pNe.setLogined(bIsLogined);
        }
    }

    public int setAutoLogoutTime(int ulNeId, int ulTime) {
        SNeLoginItem item = new SNeLoginItem();
        int ulResult = this.getNeLoginItem(ulNeId, item, false);
        if (ulResult == 0) {
            SAppSetAutoParaReq appReq = new SAppSetAutoParaReq();
            appReq.ulNeId = ulNeId;
            appReq.ulTempId = item.ulLoginNeId;
            appReq.strNeUser = item.strNeUser;
            appReq.ulTime = ulTime;
        }
        return ulResult;
    }

    public boolean isLogin(int ulNeId) {
        int logicNeId = TENEIDCacheMgr.getInstance().getDevID(ulNeId);
        if (TEConfigUtil.isPreConfigNe(logicNeId)) {
            return true;
        }
        boolean bIsLogined = false;
        TECommuNe pNe = TECommuNEMgr.getInstance().getCommuNE(logicNeId);
        bIsLogined = pNe != null ? pNe.getLogined() > 0 : false;
        return bIsLogined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int neLogin(int neId, boolean force, boolean isLogicNeId) {
        boolean isAutoLogin = false;
        if (neId == 0) {
            return 0;
        }
        int phyNeId = neId;
        if (isLogicNeId && (phyNeId = TENEIDCacheMgr.getInstance().getPhyID(phyNeId)) == 0) {
            return 1090646020;
        }
        TECommuNe pNe = TECommuNEMgr.getInstance().getCommuNeByPhyID(neId);
        if (pNe != null) {
            isAutoLogin = pNe.isAutoLogin();
        }
        if (!isAutoLogin) {
            return 0;
        }
        if (!this.isLogin(phyNeId) || force) {
            this.m_mutexLoginReqNEs.lock();
            try {
                if (this.m_listLoginReqNEs.contains(phyNeId)) return 0;
                this.m_mutexLoginNEList.lock();
                try {
                    if (this.m_listLoginningNE.contains(phyNeId)) return 0;
                    this.m_listLoginReqNEs.add(phyNeId);
                    return 0;
                }
                finally {
                    this.m_mutexLoginNEList.unlock();
                }
            }
            finally {
                this.m_mutexLoginReqNEs.unlock();
            }
        } else {
            SNeLoginStateSyn syn = new SNeLoginStateSyn();
            syn.bIsCommuOk = true;
            syn.bIsLoginOk = true;
            syn.bWantLock = true;
            syn.ulNeId = phyNeId;
            syn.ulTempId = phyNeId;
            syn.ulVersion = 0;
            this.neLoginStateSyn(syn);
        }
        return 0;
    }

    public void neLoginStateSyn(SNeLoginStateSyn syn) {
        if (syn.ulVersion != 0) {
            this.setNeLoginRet(syn.ulNeId, syn.ulVersion, syn.bIsLoginOk);
        } else {
            this.setNeLoginState(syn.ulNeId, syn.bIsLoginOk);
        }
        if (syn.bIsLoginOk) {
            this.setAutoLogoutTime(syn.ulTempId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateGneUsedCount(int ulOldGneId, int ulNewGneId) {
        this.m_mutexMapGneUsed.lock();
        try {
            int usedTimes = 0;
            if (-1 != ulOldGneId && this.m_mapGneUsed.containsKey(ulOldGneId) && (usedTimes = this.m_mapGneUsed.get(ulOldGneId)) > 0) {
                this.m_mapGneUsed.put(ulOldGneId, --usedTimes);
            }
            if (-1 != ulNewGneId) {
                if (this.m_mapGneUsed.containsKey(ulNewGneId)) {
                    usedTimes = this.m_mapGneUsed.get(ulNewGneId);
                    this.m_mapGneUsed.put(ulOldGneId, ++usedTimes);
                } else {
                    this.m_mapGneUsed.put(ulNewGneId, 1);
                }
            }
        }
        finally {
            this.m_mutexMapGneUsed.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delNoExistGneFromGneMap(int ulGneId) {
        if (-1 != ulGneId) {
            this.m_mutexMapGneUsed.lock();
            try {
                if (this.m_mapGneUsed.containsKey(ulGneId)) {
                    this.m_mapGneUsed.remove(ulGneId);
                }
            }
            finally {
                this.m_mutexMapGneUsed.unlock();
            }
        }
    }

    public void refreshNeConnectState(int neId, boolean bIsLogicNeId) {
        TECommuNe pCommuNE = TECommuNEMgr.getInstance().getCommuNE(neId);
        if (null != pCommuNE) {
            int eConnState = pCommuNE.getCurConnState();
            TENEStateChangedMgr.getInstance().getQueueCommuState().pushChangedNEID(pCommuNE.getNeId(), eConnState == 1);
        }
    }

    public void TestNeVectorConnectState(TIntArrayList neIDs) {
        AsnCommuNeTestReq req = new AsnCommuNeTestReq();
        int m = neIDs.size();
        for (int i = 0; i < m; ++i) {
            req.neIdList.add(neIDs.get(i));
        }
        req.userId = (int)(System.currentTimeMillis() / 1000L);
        MSGPacketExt msg = new MSGPacketExt();
        if (TECommUtil.setASNData(msg, (FStruct)req)) {
            msg.mheader.cmdCode = 2121838;
            msg.mheader.receiverModule = (byte)8;
            msg.mheader.cmdHandle = (char)4;
            msg.mheader.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_NBC.getValue();
            TEAppMgr.instance().imapOutSendMsg(msg, 8);
        }
    }

    public void GetRelatedNeId(int ulGneId, TIntArrayList vecMainGneId, TIntArrayList vecBackup1GneId, TIntArrayList vecBackup2GneId, TIntArrayList vecBackup3GneId, boolean bIsLogicNeId) {
        int ulPhyGneId = ulGneId;
        if (bIsLogicNeId && 0 == (ulPhyGneId = TECommuGlobal.CommuNePhyIDandDevIDConvert(ulGneId, bIsLogicNeId, true))) {
            return;
        }
        Collection commuNes = TECommuNEMgr.getInstance().getAllCommuNE();
        for (TECommuNe pCommuNe : commuNes) {
            if (pCommuNe.getMainGneId() == ulPhyGneId) {
                if (bIsLogicNeId) {
                    vecMainGneId.add(pCommuNe.getLogicNeId());
                } else {
                    vecMainGneId.add(pCommuNe.getNeId());
                }
            }
            if (pCommuNe.getBackup1gneId() == ulPhyGneId) {
                if (bIsLogicNeId) {
                    vecMainGneId.add(pCommuNe.getLogicNeId());
                } else {
                    vecMainGneId.add(pCommuNe.getNeId());
                }
            }
            if (pCommuNe.getBackup2gneId() == ulPhyGneId) {
                if (bIsLogicNeId) {
                    vecMainGneId.add(pCommuNe.getLogicNeId());
                } else {
                    vecMainGneId.add(pCommuNe.getNeId());
                }
            }
            if (pCommuNe.getBackup3gneId() != ulPhyGneId) continue;
            if (bIsLogicNeId) {
                vecMainGneId.add(pCommuNe.getLogicNeId());
                continue;
            }
            vecMainGneId.add(pCommuNe.getNeId());
        }
    }

    public void SetRelatedGne(int ulGneId, TIntArrayList vecMainGneId, TIntArrayList vecBackup1GneId, TIntArrayList vecBackup2GneId, TIntArrayList vecBackup3GneId, boolean bIsLogicNeId) {
        int ulGnePhyID = 0;
        TIntArrayList vecMainGnePhyId = new TIntArrayList();
        TIntArrayList vecBackup1GnePhyId = new TIntArrayList();
        TIntArrayList vecBackup2GnePhyId = new TIntArrayList();
        TIntArrayList vecBackup3GnePhyId = new TIntArrayList();
        if (bIsLogicNeId) {
            ulGnePhyID = TECommuGlobal.CommuNePhyIDandDevIDConvert(ulGneId, bIsLogicNeId, true);
            if (0 == ulGnePhyID) {
                return;
            }
            int gneId = 0;
            int ulTmpNeId = 0;
            int m = vecMainGneId.size();
            for (int i = 0; i < m; ++i) {
                gneId = vecMainGneId.get(i);
                ulTmpNeId = TECommuGlobal.CommuNePhyIDandDevIDConvert(gneId, bIsLogicNeId, true);
                if (ulTmpNeId == 0) continue;
                vecMainGnePhyId.add(ulTmpNeId);
            }
            int n = vecBackup1GneId.size();
            for (int j = 0; j < n; ++j) {
                gneId = vecBackup1GneId.get(j);
                ulTmpNeId = TECommuGlobal.CommuNePhyIDandDevIDConvert(gneId, bIsLogicNeId, true);
                if (ulTmpNeId == 0) continue;
                vecBackup1GnePhyId.add(ulTmpNeId);
            }
            int mm = vecBackup2GneId.size();
            for (int k = 0; k < mm; ++k) {
                gneId = vecBackup2GneId.get(k);
                ulTmpNeId = TECommuGlobal.CommuNePhyIDandDevIDConvert(gneId, bIsLogicNeId, true);
                if (ulTmpNeId == 0) continue;
                vecBackup2GnePhyId.add(ulTmpNeId);
            }
            int nn = vecBackup3GneId.size();
            for (int t = 0; t < nn; ++t) {
                gneId = vecBackup3GneId.get(t);
                ulTmpNeId = TECommuGlobal.CommuNePhyIDandDevIDConvert(gneId, bIsLogicNeId, true);
                if (ulTmpNeId == 0) continue;
                vecBackup3GnePhyId.add(ulTmpNeId);
            }
        } else {
            ulGnePhyID = ulGneId;
            vecMainGnePhyId = vecMainGneId;
            vecBackup1GnePhyId = vecBackup1GneId;
            vecBackup2GnePhyId = vecBackup2GneId;
            vecBackup3GnePhyId = vecBackup3GneId;
        }
        int tmpNeId = 0;
        TECommuNe pCommuNe = null;
        TENEIDCacheMgr cacheMgr = TENEIDCacheMgr.getInstance();
        TECommuNEMgr commMgr = TECommuNEMgr.getInstance();
        int m = vecMainGnePhyId.size();
        for (int i = 0; i < m; ++i) {
            tmpNeId = vecMainGnePhyId.get(i);
            pCommuNe = commMgr.getCommuNE(cacheMgr.getDevID(tmpNeId));
            if (pCommuNe == null) continue;
            pCommuNe.setMainGneId(ulGnePhyID);
            CommonDaoService.update(pCommuNe);
        }
        int n = vecBackup1GnePhyId.size();
        for (int j = 0; j < n; ++j) {
            tmpNeId = vecBackup1GnePhyId.get(j);
            pCommuNe = commMgr.getCommuNE(cacheMgr.getDevID(tmpNeId));
            if (pCommuNe == null) continue;
            pCommuNe.setBackup1gneId(ulGnePhyID);
            CommonDaoService.update(pCommuNe);
        }
        int mm = vecBackup2GnePhyId.size();
        for (int k = 0; k < mm; ++k) {
            tmpNeId = vecBackup2GnePhyId.get(k);
            pCommuNe = commMgr.getCommuNE(cacheMgr.getDevID(tmpNeId));
            if (pCommuNe == null) continue;
            pCommuNe.setBackup2gneId(ulGnePhyID);
            CommonDaoService.update(pCommuNe);
        }
        int nn = vecBackup3GnePhyId.size();
        for (int t = 0; t < nn; ++t) {
            tmpNeId = vecBackup3GnePhyId.get(t);
            pCommuNe = commMgr.getCommuNE(cacheMgr.getDevID(tmpNeId));
            if (pCommuNe == null) continue;
            pCommuNe.setBackup3gneId(ulGnePhyID);
            CommonDaoService.update(pCommuNe);
        }
    }

    public int getGneDetailInfo(int gneId, iMAPNECommuInfo gneCommuInfo) {
        int logicGneId = TENEIDCacheMgr.getInstance().getDevID(gneId);
        if (null != TECommuNEMgr.getInstance().getCommuNE(logicGneId)) {
            return this.getNeCommuInfo(gneId, gneCommuInfo, false, false);
        }
        int errCode = 0;
        if (0 == logicGneId) {
            return 1090646020;
        }
        ArrayList<Integer> hook = new ArrayList<Integer>();
        if (this.executeSP(logicGneId, gneCommuInfo, hook) != 0) {
            return errCode;
        }
        if (0 == (Integer)hook.get(0)) {
            return 1090646020;
        }
        return 0;
    }

    public int createGneIfNotExists(iMAPNECommuInfo commuInfo) {
        TEGne gne = this.getGne(commuInfo.m_GneID);
        if (null != gne) {
            return 0;
        }
        switch (commuInfo.m_nGateWayType) {
            case 1: {
                return this.CreateEthGne(commuInfo.m_GneID, commuInfo.m_LogicGneID, commuInfo.m_ulIPAddress, commuInfo.m_usIPPort, true);
            }
        }
        return 1090609165;
    }

    public int changeCommuNePhyID(int oldPhyNeid, int newPhyNeid, int logicNeid) {
        TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNE(logicNeid);
        if (null == pCommuNe) {
            return 1090609156;
        }
        pCommuNe.setNeId(newPhyNeid);
        CommonDaoService.update(pCommuNe);
        return 0;
    }

    public int changeGnePhyID(int oldPhyNeid, int newPhyNeid, int logicNeid) {
        TEGne gne = this.getGne(oldPhyNeid);
        if (null != gne) {
            TIntArrayList vecMainGneId = new TIntArrayList();
            TIntArrayList vecBackup1GneId = new TIntArrayList();
            TIntArrayList vecBackup2GneId = new TIntArrayList();
            TIntArrayList vecBackup3GneId = new TIntArrayList();
            this.GetRelatedNeId(oldPhyNeid, vecMainGneId, vecBackup1GneId, vecBackup2GneId, vecBackup3GneId, false);
            int errCode = 0;
            iMAPNECommuInfo commuInfo = new iMAPNECommuInfo();
            errCode = this.getGneDetailInfo(oldPhyNeid, commuInfo);
            if (errCode != 0) {
                errCode = this.getGneDetailInfo(newPhyNeid, commuInfo);
                if (errCode != 0) {
                    return errCode;
                }
            } else {
                commuInfo.m_GneID = newPhyNeid;
            }
            if ((errCode = this.deleteGne(oldPhyNeid, 0, false)) != 0) {
                return errCode;
            }
            errCode = this.createGneIfNotExists(commuInfo);
            if (errCode != 0) {
                return errCode;
            }
            this.SetRelatedGne(newPhyNeid, vecMainGneId, vecBackup1GneId, vecBackup2GneId, vecBackup3GneId, false);
        }
        return 0;
    }

    public int changePhyID(int oldPhyNeid, int newPhyNeid, int logicNeid) {
        if (oldPhyNeid == newPhyNeid) {
            return 0;
        }
        int ulLogicNeId = TENEIDCacheMgr.getInstance().getDevID(oldPhyNeid);
        TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNE(ulLogicNeId);
        if (null == pCommuNe) {
            return 1090609156;
        }
        int errorCode = 0;
        errorCode = this.changeCommuNePhyID(oldPhyNeid, newPhyNeid, logicNeid);
        if (errorCode != 0) {
            return errorCode;
        }
        errorCode = this.changeGnePhyID(oldPhyNeid, newPhyNeid, logicNeid);
        if (errorCode != 0) {
            errorCode = this.changeCommuNePhyID(newPhyNeid, oldPhyNeid, logicNeid);
            return errorCode;
        }
        return 0;
    }

    public int changeToEthGne(int ulNeId, long ulIp, int usPort, boolean bIsLogicNeId) {
        int ulLogicId;
        int ulPhyNeId = ulNeId;
        if (bIsLogicNeId && 0 == (ulPhyNeId = TECommuGlobal.CommuNePhyIDandDevIDConvert(ulNeId, bIsLogicNeId, false))) {
            return 1090609156;
        }
        int errorCode = 0;
        TIntArrayList vecMainGneId = new TIntArrayList();
        TIntArrayList vecBackup1GneId = new TIntArrayList();
        TIntArrayList vecBackup2GneId = new TIntArrayList();
        TIntArrayList vecBackup3GneId = new TIntArrayList();
        int neId = 0;
        TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNeByPhyID(ulPhyNeId);
        if (pCommuNe == null) {
            return 1090609156;
        }
        if (this.IsGneExist(1, ulIp, usPort, 0, 0, "", "", neId, false, 2) && neId != ulPhyNeId) {
            return 1090609155;
        }
        boolean bIsGne = false;
        TEGne pGne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(ulPhyNeId));
        if (pGne != null) {
            bIsGne = true;
        }
        if (bIsGne) {
            this.GetRelatedNeId(ulPhyNeId, vecMainGneId, vecBackup1GneId, vecBackup2GneId, vecBackup3GneId, false);
            int r = this.deleteGne(ulPhyNeId, 0, false);
            if (0 != r) {
                return r;
            }
        }
        if (0 == (ulLogicId = TENEIDCacheMgr.getInstance().getDevID(ulPhyNeId))) {
            return 1090646016;
        }
        errorCode = this.CreateEthGne(ulPhyNeId, ulLogicId, ulIp, usPort, false);
        if (errorCode != 0) {
            return errorCode;
        }
        pCommuNe.setMainGneId(ulPhyNeId);
        if (!bIsGne) {
            pCommuNe.setConnState(ulPhyNeId, 2);
        }
        TECommuNEMgr.getInstance().putCommuNE(pCommuNe.getLogicNeId(), pCommuNe);
        CommonDaoService.update(pCommuNe);
        int eConnState = pCommuNe.getCurConnState();
        TENEStateChangedMgr.getInstance().getQueueCommuState().pushChangedNEID(ulPhyNeId, eConnState == 1);
        if (bIsGne) {
            this.SetRelatedGne(ulPhyNeId, vecMainGneId, vecBackup1GneId, vecBackup2GneId, vecBackup3GneId, false);
        }
        this.SetRelatedNeConnectState(ulPhyNeId, false, false);
        this.startConnect(ulPhyNeId, 0, true, false);
        if (2 == pCommuNe.getCurConnState() && pCommuNe.isIsDcnAutoRestore()) {
            pCommuNe.setNeGneState(0);
        }
        return errorCode;
    }

    public int ChangeGnePara(int ulNeId, int eGneType, long ulIp, int usPort, int ucDeviceID, int ulBaudrate, String strTP4Address, String strTP4TSAP) {
        int ulLogicId = ulNeId;
        ulNeId = TENEIDCacheMgr.getInstance().getPhyID(ulLogicId);
        if (0 == ulNeId) {
            return 1090646020;
        }
        TEGne pGne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(ulNeId));
        if (null == pGne) {
            return 1090609157;
        }
        switch (eGneType) {
            case 1: {
                TEEthGne ethGne;
                if (pGne.getGneType() == eGneType && (ethGne = (TEEthGne)pGne).getIp() == ulIp && ethGne.getPort() == usPort) {
                    return 0;
                }
                int neId = 0;
                if (this.IsGneExist(1, ulIp, usPort, 0, 0, "", "", neId, false, 2) && neId != ulNeId) {
                    return 1090609155;
                }
                this.GneSocketBreakRpt(ulNeId);
                this.SetRelatedNeConnectState(ulNeId, false, false);
                pGne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(ulNeId));
                if (pGne == null) {
                    return 1090609157;
                }
                if (pGne.getGneType() != eGneType) {
                    return this.changeToEthGne(ulNeId, ulIp, usPort, false);
                }
                int usPortold = 0;
                usPortold = ((TEEthGne)pGne).getPort();
                if (usPort != usPortold && TECommuGlobal.iMapIsNeSSLPort(usPort) ^ TECommuGlobal.iMapIsNeSSLPort(usPortold)) {
                    return this.changeToEthGne(ulNeId, ulIp, usPort, false);
                }
                ((TEEthGne)pGne).setDevicePara(ulIp, usPort);
                break;
            }
            case 2: {
                break;
            }
        }
        return 0;
    }

    private TEGne getGne(int ulPhyNeId) {
        return (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(ulPhyNeId));
    }

    public boolean SendDCNGneCommuParaCHGEvt(int ulLogicNeId) {
        if (ulLogicNeId > -1) {
            EventManager.getInstance().postEvent(new Event(8211, ulLogicNeId));
            return true;
        }
        return false;
    }

    public void GetCommuNeData(List<SCommuNeData> vecCommuNeData, List<Integer> vecNeId, List<SOneReturn> vecNotFound) {
        SCommuNeData commuNeData = null;
        int ulTempNeId = -1;
        int ulTempLogicNeId = -1;
        if (vecNeId.isEmpty()) {
            Collection comNe = TECommuNEMgr.getInstance().getAllCommuNE();
            for (TECommuNe pCommuNe : comNe) {
                commuNeData = new SCommuNeData();
                commuNeData.m_ulNeId = pCommuNe.getNeId();
                commuNeData.m_ulNeLogicId = pCommuNe.getLogicNeId();
                ulTempNeId = pCommuNe.getMainGneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getPhyID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulMainGneId = ulTempNeId;
                commuNeData.m_ulMainGneLogicId = ulTempLogicNeId;
                ulTempNeId = pCommuNe.getBackup1gneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getPhyID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulBackup1GneId = ulTempNeId;
                commuNeData.m_ulBackup1GneLogicId = ulTempLogicNeId;
                ulTempNeId = pCommuNe.getBackup2gneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getPhyID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulBackup2GneId = ulTempNeId;
                commuNeData.m_ulBackup2GneLogicId = ulTempLogicNeId;
                ulTempNeId = pCommuNe.getBackup3gneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getPhyID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulBackup3GneId = ulTempNeId;
                commuNeData.m_ulBackup3GneLogicId = ulTempLogicNeId;
                commuNeData.m_bIsDcnLocked = pCommuNe.isIsDcnLocked();
                commuNeData.m_bIsRestoreAllowed = pCommuNe.isIsDcnAutoRestore();
                commuNeData.m_stateNeGne = pCommuNe.getNeGneState();
                commuNeData.m_stateNeConn = pCommuNe.getCurConnState();
                commuNeData.m_bIsMainGneExist = commuNeData.m_ulMainGneId != -1;
                commuNeData.m_bIsBackup1GneExist = commuNeData.m_ulBackup1GneId != -1;
                commuNeData.m_bIsBackup2GneExist = commuNeData.m_ulBackup2GneId != -1;
                commuNeData.m_bIsBackup3GneExist = commuNeData.m_ulBackup3GneId != -1;
                commuNeData.m_nXPos = pCommuNe.getDcnxpos();
                commuNeData.m_nYPos = pCommuNe.getDcnypos();
                vecCommuNeData.add(commuNeData);
            }
        } else {
            SOneReturn oneRtn = null;
            int m = vecNeId.size();
            for (int i = 0; i < m; ++i) {
                oneRtn = new SOneReturn();
                int ulLogicNeId = vecNeId.get(i);
                TECommuNe pCommuNe = TECommuNEMgr.getInstance().getCommuNE(ulLogicNeId);
                if (pCommuNe == null) {
                    oneRtn.m_ulId = ulLogicNeId;
                    oneRtn.m_errorCode = 1090609156;
                    oneRtn.m_bIsSuccess = false;
                    vecNotFound.add(oneRtn);
                    continue;
                }
                commuNeData = new SCommuNeData();
                commuNeData.m_ulNeId = pCommuNe.getNeId();
                commuNeData.m_ulNeLogicId = pCommuNe.getLogicNeId();
                ulTempNeId = pCommuNe.getMainGneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getDevID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulMainGneId = ulTempNeId;
                commuNeData.m_ulMainGneLogicId = ulTempLogicNeId;
                ulTempNeId = pCommuNe.getBackup1gneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getDevID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulBackup1GneId = ulTempNeId;
                commuNeData.m_ulBackup1GneLogicId = ulTempLogicNeId;
                ulTempNeId = pCommuNe.getBackup2gneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getDevID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulBackup2GneId = ulTempNeId;
                commuNeData.m_ulBackup2GneLogicId = ulTempLogicNeId;
                ulTempNeId = pCommuNe.getBackup3gneId();
                ulTempLogicNeId = 0;
                if (0 != ulTempNeId && 0 == (ulTempLogicNeId = TENEIDCacheMgr.getInstance().getDevID(ulTempNeId))) {
                    ulTempLogicNeId = 0;
                }
                commuNeData.m_ulBackup3GneId = ulTempNeId;
                commuNeData.m_ulBackup3GneLogicId = ulTempLogicNeId;
                commuNeData.m_bIsDcnLocked = pCommuNe.isIsDcnLocked();
                commuNeData.m_bIsRestoreAllowed = pCommuNe.isIsDcnAutoRestore();
                commuNeData.m_stateNeGne = pCommuNe.getNeGneState();
                commuNeData.m_stateNeConn = pCommuNe.getCurConnState();
                commuNeData.m_bIsMainGneExist = commuNeData.m_ulMainGneId != -1;
                commuNeData.m_bIsBackup1GneExist = commuNeData.m_ulBackup1GneId != -1;
                commuNeData.m_bIsBackup2GneExist = commuNeData.m_ulBackup2GneId != -1;
                commuNeData.m_bIsBackup3GneExist = commuNeData.m_ulBackup3GneId != -1;
                commuNeData.m_nXPos = pCommuNe.getDcnxpos();
                commuNeData.m_nYPos = pCommuNe.getDcnypos();
                vecCommuNeData.add(commuNeData);
            }
        }
    }

    public boolean isNEAutoLogin(int neID) {
        boolean bAutoLogin = false;
        TECommuNe pSecuNE = TECommuNEMgr.getInstance().getCommuNeByPhyID(neID);
        if (pSecuNE != null) {
            bAutoLogin = pSecuNE.isAutoLogin();
        }
        return bAutoLogin;
    }

    public void setMainGne(int gneId, List<SOneReturn> returns, boolean isLogicNeId) {
        TIntArrayList neIDs = new TIntArrayList();
        int state = 2;
        if (TECommuMgr.GetGneHandle(gneId, 0) != 0) {
            state = 1;
        }
        boolean gneExistInNM = false;
        boolean gneExistInNEMgr = false;
        boolean execSPOK = true;
        if (gneId != 0) {
            int logicGneId = TENEIDCacheMgr.getInstance().getDevID(gneId);
            TECommuNe commInfo = TECommuNEMgr.getInstance().getCommuNE(logicGneId);
            if (commInfo != null) {
                gneExistInNEMgr = true;
                gneExistInNM = true;
            } else {
                logicGneId = TENEIDCacheMgr.getInstance().getDevID(gneId);
                if (logicGneId == 0) {
                    DebugTracer.trace(String.format("SetMainGne, fail to GetDevIDbyPhyID, gneid=0x%x\n", gneId));
                    execSPOK = false;
                } else {
                    iMAPNECommuInfo commuInfo = new iMAPNECommuInfo();
                    ArrayList<Integer> hook = new ArrayList<Integer>();
                    this.executeSP(logicGneId, commuInfo, hook);
                    int lastErr = (Integer)hook.get(1);
                    if (lastErr != 0) {
                        DebugTracer.trace(String.format("SetMainGne, fail to exec p_GetGneDetail, gneid=0x%x, logicGneid=0x%x, errno=%d\n", gneId, logicGneId, lastErr));
                        execSPOK = false;
                    } else if ((Integer)hook.get(1) > 0) {
                        gneExistInNM = true;
                    }
                }
            }
        }
        int neId = 0;
        for (SOneReturn oneReturn : returns) {
            if (!execSPOK) {
                oneReturn.m_errorCode = 1090609159;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            if (!gneExistInNM && gneId != 0) {
                DebugTracer.trace(String.format("SetMainGne fail, main gne(id=0x%x) is not exist, neid(0x%x)\n", gneId, oneReturn.m_ulId));
                oneReturn.m_errorCode = 1090609198;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            neId = oneReturn.m_ulId;
            int logicNeId = 0;
            if (isLogicNeId) {
                logicNeId = neId;
                neId = TENEIDCacheMgr.getInstance().getDevID(neId);
                if (neId == 0) {
                    DebugTracer.trace(String.format("SetMainGne, fail to GetPhyIDbyDevID, logicNeid(0x%x)\n", logicNeId));
                    oneReturn.m_errorCode = 1090646020;
                    oneReturn.m_bIsSuccess = false;
                    continue;
                }
            } else {
                logicNeId = TENEIDCacheMgr.getInstance().getDevID(neId);
            }
            if (TECommuNEMgr.getInstance().getCommuNE(logicNeId) == null) {
                DebugTracer.trace(String.format("SetMainGne fail, this COMMU NE is not exist(NEID = 0x%x)\n", neId));
                oneReturn.m_errorCode = 1090609156;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            if (CommonDaoService.getById(TEGne.class, Integer.valueOf(neId)) != null) {
                if (neId == gneId) {
                    oneReturn.m_bIsSuccess = true;
                    oneReturn.m_errorCode = 0;
                    continue;
                }
                oneReturn.m_errorCode = 1090609159;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            TECommuNe commuNe = (TECommuNe)CommonDaoService.getById(TECommuNe.class, Integer.valueOf(logicNeId));
            int backup1GneId = commuNe.getBackup1gneId();
            int backup2GneId = commuNe.getBackup2gneId();
            int backup3GneId = commuNe.getBackup3gneId();
            if (backup1GneId == gneId && backup1GneId != 0 || backup2GneId == gneId && backup2GneId != 0 || backup3GneId == gneId && backup3GneId != 0) {
                oneReturn.m_errorCode = 1090609189;
                oneReturn.m_bIsSuccess = false;
                CommonDaoService.clear();
                continue;
            }
            if (!gneExistInNEMgr && gneId != 0) {
                iMAPNECommuInfo commuInfo = new iMAPNECommuInfo();
                int errCode = this.getGneDetailInfo(gneId, commuInfo);
                if (errCode == 0) {
                    errCode = this.createGneIfNotExists(commuInfo);
                }
                if (0 != errCode) {
                    DebugTracer.trace(String.format("SetMainGne, fail to create gne(neid=0x%x)\n", gneId));
                    oneReturn.m_errorCode = 1090609159;
                    oneReturn.m_bIsSuccess = false;
                    continue;
                }
                gneExistInNEMgr = true;
            }
            int neGneState = 4;
            commuNe.setMainGneId(gneId);
            commuNe.setMainConnState(state);
            commuNe.setMainUnReachTimeCount(0);
            CommonDaoService.save(commuNe);
            state = commuNe.getCurConnState();
            neGneState = commuNe.getNeGneState();
            if (neGneState == 4) {
                commuNe.setNeGneState(0);
            } else if (neGneState == 0) {
                this.refreshMapGneMgrState(neId, gneId);
            }
            oneReturn.m_errorCode = 0;
            oneReturn.m_bIsSuccess = true;
            if (neGneState == 0) {
                if (state == 1) {
                    this.neLogin(neId, true, false);
                }
                neIDs.add(neId);
            }
            CommonDaoService.clear();
        }
        this.delUnusedGne(null);
        this.TestNeVectorConnectState(neIDs);
    }

    public void setBackupGne(int gneId, List<SOneReturn> returns, int backupGne, boolean isLogicNeId) {
        TIntArrayList neIDs = new TIntArrayList();
        int state = 2;
        if (TECommuMgr.GetGneHandle(gneId, 0) != 0) {
            state = 1;
        }
        boolean gneExistInNM = false;
        boolean gneExistInNEMgr = false;
        boolean execSPOK = true;
        if (gneId != 0) {
            int logicGneId = TENEIDCacheMgr.getInstance().getDevID(gneId);
            TECommuNe commInfo = TECommuNEMgr.getInstance().getCommuNE(logicGneId);
            if (commInfo != null) {
                gneExistInNEMgr = true;
                gneExistInNM = true;
            } else {
                int errCode = 0;
                logicGneId = TENEIDCacheMgr.getInstance().getDevID(gneId);
                if (logicGneId == 0) {
                    DebugTracer.trace(String.format("SetBackupGne, fail to GetDevIDbyPhyID, gneid=0x%x, errno=%d\n", gneId, errCode));
                    execSPOK = false;
                } else {
                    iMAPNECommuInfo commuInfo = new iMAPNECommuInfo();
                    ArrayList<Integer> hook = new ArrayList<Integer>();
                    this.executeSP(logicGneId, commuInfo, hook);
                    int lastErr = (Integer)hook.get(1);
                    if (lastErr != 0) {
                        DebugTracer.trace(String.format("SetBackupGne, fail to exec p_GetGneDetail, gneid=0x%x, logicGneid=0x%x, errno=%d\n", gneId, logicGneId, lastErr));
                    } else if ((Integer)hook.get(1) > 0) {
                        gneExistInNM = true;
                    }
                }
            }
        }
        int neId = 0;
        for (SOneReturn oneReturn : returns) {
            TECommuNe commuNe;
            if (backupGne < 1 || backupGne > 3) {
                oneReturn.m_errorCode = 1090609192;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            if (!execSPOK) {
                oneReturn.m_errorCode = 1090740309;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            if (!gneExistInNM && gneId != 0) {
                DebugTracer.trace(String.format("SetBackupGne fail, bak gne(id=0x%x) is not exist, neid(0x%x)\n", gneId, oneReturn.m_ulId));
                oneReturn.m_errorCode = 1090609199;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            neId = oneReturn.m_ulId;
            if (isLogicNeId) {
                int logicNeId = neId;
                neId = TENEIDCacheMgr.getInstance().getPhyID(logicNeId);
                if (neId == 0) {
                    DebugTracer.trace(String.format("SetBackupGne, fail to GetPhyIDbyDevID, logicNeid(0x%x)\n", logicNeId));
                    oneReturn.m_errorCode = 1090646020;
                    oneReturn.m_bIsSuccess = false;
                    continue;
                }
            }
            if ((commuNe = TECommuNEMgr.getInstance().getCommuNE(neId)) == null) {
                DebugTracer.trace(String.format("this COMMU NE is not exist(NEID = 0x%x)\n", neId));
                oneReturn.m_errorCode = 1090609156;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            int mainGneId = commuNe.getMainGneId();
            if (mainGneId == gneId && mainGneId != 0) {
                oneReturn.m_errorCode = 1090609200;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            int otherBackupGneId1 = 0;
            int otherBackupGneId2 = 0;
            switch (backupGne) {
                case 1: {
                    otherBackupGneId1 = commuNe.getBackup2gneId();
                    otherBackupGneId2 = commuNe.getBackup3gneId();
                    break;
                }
                case 2: {
                    otherBackupGneId1 = commuNe.getBackup3gneId();
                    otherBackupGneId2 = commuNe.getBackup1gneId();
                    break;
                }
                case 3: {
                    otherBackupGneId1 = commuNe.getBackup1gneId();
                    otherBackupGneId2 = commuNe.getBackup2gneId();
                    break;
                }
            }
            if (otherBackupGneId1 == gneId && otherBackupGneId1 != 0 || otherBackupGneId2 == gneId && otherBackupGneId2 != 0) {
                oneReturn.m_errorCode = 1090609193;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            if (!gneExistInNEMgr && gneId != 0) {
                iMAPNECommuInfo commuInfo = new iMAPNECommuInfo();
                int errCode = this.getGneDetailInfo(gneId, commuInfo);
                if (0 == errCode) {
                    errCode = this.createGneIfNotExists(commuInfo);
                }
                if (errCode != 0) {
                    DebugTracer.trace(String.format("SetBackupGne, fail to create gne(neid=0x%x)\n", gneId));
                    oneReturn.m_errorCode = 1090740309;
                    oneReturn.m_bIsSuccess = false;
                    continue;
                }
                gneExistInNEMgr = true;
            }
            int neBackupGneState = 4;
            int neGneState = 4;
            switch (backupGne) {
                case 1: {
                    commuNe.setBackup1gneId(gneId);
                    neBackupGneState = 1;
                    break;
                }
                case 2: {
                    commuNe.setBackup2gneId(gneId);
                    neBackupGneState = 2;
                    break;
                }
                case 3: {
                    commuNe.setBackup3gneId(gneId);
                    neBackupGneState = 3;
                    break;
                }
            }
            commuNe.setBackupConnState(state, backupGne);
            commuNe.setBackupUnReachTimeCount(0, backupGne);
            CommonDaoService.save(commuNe);
            state = commuNe.getCurConnState();
            neGneState = commuNe.getNeGneState();
            if (neGneState == 4) {
                commuNe.setNeGneState(neBackupGneState);
            } else if (neGneState == neBackupGneState) {
                this.refreshMapGneMgrState(neId, gneId);
            }
            oneReturn.m_errorCode = 0;
            oneReturn.m_bIsSuccess = true;
            boolean isStateChange = false;
            switch (backupGne) {
                case 1: {
                    if (neGneState != 1) break;
                    isStateChange = true;
                    break;
                }
                case 2: {
                    if (neGneState != 2) break;
                    isStateChange = true;
                    break;
                }
                case 3: {
                    if (neGneState != 3) break;
                    isStateChange = true;
                    break;
                }
            }
            if (!isStateChange) continue;
            if (state == 1) {
                this.neLogin(neId, false, false);
            }
            neIDs.add(neId);
        }
        this.delUnusedGne(null);
        this.TestNeVectorConnectState(neIDs);
    }

    public boolean setDcnLock(List<SOneReturn> returns, boolean isLock, boolean isLogicNeid) {
        int neId = 0;
        int logicNeid = 0;
        for (SOneReturn oneReturn : returns) {
            TECommuNe commuNe;
            neId = oneReturn.m_ulId;
            if (isLogicNeid) {
                logicNeid = neId;
                neId = TENEIDCacheMgr.getInstance().getPhyID(logicNeid);
                if (neId == 0) {
                    DebugTracer.trace(String.format("SetDcnLock, GetPhyIDbyDevID failed, logicNeid=0x%x\n", logicNeid));
                    oneReturn.m_errorCode = 1090609156;
                    oneReturn.m_bIsSuccess = false;
                    continue;
                }
            }
            if ((commuNe = TECommuNEMgr.getInstance().getCommuNE(neId)) == null) {
                DebugTracer.trace(String.format("this COMMU NE is not exist(NEID = 0x%x)\n", neId));
                oneReturn.m_errorCode = 1090609156;
                oneReturn.m_bIsSuccess = false;
                continue;
            }
            commuNe.setIsDcnLocked(isLock);
            oneReturn.m_bIsSuccess = true;
            oneReturn.m_errorCode = 0;
            CommonDaoService.save(commuNe);
        }
        return true;
    }

    public boolean setDcnRestore(List<SOneReturn> returns, boolean isRestore, boolean isLogicNeid) {
        int neId = 0;
        int logicNeid = 0;
        for (SOneReturn one : returns) {
            TECommuNe commuNE;
            neId = one.m_ulId;
            if (isLogicNeid) {
                logicNeid = neId;
                neId = TENEIDCacheMgr.getInstance().getPhyID(logicNeid);
                if (neId == 0) {
                    TELogFactory.getNormalLogger().debug(String.format("SetDcnRestore, GetPhyIDbyDevID failed, logicNeid=0x%x\n", logicNeid));
                    one.m_errorCode = 1090609156;
                    one.m_bIsSuccess = false;
                    continue;
                }
            }
            if ((commuNE = (TECommuNe)CommonDaoService.getById(TECommuNe.class, Integer.valueOf(logicNeid))) == null) {
                TELogFactory.getNormalLogger().debug(String.format("this COMMU NE is not exist(NEID = 0x%x)\n", logicNeid));
                one.m_errorCode = 1090609156;
                one.m_bIsSuccess = false;
                continue;
            }
            commuNE.setIsDcnAutoRestore(isRestore);
            one.m_bIsSuccess = true;
            one.m_errorCode = 0;
            CommonDaoService.save(commuNE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBakGneCommuState(int neId, int iBakGneNo, int bakGneId, int iCommuState) {
        if (-1 == neId) {
            return;
        }
        if (0 == (neId = TECommuGlobal.CommuNePhyIDandDevIDConvert(neId, false, false))) {
            return;
        }
        if (bakGneId != 0 && 0 == (bakGneId = TECommuGlobal.CommuNePhyIDandDevIDConvert(bakGneId, false, true))) {
            return;
        }
        this.m_MutexMapBakGneState.lock();
        try {
            if (this.m_MapBakGneCommuState.containsKey(neId)) {
                TEBakGneCommuState pBakGneCommuState;
                BakGneCommuState commuState = (BakGneCommuState)this.m_MapBakGneCommuState.get(neId);
                int oldBakGneId = commuState.bakGneId[iBakGneNo];
                int oldBakGneCommuState = commuState.iCommuState[iBakGneNo];
                if (oldBakGneId == bakGneId && oldBakGneCommuState == iCommuState) {
                    return;
                }
                commuState.bakGneId[iBakGneNo] = bakGneId;
                commuState.iCommuState[iBakGneNo] = iCommuState;
                if (oldBakGneId != -1 && oldBakGneCommuState == 2) {
                    pBakGneCommuState = new TEBakGneCommuState();
                    pBakGneCommuState.neId = neId;
                    pBakGneCommuState.iBakGneNo = iBakGneNo;
                    pBakGneCommuState.bakGneId = oldBakGneId;
                    EventManager.getInstance().postEvent(new Event(8227, 0, pBakGneCommuState));
                }
                if (bakGneId != -1) {
                    pBakGneCommuState = new TEBakGneCommuState();
                    pBakGneCommuState.neId = neId;
                    pBakGneCommuState.iBakGneNo = iBakGneNo;
                    pBakGneCommuState.bakGneId = bakGneId;
                    if (2 == iCommuState) {
                        EventManager.getInstance().postEvent(new Event(8226, 0, pBakGneCommuState));
                    } else if (1 == iCommuState) {
                        EventManager.getInstance().postEvent(new Event(8227, 0, pBakGneCommuState));
                    }
                }
            } else {
                BakGneCommuState bakGneCommuState = new BakGneCommuState();
                bakGneCommuState.bakGneId[iBakGneNo] = bakGneId;
                bakGneCommuState.iCommuState[iBakGneNo] = iCommuState;
                this.m_MapBakGneCommuState.put(neId, (Object)bakGneCommuState);
                if (-1 != bakGneId) {
                    TEBakGneCommuState pBakGneCommuState = new TEBakGneCommuState();
                    pBakGneCommuState.neId = neId;
                    pBakGneCommuState.iBakGneNo = iBakGneNo;
                    pBakGneCommuState.bakGneId = bakGneId;
                    if (1 == iCommuState) {
                        EventManager.getInstance().postEvent(new Event(8227, 0, pBakGneCommuState));
                    } else if (2 == iCommuState) {
                        EventManager.getInstance().postEvent(new Event(8226, 0, pBakGneCommuState));
                    }
                }
            }
        }
        finally {
            this.m_MutexMapBakGneState.unlock();
        }
    }

    public void refreshMapGneMgrState(int neId, int newGneId) {
    }

    protected int executeSP(int logicGneId, iMAPNECommuInfo gneCommuInfo, List<Integer> hook) {
        TENESPTransaction trans = new TENESPTransaction();
        ArrayList<SPParameter> spParameters = new ArrayList<SPParameter>();
        SPParameter para = new SPParameter(4, logicGneId);
        spParameters.add(para);
        trans.addNESP("p_GetGneDetail", spParameters);
        int errCode = trans.exec();
        if (0 != errCode) {
            return errCode;
        }
        int retCount = 0;
        if (trans.getLastExecResult().size() > 0) {
            ArrayList<TIntObjectHashMap<Object>> lstRet = trans.getLastExecResult();
            int spRowsExpected = 9;
            int m = lstRet.size();
            for (int i = 0; i < m; ++i) {
                TIntObjectHashMap ret = (TIntObjectHashMap)lstRet.get(i);
                if (ret.size() != 9) continue;
                gneCommuInfo.m_GneID = ((BigDecimal)ret.get(1)).intValue();
                gneCommuInfo.m_LogicGneID = ((BigDecimal)ret.get(2)).intValue();
                gneCommuInfo.m_nGateWayType = (Integer)ret.get(3);
                gneCommuInfo.m_ulIPAddress = ((BigDecimal)ret.get(4)).intValue();
                gneCommuInfo.m_usIPPort = ((BigDecimal)ret.get(5)).intValue();
                gneCommuInfo.m_strTP4Address = (String)ret.get(6);
                gneCommuInfo.m_strTP4SAP = (String)ret.get(7);
                gneCommuInfo.m_ulComBaudrate = (Integer)ret.get(8);
                gneCommuInfo.m_ucGneToNMCom = (Integer)ret.get(9);
                ++retCount;
            }
        }
        hook.add(retCount);
        hook.add(trans.resultOf("p_GetGneDetail"));
        return errCode;
    }

    public int synGnePara() {
        int ulPhyNeId = 0;
        int ulLogicNeid = 0;
        int ulRealPhyID = 0;
        TECommuNEMgr commMgr = TECommuNEMgr.getInstance();
        List gneList = CommonDaoService.findAll(TEEthGne.class);
        if (null != gneList) {
            int m = gneList.size();
            for (int i = 0; i < m; ++i) {
                TEEthGne pGne = (TEEthGne)gneList.get(i);
                ulPhyNeId = pGne.getNeId();
                ulLogicNeid = pGne.getLogicNeId();
                long ulIp = pGne.getIp();
                int usPort = pGne.getPort();
                ulRealPhyID = TENEIDCacheMgr.getInstance().getPhyID(ulLogicNeid);
                if (0 == ulRealPhyID) {
                    TELogFactory.getNormalLogger().info("SynGnePara, ethgne, fail to GetPhyIDbyDevID(logicNeid=0x" + ulLogicNeid);
                    continue;
                }
                if (ulPhyNeId != ulRealPhyID) {
                    pGne.setNeId(ulRealPhyID);
                    CommonDaoService.update(pGne);
                }
                if (null != commMgr.getCommuNeByPhyID(ulRealPhyID)) continue;
                iMAPNECommuInfo commuInfo = new iMAPNECommuInfo();
                if (0 == this.getGneDetailInfo(ulRealPhyID, commuInfo)) {
                    if (ulIp == commuInfo.m_ulIPAddress && usPort == commuInfo.m_usIPPort) continue;
                    pGne.setIp(commuInfo.m_ulIPAddress);
                    pGne.setPort(commuInfo.m_usIPPort);
                    CommonDaoService.update(pGne);
                    continue;
                }
                TELogFactory.getNormalLogger().info("SynGnePara, ethgne, fail to GetGneDetailInfo(neid: 0x" + ulRealPhyID + "x) failed!");
            }
        }
        return 0;
    }

    public int synCommuNePhyID() {
        int ulPhyNeId = 0;
        int ulLogicNeid = 0;
        int ulRealPhyID = 0;
        TECommuNe pCommuNe2 = null;
        Collection commuNeList = TECommuNEMgr.getInstance().getAllCommuNE();
        for (TECommuNe pCommuNe2 : commuNeList) {
            ulPhyNeId = pCommuNe2.getNeId();
            ulLogicNeid = pCommuNe2.getLogicNeId();
            ulRealPhyID = TENEIDCacheMgr.getInstance().getPhyID(ulLogicNeid);
            if (0 == ulRealPhyID) {
                TELogFactory.getNormalLogger().debug("SynCommuNePhyID, fail to GetPhyIDbyDevID(logicNeid=0x" + ulLogicNeid + ")");
                continue;
            }
            if (ulPhyNeId == ulRealPhyID) continue;
            pCommuNe2.setNeId(ulRealPhyID);
            CommonDaoService.update(pCommuNe2);
        }
        return 0;
    }

    void startConnect(int ulGneId, int nType, boolean bWait, boolean bIsReconnect) {
        TEGne pGne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(ulGneId));
        if (pGne == null) {
            return;
        }
    }

    public void connectGne(List<SOneReturn> vecOneReturn) {
        int ulLogicNeId = 0;
        int neId = 0;
        SOneReturn oneReturn = null;
        int m = vecOneReturn.size();
        for (int i = 0; i < m; ++i) {
            oneReturn = vecOneReturn.get(i);
            ulLogicNeId = oneReturn.m_ulId;
            neId = TECommuGlobal.CommuNePhyIDandDevIDConvert(ulLogicNeId, true, true);
            if (0 == neId) {
                oneReturn.m_bIsSuccess = false;
                oneReturn.m_errorCode = 1090609157;
                continue;
            }
            TEGne pGne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(neId));
            if (pGne == null) {
                oneReturn.m_bIsSuccess = false;
                oneReturn.m_errorCode = 1090609157;
                continue;
            }
            int nstate = 0;
            int eGneState = nstate == 3 ? 3 : 1;
            this.getGneState(neId, eGneState);
            oneReturn.m_bIsSuccess = true;
            oneReturn.m_errorCode = eGneState;
        }
    }

    public void disConnectGne(List<SOneReturn> vecOneReturn) {
        int ulLogicNeId = 0;
        int neId = 0;
        SOneReturn oneReturn = null;
        int n = vecOneReturn.size();
        for (int j = 0; j < n; ++j) {
            oneReturn = vecOneReturn.get(j);
            ulLogicNeId = oneReturn.m_ulId;
            neId = TECommuGlobal.CommuNePhyIDandDevIDConvert(ulLogicNeId, true, true);
            if (0 == neId) {
                oneReturn.m_bIsSuccess = false;
                oneReturn.m_errorCode = 1090609157;
                continue;
            }
            TEGne pGne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(neId));
            if (pGne == null) {
                oneReturn.m_bIsSuccess = false;
                oneReturn.m_errorCode = 1090609157;
                continue;
            }
            this.SetRelatedNeConnectState(neId, false, false);
            this.GneSocketBreakRpt(neId);
            oneReturn.m_bIsSuccess = true;
            oneReturn.m_errorCode = 0;
        }
    }

    public boolean getGneState(int ulGneId, int eGneState) {
        return false;
    }

    public void startAllGne() {
        List gneList = CommonDaoService.findAll(TEEthGne.class);
        int m = gneList.size();
        for (int i = 0; i < m; ++i) {
            TEEthGne pEthGne = (TEEthGne)gneList.get(i);
            int ulNeId = pEthGne.getNeId();
            int logicNeId = pEthGne.getLogicNeId();
            if (!TEConfigUtil.isTENEExist(ulNeId)) {
                if (this.deleteNe(logicNeId) == 0) {
                    TELogFactory.getNormalLogger().debug("NE " + logicNeId + " not Existed, succeed in delete CommuNE(id = " + logicNeId + ")");
                    continue;
                }
                TELogFactory.getNormalLogger().debug("NE " + logicNeId + " not Existed, failed in delete CommuNE(id = " + logicNeId + ")");
                continue;
            }
            this.SetRelatedNeConnectState(ulNeId, false, false);
            TENECommMgr.getInstance().registerNEStateListener(logicNeId, (NEStateNoticeHandle)new NECommuStateNoticeReceiver());
            String ip = TEConvertUtil.ipToString(pEthGne.getIp());
            int result = -1;
            result = TENECommMgr.getInstance().createConect((long)logicNeId, pEthGne.getPort(), ip, pEthGne.getGneType());
            if (result != 0) {
                TECommuUtil.onSockBreak(ulNeId);
                continue;
            }
            TECommuUtil.onConnectOK(ulNeId);
        }
    }

    public void correctCurrentState() {
        Collection c = TECommuNEMgr.getInstance().getAllCommuNE();
        for (TECommuNe pCommuNe : c) {
            if (1 != pCommuNe.getMainConnState() || -1 != pCommuNe.getMainGneId()) continue;
            pCommuNe.setMainConnState(2);
        }
    }

    public void registerAllCommu() {
        TIntIntHashMap mapNeId = new TIntIntHashMap();
        this.getAllCommuNe(mapNeId);
        TIntIntIterator iter = mapNeId.iterator();
        while (iter.hasNext()) {
            iter.advance();
        }
    }

    public void getAllCommuNe(TIntIntHashMap mapNeId) {
        Collection c = TECommuNEMgr.getInstance().getAllCommuNE();
        for (TECommuNe pCommuNe : c) {
            int neId = pCommuNe.getNeId();
            if (neId == 0) continue;
            int ulGneId = -1;
            int ulMainGneIdtemp = pCommuNe.getMainGneId();
            int ulBackup1GneIdtemp = pCommuNe.getBackup1gneId();
            int ulBackup2GneIdtemp = pCommuNe.getBackup2gneId();
            int ulBackup3GneIdtemp = pCommuNe.getBackup3gneId();
            if (ulMainGneIdtemp != -1) {
                pCommuNe.setNeGneState(0);
                ulGneId = ulMainGneIdtemp;
            } else if (ulBackup1GneIdtemp != -1) {
                pCommuNe.setNeGneState(1);
                ulGneId = ulBackup1GneIdtemp;
            } else if (ulBackup2GneIdtemp != -1) {
                pCommuNe.setNeGneState(2);
                ulGneId = ulBackup2GneIdtemp;
            } else if (ulBackup3GneIdtemp != -1) {
                pCommuNe.setNeGneState(3);
                ulGneId = ulBackup3GneIdtemp;
            } else {
                pCommuNe.setNeGneState(4);
            }
            mapNeId.put(neId, ulGneId);
        }
    }

    public int getGneHandle(int ulGneId, int nType) {
        int handle = -1;
        handle = 0;
        return handle;
    }
}

