/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.boardview;

import com.huawei.nglct.boardview.TEBoardMenu;
import com.huawei.nglct.boardview.TEMenuItem;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEBoardMenuFactory {
    private static TEBoardMenuFactory instance = new TEBoardMenuFactory();
    private static HashMap boardMenuMap = new HashMap();

    private TEBoardMenuFactory() {
    }

    public static TEBoardMenuFactory getInstance() {
        return instance;
    }

    public TEBoardMenu getBoardMenu(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        return this.getBoardMenu(ne.getNEType(), ne.getHostVersion());
    }

    public TEBoardMenu getBoardMenu(int neType, String hostVersion) {
        StringBuffer pathBuff = new StringBuffer(TEResourceManager.getPath());
        pathBuff.append("nemgr").append(File.separator).append("device").append(File.separator);
        pathBuff.append("boardmenu_").append(TESysManagerBean.getInstance().getlanguage()).append(".xml");
        TEBoardMenu boardMenu = (TEBoardMenu)boardMenuMap.get(pathBuff.toString());
        if (null == boardMenu && null != (boardMenu = this.parseBoardMenuFile(pathBuff.toString()))) {
            boardMenuMap.put(pathBuff.toString(), boardMenu);
        }
        return boardMenu;
    }

    public TEBoardMenu parseBoardMenuFile(String path) {
        TEBoardMenu boardmenu = null;
        Document doc = TEParseXMLFile.parseFile(path);
        if (null == doc) {
            return null;
        }
        Element element = doc.getDocumentElement();
        boardmenu = new TEBoardMenu();
        this.createBoardMenu(boardmenu, element);
        return boardmenu;
    }

    public void createBoardMenu(TEBoardMenu boardMenu, Element menuElement) {
        NodeList itemList = menuElement.getChildNodes();
        Node childNode = null;
        Element childElement = null;
        TEMenuItem menuitem = null;
        TEBoardMenu subBoardMenu = null;
        ArrayList menuList = boardMenu.getMenuItemList();
        int len = itemList.getLength();
        for (int i = 0; i < len; ++i) {
            childNode = itemList.item(i);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            if (childElement.getTagName().equals("menuitem")) {
                menuitem = new TEMenuItem(childElement.getAttribute("id"));
                menuitem.setMenuItemName(childElement.getAttribute("name"));
                menuitem.setFuncid(childElement.getAttribute("funcid"));
                menuitem.setAction(childElement.getAttribute("action"));
                menuitem.setNeConnectType(childElement.getAttribute("neconnecttype"));
                menuList.add(menuitem);
                continue;
            }
            if (!childElement.getTagName().equals("menu")) continue;
            subBoardMenu = new TEBoardMenu(childElement.getAttribute("id"));
            subBoardMenu.setMenuName(childElement.getAttribute("name"));
            this.createBoardMenu(subBoardMenu, childElement);
            boardMenu.getMenuItemList().add(subBoardMenu);
        }
    }
}

