/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.objselect.TENEIDAndName;
import com.huawei.nglct.consts.system.Environment;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.taskmgr.TEExtMsgHandler;
import com.huawei.nglct.core.taskmgr.TEGnlTask;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.neexplorer.AsnGetNGLCTParaReq;
import com.huawei.nglct.nemgr.f_interface.neexplorer.AsnGetNGLCTParaRsp;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datastruct.TEASNConvertor;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.commustru.fstru.FStruct;

public class TEGetNGLCTParaTask
implements TEExtMsgHandler {
    private static final String KEY = "YEK0002T";

    @Override
    public int handleMessage(FStruct req, FStruct[] rsp, TEGnlTask task) {
        this.onTaskExecuting(req, rsp, task.getCurReqMsg());
        return 0;
    }

    public boolean onTaskExecuting(FStruct reqAsn, FStruct[] rspAsn, MSGPacketExt data) {
        AsnGetNGLCTParaReq req = (AsnGetNGLCTParaReq)reqAsn;
        AsnGetNGLCTParaRsp rsp = new AsnGetNGLCTParaRsp();
        if (Environment.g_WebServerPort == -1) {
            TEASNConvertor.cfgFillRspRslt(1090609684, rsp.result);
            return false;
        }
        String webServerConnStr = this.getIpAddress().get(0) + ":" + "8080" + "/" + TESysManagerBean.getInstance().getContext();
        rsp.result.retCode = BigInteger.valueOf(0L);
        rsp.neID = req.neID;
        rsp.webServerConnStr = webServerConnStr.getBytes();
        String commStr = "";
        try {
            commStr = this.encrypt("lct1") + this.encrypt("lct123") + this.encrypt("127.0.0.1") + this.encrypt("11021");
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGetNGLCTParaTask.onTaskExecuting() fail!", (Throwable)e);
        }
        rsp.commStr = commStr.getBytes();
        rsp.result.isSuccess = true;
        TEASN1CommMgr.sendMessage((FStruct)rsp, TEASN1CommMgr.CreateMsgHead(data), 0x202211);
        return true;
    }

    private List getIpAddress() {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> cardipaddress = ni.getInetAddresses();
                while (cardipaddress.hasMoreElements()) {
                    InetAddress ip = cardipaddress.nextElement();
                    if (ip.getHostAddress().equalsIgnoreCase("127.0.0.1")) continue;
                    ipList.add(ip.getHostAddress());
                    while (cardipaddress.hasMoreElements()) {
                        ip = cardipaddress.nextElement();
                        ipList.add(ip.getHostAddress());
                    }
                }
            }
        }
        catch (SocketException ex) {
            TELogFactory.getNormalLogger().error("", (Throwable)ex);
        }
        return ipList;
    }

    protected void sortNEIDByName(List<Integer> neIDs) {
        int i;
        TENEIDAndName idName = new TENEIDAndName();
        ArrayList<TENEIDAndName> idNames = new ArrayList<TENEIDAndName>();
        int size = neIDs.size();
        for (i = 0; i < size; ++i) {
            int neID = neIDs.get(i);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String neName = ne.getNEName();
            if (neName == null || "".equals(neName)) {
                neName = "NE" + neID;
            }
            idName.neID = neID;
            idName.neName = neName;
            idNames.add(idName);
        }
        Collections.sort(idNames);
        neIDs.clear();
        size = idNames.size();
        for (i = 0; i < size; ++i) {
            neIDs.add(((TENEIDAndName)idNames.get((int)i)).neID);
        }
    }

    private String encrypt(String initStr) throws Exception {
        SecretKeySpec key = new SecretKeySpec(KEY.getBytes(), "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, key);
        return this.byte2hex(cipher.doFinal(initStr.getBytes()));
    }

    private String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder("");
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0').append(stmp);
            } else {
                hs.append(stmp);
            }
            if (n >= b.length - 1) continue;
            hs.append("");
        }
        return hs.toString().toUpperCase();
    }
}

