/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.q_interface.inventory_cp;

import com.huawei.nglct.nemgr.q_interface.common.QAsnCPIndex;
import com.huawei.nglct.nemgr.q_interface.inventory_cp.QAsnPortSFPInfoList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FormatedOutputStream;

public class QAsnCPExInfo
implements FStruct {
    public QAsnCPIndex cpIndex = new QAsnCPIndex();
    public byte[] version = null;
    public byte[] serialNo = null;
    public QAsnPortSFPInfoList sfpInfoList = null;

    public QAsnCPExInfo() {
    }

    public QAsnCPExInfo(QAsnCPExInfo arg) {
        this.cpIndex = new QAsnCPIndex(arg.cpIndex);
        this.version = new byte[arg.version.length];
        System.arraycopy(arg.version, 0, this.version, 0, arg.version.length);
        this.serialNo = new byte[arg.serialNo.length];
        System.arraycopy(arg.serialNo, 0, this.serialNo, 0, arg.serialNo.length);
        this.sfpInfoList = new QAsnPortSFPInfoList(arg.sfpInfoList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.cpIndex.serialize(enc);
        if (this.version != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.version);
        }
        if (this.serialNo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.serialNo);
        }
        if (this.sfpInfoList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.sfpInfoList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.cpIndex.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.version = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.serialNo = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.sfpInfoList = new QAsnPortSFPInfoList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.sfpInfoList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("-- asn file name: QAsnCPExInfo --");
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cpIndex = ");
        this.cpIndex.print(os, indent + 2);
        os.println(',');
        if (this.version != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("version = ");
            try {
                new FormatedOutputStream((OutputStream)os).write(this.version);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println(',');
        if (this.serialNo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("serialNo = ");
            try {
                new FormatedOutputStream((OutputStream)os).write(this.serialNo);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println(',');
        if (this.sfpInfoList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("sfpInfoList = ");
            this.sfpInfoList.print(os, indent + 2);
        }
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }
}

