/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.f_interface.emf.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FormatedOutputStream;

public class AsnRelativeResource
implements FStruct {
    public int resID;
    public byte[] label = null;
    public int maintype = -1;
    public int subtype = -1;
    public int iResNumber = -1;

    public AsnRelativeResource() {
    }

    public AsnRelativeResource(AsnRelativeResource arg) {
        this.resID = arg.resID;
        this.label = new byte[arg.label.length];
        System.arraycopy(arg.label, 0, this.label, 0, arg.label.length);
        this.maintype = arg.maintype;
        this.subtype = arg.subtype;
        this.iResNumber = arg.iResNumber;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.resID);
        if (this.label != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.label);
        }
        if (this.maintype != -1) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.maintype);
        }
        if (this.subtype != -1) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.subtype);
        }
        if (this.iResNumber != -1) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(this.iResNumber);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.resID = dec.deserializeIntegerAsInt();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.label = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.maintype = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.subtype = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.iResNumber = dec.deserializeIntegerAsInt();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("-- asn file name: AsnRelativeResource --");
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("resID = ");
        os.print(this.resID);
        os.println(',');
        if (this.label != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("label = ");
            try {
                new FormatedOutputStream((OutputStream)os).write(this.label);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println(',');
        if (this.maintype != -1) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("maintype = ");
            os.print(this.maintype);
        }
        os.println(',');
        if (this.subtype != -1) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("subtype = ");
            os.print(this.subtype);
        }
        os.println(',');
        if (this.iResNumber != -1) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iResNumber = ");
            os.print(this.iResNumber);
        }
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }
}

