/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.f_interface.asncommon;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FormatedOutputStream;

public class AsnFile
implements FStruct {
    public byte[] fileName;
    public byte[] fileContent;
    public int compressFlag;

    public AsnFile() {
    }

    public AsnFile(AsnFile arg) {
        this.fileName = new byte[arg.fileName.length];
        System.arraycopy(arg.fileName, 0, this.fileName, 0, arg.fileName.length);
        this.fileContent = new byte[arg.fileContent.length];
        System.arraycopy(arg.fileContent, 0, this.fileContent, 0, arg.fileContent.length);
        this.compressFlag = arg.compressFlag;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.fileName);
        enc.serializeOctetString(this.fileContent);
        enc.serializeInteger(this.compressFlag);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.fileName = dec.deserializeOctetString();
        this.fileContent = dec.deserializeOctetString();
        this.compressFlag = dec.deserializeIntegerAsInt();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("-- asn file name: AsnFile --");
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("fileName = ");
        try {
            new FormatedOutputStream((OutputStream)os).write(this.fileName);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (int ii3 = 0; ii3 < indent + 2; ++ii3) {
            os.print(' ');
        }
        os.print("fileContent = ");
        try {
            new FormatedOutputStream((OutputStream)os).write(this.fileContent);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("compressFlag = ");
        os.print(this.compressFlag);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }
}

