/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.f_interface.asnattrib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FormatedOutputStream;

public class AsnAttribValue
implements FStruct {
    public int attribID;
    public int attribAccess;
    public int intValue = -1;
    public byte[] strValue = null;
    public byte[] floatValue = null;

    public AsnAttribValue() {
    }

    public AsnAttribValue(AsnAttribValue arg) {
        this.attribID = arg.attribID;
        this.attribAccess = arg.attribAccess;
        this.intValue = arg.intValue;
        this.strValue = new byte[arg.strValue.length];
        System.arraycopy(arg.strValue, 0, this.strValue, 0, arg.strValue.length);
        this.floatValue = new byte[arg.floatValue.length];
        System.arraycopy(arg.floatValue, 0, this.floatValue, 0, arg.floatValue.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.attribID);
        enc.serializeInteger(this.attribAccess);
        if (this.intValue != -1) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.intValue);
        }
        if (this.strValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strValue);
        }
        if (this.floatValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.floatValue);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.attribID = dec.deserializeIntegerAsInt();
        this.attribAccess = dec.deserializeIntegerAsInt();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.intValue = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strValue = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.floatValue = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("-- asn file name: AsnAttribValue --");
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attribID = ");
        os.print(this.attribID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attribAccess = ");
        os.print(this.attribAccess);
        os.println(',');
        if (this.intValue != -1) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("intValue = ");
            os.print(this.intValue);
        }
        os.println(',');
        if (this.strValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strValue = ");
            try {
                new FormatedOutputStream((OutputStream)os).write(this.strValue);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println(',');
        if (this.floatValue != null) {
            for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
                os.print(' ');
            }
            os.print("floatValue = ");
            try {
                new FormatedOutputStream((OutputStream)os).write(this.floatValue);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println();
        for (int ii3 = 0; ii3 < indent; ++ii3) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }
}

