<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.huawei.vmf.common.util.WebUtil;" %>
<%
    String callback = WebUtil.encodeOutput(request.getParameter("callback"));
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" oncontextmenu="return false">
<head>
<meta http-equiv="X-UA-Compatible" content="IE=7"/>
    <title></title>
<link rel="stylesheet" type="text/css"
    href="/uflight/jse/style/widgets.css" />
    <script type="text/javascript" src="/uflight/jse/jse.js"></script>
    <script type="text/javascript" src="../../../vmt/ct/systemmgr/constants/constants.js"></script>
        <script type="text/javascript" src="../../../vmt/ct/devicemgr/common/map.js"></script>
    <script type="text/javascript" src="../../../vmt/ct/common/processor/tabkeyprocess.js"></script> 
	<script type="text/javascript" src="../../../vmt/ct/common/util/commonutil.js"></script>
    <script type="text/javascript"> 
    /**
     * 顶层容器对象
     */
    var RootBox = null;
    /**e
     * 详细列表对象
     */
    var tblDetail = null;
    /**
     * 是否显示标识
     */
    var isDisplay = true;
    /**
     * 父页面对象
     */
    var win = null;
    /**
     * 详细按钮对象
     */
    var btnDetail = null;
    /**
     * 错误提示信息标签
     */
    var lblErrorInfo = null;
    /**
     * 获取常量对象
     */
    var Constants = new Constants();
    /**
     * 映射表,在ftp.xui界面文件中定义的事件都在此映射表中做 映射
     * 并在此文件中处理
     */
    var signalMap = {
        on_load_ui :doLoad,
        on_click_detail :doDetail,
        on_click_close :doClose
    };

    /**
     * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来
     */
    function init() 
    {
        window.xui = new jse.XUI();
		window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
        window.xui.load("../../../vmt/ct/common/errordialog.xui", signalMap);
    }

    /**
     * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来
     */
    function doLoad() 
    {
        setTimeout("loadContent();",500);
    }

    /**
     * 加载详细的错误信息
     */
   function loadContent()
   {
     //获取界面控件对象
       RootBox = window.xui.getWidget("RootBox");
       tblDetail = window.xui.getWidget("tblDetail");
       btnDetail = window.xui.getWidget("btnDetail");
       lblErrorInfo = window.xui.getWidget("lblErrorInfo");
       
       var closeBtn = window.xui.getWidget("btnClose");
       closeBtn.focus();
       
       //获取父页面对象
       win = jse.getFromWin();
       //获取父页面的DOM对象
       var doc = jse.base.util.loadXML(win.errorText);
       
       //获得返回报文中的errorMessage节点(数组)
       var nodes = jse.selectNodes("//errorMessage", doc);
       //获取errorMessage节点个数
       var length = nodes.length;
       
       // 获取operResultType节点
       var operNode = jse.selectSingleNode("/response/operResultType", doc);
       
       // 获取节点 resultType 属性值
       var resultType = operNode.getAttribute("resultType");
       var errorCode = "";
		       
       // 一条失败记录时
       if(1 == length)
       {
           if(Constants.OPER_NOK == resultType)
           {
               var text = jse.getI18nValue("qat:public", "table.failed_d");
               lblErrorInfo.setText(text);
           }
           else
           {
           	 var text = jse.getI18nValue("qat:public", "table.partfailed_d");
                lblErrorInfo.setText(text);
           }
           
           if (nodes[0]!=null) 
   		{
   			errorCode = nodes[0].getAttribute("errorCode");
   		}
           var OperObj = nodes[0].getAttribute("operatedObject");
           if("null" == OperObj)
           {
               OperObj = jse.getI18nValue("qat:public", "table.null_d");
           }
           else
           {
               var ipos = OperObj.search("@obj@");
               if (-1 != ipos)
               {
               	OperObj = getErrorInfo(OperObj, ipos);
               }
           }
           var OperObjCell = {value:OperObj,tooltip:OperObj};
           
           var OperResult = jse.getI18nValue("qat:public", "FAIL");
           
           var OperResCell = {value:OperResult,tooltip:OperResult};
			//从报文中读取错误信息，如果是主机错误，错误信息由主机传上来，如果是后台自身错误，错误信息从资源文件读出
           var Reason = nodes[0].getAttribute("errorMsg");
           if(null == Reason || "null" == Reason)
           {
               Reason = jse.getI18nValue("qat:errorcode", errorCode);
           }
           else
           {
               var fullStop = jse.getI18nValue("qat:public", "label.fullstop_d") ;
               if(fullStop != Reason.substr(Reason.length - 1,1))
               {
               	Reason = Reason + fullStop;
               }              
           	Reason = Reason +" " + jse.getI18nValue("qat:public","label.neerror_d") + errorCode;
           }
           var ReasonCell = {value:Reason,tooltip:Reason};
           
           tblDetail.addRow("row" + 0, {
               OperObj :OperObjCell,
               OperResult :OperResCell,
               Reason :ReasonCell
           });
           setTableColumnWidth(OperObj,OperResult,Reason);
       }
       else
       {
           if(Constants.OPER_NOK == resultType)
           {
               var text = jse.getI18nValue("qat:public", "table.allfailed_d");
               lblErrorInfo.setText(text);
           }
           else
           {
           	 var text = jse.getI18nValue("qat:public", "table.partfailed_d");
                lblErrorInfo.setText(text);
           }
           //将错误信息添加到详细列表中
           for ( var i = 0; i < length; i++) 
          {
               var OperObj = nodes[i].getAttribute("operatedObject");
               if("null" == OperObj)
               {
                   OperObj = jse.getI18nValue("qat:public", "table.null_d");
               }
               else
               {
                   var ipos = OperObj.search("@obj@");
                   if (-1 != ipos)
                   {
                   	OperObj = getErrorInfo(OperObj, ipos);
                   }
               }
               var OperObjCell = {value:OperObj,tooltip:OperObj};
               
               var OperResult = null;
               if(Constants.OPER_OK == resultType)
               {
                   OperResult = jse.getI18nValue("qat:public", "SUCCESS");
               }
               else
               {
                   OperResult = jse.getI18nValue("qat:public", "FAIL");
               }
               var OperResCell = {value:OperResult,tooltip:OperResult};
               
               errorCode = nodes[i].getAttribute("errorCode");
   			//从报文中读取错误信息，如果是主机错误，错误信息由主机传上来，如果是后台自身错误，错误信息从资源文件读出
               var Reason = nodes[0].getAttribute("errorMsg");
               if(null == Reason || "null" == Reason)
               {
                   Reason = jse.getI18nValue("qat:errorcode", errorCode);
               }
               else
               {
                   var fullStop = jse.getI18nValue("qat:public", "label.fullstop_d") ;
                   if(fullStop != Reason.substr(Reason.length - 1,1))
                   {
                   	Reason = Reason + fullStop;
                   }
               	 Reason = Reason +" " + jse.getI18nValue("qat:public","label.neerror_d") + errorCode;
               }
               var ReasonCell = {value:Reason,tooltip:Reason};
               
               tblDetail.addRow("row" + i, {
                   OperObj :OperObjCell,
                   OperResult :OperResCell,
                   Reason :ReasonCell
               });
           }
       }

       RootBox.pack();
   }
    
    /**
     * 根据内容设置表格各列的长度
     */
    function setTableColumnWidth(OperObj,OperResult,Reason)
    {
        var flag = jse.topWin.flag;
        var rate = flag?10:6;
        
        var columns = new Array();

        var operObjColumn = new Array();
        operObjColumn.push("OperObj");
        var width = rate*(OperObj.length);
        width = (width<100)?100:width;
        operObjColumn.push(width);
        
        var operResColumn = new Array();
        operResColumn.push("OperResult");
        width = rate*(OperResult.length);
        width = (width<100)?100:width;
        operResColumn.push(width);
        
        var reasonColumn = new Array();
        reasonColumn.push("Reason");
        width = rate*(Reason.length);
        width = (width<100)?100:width;
        reasonColumn.push(width);
        
        columns.push(operObjColumn);
        columns.push(operResColumn);
        columns.push(reasonColumn);
        
        tblDetail.setColumnsWidth(columns);
    }

    /**
    * 获取错误对象信息
    **/
	function getErrorInfo(source, ipos)
	{
        // 取得featureVersion用于构造路径
       var featureName = source.substring(0, ipos);
       
        var ipos1 = source.search(/[(]/);
        var ipos2 = source.search(/[=]/);
        
        // 取得操作对象的xpath
        var objXpath = source.substring(ipos + 5, ipos1);
        var objName = Resource.getXpathResource(featureName,objXpath);
        
     	// 取得关键值属性的xpath
        var attriXpath = source.substring(ipos1 + 1, ipos2);
        var attriName = Resource.getXpathResource(featureName,attriXpath);
        var value = source.substring(ipos2 + 1, source.length - 1);

        var errorInfo = objName + "(" + attriName + "=" + value + ")";	

        return errorInfo;
	}
	
    /**
     * 点击[详细]按钮事件处理
     */
    function doDetail() {
        var tblLayoutData = null;
        
        switch (isDisplay) {
        //详细列表已经显示的状态
        case true:
        	win.setPreferSize(540, 170);
            btnDetail.setText(jse.getI18nValue("qat:public", "button.detail1_d"));
            RootBox.pack();
            isDisplay = false;
            break;
        //详细列表隐藏的状态
        case false:
        	win.setPreferSize(540, 340);
            btnDetail.setText(jse.getI18nValue("qat:public", "button.detail2_d"));
            RootBox.pack();
            isDisplay = true;
            break;
        }
    }

    /**
     * 点击[关闭]按钮事件处理
     */
    function doClose(evt) 
    {
        //调用回调函数
        <%=callback%>
    }
    Event.observe(window,"load",init);
    </script>
</head>
<body>
</body>
</html>