/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.windowmgr.web;

import com.huawei.vmf.common.tool.IOUtil;
import com.huawei.vmf.qat.common.GlobalConstants;
import com.huawei.vmf.qat.common.check.HttpReqParaExceptionHandler;
import com.huawei.vmf.qat.common.check.HttpReqParaInvalidateException;
import com.huawei.vmf.qat.security.support.HttpReqParaInfoEnum;
import com.huawei.vmf.qat.security.util.HttpReqUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileDownlodServlet
extends HttpServlet {
    private static final int FILENAMEMAX_LEN = 150;
    private static final int INPUTBUFF_SIZE = 2048;
    private static final int LIMITATION = 9;

    public static void main(String[] args) {
        System.out.println("?aA1".matches("[A-Za-z0-9]+"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = null;
        String tmpFolderName = null;
        String selLanuage = null;
        try {
            fileName = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.FILE_NAME, (HttpServletRequest)request) + "";
            tmpFolderName = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.FOLDER_NAME, (HttpServletRequest)request) + "";
            selLanuage = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.SEL_LANUAGE, (HttpServletRequest)request) + "";
        }
        catch (HttpReqParaInvalidateException e) {
            HttpReqParaExceptionHandler.invalidSession((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        fileName = URLDecoder.decode(fileName, "UTF-8");
        String filePath = null == selLanuage || "".equals(selLanuage) || "null".equals(selLanuage) ? GlobalConstants.TMP_DATA_DIR + File.separator + fileName : GlobalConstants.TMP_DIR + File.separator + tmpFolderName + File.separator + selLanuage + File.separator + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().print("File is not exist! fileName=" + fileName);
            return;
        }
        this.setResponse(request, response, fileName);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(filePath));
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            int bytesRead = bis.read(buff, 0, buff.length);
            while (-1 != bytesRead) {
                bos.write(buff, 0, bytesRead);
                bytesRead = bis.read(buff, 0, buff.length);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(bis);
            IOUtil.close(bos);
            throw throwable;
        }
        IOUtil.close((InputStream)bis);
        IOUtil.close((OutputStream)bos);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void setResponse(HttpServletRequest request, HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        String agent = request.getHeader("USER-AGENT");
        if (null != agent && -1 != agent.indexOf("MSIE")) {
            String prefix = fileName.lastIndexOf(95) != -1 ? fileName.substring(0, fileName.lastIndexOf(95)) : fileName;
            String extension = fileName.lastIndexOf(95) != -1 ? fileName.substring(fileName.lastIndexOf(95)) : "";
            String name = URLEncoder.encode(fileName, "UTF-8");
            name = URLEncoder.encode(fileName, "UTF-8");
            String codedfilename = "";
            int limit = 150 - extension.length();
            if (name.length() > limit) {
                int length = Math.min(prefix.length(), limit / 9);
                name = URLEncoder.encode(prefix.substring(0, length), "UTF-8");
                codedfilename = name + extension;
            } else {
                codedfilename = name;
            }
            response.setContentType("text/html;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=\"" + codedfilename + "\"");
        } else if (null != agent && -1 != agent.indexOf("Mozilla")) {
            byte[] bytes = fileName.getBytes();
            String newFileName = new String(bytes, "ISO8859-1");
            response.setContentType("text/html;charset=UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=\"" + newFileName + "\"");
        } else {
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        }
    }
}

