/**
 * 父辈窗口引用
 */
var openerWin = null;

/**
 * 用户名引用
 */
var username = null;

/**
 * 密码引用
 */
var password = null;

/**
 * 错误提示栏引用
 */
var errorMsg = null;

/**
 * 语言选择下拉框引用
 */
var selLanuage = null;
/**
 * 语言选择下拉框引用
 */
var distructSelect = null;
/**
 * 确定按钮引用
 */
var btnOK = null;

/**
 * 重至按钮引用
 */
var btnReset = null;

/**
 * 错误提示栏标识
 */
var errMsgFlg = "null";

/**
 * 语种标识
 */
var flag = true;

/**
 * text中的内容转换为DOM结构的对象 错误提示对话框使用
 */
var doc = null;

/**
 * 后台返回的结果类型
 */
var resultType = null;

/**
 * 向后台传递预存cookies原始信息
 */
var cookiesInfo = null;

/**
 * Mozilla Firefox 浏览器标识
 */
var FIREFOX_BROWSER = "Netscape";

/**
 * Microsoft Internet Explorer 浏览器标识
 */
var IE_BROWSER = "Microsoft";

/**
 * 初始化
 */
function init()
{
    Event.observe($("submit"), "click", submitLogin);
    Event.observe($("reset"), "click", resetLoginView);
    Event.observe($("distructSelect"), "change", doChanged);
    Event.observe($("memorypassword"), "click", doMemorypasswordCheckboxChanged);
    Event.observe($("autologin"), "click", doAutologinCheckboxChanged);

    openerWin = jse.getFromWin();

    // 获取控件引用
    username = document.getElementById("username");
    password = document.getElementById("password");
    btnOK = document.getElementById("submit");
    btnReset = document.getElementById("reset");
    distructSelect = document.getElementById("distructSelect");

    $('errorMsg').innerHTML = "";

    password.focus();

    var userNameNode = $("username");
    Event.observe(userNameNode, "keydown", doUsernameOnkeyup);

    var userNameNode = $("password");
    Event.observe(userNameNode, "keydown", doPasswordOnkeyup);
    
    var memoryPasswordNode = $("memorypassword");
    Event.observe(memoryPasswordNode, "keydown", doMemoryPasswordOnkeyup);
    
    var autoLoginNode = $("autologin");
    Event.observe(autoLoginNode, "keydown", doAutoLoginNodeOnkeyup);

    // 注册tab键切换事件
    Tabkeyprocess.registKeyDown(btnReset, Tabkeyprocess.BUTTON, distructSelect, Tabkeyprocess.BUTTON);
}

/**
 * 根据cookies信息初始化登录页面，处理记住密码和自动登录
 */
function initCookie()
{
    // 读取cookie信息处理"记住密码"和"自动登录",刷新页面
    initcookies();

    // 设置语言为浏览器的语言
    initLanguage();
}

/**
 * 记住密码checkbox触发事件
 */
function doMemorypasswordCheckboxChanged(evt)
{
    if (!$("memorypassword").checked)
    {
        $("autologin").checked = false;
    }
}

/**
 * 自动登录checkbox触发事件
 */
function doAutologinCheckboxChanged(evt)
{
    if ($("autologin").checked)
    {
        $("memorypassword").checked = true;
    }
    else
    {
        $("memorypassword").checked = false;
    }
}

/**
 * 读取cookie信息处理"记住密码"和"自动登录",刷新页面
 */
function initcookies()
{
    var name = "vmt_cookie_security=";
    var allcookies = document.cookie;
    var pos = allcookies.indexOf(name);

    if (pos != -1)
    {

        var start = pos + name.length; // Start of cookie value

        var end = allcookies.indexOf(";", start); // End of cookie value

        if (end == -1)
        {
            end = allcookies.length;
        }

        var value = allcookies.substring(start, end); // Extract the value

        var cookieInfo = value.split("_");

        if (value != null)
        {
            if (cookieInfo[1] == "true")
            {
                $("memorypassword").checked = true;
                $("password").value = cookieInfo[0];
            }
            else
            {
                $("memorypassword").checked = false;
            }

            if (cookieInfo[2] == "true")
            {
                $("autologin").checked = true;
            }
            else
            {
                $("autologin").checked = false;
            }
        }
    }
    if (pos == -1)
    {
        // alert("cookies not found");
    }
}

function initLanguage()
{
    // 向后台请求功能树的数据
    var req = jse.RpcRequest.create(CommonUtil.getRootPath() + "/vmt/security/BrowerLangAction.do?methodID=handleBrowerLangRequest");
    req.invoke(handleResult, [ "initLangCallback();" ]);
}

function initLangCallback()
{
    if ("OPER_OK" == resultType)
    {
        var langNode = jse.selectSingleNode("/response/language", doc);

        var lang = langNode.getAttribute("value");

        // 设置语言标识
        if (lang.toLowerCase().indexOf("en") > -1)
        {
            lang = "en_US";
            flag = false;
        }
        else if (lang.toLowerCase().indexOf("zh") > -1)
        {
            lang = "zh_CN";
            flag = true;
        }
        else
        {
            lang = "en_US";
            flag = false;
        }

        $("username").value = "admin";
        $("memorypassword").text = jse.getI18nValue("qat:public", "label.language_ch_d");
        $("autologin").text = jse.getI18nValue("qat:public", "label.language_ch_d");
        // 重新设置语言
        jse.setLanguage(lang);
        loadStaticResource("rcid");

        // 设置下拉框为相应的值
        var select = $("distructSelect");

        for ( var i = 0; i < select.length; i++)
        {
            if (select.options[i].value == lang)
            {
                select.options[i].selected = true;
                break;
            }
        }

        // 重新加载资源
        // loadStaticResource("rcid");
        username = document.getElementById("username");
        password.focus();

        selLanuage = lang;
        $('errorMsg').innerHTML = "";
    }

    // 自动登录跳转到设备列表页面
    if ($("autologin").checked && $("password").value != "")
    {
        submitLogin();
    }
}

/**
 * 用户名文本框点击回车键事件处理函数
 */
function doUsernameOnkeyup(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        password = document.getElementById("password");
        // TODO by wangli 20090323每次发布版本前要将这行显出下行隐掉
        // password.focus();
        btnOK.focus();
    }
}

/**
 * 记住密码复选框点击回车键事件处理函数
 */
function doMemoryPasswordOnkeyup(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        password = document.getElementById("password");
        // TODO by wangli 20090323每次发布版本前要将这行显出下行隐掉
        // password.focus();
        btnOK.focus();
    }
}

/**
 * 自动登录复选框点击回车键事件处理函数
 */
function doAutoLoginNodeOnkeyup(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        password = document.getElementById("password");
        // TODO by wangli 20090323每次发布版本前要将这行显出下行隐掉
        // password.focus();
        btnOK.focus();
    }
}

/**
 * 密码文本框点击回车键事件处理函数
 */
function doPasswordOnkeyup(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        btnOK.focus();
    }
}

/**
 * 切换语言事件处理函数
 */
function doChanged()
{
    // 设置语言标识
    var lang = flag ? "en_US" : "zh_CN";
    flag = !flag;

    $("username").value = "admin";

    // 重新设置语言
    jse.setLanguage(lang);

    // 重新加载资源
    loadStaticResource("rcid");

    password = document.getElementById("password");
    password.focus();

    var select = $("distructSelect");
    selLanuage = select.options[select.selectedIndex].value;

    $('errorMsg').innerHTML = "";
}

/**
 * 加载静态语言资源
 * 
 * @param rcid 静态资源标识
 */
function loadStaticResource(rcid)
{
    var languageSel = $("distructSelect");
    languageSel.options[0].text = jse.getI18nValue("qat:public", "label.language_ch_d");
    languageSel.options[1].text = jse.getI18nValue("qat:public", "label.language_en_d");
    jse.loadStaticResource(rcid);
}

/**
 * 点击【确定】按钮事件处理函数
 */
function submitLogin()
{
    var loginInfo =
    {
        "username" :$("username").value,
        "password" :$("password").value
    };

    username = loginInfo.username;
    password = loginInfo.password;

    var patrn = /[\uFF00-\uFFFF]/; // 全角符号

    if (loginInfo.username.length == 0)
    {
        var ivalue=jse.getI18nValue("qat:public", "label.username_empty_d");
        $('errorMsg').innerHTML =(ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,'')); 
        errMsgFlg = "msg_username_empty";
        username = document.getElementById("username");
        username.focus();
        return;
    }
    if (loginInfo.password.length == 0)
    {
        var ivalue=jse.getI18nValue("qat:public", "label.password_empty_d");
        $('errorMsg').innerHTML = (ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,'')); 
        errMsgFlg = "msg_password_empty";
        password = document.getElementById("password");
        password.focus();
        return;
    }
    if (loginInfo.password.length > 32)
    {
        var ivalue=jse.getI18nValue("qat:public", "label.login_error_d");
        $('errorMsg').innerHTML = (ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,'')); 
        errMsgFlg = "msg_login_error";
        password = document.getElementById("password");
        $("password").value = "";
        password.focus();
        return;
    }
    if (patrn.exec(loginInfo.password))
    {
        var ivalue=jse.getI18nValue("qat:public", "label.login_error_d");
        $('errorMsg').innerHTML = (ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,'')); 
        errMsgFlg = "msg_login_error";
        password = document.getElementById("password");
        $("password").value = "";
        password.focus();
        return;
    }
    if (!check(loginInfo.password))
    {
        var ivalue=jse.getI18nValue("qat:public", "label.login_error_d");
        $('errorMsg').innerHTML = (ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,'')); 
        errMsgFlg = "msg_login_error";
        password = document.getElementById("password");
        $("password").value = "";
        password.focus();
        return;
    }

    var tempM = false;
    var tempA = false;
    if ($("memorypassword").checked)
    {
        tempM = true;
    }
    if ($("autologin").checked)
    {
        tempA = true;
    }

    var ajaxReq = jse.RpcRequest.create(CommonUtil.getRootPath() + "/vmt/security/indeplogin.do?userNameIdentifier=" + username
            + "&pwdIdentifier=" + password + "&languageIdentifier=" + selLanuage + "&vmt_cookie_security="
            + loginInfo.password + "_" + tempM + "_" + tempA);

    ajaxReq.invoke(handleResult, [ "submitLoginCallback();" ]);
}

/**
 * 检查密码是否符合规则
 * 
 * @return 检验是否符合规则的结果，true表示符合规则，false表示不符合规则
 */
function check(str)
{
    for ( var i = 0; i < str.length; i++)
    {
        var c = str.charCodeAt(i);
        if ((c < 0x0020) || (c > 0x007e))
        {
            return false;
        }
    }
    return true;
}

/**
 * 确认登录响应函数
 */
function submitLoginCallback()
{    
    if ("OPER_OK" == resultType)
    {
        try
        {
            var url = CommonUtil.getRootPath() + "/vmt/ct/devicewindowhtml.jsp?pageType=DEVICEMGR&language=" + selLanuage
                    + "&independence=true&xuiSwitch=true";

            if (-1 != navigator.appName.indexOf(FIREFOX_BROWSER))
            {
                window.location = url;
            }
            else if (-1 != navigator.appName.indexOf(IE_BROWSER))
            {
                var newPopup = window.open(url, "", "top=0,left=0,height=" + screen.availHeight + ",width="
                        + screen.availWidth + ",menubar=0,status=yes,scrollbars=yes,resizable=yes,location=no");
                window.opener = null;
                window.open('about:blank', '_self');
                window.close();
            }

        }
        catch (ex)
        {
            window.opener = null;
            window.open('about:blank', '_self');
            window.close();
        }
    }
    else
    {
        var node = jse.selectSingleNode("/response/isRemoteHostAreadyLogin", doc);
        var isRemoteHostAreadyLogin = node.getAttribute("value");
        if(isRemoteHostAreadyLogin == "true")
        {
            VMTError("win.closeErrDlg_submitLogin();"); 
        }
        else
        {
            var ivalue=jse.getI18nValue("qat:public", "label.login_error_d");
            $('errorMsg').innerHTML =(ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,''));  
            errMsgFlg = "msg_login_error";
            password = document.getElementById("password");
            $("password").value = "";
            password.focus();
            return;
        }
    }
}

function closeErrDlg_submitLogin()
{
    // errorDlg.dispose();
}
/**
 * 重置处理函数
 */
function resetLoginView()
{
    $("password").value = "";
    $('errorMsg').innerHTML = "";
    password = document.getElementById("password");
    password.focus();
}

/**
 * 语言切换处理错误提示栏中英文资源处理函数
 */
function languageChangeErr()
{
    switch (errMsgFlg)
    {
        case "null":
            $('errorMsg').innerHTML = "";
            break;
        case "msg_username_empty":
            var ivalue=jse.getI18nValue("qat:public", "label.username_empty_d");
            $('errorMsg').innerHTML = (ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,''));  
            break;
        case "msg_password_empty":
            var ivalue=jse.getI18nValue("qat:public", "label.password_empty_d");
            $('errorMsg').innerHTML = (ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,''));  
            break;
        case "msg_login_error":
            var ivalue=jse.getI18nValue("qat:public", "label.login_error_d");
            $('errorMsg').innerHTML =(ivalue==null?ivalue:ivalue.replace(/<.+?>/gim,''));  
            break;
        default:
            break;
    }
}

/**
 * 错误对话框回调函数
 * 
 * @return
 */
function closeDlg()
{
    // errorDlg.dispose();
}

/**
 * 设置错误对话框大小
 * 
 * @param width
 * @param height
 */
function setPreferSize(width, height)
{
    errorDlg.setPreferSize(width, height);
}

Event.observe(window, "load", init);