/**
 * 顶层容器对象
 */
var RootBox = null;

/**
 * 是否显示标识
 */
var isDisplay = false;

/**
 * 父页面对象
 */
var fromwin = null;

/**
 * 详细按钮对象
 */
var btnDetail = null;

/**
 * 详细文本框
 */
var txtAreaDetail = null;

/**
 * 详细对话框宽度
 */
var detailDlgWidth = 370;

/**
 * 详细对话框高度
 */
var detailDlgHeight = 138;

/**
 * 详细对话框高度
 */
var detailDlgHgtExp = 265;

/**
 * 映射表,在ftp.xui界面文件中定义的事件都在此映射表中做 映射 并在此文件中处理
 */
var signalMap =
{
    on_load_ui :doLoad,
    on_click_detail :doDetail,
    on_click_close :doClose
};

/**
 * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/security/prompt.xui", signalMap);

   
}

/**
 * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来
 */
function doLoad()
{
    // 获取界面控件对象
    RootBox = window.xui.getWidget("RootBox");
    btnDetail = window.xui.getWidget("btnDetail");
    txtAreaDetail = window.xui.getWidget("txtAreaDetail");
    txtAreaDetail.setText(jse.getI18nValue("qat:public",
            "label.common_password1_d"));
    // 获取父页面对象
    fromwin = jse.getFromWin();
}

/**
 * 点击[详细]按钮事件处理
 */
function doDetail()
{
    var tblLayoutData = null;

    switch (isDisplay)
    {
    // 详细列表已经显示的状态
    case true:
        fromwin.setPromptPreferSize(detailDlgWidth, detailDlgHeight);
        btnDetail.setText(jse.getI18nValue("qat:public", "button.detail1_d"));
        RootBox.pack();
        isDisplay = false;
        break;
    // 详细列表隐藏的状态
    case false:
        fromwin.setPromptPreferSize(detailDlgWidth, detailDlgHgtExp);
        btnDetail.setText(jse.getI18nValue("qat:public", "button.detail2_d"));
        RootBox.pack();
        isDisplay = true;
        break;
    }
}

/**
 * 点击[关闭]按钮事件处理
 */
function doClose()
{
    // 关闭对话框
    // jse.closeSelfView();
    // fromwin.txtNewPwd.focus();
    // 重新输入密码
    fromwin.reInput();
}

Event.observe(window, "load", init);