/**
 * 引用父窗体dialog对话框
 */
/**
 * 取消按钮
 */
var btnCancle = null;
/**
 * 确定按钮
 */
var btnAfirm = null;

/**
 * 旧密码标签
 */
var lblOldPwd = null;

/**
 * 旧密码输入框引用
 */
var txtOldPwd = null;

/**
 * 旧密码输入框引用
 */
var contentOldPwd = null;
/**
 * 旧密码提示lable引用
 */
var lblerror_tip = null;
/**
 * 旧密码提示lable引用
 */
var lblOldPwd_tip = null;

/**
 * 新密码标签
 */
var lblNewPwd = null;

/**
 * 新密码输入框引用
 */
var txtNewPwd = null;

/**
 * 新密码输入框引用
 */
var contentNewPwd = null;

/**
 * 新密码提示lable引用
 */
var lblNewPwd_tip = null;

/**
 * 确认新密码标签
 */
var lblAffirmNewPwd = null;

/**
 * 确认新密码输入框引用
 */
var txtAffirmNewPwd = null;

/**
 * 确认新密码输入框引用
 */
var contentAffirmNewPwd = null;

/**
 * 确认新密码提示lable引用
 */
var lblAffirmNewPwd_tip = null;

/**
 * 取消重置引用
 */
var btnCancel = null;

/**
 * 提示字体颜色
 */
var promptColor = "#FF0000";

/**
 * 后台返回错误信息文本
 */
var doc = null;

/**
 * 错误对话框的对象
 */
var errorDlg = null;

/**
 * resultType的对象
 */
var resultType = null;

/**
 * 修改密码成功中英文资源
 */
var password_succeed = null;

/**
 * 提示对话框对象
 */
var vmtalert = null;

/**
 * 提示对话框对象
 */
var promptDlg = null;
/**
 * 提示对话框宽度
 */
var promptDlgWidth = 370;
/**
 * 提示对话框高度
 */
var promptDlgHeight = 136;
/**
 * 处理方法映射
 */
var signalMap =
{
    on_load_ui :doLoad,
    on_click_Afirm :doOK,
    on_click_Cancle :doCancle
};

/**
 * 加载xui
 */
function init()
{
    // 生成一个xui实例, window.xui
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    // 通过window.xui加载修改密码界面的xui文件和事件列表
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/security/modifypwd.xui", signalMap);
}

/**
 * 加载时初始化
 */
function doLoad()
{
    // 获取控件引用
    btnCancle = window.xui.getWidget("btnCancle");
    btnAfirm = window.xui.getWidget("btnAfirm");
    
    // 错误提示控件
    lblerror_tip = window.xui.getWidget("lblerror_tip");
    
    // 旧密码相关控件
    lblOldPwd = window.xui.getWidget("lblOldPwd");
    txtOldPwd = window.xui.getWidget("txtOldPwd");
    lblOldPwd_tip = window.xui.getWidget("lblOldPwd_tip");
    
	//注册前置校验文本,旧密码
	var infoOldPwd  = new Preconstraints.textInfo(Preconstraints.TEXT_STRING,1,25,null, false);
	Preconstraints.registText(txtOldPwd,infoOldPwd);
    
    // 新密码相关控件
    lblNewPwd = window.xui.getWidget("lblNewPwd");
    txtNewPwd = window.xui.getWidget("txtNewPwd");
    lblNewPwd_tip = window.xui.getWidget("lblNewPwd_tip");
	//注册前置校验文本,新密码
	var infoNewPwd  = new Preconstraints.textInfo(Preconstraints.TEXT_STRING,1,25,null, false);
	Preconstraints.registText(txtNewPwd,infoNewPwd);
    
    // 确认新密码相关控件
    lblAffirmNewPwd = window.xui.getWidget("lblAffirmNewPwd");
    txtAffirmNewPwd = window.xui.getWidget("txtAffirmNewPwd");
    lblAffirmNewPwd_tip = window.xui.getWidget("lblAffirmNewPwd_tip");
    
	//注册前置校验文本,新密码确认
	var infoNewPwdEx  = new Preconstraints.textInfo(Preconstraints.TEXT_STRING,1,25,null, false);
	Preconstraints.registText(txtAffirmNewPwd,infoNewPwdEx);
	  
    //注册tab键切换事件
    //Tabkeyprocess.registKeyDown(btnCancle, Tabkeyprocess.BUTTON, txtOldPwd, Tabkeyprocess.PASSWORD);
	Tabkeyprocess.registKeyDown(btnAfirm, Tabkeyprocess.BUTTON, btnCancle, Tabkeyprocess.BUTTON);
    
    // 设置字体颜色
    font =
    {
        color :promptColor
    }
    lblerror_tip.setFont(font);
    lblOldPwd_tip.setFont(font);
    lblNewPwd_tip.setFont(font);
    lblAffirmNewPwd_tip.setFont(font);
    
    lblOldPwd_tip.setText("*");
    lblNewPwd_tip.setText("*");
    lblAffirmNewPwd_tip.setText("*");

    // 错误提示相关中英文资源
    oldpassword_empty = jse.getI18nValue("qat:public",
            "label.oldpassword_empty_d");
    oldpassword_error = jse.getI18nValue("qat:public",
            "label.oldpassword_error_d");
    newpassword_empty = jse.getI18nValue("qat:public",
            "label.newpassword_empty_d");
    newpassword_error = jse.getI18nValue("qat:public",
            "label.newpassword_error_d");
    affirmnewpassword_empty = jse.getI18nValue("qat:public",
            "label.affirmnewpassword_empty_d");
    affirmnewpassword_error = jse.getI18nValue("qat:public",
            "label.affirmpassword_error_d");
    password_succeed = jse.getI18nValue("qat:public", "label.succeed_d");

    var txtOldPwdNode = $("txtOldPwd");
    var txtNewPwdNode = $("txtNewPwd");
    var txtAffirmNewPwdNode = $("txtAffirmNewPwd");
    Event.observe(txtOldPwdNode, "keydown", doTxtOldPwdOnkeyup);
    Event.observe(txtNewPwdNode, "keydown", doTxtNewPwdOnkeyup);
    Event.observe(txtAffirmNewPwdNode, "keydown", doTxtAffirmNewPwdOnkeyup);

    // 将鼠标焦点定位在旧密码输入文本框
    txtOldPwd.focus();
}

/**
 * 旧密码文本框回车键处理事件
 */
function doTxtOldPwdOnkeyup(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        txtNewPwd = document.getElementById("txtNewPwd");
        txtNewPwd.focus();
    }
}

/**
 * 新密码文本框回车键处理事件
 */
function doTxtNewPwdOnkeyup(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        txtAffirmNewPwd = document.getElementById("txtAffirmNewPwd");
        txtAffirmNewPwd.focus();
    }
}

/**
 * 确认密码文本框回车键处理事件
 */
function doTxtAffirmNewPwdOnkeyup(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        window.focus();
        doOK();
    }
}

/**
 * 修改密码的处理函数
 */
function doOK()
{
	lblerror_tip.setText("");
	
    txtOldPwd = window.xui.getWidget("txtOldPwd");
    // 获取用户输入的旧密码
    contentOldPwd = txtOldPwd.getText();

    // 旧密码为空时提示用户,并将鼠标焦点定位到旧密码输入文本框
    if (contentOldPwd == "")
    {
        lblerror_tip.setText(oldpassword_empty);
        txtOldPwd.focus();
        return;
    }
    
	// 获取用户输入的新密码
    txtNewPwd = window.xui.getWidget("txtNewPwd");
    contentNewPwd = txtNewPwd.getText();
    // 新密码为空时提示用户,并将鼠标焦点定位到新密码输入文本框
    if (contentNewPwd == "")
    {
        lblerror_tip.setText(newpassword_empty);
        txtNewPwd.focus();
        return;
    }

    // 获取用户输入的确认新密码
    txtAffirmNewPwd = window.xui.getWidget("txtAffirmNewPwd");
    contentAffirmNewPwd = txtAffirmNewPwd.getText();
    // 确认新密码为空时提示用户,并将鼠标焦点定位到确认新密码输入文本框
    if (contentAffirmNewPwd == "")
    {
        lblerror_tip.setText(affirmnewpassword_empty);
        txtAffirmNewPwd.focus();
        return;
    }

    // 旧密码小于6位或大于32位字符时提示用户有误,并将鼠标焦点定位到旧密码输入文本框
    //if (contentOldPwd.length < 6 || contentOldPwd.length > 32)
    //{
    //    lblerror_tip.setText(oldpassword_error);
    //    txtOldPwd.setText("");
    //    txtOldPwd.focus();
    //    return;
    //}

    // 新密码小于6位或大于32位字符时提示用户有误,并将鼠标焦点定位到新密码输入文本框
    if (contentNewPwd.length < 6 || contentNewPwd.length > 32)
    {
        txtNewPwd.setText("");
        txtAffirmNewPwd.setText("");
        lblerror_tip.setText("");
        // 显示规则提示对话框
        var dlgTitle = jse.getI18nValue("qat:public", "dialog.prompt_d");
        
        jse.require("jse.widget.dialog");
        promptDlg = new jse.widget.dialog.Dialog("dlg_prompt", dlgTitle);
        promptDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/security/prompt.html");
        promptDlg.setPreferSize(promptDlgWidth, promptDlgHeight);
        promptDlg.show();
        return;
    }

    var patrn1 = /.*[A-Z].*/;
    var patrn2 = /.*[a-z].*/;
    var patrn3 = /.*[0-9].*/;
    var patrn4 = /[\uFF00-\uFFFF]/; // 全角符号

    if (!check(contentNewPwd))
    {
        txtNewPwd.setText("");
        txtAffirmNewPwd.setText("");
        lblerror_tip.setText("");
        // 显示规则提示对话框
        var dlgTitle = jse.getI18nValue("qat:public", "dialog.prompt_d");
        jse.require("jse.widget.dialog");
        promptDlg = new jse.widget.dialog.Dialog("dlg_prompt", dlgTitle);
        promptDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/security/prompt.html");
        promptDlg.setPreferSize(promptDlgWidth, promptDlgHeight);
        promptDlg.show();
        return;
    }
    if (!patrn1.exec(contentNewPwd))
    {
        txtNewPwd.setText("");
        txtAffirmNewPwd.setText("");
        lblerror_tip.setText("");
        // 显示规则提示对话框
        var dlgTitle = jse.getI18nValue("qat:public", "dialog.prompt_d");
        
        jse.require("jse.widget.dialog");
        promptDlg = new jse.widget.dialog.Dialog("dlg_prompt", dlgTitle);
        promptDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/security/prompt.html");
        promptDlg.setPreferSize(promptDlgWidth, promptDlgHeight);
        promptDlg.show();
        return;
    }
    if (!patrn2.exec(contentNewPwd))
    {
        txtNewPwd.setText("");
        txtAffirmNewPwd.setText("");
        lblerror_tip.setText("");
        // 显示规则提示对话框
        var dlgTitle = jse.getI18nValue("qat:public", "dialog.prompt_d");
        
        jse.require("jse.widget.dialog");
        promptDlg = new jse.widget.dialog.Dialog("dlg_prompt", dlgTitle);
        promptDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/security/prompt.html");
        promptDlg.setPreferSize(promptDlgWidth, promptDlgHeight);
        promptDlg.show();
        return;
    }
    if (!patrn3.exec(contentNewPwd))
    {
        txtNewPwd.setText("");
        txtAffirmNewPwd.setText("");
        lblerror_tip.setText("");
        // 显示规则提示对话框
        var dlgTitle = jse.getI18nValue("qat:public", "dialog.prompt_d");
        
        jse.require("jse.widget.dialog");
        promptDlg = new jse.widget.dialog.Dialog("dlg_prompt", dlgTitle);
        promptDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/security/prompt.html");
        promptDlg.setPreferSize(promptDlgWidth, promptDlgHeight);
        promptDlg.show();
        return;
    }
    if (patrn4.exec(contentNewPwd))
    {
        txtNewPwd.setText("");
        txtAffirmNewPwd.setText("");
        lblerror_tip.setText("");
        // 显示规则提示对话框
        var dlgTitle = jse.getI18nValue("qat:public", "dialog.prompt_d");
        
        jse.require("jse.widget.dialog");
        promptDlg = new jse.widget.dialog.Dialog("dlg_prompt", dlgTitle);
        promptDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/security/prompt.html");
        promptDlg.setPreferSize(promptDlgWidth, promptDlgHeight);
        promptDlg.show();
        return;
    }

    // 两次输入的新密码不一致提示用户输入有误,并将新密码文本框置空,
    // 鼠标焦点定位到新密码输入文本框
    if (contentAffirmNewPwd != contentNewPwd)
    {
        lblerror_tip.setText(affirmnewpassword_error);
        txtNewPwd.setText("");
        txtAffirmNewPwd.setText("");
        txtNewPwd.focus();
        return;
    }

    // 跳转至ModifyPwdAction类中handleRequest方法,进行修改密码处理
    var req = jse.RpcRequest
            .create(CommonUtil.getRootPath() + "/vmt/ct/security/modifypwdaction.do?pwdOldIdentifier="
                    + contentOldPwd + "&pwdNewIdentifier=" + contentNewPwd);
    req.invoke(handleResult, [ "handleModifyResponse();" ]);
}

/**
 * 检查密码是否符合规则
 */
function check(str)
{
    for ( var i = 0; i < str.length; i++)
    {
        var c = str.charCodeAt(i);
        if ((c < 0x0020) || (c > 0x007e))
        {
            return false;
        }
    }
    return true;
}

/**
 * Response返回时处理函数
 * 
 * @param errorCode
 *            错误码
 * @param request
 *            HttpRequest请求
 */
function handleModifyResponse()
{
    // 处理请求成功情况下
    if ("OPER_OK" == resultType)
    {
        // 显示提示信息
        VMTAlert(password_succeed, "win.modifySucceed();", 320, 150);
    }
    // 处理请求失败的情况
    else
    {
        VMTError("win.errorClose();");
    }
}

/**
 * 关闭错误对话框处理函数
 */
function errorClose()
{
//    errorDlg.dispose();
}

/**
 * 确认修改密码成功回调方法
 */
function modifySucceed()
{
//    vmtalert.dispose();
    jse.closeSelfView();
}

/**
 * 点击取消按钮的响应事件
 */
function doCancle()
{
    jse.closeSelfView();
}

/**
 * 设置错误对话框大小
 * 
 * @param width
 *            对话框宽度
 * @param height
 *            对话框高度
 */
function setPreferSize(width, height)
{
    errorDlg.setPreferSize(width, height);
}

/**
 * 设置错误对话框大小
 * 
 * @param width
 *            对话框宽度
 * @param height
 *            对话框高度
 */
function setPromptPreferSize(width, height)
{
    promptDlg.setPreferSize(width, height);
}

window.reInput = function()
{
    promptDlg.dispose();
    txtNewPwd.focus();
}

Event.observe(window, "load", init);