jse.require("jse.widget.dialog");
/**
 * 旧密码控件对象
 */
var g_oldPasswordWidget = null;

/**
 * 密码控件对象
 */
var g_passwordWidget = null;
var g_affirmPasswordWidget = null;

/**
 * 密码复杂度显示控件
 */
var g_pwdComplexityWidget = null;

// var passwordPattern = "[A-Za-z0-9]{8,}";
var passwordPattern = "[\\w]{8,}";

var DB_PASSWORD_ILLEGAL = 1107525817;

var g_txtNewPwd = null;

var g_pwdMaxLength = 32;

var g_pwdMinLength = 6;

/**
 * 处理方法映射
 */
var signalMap =
{
    on_load_ui : doLoad,
    on_click_Afirm : doOK,
    on_click_Cancle : doCancle
};

/**
 * 加载xui
 */
function init()
{
    // 生成一个xui实例, window.xui
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    // 通过window.xui加载修改密码界面的xui文件和事件列表
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/modifysqlparam/modifysqlparam.xui", signalMap);
}

/**
 * 加载时初始化
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-23
 */
function doLoad()
{
    var parentWin = jse.getFromWin();

    // 用户名相关控件
    g_oldPasswordWidget = window.xui.getWidget("txtOldPwd");

    // 密码控件
    g_passwordWidget = window.xui.getWidget("txtPassword");
    g_affirmPasswordWidget = window.xui.getWidget("txtAffirmPassword");

    g_pwdComplexityWidget = window.xui.getWidget("txtComplexity");

    g_oldPasswordWidget.setMaxLength(g_pwdMaxLength);
    g_passwordWidget.setMaxLength(g_pwdMaxLength);
    g_affirmPasswordWidget.setMaxLength(g_pwdMaxLength);

    g_oldPasswordWidget.setText("");
    g_passwordWidget.setText("");
    g_affirmPasswordWidget.setText("");
    g_pwdComplexityWidget.setText("");

    // 注册前置校验文本,密码.密码长度限制范围:最小长度、最大长度、字符集
    // var g_pwdMinLength = 8;
    // // var passwordSet = "^[\u4E00-\u9FA5\u3000-\u303f]";
    var infoNewPwd = new Preconstraints.textInfo(Preconstraints.TEXT_STRING, g_pwdMinLength, g_pwdMaxLength,
            null, false);

    Preconstraints.registText(g_passwordWidget, infoNewPwd);
    Preconstraints.registText(g_affirmPasswordWidget, infoNewPwd);

    // 获取控件引用
    var btnCancle = window.xui.getWidget("btnCancle");
    var btnAffirm = window.xui.getWidget("btnAffirm");

    // 注册tab键切换事件
    Tabkeyprocess.registKeyDown(btnAffirm, Tabkeyprocess.BUTTON, btnCancle, Tabkeyprocess.BUTTON);

    var txtOldPwdNode = $("txtOldPwd");
    var txtPwdNode = $("txtPassword");
    var txtAffirmNode = $("txtAffirmPassword");
    Event.observe(txtOldPwdNode, "keydown", doTxtOldPwdOnkeydown);
    Event.observe(txtPwdNode, "keydown", doTxtPwdOnkeydown);
    Event.observe(txtAffirmNode, "keydown", doTxtAffirmPwdOnkeydown);

    g_passwordWidget.onkeyup = onNewPasswordTxtKeyUp;

    // 将鼠标焦点定位在用户名输入文本框
    txtOldPwdNode.focus();
}

/**
 * 加载动态信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-23
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    doLoad();
}

/**
 * 新密码框输入事件处理
 * 
 * @param evt
 */
function onNewPasswordTxtKeyUp(evt)
{
    var txt = g_passwordWidget.getText();
    var passwordComplexity = CommonUtil.getPasswordComplexity(txt,g_pwdMinLength);

    //清空中间值
    txt = null;
    g_pwdComplexityWidget.setText(passwordComplexity);
}


/**
 * 旧密码输入框回车键处理事件
 * 
 * @param evt
 */
function doTxtOldPwdOnkeydown(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        var txtNewPwd = document.getElementById("txtPassword");
        txtNewPwd.focus();
    }
}

/**
 * 密码文本框回车键处理事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doTxtPwdOnkeydown(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        var btnAfirm = document.getElementById("btnAffirm");
        btnAfirm.focus();
    }
}

/**
 * 确认密码文本框回车键处理事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doTxtAffirmPwdOnkeydown(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        window.focus();
        doOK();
    }
}

/**
 * 点击确定按钮的响应事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doOK()
{
    // 获取输入的用户名的值
    var oldPasswordValue = g_oldPasswordWidget.getText();

    // 获取输入的密码值
    var passwordValue = g_passwordWidget.getText();

    // 确认密码框中的密码值
    var affirmPasswordValue = g_affirmPasswordWidget.getText();

    // 校验旧密码是否为空参数
    if ((null == oldPasswordValue) || ("" == oldPasswordValue))
    {
        CommonDlgReq.openAlertDialog(jse.getI18nValue("qat:public", "label.password_empty_d"), focusOldPassword);
        //清空中间值
        oldPasswordValue = null;
        passwordValue = null;
        affirmPasswordValue = null;
        return;
    }

    // 校验新密码
    if ((null == passwordValue) || ("" == passwordValue))
    {
        CommonDlgReq.openAlertDialog(jse.getI18nValue("qat:public", "label.password_empty_d"), focusPassword);
        //清空中间值
        oldPasswordValue = null;
        passwordValue = null;
        affirmPasswordValue = null;
        return;
    }

    if (passwordValue.length < g_pwdMinLength)
    {
        CommonDlgReq.openAlertDialog(jse.getI18nValue("qat:public", "password_length_between_6_32"), focusPassword);
        //清空中间值
        oldPasswordValue = null;
        passwordValue = null;
        affirmPasswordValue = null;
        return;
    }

    if ((null == affirmPasswordValue) || ("" == affirmPasswordValue))
    {
        CommonDlgReq.openAlertDialog(jse.getI18nValue("qat:public", "label.affirmnewpassword_empty_d"),
                focusAffirmPassword);
        //清空中间值
        oldPasswordValue = null;
        passwordValue = null;
        affirmPasswordValue = null;
        return;
    }

    if (passwordValue != affirmPasswordValue)
    {
        var message = jse.getI18nValue("qat:public", "label.affirmpassword_error_d");
        CommonDlgReq.openAlertDialog(message, focusPassword);
        //清空中间值
        oldPasswordValue = null;
        passwordValue = null;
        affirmPasswordValue = null;
        return;
    }

    // 请求下发设置用户名和密码
    configDBParam(oldPasswordValue, passwordValue);
    //清空中间值
    oldPasswordValue = null;
    passwordValue = null;
    affirmPasswordValue = null;

}

/**
 * 请求下发设置用户名和密码
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-23
 * @param oldPasswordValue 旧密码
 * @param passwordValue 新密码
 */
function configDBParam(oldPasswordValue, passwordValue)
{
   var encryOldPassword =  EncryptUtils.encrypt(oldPasswordValue);
   var encryNewPassword =  EncryptUtils.encrypt(passwordValue);
    
    // 请求下发设置用户名和密码
    var operResult = jsonrpc.invoke("configureDBParam", "configureDBParam", [ encryOldPassword, encryNewPassword ]);
    if (null == operResult)
    {
    	//清空中间值
    	oldPasswordValue = null;
    	passwordValue = null;
        return;
    }
    if (operResult.resultType == GlobalConstants.OPER_OK)
    {
        // 弹出配置成功的对话框
        CommonDlgReq.openAlertDialog(jse.getI18nValue("qat:public", "label.succeed_d"),doCancle);
    }
    else
    {
        // 弹出错误对话框
        CommonDlgReq.openRspErrorDialog(operResult, focusOldPassword, null);
    }
    //清空中间值
	oldPasswordValue = null;
	passwordValue = null;
}


/**
 * 将焦点切到旧密码输入框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-23
 */
function focusOldPassword()
{
    g_oldPasswordWidget.focus();
}

/**
 * 将焦点切到新密码输入框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-23
 */
function focusPassword()
{
    g_passwordWidget.focus();
}

/**
 * 将焦点切到确认新密码输入框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-23
 */
function focusAffirmPassword()
{
    g_affirmPasswordWidget.focus();
}

/**
 * @returns
 */
function clearPassword()
{
    g_passwordWidget.setText("");
    g_affirmPasswordWidget.setText("");
    g_passwordWidget.focus();
}


/**
 * 点击取消按钮的响应事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-23
 */
function doCancle()
{
    resetMainFrameTitle();

    jse.closeSelfView();
}

window.reInput = function()
{
    g_txtNewPwd.focus();
}

/**
 * 集成情况下，关闭对话框时，恢复主界面的title，响应F1
 */
function resetMainFrameTitle()
{
    var title = F1HelpUtil.getF1HelpID("root");
    F1HelpUtil.resetF1PageTitle(title);
    

}

Event.observe(window, "load", init);