/**
 * 当前用户选择的设备树结点信息
 * 
 * @author w00131173
 */
var g_curNeInfo = null;

// //////////////////////////////////

/**
 * 是否在工作区标识
 */
var isWorkspace = "true";

/**
 * 是否编辑过工作区
 */
var isModify = "false";

/**
 * 剩余试运行时间宏
 */
var MACRO_PARA_0 = "{0}";

/**
 * 试运行最小化窗口宽度
 */
var TEST_RUN_WIN_WIDTH = 350;

/**
 * 顶层最小化窗口默认长度
 */
var TOP_WIN_DEFAULT_LENGTH = 10;

/**
 * 视图管理
 */
var viewManager = null;
/**
 * 工具栏的退出按钮
 */
var toolbtnExit = null;
/**
 * 工具栏的查看日志按钮
 */
var toolbtnViewLog = null;
/**
 * 工具栏的生效按钮
 */
var toolbtnCommit = null;

/**
 * 工具栏的预览配置按钮
 */
var toolbtnPreview = null;

/**
 * 工具栏的放弃配置
 */
var toolbtnDiscard = null;
/**
 * 工具栏的试运行按钮
 */
var toolbtnTest = null;
/**
 * 工具栏的试运行停止按钮
 */
var toolbtnTestStop = null;
/**
 * 工具栏的试运行生效按钮
 */
var toolbtnTestCommit = null;
/**
 * 工具栏状态标识
 */
var tFlg = "start";
/**
 * 查看日志对话框标题
 */
var logTitle = null;
/**
 * 生效配置对话框标题
 */
var commitTitle = null;
/**
 * 放弃配置对话框标题
 */
var discardTitle = null;
/**
 * 试运行对话框标题
 */
var testTitle = null;
/**
 * 试运行停止对话框标题
 */
var stopTitle = null;
/**
 * 试运行生效对话框标题
 */
var testCommitTitle = null;

/**
 * 空白的标签，用于调整试运行剩余时间的位置
 */
var blankLabel = null;

/**
 * 配置已经提交标识
 */
var isCommitted = false;
/**
 * 获取常量对象
 */
var Constants = new Constants();
/**
 * 子对话框对象
 */
var subDlg = null;
/**
 * 主窗口
 */
var fromWin = null;
/**
 * 记录當前VR节点ID
 */
var g_VRID = null;
/**
 * 记录當前VR名字
 */
var g_VRName = null;

/**
 * 设备是否是LR标识
 */
var g_NeFlag = null;

/**
 * 网元类型
 */
var neName = null;

/**
 * 试运行剩余时间标签
 */
var labelTestLeftTime = null;
/**
 * 试运行剩余时间
 */
var labelTestTime = null;
/**
 * 警告对话框对象
 */
var vmtwarning = null;

/**
 * 提示对话框对象
 */
var vmtalert = null;

/**
 * 试运行定时器
 */
var timer = null;

/**
 * 试运行结束时间
 */
var finish = "00:00:00";

/**
 * 试运行开始时间
 */
var start = "00:00:00";

/**
 * 模板树是否已经加载
 */
var isTempletTreeLoad = false;

/**
 * 模板是否为当前操作对象
 */
var isTemplet = false;

var isWorkspace = true;

/**
 * 工作区是否打开
 */
var isWorkspaceOpen = false;

/**
 * 是否在试运行
 */
var isTestRun = false;

/**
 * 工具栏面板
 */
var toolbarPane = null;

/**
 * 试运行标题
 */
var testRunTitle = null;

/**
 * 工作区顶层窗口对象
 */
var wsWin = null;

/**
 * 工作区顶层窗口默认标题
 */
var topWinTitle = null;

/**
 * 全局doc对象
 */
var doc = null;

/**
 * 错误对话框
 */
var errorDlg = null;

var deviceIP = null;
/**
 * 映射表
 */
var signalMap =
{
    on_load_ui :doLoad,
    on_click_Log :viewLog,
    on_discard_changes :discardChanges,
    on_commit_confirmed :commitConfirmed,
    on_preview :previewConfig,
    on_discard_commit :discardCommit,
    on_testeffect :doTestEffect,
    on_effect :doEffect,
    on_click_Exit :exitWorkspace
};

/**
 * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-1
 */
function init()
{
    // 试运行剩余时间标签与工具栏最后一个按钮的间隔
    // var blankwidth = screen.width * 0.15;

    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/mainframe/workspace/workspace.xui", signalMap);
}

/**
 * 加载页面初始设置
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-1
 */
function doLoad()
{
    // 获得界面控件对象
    viewManager = window.xui.getWidget("ViewManager");
    toolbarPane = window.xui.getWidget("ToolbarPane");
    toolbtnExit = window.xui.getWidget("toolbtnExit");
    toolbtnViewLog = window.xui.getWidget("toolbtnViewLog");
    toolbtnCommit = window.xui.getWidget("toolbtnCommit");
    toolbtnPreview = window.xui.getWidget("toolbtnPreview");
    toolbtnDiscard = window.xui.getWidget("toolbtnDiscard");
    toolbtnTest = window.xui.getWidget("toolbtnTest");
    toolbtnTestStop = window.xui.getWidget("toolbtnTestStop");
    toolbtnTestCommit = window.xui.getWidget("toolbtnTestCommit");

    labelTestLeftTime = window.xui.getWidget("LabelTestLeftTime");
    labelTestTime = window.xui.getWidget("LabelTestTime");
    labelTestLeftTime.setText("");
    labelTestTime.setText("");

    topWinTitle = jse.getI18nValue("qat:public", "dailog.workspacetitle_d");
    testRunTitle = jse.getI18nValue("qat:public", "dailog.workspacetesttitle_d");
    wsWin = jse.topWin.wsWin;
    fromWin = jse.getFromWin();
    deviceIP = fromWin.deviceIp_URLParam;
    neName = fromWin.g_NeFlag;

    // 獲取當期VRID信息
    g_VRID = fromWin.pub_getVRID();
    g_VRName = fromWin.pub_getVRName();
    g_NeFlag = fromWin.pub_getNeFlag();
    var isSupportPartition = fromWin.g_IsSupportPartition;
    g_curNeInfo = new CurSelNEInfo(true, g_NeFlag, g_VRID, g_VRName, isSupportPartition, deviceIP);

    initAuthority();
    viewManager.setViewURL("capability", CommonUtil.getRootPath() + "/vmt/ct/capability/functreehtml.jsp?isSupportPartition="
            + g_curNeInfo.isSupportPartition + "&deviceName=" + g_curNeInfo.vrName + "&deviceID=" + g_curNeInfo.vrID
            + "&neFlag=" + g_curNeInfo.neType + "&isWorkspace=" + g_curNeInfo.isWorkspace);

    // 设置工具栏
    refreshToolbar(tFlg);

    // 下发创建CDB的命令
    createCDBRequest();

}

/**
 * 创建CDB
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-1
 */
function createCDBRequest()
{
    // 向后台发送创建CDB请求
    var operResult = jsonrpc.invoke("workspaceService", "createCDB", [ g_curNeInfo.neType, g_curNeInfo.vrID, "true",
            g_curNeInfo.devIP ]);
    cdbCallback(operResult);
}

/**
 * 创建CDB的回调函数
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-3
 * @param OperResult 后台返回的操作结果对象
 */
function cdbCallback(operResult)
{
    if (null == operResult)
    {
        return;
    }
    if ("OPER_OK" != operResult.resultType)
    {
        // 弹出错误对话框
        VMTError(operResult, null);
    }
}

/**
 * 退出工作区时停止试运行
 */
function quitDiscardCommit()
{
    // 向后台发送停止试运行的请求
    var result = jsonrpc.invoke("workspaceService", "discardCommit", [ g_curNeInfo.neType, g_curNeInfo.vrID,
            g_curNeInfo.devIP ], cdbCallback);
    if ("OPER_OK" != result.resultType)
    {
        refreshTable();
    }
    pub_Exit();
}

/**
 * 
 * 初始化集成鉴权信息
 * 
 * @return
 */
function initAuthority()
{
    // 生效配置 11544605
    btnAuthorityMap.put(toolbtnCommit, qatCommandCode.QATCMDCODE_FEATURE_COMMIT);
    // 预览配置11544609
    btnAuthorityMap.put(toolbtnPreview, qatCommandCode.QATCMDCODE_FEATURE_COMPARECONF);
    // 放弃配置 11544608
    btnAuthorityMap.put(toolbtnDiscard, qatCommandCode.QATCMDCODE_FEATURE_DISCARDCHANGE);
    // 试运行启动 11544606
    btnAuthorityMap.put(toolbtnTest, qatCommandCode.QATCMDCODE_FEATURE_COMMITCONFIRMED);
    // 试运行停止 11544607
    btnAuthorityMap.put(toolbtnTestStop, qatCommandCode.QATCMDCODE_FEATURE_DISCARDCOMMIT);
    // 试运行生效 11544626
    btnAuthorityMap.put(toolbtnTestCommit, qatCommandCode.QATCMDCODE_FEATURE_TESTEFFECT);
    var cmdListStr = "" + qatCommandCode.QATCMDCODE_FEATURE_COMMIT + ","
            + qatCommandCode.QATCMDCODE_FEATURE_COMPARECONF + "," + qatCommandCode.QATCMDCODE_FEATURE_DISCARDCHANGE
            + "," + qatCommandCode.QATCMDCODE_FEATURE_COMMITCONFIRMED + ","
            + qatCommandCode.QATCMDCODE_FEATURE_DISCARDCOMMIT + "," + qatCommandCode.QATCMDCODE_FEATURE_TESTEFFECT;
    getAuthority(cmdListStr);
}

/**
 * 刷新工具栏
 */
function refreshToolbar(toolBarFlg)
{
    // 设置工具栏状态标识
    tFlg = toolBarFlg;

    switch (tFlg)
    {
        // 初始状态
        case Constants.START:
            toolbtnCommit.setEnabled(false);
            toolbtnPreview.setEnabled(false);
            toolbtnDiscard.setEnabled(false);
            toolbtnTest.setEnabled(false);
            toolbtnTestStop.setEnabled(false);
            toolbtnTestCommit.setEnabled(false);
            break;

        // 修改数据状态
        case Constants.MODIFY:
            toolbtnCommit.setEnabled(true);
            toolbtnPreview.setEnabled(true);
            toolbtnDiscard.setEnabled(true);
            toolbtnTest.setEnabled(true);
            toolbtnTestStop.setEnabled(false);
            toolbtnTestCommit.setEnabled(false);
            break;

        // 试运行状态
        case Constants.TESTRUNNING:
            toolbtnCommit.setEnabled(false);
            toolbtnPreview.setEnabled(false);
            toolbtnDiscard.setEnabled(false);
            toolbtnTest.setEnabled(false);
            toolbtnTestStop.setEnabled(true);
            toolbtnTestCommit.setEnabled(true);
            break;
        default:
            break;
    }
    setEnableByAuthority(null);
}

/**
 * 处理点击[查看日志]按钮事件
 */
function viewLog()
{
    var viewLogTitle = jse.getI18nValue("qat:public", "dailog.logtitle_d");
    // 创建对话框
    
    jse.require("jse.widget.dialog");
    subDlg = new jse.widget.dialog.Dialog("dlg_Log", viewLogTitle);
    // 对话框中载入页面
    subDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/log/readlogger.html");
    // 设置对话框大小
    subDlg.setPreferSize(902, 700);
    // 显示对话框
    subDlg.show();
}

/**
 * 处理点击[放弃配置]按钮事件
 */
function discardChanges()
{
    var title = jse.getI18nValue("qat:public", "dialog.warning_d");
    var message = jse.getI18nValue("qat:public", "label_discardchanges_d");
    VMTWarning(message, "win.beginDiscardChanges();", "400", "150", title);
}
/**
 * 向后台发送放弃配置请求
 */
function beginDiscardChanges()
{
    // hideWarningDlg();
    var req = jse.RpcRequest
            .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/workspaceaction.do?methodID=discardChanges&vrID=" + g_VRID
                    + "&neName=" + neName));
    req.invoke(handleResult, [ "discardChangesCallback(request);" ]);
}
/**
 * 放弃配置的回调函数
 */
function discardChangesCallback(req)
{
    var result = req.responseText;

    // 弹出错误对话框
    if (result == "<response>NOK</response>")
    {
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_discardchanges_error_d");
        VMTAlert(message, "win.hideAlertDialog();", "450", "150", title);
    }
    if (result == "<response>OK</response>")
    {
        refreshToolbar(Constants.START);
        isModify = "false";

        refreshWSTable(false);

        // 弹出对话框提示成功
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_discardchanges_success_d");
        VMTAlert(message, "win.hideAlertDialog();", "400", "150", title);
    }
}

/**
 * 放弃配置后，刷新工作区表格
 */
function refreshWSTable(isTimeout)
{
    var featureWin = viewManager.getWindowById("feature");
    var nodeID = curFeatureNodeID;
    var isFeaNode = isCurFeatureNode;
    if (null != nodeID && isFeaNode == true)
    {
        if (false == isTimeout)
        {
            featureWin.queryData("");
        }
        else
        {
            featureWin.timeoutRefreshTable();
        }
    }
}

/**
 * 处理点击[试运行]按钮事件
 */
function commitConfirmed()
{
    var dialog = null;
    var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
    
    jse.require("jse.widget.dialog");
    dialog = new jse.widget.dialog.Dialog("conmitConfirmed", title);
    dialog.setURL(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/workspace/commitConfirmedhtml.jsp"));
    dialog.setPreferSize(680, 200);
    dialog.show();
}

/**
 * 设置[试运行剩余时间]标签
 * 
 * @param flag
 * @return
 */
function setTestLeftTimeLabel(flag)
{
    if (flag == true)
    {
        var text = jse.getI18nValue("qat:public", "label.testlefttime_d");
        labelTestLeftTime.setText("");
    }
    else
    {
        wsWin.setTitle(topWinTitle);
        wsWin.setMinimumSize(TOP_WIN_DEFAULT_LENGTH, TOP_WIN_DEFAULT_LENGTH);
        labelTestLeftTime.setText("");
    }
}
/**
 * 处理点击[试运行停止]按钮事件
 */
function discardCommit()
{
    var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
    var message = jse.getI18nValue("qat:public", "label_discardcommit_d");
    VMTWarning(message, "win.beginDiscardCommit();", "300", "150", title);
}
/**
 * 确定试运行停止的处理
 */
function beginDiscardCommit()
{
    // hideWarningDlg();
    window.clearTimeout(timer);
    var req = jse.RpcRequest
            .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/workspaceaction.do?methodID=discardCommit&vrID=" + g_VRID
                    + "&neName=" + neName));
    req.invoke(handleResult, [ "discardCommitCallback(request);" ]);
}
/**
 * 试运行停止的回调函数
 */
function discardCommitCallback(req)
{
    var result = req.responseText;
    if (result == "<response>OK</response>")
    {
        setTestLeftTimeLabel(false);
        labelTestTime.setText("");
        refreshToolbar(Constants.MODIFY);

        isTestRun = false;
        isModify = "true";
        var featureWin = viewManager.getWindowById("feature");
        featureWin.switchToolBtnState();

        // 刷新主界面表格
        refreshTable();

        // 弹出对话框提示成功
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_discardcommit_success_d");
        VMTAlert(message, "win.hideAlertDialog();", "300", "150", title);
    }
    // 弹出错误对话框
    else if (result == "<response>NOK</response>")
    {
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_discardcommit_error_d");
        VMTAlert(message, "win.hideAlertDialog();", "300", "150", title);
    }
}
/**
 * 处理点击[试运行生效]按钮事件
 */
function doTestEffect()
{
    closeEffectDlg();
    previewType = "testEffect";
    effectMessage = jse.getI18nValue("qat:public", "label_testeffect_d");
    var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
    
    jse.require("jse.widget.dialog");
    effectDialog = new jse.widget.dialog.Dialog(("effect" + (new Date().getTime())), title);
    effectDialog.setURL(CommonUtil.getRootPath() + "/vmt/ct/workspace/commit/commitdialog.html");
    effectDialog.setPreferSize(370, 150);
    effectDialog.show();
}

/**
 * 确定试运行生效
 */
function beginTestEffect()
{
    hideEffectDlg();

    var req = jse.RpcRequest.create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/workspaceaction.do?methodID=testEffect&vrID="
            + g_VRID + "&neName=" + neName));
    req.invoke(handleResult, [ "testEffectCallback(request);" ]);
}
/**
 * 试运行生效的回调函数
 * 
 * @param req
 * @return
 */
function testEffectCallback(req)
{
    var result = req.responseText;
    // 弹出错误对话框
    if (result == "<response>NOK</response>")
    {
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_testeffect_error_d");
        VMTAlert(message, "win.hideAlertDialog();", "350", "150", title);
    }
    if (result == "<response>OK</response>")
    {
        refreshToolbar(Constants.START);
        window.clearTimeout(timer);
        setTestLeftTimeLabel(false);
        labelTestTime.setText("");
        isModify = "false";

        if (!isTemplet)
        {
            isTestRun = false;

            // 切换按钮的状态
            switchToolBtnState();
            // 刷新主界面的表格
            refreshTable();

            resetWorkspace();
        }
        else
        {
            isTestRun = false;
            switchToolBtnState();
            resetWSonTemplet();
        }

        // 弹出对话框提示成功
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_testeffect_success_d");
        VMTAlert(message, "win.hideAlertDialog();", "320", "150", title);

    }
}
/**
 * 处理点击[生效配置]按钮事件
 */

var effectMessage = "";
var effectDialog = null;
var previewType = "";
function doEffect()
{
    closeEffectDlg();
    previewType = "effect";
    effectMessage = jse.getI18nValue("qat:public", "label_effect_d");
    var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
    
    jse.require("jse.widget.dialog");
    effectDialog = new jse.widget.dialog.Dialog(("effect" + (new Date().getTime())), title);
    effectDialog.setURL(CommonUtil.getRootPath() + "/vmt/ct/workspace/commit/commitdialog.html");
    effectDialog.setPreferSize(400, 150);
    effectDialog.show();
}
/**
 * 关闭生效皮质提示对话框.
 */
function closeEffectDlg()
{
    if (("undefined" != typeof (effectDialog)) && (null != effectDialog))
    {
        if ("undefined" != typeof (effectDialog.dispose))
        {
            effectDialog.dispose();
        }
        effectDialog = null;
    }
}
/**
 * 隐藏生效配置对话框.
 */
function hideEffectDlg()
{
    if (("undefined" != typeof (effectDialog)) && (null != effectDialog) && ("undefined" != typeof (effectDialog.hide)))
    {
        effectDialog.hide();
    }
}
/**
 * 确定生效配置
 */
function beginEffect()
{
    hideEffectDlg();
    var req = jse.RpcRequest.create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/workspaceaction.do?methodID=commit&vrID="
            + g_VRID + "&neName=" + neName));
    req.invoke(handleResult, [ "effectCallback(request);" ]);
}

/**
 * 生效配置的回调函数
 * 
 * @param req
 * @return
 */
function effectCallback(req)
{
    var result = req.responseText;
    // 弹出错误对话框
    if (result == "<response>NOK</response>")
    {
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_effect_error_d");
        VMTAlert(message, "win.hideAlertDialog();", "350", "150", title);
    }
    if ((result == "<response>OK</response>"))
    {
        refreshToolbar(Constants.START);
        isModify = "false";

        // 刷新主界面的表格
        refreshTable();

        // 弹出对话框提示成功
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_effect_success_d");
        VMTAlert(message, "win.hideAlertDialog();", "320", "150", title);

    }
}
/**
 * 处理点击[预览配置]按钮事件
 */
function previewConfig()
{
    /**
     * 保存用户所选择的行的nodeKeyInfo，用于当过滤后，如果包含这行，将将这行选中
     */
    var func = viewManager.getWindowById("capability");
    var featureArray = func.getFeatureArray();
    var _url = CommonUtil.getRootPath() + "/vmt/ct/workspace/preview/configpreviewhtml.jsp?vrID=" + g_VRID + "&neName=" + neName + "&featureVers="
            + featureArray.toString();

    var dialogWith = screen.width * 0.6;
    var dialogHeight = dialogWith * 3 / 4 - 8;
    var operation = jse.getI18nValue("qat:public", "button.preview_d");
    var dialogTitle = "[" + operation + "]";
    
    jse.require("jse.widget.dialog");
    var dialog = new jse.widget.dialog.Dialog("modify", dialogTitle);
    dialog.setURL(handleEncodingUrl(_url));
    dialog.setPreferSize(dialogWith, dialogHeight);
    dialog.show();
}
/**
 * 隐藏警告对话框
 * 
 * @return
 */
function hideAlertDialog()
{
    // if (("undefined" != typeof (vmtalert)) && (null != vmtalert)
    // && ("undefined" != typeof (vmtalert.hide)))
    // {
    // vmtalert.hide();
    // }
}
/**
 * 切换按钮状态，用于试运行、试运行停止、试运行生效时按钮状态切换
 */
function switchToolBtnState()
{
    var featureWin = viewManager.getWindowById("feature");
    featureWin.switchToolBtnState();
}
/**
 * 重置工作区，用于当生效配置、放弃配置、试运行超时后，将工作区置为初始状态
 * 
 * @return
 */
function resetWorkspace()
{
    return;
    var VRActiveView = viewManager.getWindowById("capability");

    // 清除历史记录以及前进后退按钮状态禁止
    // clearHistorylist();

    if (null != VRActiveView)
    {
        VRActiveView.pub_clearSelectNode();
        // 调用功能树的函数刷新表格
        VRActiveView.addFeatureViewBySelNode();
    }
}
function resetWSonTemplet()
{
    return;
    var templetView = viewManager.getWindowById("stencil");
    // 清除历史记录以及前进后退按钮状态禁止
    // clearHistorylist();

    if (null != templetView)
    {
        templetView.pub_clearSelectNode();
        templetView.addFeatureViewBySelNode();
    }

}
/**
 * 处理点击[退出工作区]按钮事件
 */
function exitWorkspace()
{
    var title = jse.getI18nValue("qat:public", "dialog.warning_d");
    var message = "";
    if (isModify == "true")
    {
        // var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        message = jse.getI18nValue("qat:public", "label_quitDisChange_d");
        if (isTestRun == true)
        {
            VMTWarning(message, quitDiscardCommit, "400", "150", title);
        }
        else
        {
            VMTWarning(message, pub_Exit, "400", "150", title);
        }

    }
    else
    {
        message = jse.getI18nValue("qat:public", "label_quitworkspace_d");
        VMTWarning(message, pub_Exit, "350", "150", title, []);
        // pub_Exit();
    }
}

/**
 * 退出系统
 */
function pub_Exit()
{
    // hideWarningDlg();

    fromWin.isWorkspaceOpen = false;
    fromWin.resetMainFrameTitle();

    // 设置打开工作区按钮可用
    if (null != fromWin.toolbtnOperWS)
    {
        var operWSBtn = fromWin.toolbtnOperWS;
        operWSBtn.setEnabled(true);
        fromWin.menuBarSystem.setItemEnabled("menuBtnWorkSpace", true);

        // 基于模板配置按钮可用
        var toolbtnBaseOnTmp = fromWin.toolbtnBaseOnTemplet;
        toolbtnBaseOnTmp.setEnabled(true);
        fromWin.menuBarSystem.setItemEnabled("menuBtnBaseOnTemp", true);
        
//        fromWin.menuBarSystem.setItemEnabled("menuBtnUpdatePkg", true);
    }

    var viewMgr = fromWin.viewManager;
    var isCapActive = viewMgr.isActive("stencil");

    var featureWin = viewMgr.getWindowById("feature");
    var nodeID = fromWin.curFeatureNodeID;
    var isFeaNode = fromWin.isCurFeatureNode;
    if (null != nodeID && isFeaNode == true && "undefined" != typeof (featureWin.switchToolBtnState))
    {
        featureWin.switchToolBtnState();
    }

    if (isCapActive && null != nodeID && isFeaNode)
    {
        featureWin.pub_excuteCondition("all");
    }

    closeSession();
}

function closeSession()
{
    var req = jse.RpcRequest
            .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/device/DeviceMgrAction.do?methodID=handleCloseSessionReq&vrID=" + g_VRID
                    + "&neName=" + neName + "&deviceIP=" + fromWin.deviceIP));
    req.invoke(handleResult, [ "closeSessionCallback();" ]);
}

function closeSessionCallback()
{
    jse.closeSelfView();
}
/**
 * 处理点击工作区窗体[关闭]按钮事件
 */
function exit(evt)
{
    exitWorkspace();
}

/**
 * 当生效配置和试运行生效后，刷新主界面的表格
 */
function refreshTable()
{
    var windowViewMgr = fromWin.viewManager;
    var featureWin = windowViewMgr.getWindowById("feature");

    var nodeID = fromWin.curFeatureNodeID;
    var isFeaNode = fromWin.isCurFeatureNode;

    if (null != nodeID && isFeaNode == true)
    {
        featureWin.refreshTableByWS("");
    }

}
/**
 * 设置定时器
 * 
 * @param finishTime 结束时间
 * @return
 */
function setTimer(finishTime)
{
    start = finishTime;
    wsWin.setMinimumSize(TEST_RUN_WIN_WIDTH, TOP_WIN_DEFAULT_LENGTH);
    timer = window.setInterval("onTimer()", 1000);
}
/**
 * 倒计时函数
 * 
 * @return
 */
function onTimer()
{
    if (start == finish)
    {
        var title = jse.getI18nValue("qat:public", "dialog.prompt_d");
        var message = jse.getI18nValue("qat:public", "label_testtimeout_d");
        VMTAlert(message, "win.timeoutFun();", "580", "150", title);
        // vmtalert.onclosing = timeoutFun;
        window.clearTimeout(timer);
        return;
    }
    var hms = new String(start).split(":");
    var s = new Number(hms[2]);
    var m = new Number(hms[1]);
    var h = new Number(hms[0]);

    s -= 1;
    if (s < 0)
    {
        s = 59;
        m -= 1;
        if (m < 0)
        {
            m = 59;
            h -= 1;
        }
    }

    var ss = s < 10 ? ("0" + s) : s;
    var sm = m < 10 ? ("0" + m) : m;
    var sh = h < 10 ? ("0" + h) : h;
    start = sh + ":" + sm + ":" + ss;

    var tmpRunTitle = testRunTitle.replace(MACRO_PARA_0, start);
    wsWin.setTitle(tmpRunTitle);

    setTestLeftTimeLabel(true);
    toolbarPane.pack();
}
/**
 * 试运行超时处理
 */
function timeoutFun()
{
    // 当存在试运行生效或停止试运行对话框时,隐藏.
    hideEffectDlg();
    // hideWarningDlg();
    hideAlertDialog();

    // 设置工具栏
    refreshToolbar(Constants.MODIFY);

    setTestLeftTimeLabel(false);
    labelTestTime.setText("");

    // 超时后，放弃所有配置
    timeoutDisChange();
}

/**
 * 试运行超时后放弃所有配置
 * 
 * @return
 */
function timeoutDisChange()
{
    var req = jse.RpcRequest
            .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/workspaceaction.do?methodID=discardChanges&vrID=" + g_VRID
                    + "&neName=" + neName));
    req.invoke(handleResult, [ "timeoutDisChanCallback(request);" ]);
}

/**
 * 试运行超时后的回调函数
 * 
 * @return
 */
function timeoutDisChanCallback(req)
{
    var result = req.responseText;
    if (result == "<response>OK</response>")
    {
        refreshToolbar(Constants.START);
        isModify = "false";
        isTestRun = false;
        refreshWSTable(true);
    }
}
Event.observe(window, "load", init);