/**
 * 工作区是否打开标识
 */
var isWorkspaceOpen = false;

var isOffline = false;

/**
 * 是否在试运行
 */
var isTestRun = false;

/**
 * 支持包信息
 */
var pnpForm = new PnpForm();

/**
 * 特性Tab页view控制类
 */
var g_featureTabViewCtrl ;
/**
 * 是否加载单板树
 */
var loadBoardTree = null; 
/**
 * 设备选项对象
 */
var deviceOption = null;
/**
 * 第三段第一次弹出详细信息对话框初始位置的横坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function pub_getXChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availWidth - 10;

}

/**
 * 第三段第一次弹出详细信息对话框初始位置的纵坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function pub_getYChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availHeight - 30;
}

/**
 * 视图管理
 */
var viewManager = null;
/**
 * 顶层窗体对象
 */
var topWin = null;

/**
 * 工具栏的切换设备按钮
 */
var toolbtnBaseOnTemplet = null;
/**
 * 工具栏的打开工作区按钮
 */
var toolbtnOperWS = null;
/**
 * 工具栏的查看日志按钮
 */
var toolbtnLog = null;
/**
 * 工具栏的修改密码按钮
 */
var toolbtnModifyPW = null;
/**
 * 选择设备对话框标题
 */
var selDevTitle = null;
/**
 * 错误对话框的对象
 */
var errorDlg = null;
/**
 * 子对话框对象
 */
var subDlg = null;

/**
 * 切换设备按钮对象
 */
var toolbtnBaseOnTemplet = null;

/**
 * 提示对话框对象
 */
var vmtalert = null;
/**
 * 工具栏对象
 */
var toolbarpane = null;

/**
 * 工作区窗口
 */
var wsWin = null;

/**
 * 警告对话框
 */
var vmtwarning = null;

/**
 * 设备IP
 */
var deviceIP = null;

/**
 * 导出配置按钮对象
 */
var toolbtnExpConfig = null;
/**
 * 导出的模板名
 */
var expTempletName = null;

var exportTmpFileName = null;

var doc = null;

var resultType = null;

/**
 * 当前设备标识
 */
var curDevFlag = null;

/**
 * 是否支持划分VR
 */
var isSupPartition = null;
/**
 * 系统菜单
 */
var menuBarSystem = null;
var deviceWin = null;

/**
 * C00 merge代码，没有注释，请后续懂这个字段含义的兄弟添加下，谢谢
 */
var childProperNum = 0;

var devType = null;
var devVersion = null;
var devId = null;

/**
 * 全局配置选项数据管理对象
 */
var g_SystemConfigDataMgr = new SystemConfigDataMgr();

/**
 * 硬件规格差异数据缓存管理对象
 */
var g_HardSpecDiffDataCacheMgr = new DataCacheMgr();

function pub_setDeviceInfo(deviceType, deviceVersion, devIdInfo)
{
    devType = deviceType;
    devVersion = deviceVersion;
    if(null != devIdInfo)
    {
    	 var infos = devIdInfo.split("=");
    	 if(infos.length > 1)
    	 {
    	 	devId = infos[1];
    	 }
    }
}

/**
 * 加载window页面处理
 */
function windowLoad()
{
    logger.log("enter window doLoad");

    // 获得界面控件对象
    viewManager = window.xui.getWidget("ViewManager");
    g_featureTabViewCtrl = new TabViewCtrl(viewManager, new FeaturesResourceMgr(), null, Constants.FEATURE_VIEWID);

    if ("true" == independence)
    {
        // 集成下没有按钮栏和top头，独立下才处理
        // toolbtnOperWS = window.xui.getWidget("toolbtnOperWS");
        toolbarpane = window.xui.getWidget("ToolbarPane");
        menuBarSystem = window.xui.getWidget("menuBarSystem");
        topToolbarPane = window.xui.getWidget("topToolbarPane");

        // 为toolbutton注册事件
        if (null != toolbarpane)
        {
            var warningButton = window.xui.getWidget("Warning");
            var minorButton = window.xui.getWidget("Minor");
            var majorButton = window.xui.getWidget("Major");
            var criticalButton = window.xui.getWidget("Critical");
            
            // 目前不支持工作区相关功能，暂时屏蔽入口。
            // toolbtnOperWS.onclick = doOpenWS;
            warningButton.onclick = doAlarm;
            minorButton.onclick = doAlarm;
            majorButton.onclick = doAlarm;
            criticalButton.onclick = doAlarm;
        }

        // 注册退出事件
        // toolbuttonExit.onclick = doExit;
        // 获取容器对象
        var logoDiv = $("topRootBox_c_0");
        var backDiv = $("topRootBox");
        backDiv.style.backgroundRepeat = "repeat";

        // 设置标题图片
        if (lang == "zh_CN")
        {
            // 设置背景图片
            // 语言环境为中文时，设置标题图片
            logoDiv.className = "logo_CN";
        }
        else if (lang == "en_US")
        {
            // 设置背景图片
            logoDiv.className = "logo_EN";
        }

        // 目前不支持工作区相关功能，暂时屏蔽入口。
        // 初始化设置打开工作区按钮
        // toolbtnOperWS.setEnabled(false);
    }
    else
    {
        menuBarSystem = window.xui.getWidget("menuBarSystem");
    }

    deviceWin = viewManager.getWindowById("device");

    // 存在menuBar，则初始化状态
    if (null != menuBarSystem)
    {
        // 测试使用
        setTimeout("initMenuBarSystem()", 100);
    }

    logger.log("exit window initMenuBarSystem");
    
    viewManager.setViewMinimumSize("device",
    {
        width : 150,
        height : 50
    });
    viewManager.setViewMinimumSize("feature",
    {
        width : 150,
        height : 50
    });
    
    if(preLoadFlag)
    {
        viewManager.changeViewSize("device", "feature", -80);
        //预加载页面
        preLoadView();
        return;
    }
    
    viewManager.changeViewSize("device", "feature", 100);
    // 设备ip信息
    deviceIP = deviceIp_URLParam;
    var devIdInfo = jse.topWin.resID;
	if(null != devIdInfo)
    {
    	 var infos = devIdInfo.split("=");
    	 if(infos.length > 1)
    	 {
    	 	devId = infos[1];
    	 }
    }
    logger.log("window doLoad pub_getDevSupportPkg");
    pub_getDevSupportPkg();
    
    //初始化全局配置参数，3s后起个线程初始化，以免后续使用时消耗时间
    setTimeout("initSystemConfigDataMgr()", 3000);
    logger.log("exit window doLoad");
}

/**
 * 预加载页面
 */
function preLoadView()
{
    viewManager = window.xui.getWidget("ViewManager");

    // 预加载设备视图
    viewManager.setViewURL(Constants.DEVICE_VIEWID, Constants.URL_DEVICEHTML);

    // 预加载功能树视图
    viewManager.setViewURL(Constants.FUNCTION_VIEWID, Constants.URL_FUNCTREEHTML + "preLoadFlag=true");
    
    var panelTitle = jse.getI18nValue("panel:public", "functree.devicepanel_d");
    // 预加载面板
    pub_addDevicePanelView("", "", "", "", panelTitle);
    
//    var featureUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/feature.html" + "?preLoadPage=true";
    var featureUrl = Constants.URL_MULTIFEATURE_HTML + "?preLoadPage=true";
    g_ViewsManager.loadSpecialView(Constants.FEATURE_VIEWID, "", featureUrl);  
    
    preRequestActionUrl();
    
}

/**
 * 网元管理器有3次ation请求，第一次请求会加载class占用打开网元管理器的时间，在预加载时预先做个请求初始化
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-8-3
 * @return
 */
function preRequestActionUrl()
{
    var urlArray = [];
    urlArray.push(CommonUtil.getRootPath() + "/vmt/ct/device/DeviceMgrAction.do?methodID=handleLoginDeviceReq");
    urlArray.push(CommonUtil.getRootPath() + "/vmt/ct/device/DeviceNavigatorMgrAction.do?methodID=handleNullListLRVRRequest");
    urlArray.push(CommonUtil.getRootPath() + "/vmt/ct/capability/FunctionTreeNavAction.do?methodID=functiontree");
    
    for(var index in urlArray)
    {
        var req = jse.RpcRequest.create(urlArray[index] + "&preRequest=true");
        req.invoke(handleResult, [ "doPreNothing();" ]);
    }
}

function doPreNothing()
{
    
}

function freshMenuBarSystem(nodeEnable)
{
    if (null != menuBarSystem)
    {
        // 如果是不支持划分，则不显示刷新VR列表菜单
        if (false == g_IsSupportPartition || "false" == g_IsSupportPartition)
        {
            menuBarSystem.setItemVisible("menuBtnUpdateVR", false);
        }
        else
        {
            // 如果支持划分，选中LR则可用，选中VR则不可用
            if (!nodeEnable.isVr)
            {
                menuBarSystem.setItemEnabled("menuBtnUpdateVR", true);
            }
            else
            {
                menuBarSystem.setItemEnabled("menuBtnUpdateVR", false);
            }
        }
        menuBarSystem.setItemEnabled("menuBtnLock", !nodeEnable.isNodeLock);
        menuBarSystem.setItemEnabled("menuBtnUnlock", nodeEnable.isNodeLock);
    }
}
/**
 * 初始化全局配置数据
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-8-31
 */
function initSystemConfigDataMgr()
{
    g_SystemConfigDataMgr.init();
}


/**
 * 初始化系统菜单
 */
function initMenuBarSystem()
{
    if ("true" == independence)
   {
    // 系统菜单
    menuBarSystem.addItem(null, "menuSystem",
    {
        text : jse.getI18nValue("qat:public", "menubar.system_d")
    });
    menuBarSystem.addItem("menuSystem", "menuBtnModifyPwd",
    {
        text : jse.getI18nValue("qat:public", "menubar.modify_d"),
        action : doModifyPwd
    });
    menuBarSystem.addItem("menuSystem", "separator1",
    {
        text : "-"
    });
    menuBarSystem.addItem("menuSystem", "menuBtnOption",
    {
        text : jse.getI18nValue("qat:public", "menubar.option_d"),
        action : doOption
    });
    menuBarSystem.addItem("menuSystem", "separator2",
        {
            text : "-"
        });

        menuBarSystem.addItem("menuSystem", "menuBtnConfigDBParam",
        {
            text : jse.getI18nValue("qat:public", "system.menu.hsqldbparamconfig_d") + "...",
            action : configDBParam
        });
        menuBarSystem.addItem("menuSystem", "separatorhsqldbparamconfig",
    {
        text : "-"
    });
    menuBarSystem.addItem("menuSystem", "menuBtnLogout",
    {
        text : jse.getI18nValue("qat:public", "toolbar.logout"),
        action : doExit
    });

    // 网元菜单
    menuBarSystem.addItem(null, "menuNE",
    {
        text : jse.getI18nValue("qat:public", "menubar.ne_d")
    });
    // 暂时屏蔽工作区配置的入口
    // menuBarSystem.addItem("menuNE", "menuBtnWorkSpace",
    // {
    // text :jse.getI18nValue("qat:public", "toolbar.workspacecfg_d") + "…",
    // action :doOpenWS
    // });
    // menuBarSystem.addItem("menuNE", "separator3",
    // {
    // text :"-"
    // });
    menuBarSystem.addItem("menuNE", "menuBtnLock",
    {
        text : jse.getI18nValue("qat:public", "menubar.lock_d"),
        action : doLock
    });
    menuBarSystem.addItem("menuNE", "menuBtnUnlock",
    {
        text : jse.getI18nValue("qat:public", "menubar.unlock_d"),
        action : doUnlock
    });

    menuBarSystem.addItem("menuNE", "menuBtnUpdateVR",
    {
        text : jse.getI18nValue("qat:public", "menubar.updatevrlist_d"),
        action : doUpdateVR
    });

    // // 模板菜单
    // menuBarSystem.addItem(null, "menuTemplet",
    // {
    // text : jse.getI18nValue("qat:public", "menubar.templet_d")
    // });
    // menuBarSystem.addItem("menuTemplet", "menuBtnTempletmgr",
    // {
    // text : jse.getI18nValue("qat:public", "menubar.templetmgr_d"),
    // action : doTempletMgr
    // });

    // C01版本功能，C00版本不要要
    // 故障菜单
    menuBarSystem.addItem(null, "menuFault",
    {
        text : jse.getI18nValue("qat:public", "menubar.fault_d")
    });
    // menuBarSystem.addItem("menuFault", "menuBtnCurAlarm",
    // {
    // text :jse.getI18nValue("qat:public", "menubar.currentalarm_d"),
    // action :doCurAlarm
    // });
    // menuBarSystem.addItem("menuFault", "menuBtnHisAlarm",
    // {
    // text :jse.getI18nValue("qat:public", "menubar.historyalarm_d"),
    // action :doHisAlarm
    // });

    // 诊断菜单
    menuBarSystem.addItem(null, "menuDiagnosis",
    {
        text : jse.getI18nValue("qat:public", "menubar.diagnosis_d")
    });
    // menuBarSystem.addItem("menuDiagnosis", "menuBtnPing",
    // {
    // text :jse.getI18nValue("qat:public", "menubar.ping_d"),
    // action :doPing
    // });
    // menuBarSystem.addItem("menuDiagnosis", "menuBtnTrace",
    // {
    // text :jse.getI18nValue("qat:public", "menubar.trace_d"),
    // action :doTrace
    // });

    // 帮助菜单
    menuBarSystem.addItem(null, "menuHelp",
    {
        text : jse.getI18nValue("qat:public", "menubar.helpall_d")
    });
    menuBarSystem.addItem("menuHelp", "menuBtnHelp",
    {
        text : jse.getI18nValue("qat:public", "menubar.help_d"),
        action : doHelp
    });
    // C01版本功能，C00版本不要
    // menuBarSystem.addItem("menuHelp", "menuBtnLicense",
    // {
    // text :jse.getI18nValue("qat:public", "menubar.license_d"),
    // action :doLicense
    // });
    // menuBarSystem.addItem("menuHelp", "menuBtnUpgrade",
    // {
    // text :jse.getI18nValue("qat:public", "menubar.upgrade_d"),
    // action :doUpgrade
    // });
    menuBarSystem.addItem("menuHelp", "separator4",
    {
        text : "-"
    });
    menuBarSystem.addItem("menuHelp", "menuBtnAbout",
    {
        text : jse.getI18nValue("qat:public", "menubar.about_d"),
        action : doAbout
    });
}
    else
    {
        // 系统菜单
        menuBarSystem.addItem(null, "menuSystem",
        {
            text : jse.getI18nValue("qat:public", "menubar.system_d")
        });
        menuBarSystem.addItem("menuSystem", "menuBtnConfigDBParam",
        {
            text : jse.getI18nValue("qat:public", "system.menu.hsqldbparamconfig_d") + "...",
            action : configDBParam
        });
    }
}

/**
 * 修改HSQLDB数据库参数
 */
function configDBParam()
{
    changeMainFrameTitle("modify.hsqldb.code");
    
    // 创建对话框
    jse.require("jse.widget.dialog");
    subDlg = new jse.widget.dialog.Dialog("dlg_ModifySqlPwd", jse.getI18nValue("qat:public",
            "system.menu.hsqldbparamconfig_d"));
    // 对话框中载入页面
    subDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/modifysqlparam/modifysqlparam.html");
    // 设置对话框大小
    subDlg.setPreferSize(350, 210);
    subDlg.setTitleImage(CommonUtil.getRootPath() + "/vmt/image/imapclient_nw.gif");
    subDlg.setDefaultCloseOperation(jse.DISPOSE_ON_CLOSE);
    subDlg.onclosing = doCloseHideDialog;
    // 显示对话框
    subDlg.show();
}

function doCloseHideDialog(evt)
{
    var contentWin = evt.target.getContentWin();

    if ((null != contentWin) && ('undefined' != typeof contentWin.doCancle))
    {
        contentWin.doCancle();
    }
    return false;
}

/**
 * 处理点击[配置选项]按钮事件
 */
function doOption()
{
    // 创建对话框
    jse.require("jse.widget.dialog");
    subDlg = new jse.widget.dialog.Dialog("dlg_Option", jse.getI18nValue("qat:public", "dailog.optiontitle_d"));
    // 对话框中载入页面
    subDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/optionmgr/option.html");
    // 设置对话框大小
    subDlg.setPreferSize(565, 400);
    // 显示对话框
    subDlg.show();
}
/**
 * 处理点击[查看日志]按钮事件
 */
function doViewLog()
{
    // 创建对话框
    jse.require("jse.widget.dialog");
    subDlg = new jse.widget.dialog.Dialog("dlg_Log", jse.getI18nValue("qat:public", "dailog.logtitle_d"));
    // 对话框中载入页面
    subDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/log/readlogger.html");
    // 设置对话框大小
    subDlg.setPreferSize(874, 600);
    // 显示对话框
    subDlg.show();
}
/**
 * 处理点击[修改用户密码]按钮事件
 */
function doModifyPwd()
{
    // 创建对话框
    jse.require("jse.widget.dialog");
    subDlg = new jse.widget.dialog.Dialog("dlg_Modify", jse.getI18nValue("qat:public", "dailog.modifytitle_d"));
    // 对话框中载入页面
    subDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/security/modifypwd.html");
    // 设置对话框大小
    subDlg.setPreferSize(390, 190);
    // 显示对话框
    subDlg.show();
}
/**
 * 处理点击[查看版本信息]按钮事件
 */
function doAbout()
{
    // 创建对话框
    jse.require("jse.widget.dialog");
    subDlg = new jse.widget.dialog.Dialog("dlg_About", jse.getI18nValue("qat:public", "dailog.abouttitle_d"));
    // 对话框中载入页面
    subDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/about/about.html");
    // 设置对话框大小
    subDlg.setPreferSize(463, 380);
    // 显示对话框
    subDlg.show();
}
/**
 * 
 * @return
 */
function doLicense()
{
    alert("doLicense");
}

/**
 * 
 * @return
 */
function doUpgrade()
{
    alert("doUpgrade");
}
/**
 * 
 * @return
 */
function doLock()
{
    deviceWin.doLock();
}

/**
 * 
 * @return
 */
function doUnlock()
{
    deviceWin.doUnLock();
}

/**
 * 
 * @return
 */
function doPing()
{
    // 处理PingTrace动态菜单
    pub_getDynamicMenu(menuBarSystem);
}

/**
 * 
 * @return
 */
function doTrace()
{
    alert("doTrace");
}

/**
 * 
 * @return
 */
function doCurAlarm()
{
    alert("doCurAlarm");
}

/**
 * 
 * @return
 */
function doHisAlarm()
{
    alert("doHisAlarm");
}

function doUpdatePkg()
{
    // z00133566 功能屏蔽
    // pub_getDevSupportPkg();
}

/**
 * 
 * @return
 */
function doUpdateVR()
{
    deviceWin.doFresh();
}

/**
 * 处理点击[查看帮助]按钮事件
 */
function doHelp()
{
    pub_doHelp("indexhead");
}

function setToolBarPane()
{
    // 集成情况下去掉"切换设备"按钮
    if ("false" == independence)
    {
        toolbtnDevSel.setText("");
        toolbtnDevSel.setImage("");
        toolbarpane.pack();
    }
}

/**
 * 处理点击[选择设备]按钮事件
 */
function doChangeDev()
{
    // 创建对话框
    jse.require("jse.widget.dialog");
    subDlg = new jse.widget.dialog.Dialog("dlg_ChangeDev", selDevTitle);
    // 对话框中载入页面
    subDlg.setURL(CommonUtil.getRootPath() + "/vmt/ct/device/devicelisthtml.jsp");
    var width = 0;
    var height = 0;
    width = screen.width * 0.4;
    height = screen.height * 0.4;
    // 设置对话框大小
    subDlg.setPreferSize(width, height);
    // 显示对话框
    subDlg.show();
}

/**
 * 处理点击[工作区]按钮事件
 */
function doOpenWS()
{
    if (isWorkspaceOpen)
    {
        return;
    }
    var topWin = jse.topWin;
    // 每次打开工作区，先discardChange
    var result = jsonrpc.invoke("workspaceService", "discardChanges", [ "false", g_NeFlag, g_VRID,
            topWin.deviceIp_URLParam ]);
    if ("OPER_OK" != result.resultType)
    {
        // 弹出错误对话框
        CommonDlgReq.openRspErrorDialog(result, null, null);
    }
    else
    {
        var title = F1HelpUtil.getF1HelpID("workspace");
        F1HelpUtil.resetF1PageTitle(title);
        

        isWorkspaceOpen = true;
        // 创建窗口
        jse.require("jse.widget.window");
        wsWin = new jse.widget.window.InternalWindow("dlg_Workspace", jse.getI18nValue("qat:public", "dailog.workspacetitle_d"));

        wsWin.onclosing = doCloseWS;

        // TODO 将feature界面的新建、修改、克隆、删除按钮灰化

        // 对话框中载入页面
        wsWin.setURL(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/mainframe/workspace/workspace.html");

        var width = screen.width * 0.90;
        if ("undefined" != typeof (this.outerWidth))
        {
            width = this.outerWidth * 0.90;
        }
        var height = width * 0.65;
        // 设置对话框大小
        wsWin.setPreferSize(width, height);
        // 显示对话框
        wsWin.show();

        // 有工具栏的话，处理工具栏
        if (null != toolbarpane)
        {
            // 切换设备按钮灰化
            // toolbtnBaseOnTemplet.setEnabled(false);
            // menuBarSystem.setItemEnabled("menuBtnBaseOnTemp", false);

            // 目前不支持工作区相关功能，暂时屏蔽入口。
            // 将打开工作区按钮灰化
            // toolbtnOperWS.setEnabled(false);
            // menuBarSystem.setItemEnabled("menuBtnWorkSpace", false);

            // menuBarSystem.setItemEnabled("menuBtnUpdatePkg", false);
        }
        var featureWin = viewManager.getWindowById("feature");

        var nodeID = curFeatureNodeID;
        var isFeaNode = isCurFeatureNode;
        if (null != nodeID && isFeaNode == true)
        {
            if (("undefined" != typeof (featureWin)) && (null != featureWin)
                    && ("undefined" != typeof (featureWin.switchToolBtnState)))
            {
                featureWin.switchToolBtnState();
            }
        }
    }
}

/**
 * 关闭工作区函数
 * 
 */
function doCloseWS()
{
    resetMainFrameTitle();
 
    isWorkspaceOpen = false;
    var ws = wsWin.getContentWin();
    ws.exitWorkspace();
    return false;
}

/**
 * 处理点击[后退]按钮事件 Add byj65716
 */
function handleGoBack()
{
    doClickBackNutton();
}

/**
 * 处理点击[查询后退内容]按钮事件
 */
function doQueryBackContents()
{
    queryBackContents();
}

/**
 * 处理点击[前进]按钮事件
 */
function handleGoForward()
{
    doClickForwardButton();
}

/**
 * 处理点击[查询前进内容]按钮事件
 */
function doQueryForwardContents()
{
    queryForwardContents();
}

/**
 * 刷新工具栏
 */
function refreshToolbar(toolBarFlg)
{

}

/**
 * 获取当前登录设备的设备类型和版本信息的回调函数
 */
function getDevTypeVersionCallback(errorCode, request)
{
    if ("OPER_OK" == resultType)
    {
        var deviceTypeNode = jse.selectSingleNode("/response/data/deviceType", doc);
        deviceType = deviceTypeNode.getAttribute("value");

        var deviceVersionNode = jse.selectSingleNode("/response/data/deviceVerison", doc);
        deviceVersion = deviceVersionNode.getAttribute("value");

        showTempletSelDlg(pub_getClonePnpForm().deviceType, pub_getClonePnpForm().deviceVersion, curDevFlag,
                isSupPartition, "single", "win.showDeployDlg(templetName);", "configurebytemplate", "false");
    }
}

/**
 * 定位故障管理菜单项所对应的设备树节点和功能树节点
 * 
 * @param faultItem
 * @return
 */
function pub_locateFaultManagement(faultItem, condition)
{
    var viewDevice = viewManager.getWindowById(Constants.DEVICE_VIEWID);
    viewDevice.pub_selLRDevice();
    
    var viewCapability = viewManager.getWindowById(Constants.FUNCTION_VIEWID);
    viewCapability.pub_setCurSelFaultItem(faultItem, condition);
}
/**
 * 将当前页面设置为LR的设备面板,供集成告警入口使用
 * 
 * @return
 */
function pub_getAlarmPanelDevice(resId)
{
    var viewDevice = viewManager.getWindowById(Constants.DEVICE_VIEWID);
    viewDevice.pub_selLRDevice();
    var viewCapability = viewManager.getWindowById(Constants.FUNCTION_VIEWID);
    // 修改设备面板的resId
    resID = resId;
    viewCapability.pub_setCurSelDevicePanel();
}

/**
 * 调用网元面板的接口
 * 
 * @param args 参数列表
 * @return
 */
function pub_panelCommonInterface(args)
{
    var viewFeature = viewManager.getWindowById("panel");
    viewFeature.pub_panelCommonInterface(args);
}

/**
 * 集成调用
 * 
 * @param color
 * @return
 */
function pub_setBoardNormalColor(color)
{
    var viewDevice = viewManager.getWindowById(Constants.DEVICE_VIEWID);
    var viewCapability = viewManager.getWindowById(Constants.FUNCTION_VIEWID);
    // 修改设备面板的resId
    viewCapability.pub_setBoardNormalColor(color);
}

/**
 * 获取支持包信息
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function pub_getClonePnpForm()
{
    return this.pnpForm.clone();
}

/**
 * 设置pnpForm信息
 * 
 * @param deviceType 设备类型
 * @param deviceVersion 设备版本
 * @param compatible 是否兼容
 */
function pub_setPnpForm(deviceType, deviceVersion, compatible)
{
    this.pnpForm.deviceType = deviceType;
    this.pnpForm.deviceVersion = deviceVersion;
    this.pnpForm.compatible = compatible;
}

/**
 * 获取当前设备类型
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-26
 * @return
 */
function pub_getCurDeviceType()
{
    return this.pnpForm.deviceType;
}

/**
 * 获取当前设备版本
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-26
 * @return
 */
function pub_getCurDeviceVersion()
{
    return this.pnpForm.deviceVersion;
}

/**
 * 设置设备面板的资源id
 * 
 * @return
 */
function pub_setPanelResID()
{
    var viewFeature = viewManager.getWindowById("panel");
    viewFeature.pub_locateEntity(resID);
}
/**
 * 设置面板颜色
 * 
 * @param color
 * @return
 */
function pub_setPanelBoardNormalColor(color)
{
    var viewFeature = viewManager.getWindowById("panel");
    viewFeature.pub_updateBoardNormalColor(color);
}

/**
 * 退出网元，集成情况下客户端调用
 * 
 * @return
 */
function pub_ExitCurrentDevice()
{
    var req = jse.RpcRequest
            .create(CommonUtil.getRootPath() + "/vmt/ct/device/DeviceMgrAction.do?methodID=handleExitDeviceReq&deviceIP=" + deviceIP);

    // 设备列表数据后的回调处理函数
    req.invoke(handleResult, [ "callback_logOut_curDevice();" ]);
}
/**
 * 集成情况下，退出网元不分析结果
 * 
 * @return
 */
function callback_logOut_curDevice()
{

}

/**
 * 获取是否离线
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-6-27
 * @return 是否离线
 */
function pub_isOffline()
{
    return isOffline;
}

function getSubWindowById(viewId)
{
    var aaab = viewManager.getWindowById(viewId);
    return viewManager.getWindowById(viewId);
}

/**
 * 集成情况下，弹出工作区对话框时，修改主界面的title，响应F1
 */
function changeMainFrameTitle(title)
{
    var independFlag = jse.topWin.independence;
    if ("undefined" != typeof (independFlag) && independFlag == "false")
    {
        var titlePrefix;
        switch(moduleName)
        {
            case ModuleName.V8PTN:
            {
                titlePrefix = F1HelpPrefix.V8PTN;
                break;
            }
            case ModuleName.VMF:
            {
                titlePrefix = ModuleName.VMF;
                break;
            }
            default:
            {
                titlePrefix = ModuleName.VMF;
                break;
            }
        }
        
        jse.topWin.document.title = titlePrefix + title;
    }
}

/**
 * 集成情况下，关闭对话框时，恢复主界面的title，响应F1
 */
function resetMainFrameTitle()
{
    var title = F1HelpUtil.getF1HelpID("root");
    F1HelpUtil.resetF1PageTitle(title);
    

}

/**
 * 集成情况下，关闭对话框时，恢复主界面的title，响应F1
 */
function resetTemplateMainFrameTitle()
{
    var independFlag = jse.topWin.independence;
    if ("undefined" != typeof (independFlag) && independFlag == "false")
    {
        jse.topWin.document.title = "vmf.template.templatemanager";
    }
}

/**
 * 获取硬件规格差异数据缓存管理对象
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-1-15
 */
function pub_getHardSpecDiffDataCacheMgr()
{
    return g_HardSpecDiffDataCacheMgr;
}

/**
 * 获取全局配置选项信息
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-1-19
 */
function pub_getSystemConfigDataMgr()
{
    return g_SystemConfigDataMgr;
}

/**
 * 系统配置项数据
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-1-19
 */
function SystemConfigDataMgr()
{
    /**
     * 系统配置数据
     */
    this._systemProps = null;
}

/**
 * 初始化全局数据
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-1-15
 */
SystemConfigDataMgr.prototype.init = function()
{
    if (null == this._systemProps)
    {
        // 向后台请求全局选项数据
        var operResult = jsonrpc.invoke("systemConfigurationInfoMgr", "getSystemConfigurations", []);
        if ((null != operResult) && (null != operResult.map))
        {
            this._systemProps = operResult.map;
        }
    }
}

/**
 * 获取指定属性值（key为配置文件中索引值）
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-1-15
 * @return 找不到返回null；找到返回对应值
 */
SystemConfigDataMgr.prototype.getProperty = function(key)
{
    //使用时初始化
    this.init();
    
    return this._systemProps[key];
}

/* 全局RPC代理对象 */
var g_jsonrpc = null;

/**
 * 获取json对象接口
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-7-12
 */
function pub_getJsonRpcObj()
{
    if(null == g_jsonrpc)
    {
        g_jsonrpc = new VmtJsonRPC();
    }
    
    return g_jsonrpc;
}

/**
 * 重新初始化json对象接口（无论之前是否初始化过，进行重新初始化操作，
 * 提供给预加载打开网元管理器时重新注册json对象，防止后台重启出错）
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-7-11
 */
function reInitJsonRpcObj()
{
    g_jsonrpc = new VmtJsonRPC();
}

function getFuncnodeExtInfo()
{
    jsonrpc.asynInvoke("funcnodeExtInfoProcess", "getFuncnodeExtInfo", [ this.pnpForm.deviceType, this.pnpForm.deviceVersion ],
            this.initFuncnodeExtInfo, this, []);
}
var g_funcnodeExtInfoMap = null;
var pub_getFuncnodeExtInfoFlag = false;
function initFuncnodeExtInfo(operResult)
{
    if (null != operResult)
    {
        if(null != operResult.returnObj)
        {
            g_funcnodeExtInfoMap = operResult.returnObj.map;
        }
        else
        {
            g_funcnodeExtInfoMap = null;
        }
        pub_getFuncnodeExtInfoFlag = true;
    }
}
function pub_functionExtInfo(funcnodeName)
{
    if (!pub_getFuncnodeExtInfoFlag)
    {
        //var operResult = jsonrpc.doInvoke("funcnodeExtInfoProcess", "getFuncnodeExtInfo",
        //        [ this.pnpForm.deviceType, this.pnpForm.deviceVersion ], this.initFuncnodeExtInfo, this, []);
        var operResult = jsonrpc.invoke("funcnodeExtInfoProcess", "getFuncnodeExtInfo",
                [ this.pnpForm.deviceType, this.pnpForm.deviceVersion ]);
        initFuncnodeExtInfo(operResult);
    }
    if(null == g_funcnodeExtInfoMap)
    {
        return null;
    }
    return g_funcnodeExtInfoMap[funcnodeName];
}
/**
 * 获取设备管理树页面对象
 * @returns
 */
function pub_getDeviceWin()
{
	var windowManager = window.xui.getWidget("ViewManager"); 
    var deviceWin = windowManager.getWindowById(Constants.DEVICE_VIEWID);
    return deviceWin;
}
/**
 * 获取功能树页面对象
 * @returns
 */
function pub_getFuncWin()
{
	var windowManager = window.xui.getWidget("ViewManager"); 
	var id = pub_getDeviceWin().deviceTree.getCurrentSelection(); 
	var funcWin = windowManager.getWindowById(getFunctionTreeViewID(id));
    return funcWin;
}
/**
 * 通过视图id获取功能树页面对象
 * @returns
 */
function pub_getFuncWinByViewId(viewId)
{
    var windowManager = window.xui.getWidget("ViewManager"); 
    var funcWin = windowManager.getWindowById(getFunctionTreeViewID(viewId)); 
    return funcWin;
}
/**
 * 获取功能树页面对象
 * @returns
 */
function pub_getPanelWin()
{
	var windowManager = window.xui.getWidget("ViewManager"); 
	var panelWin = windowManager.getWindowById(Constants.PANEL_VIEWID);
    return panelWin;
}
/**
 * 是否加载单板树
 * @returns 
 */
function isLoadBoardTree()
{
    if(null == loadBoardTree)
    {
        if(null == deviceOption)
        {
            var operResult = jsonrpc.invoke("deviceOptionService", "getDeviceOption", [deviceType, deviceVersion]); 
            if(null != operResult && operResult.resultType == "OPER_OK") 
            {
                deviceOption = operResult.returnObj;
            } 
            if(null == deviceOption)
            {
                loadBoardTree = false;
                return loadBoardTree;
            }
            loadBoardTree = deviceOption.isLoadBoardTree;  
        }
        else
        {
            loadBoardTree = deviceOption.loadBoardTree;  
        }
    }
    return loadBoardTree; 
}
/**
 * 异步获取设备选项信息
 */
function getDeviceOption()
{
    jsonrpc.asynInvoke("deviceOptionService", "getDeviceOption", [ deviceType, deviceVersion ],
            this.doDeviceOptionOperResult, this, []);  
}
/**
 * 获取设备选项回调函数
 */
function doDeviceOptionOperResult(operResult)
{
    if(null != operResult && operResult.resultType == "OPER_OK") 
    {
        deviceOption = operResult.returnObj;
    }
}
