/**
 * 本文件为主窗体VR状态保留的处理文件
 * @author j65716 2009-2-21
 * @since 1.0
 */

/**
 * 用来保存当前设备各VR的状态信息（选中的“功能/模板”ViewID，模板树的选中节点ID）
 */
var VR_Status_Array = new Array();

/**
 * 当前设备选中的VRID
 */
var CurrentVR_ID = null;

/**
 * 当前选中VR节点text
 */
var CurrentVR_Name = null;

/**
 * 模板树上文件夹结点列表
 */
var g_foldersIds = null;

/**
 * 当前所选文件夹结点ID
 */
var g_curSelFolderId = null;

/**
 * 文件夹结点内容列表
 */
var g_folderTextList = null;

/**
 * 是否是模板管理页面
 */
var isTempletWindow = false;

/**
 * VR状态信息
 * 
 * @param VRid VR节点
 * @param ActiveTab VR下配置区激活的ViewID（功能/模板）
 * @param SelProfileNode VR下模板树上选择的模板类型节点ID（功能/模板）
 */
function VRStatusInfo(VRid, ActiveTab, selNodeInfo)
{
    this.VRid = VRid;
    this.ActiveTab = ActiveTab;
    this.selNodeInfo = selNodeInfo;
    this.functionViewLoad = false;
    this.templetViewLoad = false;
}

/**
 * 是否是模板管理页面
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-5-27
 */
function pub_isTempletWindow()
{
	return isTempletWindow;
}

/**
 * capability节点信息
 * 
 * @param featureNodeID 节点ID
 * @param featureNodeText 节点名称
 * @param nodeVersion 节点版本
 */
function capabilityNodeInfo(NodeID, NodeText, NodeVersion, isFeatureNode)
{
    this.NodeID = NodeID;
    this.NodeText = NodeText;
    this.NodeVersion = NodeVersion;
    this.isFeatureNode = isFeatureNode;
}

/**
 * 获取vr状态
 * 
 * @param vrID vrID
 */
function getVRStatusNode(vrID)
{
    for ( var k = 0; k < VR_Status_Array.length; k++)
    {
        // 找出存放的设备节点
        if (vrID == VR_Status_Array[k].VRid)
        {
            return VR_Status_Array[k];
        }
    }
    return null;
}

function pub_clearVRStatusInfo()
{
    for ( var k = 0; k < VR_Status_Array.length - 1; k++)
    {
        // if(CurrentVR_ID == VR_Status_Array[k].VRid)
        // {
        // continue;
        // }
        var oldFunctionView = viewManager.getWindowById(getFunctionTreeViewID(VR_Status_Array[k].VRid));
        if (null != oldFunctionView)
        {
            // 在关闭前需要回收视图上的组件资源
            // oldFunctionView.onClose();
        }

        // 此处JSE有Bug，隐藏的View不能close掉，需要show一下，JSE修改后再屏蔽该句
        viewManager.showView(getFunctionTreeViewID(VR_Status_Array[k].VRid));
        viewManager.closeView(getFunctionTreeViewID(VR_Status_Array[k].VRid));
    }

    VR_Status_Array[VR_Status_Array.length - 1].functionViewLoad = false;
    VR_Status_Array[VR_Status_Array.length - 1].templetViewLoad = false;

    // 清空数组元素
    VR_Status_Array.splice(0, VR_Status_Array.length - 1);

    // for(var k = 0; k< VR_Status_Array.length; k++)
    // {
    // VR_Status_Array[k].functionViewLoad = false;
    // VR_Status_Array[k].templetViewLoad = false;
    //        
    // // //找出存放的设备节点
    // // if(vrID == VR_Status_Array[k].VRid)
    // // {
    // // return VR_Status_Array[k];
    // // }
    // }
}

function pub_load()
{
    loadFunctionURL(null, null);
    loadBlankFeatureView(getFunctionTreeViewID(CurrentVR_ID));
}

function procVRStatusForPreload(VRid, deviceName)
{
    // 更改当前选中的VRID为新的VR
    CurrentVR_ID = VRid;
    CurrentVR_Name = deviceName;
    
    var node = new VRStatusInfo(CurrentVR_ID, null, null);
    node.functionViewLoad = true;
    VR_Status_Array.push(node);
}

/**
 * 处理设备节点切换的消息 要做的事情：1、保留前一个VR的状态； 2、加载选中的VR下嵌的功能/模板视图
 * 
 * @param VRid VR的节点ID
 * @param deviceName VR节点名称
 * @param isSupportPartition 是否支持LRVR划分、
 */
function processVRChange(VRid, deviceName, isSupportPartition)
{
    logger.log("enter processVRChange");
    var tmpVRid = (pub_getDeviceWin().pub_isSelectBoardNode()) ? pub_getDeviceWin().deviceTree.getCurrentSelection(): VRid; 
    // 标记VR在状态记录中是否存在
    var isVRExist = false;
    
    // 存放上一个VR信息，下面切换用
    var lastVRID = CurrentVR_ID;
    var lastVRName = CurrentVR_Name;

    // 更改当前选中的VRID为新的VR
    CurrentVR_ID = tmpVRid; 
    CurrentVR_Name = deviceName;
    
    // 记录上一个VR的状态
    saveVRStatus(lastVRID);

    // VR增加删除时也需要维护这个页面缓存（现在不支持）；设备刷新操作也需要将页面close掉吧？？
    // 还要记录模板是否是激活的并且哪个是选中的
    for ( var k = 0; k < VR_Status_Array.length; k++)
    {
        // 若存在则直接将 页面激活，并隐藏现在激活的tab
        if (tmpVRid == VR_Status_Array[k].VRid)
        {
            isVRExist = true;
            loadSavedFunctionView(lastVRID, k, isSupportPartition);
            break;
        }
    }

    // 不存在则加载对应的View
    if (!isVRExist)
    {
        resetMainFrameTitle();
        loadNewFunctionView(lastVRID, isSupportPartition);
    }

    viewManager.setViewURL(Constants.NORMAL_VIEWID, GlobalConstants.EMPTY_PAGE);
    var tabId = tabIds.split("@");
    for ( var i = 0; i < tabId.length; i++)
    {
        viewManager.closeView(tabId[i]);
    }
    tabIds = "";
}

/**
 * 保存前一个VR状态
 * 
 * @param lastVRID 上次选中的VRID
 */
function saveVRStatus(lastVRID)
{
	if (null == lastVRID)
    {
        return;
    }
    
    // 当前激活的ViewID
    var ActiveViewID = null;
    var functionViewID = getFunctionTreeViewID(lastVRID);


    // 获取切换前激活的Tab（功能/模板）
    if (viewManager.isActive(functionViewID))
    {
        ActiveViewID = functionViewID;
    }
    else if (viewManager.isActive(Constants.PROFILE_VIEWID))
    {
        ActiveViewID = Constants.PROFILE_VIEWID;
    }

    for ( var k = 0; k < VR_Status_Array.length; k++)
    {
        // 找出存放的设备节点
        if (lastVRID == VR_Status_Array[k].VRid)
        {
            // 记录切换前VR的功能区的状态（选中的是模板还是功能，模板选中的节点），
            // 模板选中节点一直已经记录了
            VR_Status_Array[k].ActiveTab = ActiveViewID;
            break;
        }
    }
}

/**
 * 加载并则添加到数组中 （需要判断是否超过十个，超过的话需要将最早的删除掉） 包含两种情况：1、鼠标切换VR引起（无指定节点） 2、前进后退切换VR引起（有指定节点）
 * 
 * @param lastVRID 上次选中的VRID
 * @param isSupportPartition 是否支持划分
 */
function loadNewFunctionView(lastVRID, isSupportPartition)
{
    logger.log("start loadNewFunctionView");
    
    // 要切换的VR对应功能View的ID
    var ChangedVRFuncitionViewID = getFunctionTreeViewID(CurrentVR_ID);
    var lastFuncitionViewID = getFunctionTreeViewID(lastVRID);

    // 这个必须在这里设置，供下面加载模板树时会保存这个节点选中的模板节点ID
    var VRNode = new VRStatusInfo(CurrentVR_ID, null, null);
    VR_Status_Array.push(VRNode);
    
    // 获取capabilityviewTitle
    var capabilityViewTitle = jse.getI18nValue(Constants.LOCALRESFILE_PATH, Constants.KEY_FOR_CAPABILITYTITLE);    
    loadFunctionView(lastFuncitionViewID, ChangedVRFuncitionViewID, isSupportPartition, null, false);
    setTemplateViewStatus();    
     
     // 默认激活功能view
     viewManager.activateView(ChangedVRFuncitionViewID);

    // 大于最大限制的话，需要删除最早的VR状态
    if (10 < VR_Status_Array.length)
    {
        var oldFunctionView = viewManager.getWindowById(getFunctionTreeViewID(VR_Status_Array[0].VRid));
        if (null != oldFunctionView)
        {
            // 在关闭前需要回收视图上的组件资源(功能树提供)
            // oldFunctionView.onClose();
        }

        // 此处JSE有Bug，隐藏的View不能close掉，需要show一下，JSE修改后再屏蔽该句
        viewManager.showView(getFunctionTreeViewID(VR_Status_Array[0].VRid));
        viewManager.closeView(getFunctionTreeViewID(VR_Status_Array[0].VRid));

        // VR状态记录中需要移除头节点
        VR_Status_Array.shift();
    }
    
    logger.log("exit loadNewFunctionView");
}

/**
 * 从保存的状态节点中获取保留状态
 * 
 * @param lastVRID 上次选中VR节点ID
 * @param positionID 要加载的VR状态在队列中的存放位置
 * @param isSupportPartition 是否支持划分
 */
function loadSavedFunctionView(lastVRID, positionID, isSupportPartition)
{
    // 获取节点信息
    var nodeForVRStatus = VR_Status_Array[positionID];

    // 要切换的VR对应功能View的ID
    var ChangedVRFuncitionViewID = getFunctionTreeViewID(CurrentVR_ID);   
    var lastFuncitionViewID = getFunctionTreeViewID(lastVRID);

    // 隐藏上一个VR的功能Tab
    viewManager.hideView(lastFuncitionViewID);
    // 显示当前VR下嵌的树，并激活上次离开时的View
    viewManager.showView(ChangedVRFuncitionViewID);
    
    setTemplateViewStatus();
    if (Constants.PROFILE_VIEWID == nodeForVRStatus.ActiveTab)
    {
        loadTemplateView();
    }
    else
    {
        viewManager.activateView(nodeForVRStatus.ActiveTab);
        
        // 若离开状态为功能View，则调用功能树方法，根据选中节点加载Tab页
        if (nodeForVRStatus.functionViewLoad)
        {
            var vrActiveView = viewManager.getWindowById(nodeForVRStatus.ActiveTab);
            if ("undefined" != typeof (vrActiveView.addFeatureViewBySelNode))
            {
                vrActiveView.addFeatureViewBySelNode();
            }
        }        
    }

    // 将操作的这个VR状态在队列中的位置更新到队尾
    VR_Status_Array.splice(positionID, 1);
    VR_Status_Array.push(nodeForVRStatus);
}

/**
 * 设置模板View 显示隐藏状态
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-5
 */
function setTemplateViewStatus()
{
    if ("LR" != g_NeFlag)
    {
        viewManager.hideView(Constants.PROFILE_VIEWID);
    }
    else
    {
        viewManager.showView(Constants.PROFILE_VIEWID);
    }
}


/**
 * 动态加载模板view（切换VR）
 * 
 * @param selNodeID 选中节点ID
 */
function loadTemplateView()
{
    // 只有激活view才能重置url，不知时JSE的bug还是如此限制的
    viewManager.showView(Constants.PROFILE_VIEWID);
    viewManager.activateView(Constants.PROFILE_VIEWID);
    var isLoad = isViewLoad(CurrentVR_ID, Constants.PROFILE_VIEWID)
    if(!isLoad)
    {
        viewManager.setViewURL(Constants.PROFILE_VIEWID, CommonUtil.getRootPath() + "/vmt/ct/templet/mainframe/templettree/templettree.html");
        // 设置加载标记
        setViewIsLoad(CurrentVR_ID, Constants.PROFILE_VIEWID, true);
    }
    else
    {
        var templetTreeTab = viewManager.getWindowById(Constants.PROFILE_VIEWID);        
        if (undefined != templetTreeTab)
        {
            // 根据选中结点加载模板实例页面
            templetTreeTab.pub_refreshTempletMgrTab(g_loadTempletTreeNum);
            g_loadTempletTreeNum++;
        }
    }
}


/**
 * 加载功能树view并隐藏上一个VR对应view，并加载URL（切换VR）
 * 
 * @param lastFuncitionViewID 上个VR的功能viewID
 * @param ChangedVRFuncitionViewID 需要显示的viewID
 * @param isSupportPartition 是否支持LR/VR划分
 * @param selNodeID 选中节点ID
 * @param isBackForwardOper是否由前进后退触发
 */
function loadFunctionView(lastFuncitionViewID, ChangedVRFuncitionViewID, isSupportPartition, selNodeID,
        isBackForwardOper)
{
    
    logger.log("enter loadFunctionView");

    // 是否支持LR/VR划分，从主窗体中获取，暂时未提供
    var capabilityViewTitle = jse.getI18nValue(Constants.LOCALRESFILE_PATH, Constants.KEY_FOR_CAPABILITYTITLE);

    var url = Constants.URL_FUNCTREEHTML + "deviceName=" + CurrentVR_Name + "&deviceID=" + CurrentVR_ID
    + "&isSupportPartition=" + isSupportPartition + "&selNodeID=" + selNodeID + "&neFlag=" + g_NeFlag
    + "&isWorkspace=" + isWorkspace;
    
    if("LR" == g_NeFlag && (!pub_getDeviceWin().pub_isSelectBoardNode()))
    {
        viewManager.setViewURL(ChangedVRFuncitionViewID, Constants.URL_FUNCTREEHTML + "deviceName=" + CurrentVR_Name + "&deviceID=" + CurrentVR_ID
                + "&isSupportPartition=" + isSupportPartition + "&selNodeID=" + selNodeID + "&neFlag=" + g_NeFlag
                + "&isWorkspace=" + isWorkspace);
    }
    else
    {
        if (null == selNodeID)
        {
            viewManager.insertAfter(lastFuncitionViewID, ChangedVRFuncitionViewID,
            {
                title :capabilityViewTitle,
                url :Constants.URL_FUNCTREEHTML + "deviceName=" + CurrentVR_Name + "&deviceID=" + CurrentVR_ID
                        + "&isSupportPartition=" + isSupportPartition + "&neFlag=" + g_NeFlag + "&isWorkspace="
                        + isWorkspace,
                detachedSize : [ 400, 300 ],
                location :"west.center",
                style :jse.UNDRAG | jse.UNCLOSE | jse.UNFLOAT
            });

        }
        else
        {
            viewManager.insertAfter(lastFuncitionViewID, ChangedVRFuncitionViewID,
            {
                title :capabilityViewTitle,
                url :Constants.URL_FUNCTREEHTML + "deviceName=" + CurrentVR_Name + "&deviceID=" + CurrentVR_ID
                        + "&isSupportPartition=" + isSupportPartition + "&selNodeID=" + selNodeID + "&neFlag=" + g_NeFlag
                        + "&isWorkspace=" + isWorkspace,
                detachedSize : [ 400, 300 ],
                location :"west.center",
                style :jse.UNDRAG | jse.UNCLOSE | jse.UNFLOAT
            });
        }
    }
    
    // 设置加载标记
    setViewIsLoad(CurrentVR_ID, Constants.FUNCTION_VIEWID, true);

    if(lastFuncitionViewID != ChangedVRFuncitionViewID)
    {
        viewManager.hideView(lastFuncitionViewID);
    }

    logger.log("exit loadFunctionView");
}

/**
 * 显示空白功能树Tabview并隐藏上一个VR对应view（切换VR）
 * 
 * @param lastFuncitionViewID 上一个视图ID
 * @param ChangedVRFuncitionViewID 要改变的目标viewID
 */
function loadBlankFunctionView(lastFuncitionViewID, ChangedVRFuncitionViewID)
{
    var capabilityViewTitle = jse.getI18nValue(Constants.LOCALRESFILE_PATH, Constants.KEY_FOR_CAPABILITYTITLE);

    // 只插入空白的，用到时再显示
    viewManager.insertAfter(lastFuncitionViewID, ChangedVRFuncitionViewID,
    {
        title :capabilityViewTitle,
        url :"",
        detachedSize : [ 400, 300 ],
        location :"west.center",
        style :jse.UNDRAG | jse.UNCLOSE | jse.UNFLOAT
    });

    viewManager.hideView(lastFuncitionViewID);
}

/**
 * 获取功能树视图ID，LR不加后缀，节省第一次加载时间
 * @param vrID
 * @param neFlag
 * @return
 */
function getFunctionTreeViewID(vrID)
{
    if(null == vrID || this.deviceIp_URLParam == vrID)
    {
        return Constants.FUNCTION_VIEWID;
    }
    else
    {
        return Constants.FUNCTION_VIEWID + vrID;
    }
}

/**
 * 加载当前VR的功能URL
 * 
 * @param lastFuncitionViewID 上个VR的功能viewID
 * @param ChangedVRFuncitionViewID 需要显示的viewID
 * @param isSupportPartition 是否支持LR/VR划分
 * @param selNodeID 选中节点ID
 * @param isBackForwardOper是否由前进后退触发
 */
function loadFunctionURL(selNodeID, isBackForwardOper)
{
    var viewID = getFunctionTreeViewID(g_VRID);

    if (null == selNodeID)
    {
        viewManager.setViewURL(viewID, Constants.URL_FUNCTREEHTML + "deviceName=" + encodeURIComponent(g_VRName)
                + "&deviceID=" + g_VRID + "&isSupportPartition=" + g_IsSupportPartition + "&neFlag=" + g_NeFlag);

    }
    else
    {
        viewManager.setViewURL(viewID, Constants.URL_FUNCTREEHTML + "deviceName=" + encodeURIComponent(CurrentVR_Name)
                + "&deviceID=" + CurrentVR_ID + "&isSupportPartition=" + isSupportPartition + "&selNodeID=" + selNodeID
                + "&neFlag=" + g_NeFlag);
    }

    // 设置加载标记
    setViewIsLoad(CurrentVR_ID, Constants.FUNCTION_VIEWID, true);

}

/**
 * 设置能力view是否已经加载
 * 
 * @param vrID vrID
 * @param viewID 视图ID
 * @param isLoad 是否已经加载
 */
function setViewIsLoad(vrID, viewID, isLoad)
{
    for ( var k = 0; k < VR_Status_Array.length; k++)
    {
        // 找出存放的设备节点
        if (vrID == VR_Status_Array[k].VRid)
        {
            if (Constants.PROFILE_VIEWID == viewID)
            {
                VR_Status_Array[k].templetViewLoad = isLoad;
            }
            else
            {
                VR_Status_Array[k].functionViewLoad = isLoad;
            }

            break;
        }
    }
}

function isViewLoad(vrID ,viewID)
{
    var isLoad = false;
    for ( var k = 0; k < VR_Status_Array.length; k++)
    {
        if (vrID == VR_Status_Array[k].VRid)
        {
            if (Constants.PROFILE_VIEWID == viewID)
            {
                isLoad = VR_Status_Array[k].templetViewLoad;
            }
            else
            {
                isLoad = VR_Status_Array[k].functionViewLoad;
            }
        }
    }
    
    return isLoad;
}


/**
 * 切换设备时的清空操作，切换设备时调用（放到设备管理文件当中）
 */
function pub_DeviceChangeClear()
{
    for ( var k = 0; k < VR_Status_Array.length; k++)
    {
        var oldFunctionView = viewManager.getWindowById(getFunctionTreeViewID(VR_Status_Array[k].VRid));
        if (null != oldFunctionView)
        {
            // 在关闭前需要回收视图上的组件资源
            // oldFunctionView.onClose();
        }

        // 此处JSE有Bug，隐藏的View不能close掉，需要show一下，JSE修改后再屏蔽该句
        viewManager.showView(Constants.FUNCTION_VIEWID + VR_Status_Array[k].VRid);
        viewManager.closeView(Constants.FUNCTION_VIEWID + VR_Status_Array[k].VRid);
    }

    // 清空数组元素
    VR_Status_Array.splice(0, VR_Status_Array.length);
    // 各个界面恢复默认界面
    viewManager.activateView(Constants.PROFILE_VIEWID);
    viewManager.setViewURL(Constants.PROFILE_VIEWID, GlobalConstants.EMPTY_PAGE);
    viewManager.showView(Constants.FUNCTION_VIEWID);
    viewManager.activateView(Constants.FUNCTION_VIEWID);
    viewManager.setViewURL(Constants.FUNCTION_VIEWID, GlobalConstants.EMPTY_PAGE);
    viewManager.setViewURL(Constants.NORMAL_VIEWID, GlobalConstants.EMPTY_PAGE);
    // 清空历史记录
    History_List.clear();

    // 重置空白页标识
    Flag_CurrentFeatureView_IsBlankTab = true;

    // 前进后退按钮禁用
    initHistoryButtonStatus();

    CurrentVR_ID = null;

    CurrentVR_Name = null;
}


/**
 * 加载模板管理页面
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-11
 * @param folderIds 文件夹结点列表
 * @param title 标题
 * @param curSelID 当前选择的文件夹结点ID
 * @param folderTextList 文件夹内容列表
 * @return
 */
function pub_LoadTempletMgrView(folderIds, title,curSelID, folderTextList)
{
    g_foldersIds = folderIds;
    g_curSelFolderId = curSelID;
    g_folderTextList = folderTextList;
    
    // 加载模板管理页面
    if (null == g_ViewsManager)
    {
        g_ViewsManager = new ViewsManager(viewManager);
    }
    
    var url = CommonUtil.getRootPath() + "/vmt/ct/templet/mainframe/templetinstance/templetinstance.html";

    g_ViewsManager.loadSpecialView("templeMgr", title, url);
}

/**
 * 切换功能树和模板树的对模板做的处理
 * @return 模板树控制器对象
 */
function pub_doTempletInstance(name)
{
	var templetInstanceTab = g_ViewsManager.getWindowById(name);
	templetInstanceTab.pub_setCurrentTabId("normal");
}

/**
 * 获取文件夹结点列表
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-11
 * @return
 */
function pub_getFolderIds()
{
    return g_foldersIds;
}

/**
 * 获取当前所选的文件夹结点ID
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-25
 * @return 当前所选的文件夹结点ID
 */
function pub_getCurSelFoderId()
{
    return g_curSelFolderId;
}

/**
 * 获取文件夹结点内容列表
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-25
 * @return 文件夹结点内容列表
 */
function pub_getFolderTextList()
{
    return g_folderTextList;
}