/**
 * 菜单的信息列表，key值为菜单的id，value为菜单对应的menuInfo对象
 */
var menuInfoMap = new Map();

/**
 * 定义菜单的结构体
 * @param id 菜单id
 * @param title 菜单标题
 * @param lrvr 菜单是基于lr或者vr
 * @param type 菜单类型，ping或者trace
 * @param parentid 菜单的父id
 * @param action 菜单对应的action操作
 * @return
 */
function MenuInfo(id,title,lrvr,type,parentid,action)
{
	this.id = id;
	this.title = title;
	this.lrvr = lrvr;
	this.type = type;
	this.parentid = parentid;
	this.action = action;
}

var menuBar = null;

/**
 * 向后台请求action信息
 * @param menuBarSystem 主菜单对象
 * @return
 */
function pub_getDynamicMenu(menuBarSystem)
{
	menuInfoMap.removeAll();
	menuBar = menuBarSystem;
	var pnpForm = pub_getClonePnpForm();
	var url = CommonUtil.getRootPath() + "/vmt/ct/featuremgr/pingtraceaction.do?methodID=handleGetDynamicMenuRequest" +
			  "&deviceIP=" + deviceIP+"&pnpDeviceType="+pnpForm.deviceType+"&pnpDeviceVersion="+pnpForm.deviceVersion+"&compatible="+pnpForm.compatible;
	var req = jse.RpcRequest.create(handleEncodingUrl(url));
	req.invoke(handleResult,["getDynamicMenuCallBack(request);"]);   
}

/**
 * 查询主菜单信息的回调方法 
 * @param request
 * @return
 */
function getDynamicMenuCallBack(request)
{
    var text = request.responseText; 
    var doc1 = jse.base.util.loadXML(text); 
    var menus = jse.selectNodes("//MENUS//MENU",doc1);
    if(null != menus)
    {
        var menuNum = menus.length;
        var key = null;
		var menuInfo = null;
		//将所有的菜单信息保存到菜单信息表中
        for(var j = 0;j < menuNum;j++ )
        {
            var menuNode = menus[j];
            key = menuNode.getAttribute("id");
            menuInfo= new MenuInfo(menuNode.getAttribute("id"),menuNode.getAttribute("title"),menuNode.getAttribute("lrvr"),
					         menuNode.getAttribute("type"),menuNode.getAttribute("parentid"),menuNode.getAttribute("action"));
            menuInfoMap.put(key,menuInfo);
		}
	}
    //生成菜单
    createDynamicMenu();
}

/**
 * 生成菜单 菜单栏对象为menuBar
 * @return
 */
function createDynamicMenu()
{
	var items = menuInfoMap.getItems();
	var dynamicMenuCount = items.length;
	//对每一个菜单进行处理
	for(var i = 0 ; i < dynamicMenuCount; i++)
	{
		if(null == items[i].id || "null" == items[i].id)
		{
			continue;
		}
		var res = menuBar._hasItem(items[i].id);
		if(!res)
		{
			var parent = null;
			var title = items[i].title;
			if("-" != title)
			{
				var paths = title.split(":");
				var file = paths[0]+ ":" + paths[1];
			    var resid = paths[2];
			    title = jse.getI18nValue(file,resid);
			}
			if(null != items[i].parentid && "null" != items[i].parentid)
			{
				parent = items[i].parentid;
			}
			if(null != items[i].action && "null" != items[i].action)
			{
			    title += "...";
				var itemStr = "menuBar.addItem(parent,items[i].id,{text:title,action:"+items[i].action+"})";
				eval(itemStr);
			}
			else
			{
				menuBar.addItem(parent,items[i].id,
				{
					text:title
				});		
			}
		}
	}
}

function onPingTrace(evt)
{
    var menuid = evt.id;
    var _url = CommonUtil.getRootPath() + "/vmt/ct/online/transfer/pingtrace/pingtrace.html?neName=" + g_NeFlag
              + "&vrId=" + g_VRID 
              + "&isSupportPartition=" + g_IsSupportPartition 
              + "&menuLrvr=" + menuInfoMap.get(evt.id).lrvr
              + "&menuTitle=" + menuInfoMap.get(evt.id).title
              + "&menuType=" + menuInfoMap.get(evt.id).type
              + "&xPath=" + evt.id
              + "&paremtxPath=null" 
              + "&deviceIP=" + deviceIP
              + "&deviceType=" + deviceType
              + "&deviceVersion=" + deviceVersion
              + "&ispopupmenu=false" + "&keyrefInfo=null"
              + "&isHidedlg=true";


    var paraMap = new Map();
    paraMap.put("neName", g_NeFlag);
    paraMap.put("vrId", g_VRID);
    paraMap.put("isSupportPartition", g_IsSupportPartition);
    paraMap.put("menuLrvr", menuInfoMap.get(evt.id).lrvr);
    paraMap.put("menuTitle", menuInfoMap.get(evt.id).title);
    paraMap.put("menuType", menuInfoMap.get(evt.id).type);
    paraMap.put("xPath", evt.id);
    paraMap.put("paremtxPath", "null");
    paraMap.put("deviceIP", deviceIP);
    paraMap.put("deviceType", deviceType);
    paraMap.put("deviceVersion", deviceVersion);
    paraMap.put("ispopupmenu", "false");
    paraMap.put("keyrefInfo", "null");
    paraMap.put("isHidedlg", "true");
    
	var dialogWidth = screen.width * 0.6;
    if("undefined" != typeof(this.outerWidth))
    {
        dialogWidth = tis.outerWidth * 0.75;
    }
	var dialogHeight = dialogWidth * 3 / 4;

	var dialogTitle = jse.getI18nValue("qat:public", "dialog_createconfig_d");
	var title = menuInfoMap.get(menuid).title;
	var paths = title.split(":");
	var file = paths[0]+ ":" + paths[1];
	var resid = paths[2];
	title = jse.getI18nValue(file,resid);
	dialogTitle = dialogTitle + title;
	var encodeUrl = handleEncodingUrl(_url);
    pub_showDlgByHide("pingtrace", dialogTitle, encodeUrl, paraMap, dialogWidth, dialogHeight, false, null);
	
}

function doPingTrace(xpath,deviceIP, deviceType, deviceVersion, lrvr, neFlag, vrId, isSupportPartition, title, type)
{
    var _url = CommonUtil.getRootPath() + "/vmt/ct/online/transfer/pingtrace/pingtrace.html?neName=" + neFlag
              + "&vrId=" + vrId 
              + "&isSupportPartition=" + isSupportPartition 
              + "&menuLrvr=" + lrvr
              + "&menuTitle=" + title
              + "&menuType=" + type
              + "&xPath=" + xpath
              + "&paremtxPath=null" 
              + "&deviceIP=" + deviceIP
              + "&deviceType=" + deviceType
              + "&deviceVersion=" + deviceVersion
              + "&ispopupmenu=false" + "&keyrefInfo=null"
              + "&isHidedlg=true";

    var paraMap = new Map();
    paraMap.put("neName", neFlag);
    paraMap.put("vrId", neFlag);
    paraMap.put("isSupportPartition", isSupportPartition);
    paraMap.put("menuLrvr", lrvr);
    paraMap.put("menuTitle", title);
    paraMap.put("menuType", type);
    paraMap.put("xPath", xpath);
    paraMap.put("paremtxPath", "null");
    paraMap.put("deviceIP", deviceIP);
    paraMap.put("deviceType", deviceType);
    paraMap.put("deviceVersion", deviceVersion);
    paraMap.put("ispopupmenu", "false");
    paraMap.put("keyrefInfo", "null");
    paraMap.put("isHidedlg", "true");
    
	var dialogWidth = screen.width * 0.6;
	var dialogHeight = dialogWidth * 3 / 4;
    var dialogTitle = jse.getI18nValue("qat:public", "dialog_createconfig_d");
    var title = FeaturesResourceMgr.getSchemaResource(xpath);
    dialogTitle = dialogTitle + title;
    var encodeUrl = handleEncodingUrl(_url);
    pub_showDlgByHide("pingtrace", dialogTitle, encodeUrl, paraMap, dialogWidth, dialogHeight, false, null);
}
