/**
 * 记录VR节点ID
 */
var g_VRID = null;

/**
 * VR名字
 */
var g_VRName = null;

/**
 * 设备ID
 */
var g_devId = null;

var g_VRID_ForTemplate = null;

var g_VRID_NeFlag_ForTemplate = null;

/**
 * VR划分
 */
var g_IsSupportPartition = null;

var vmtalert = null;

/**
 * 支持包需要用到的变量
 */
var windowTag = "window";

/**
 * 设备类型标识
 */
var g_NeFlag = null;

var subReDlg = null;

var subDlg = null;

var doc = null;

var updateFlag = false;

/**
 * 保存更新后从后台返回的文本对象
 */
var textInfo = null;

var devErrorDlg = null;

var g_pkginfo = null;

/**
 * 等待更新对话框对象
 */
var waitingDialog = null;

/**
 * 记录当前VR节点ID
 * 
 * @param currentVrId VR节点ID号
 */
function pub_setVRID(currentVRID, currentVRName, currentNeFlag)
{
    this.g_VRID = currentVRID;
    this.g_VRName = currentVRName;
    this.g_NeFlag = currentNeFlag;
    
    //初始化gloabal相关的vr信息
    var deviceForm = global.getDeviceForm();
    deviceForm.vrId = g_VRID;
    deviceForm.type = g_NeFlag;
}

/**
 * 记录当前DevID
 */
function pub_setDevId(currentDevId)
{
    this.g_devId = currentDevId;
    
    //初始化gloabal相关的devId信息
    var deviceForm = global.getDeviceForm();
    deviceForm.devId = g_devId;
}

/**
 * 设置LRVR划分
 * 
 * @param isSupportPartition LRVR划分
 */
function pub_setIsSupportPartition(isSupportPartition)
{
	if(true == isSupportPartition || "true" == isSupportPartition)
	{	
		this.g_IsSupportPartition = true;
	}
	else
	{
		this.g_IsSupportPartition = false;
	}
	
	global.getDeviceForm().isSupportPartition = g_IsSupportPartition;
}

function pub_setUpdateFlag()
{
    updateFlag = true;
}

/**
 * 获得当前VR节点ID
 */
function pub_getVRID()
{
    return g_VRID;
}

/**
 * 获得当前VR节点ID
 */
function pub_getVRName()
{
    return g_VRName;
}

/**
 * 获取设备标识
 */
function pub_getNeFlag()
{
    return g_NeFlag;
}

function setDeviceInfoForTemplate(lrvr)
{
    if ("LR" == lrvr)
    {
        g_VRID_ForTemplate = g_VRID_NeFlag_ForTemplate;
        g_NeFlag_ForTemplate = "LR";
    }
    else
    {
    	if("LR" == g_NeFlag)
    	{
    		g_VRID_ForTemplate = 0;
    	}
    	else
    	{
            g_VRID_ForTemplate = g_VRID;
    	}
        g_NeFlag_ForTemplate = "VR";
    }
}

/**
 * 集成版本接口：判断各预加载页面是否完成
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-30
 * @return true:完成；false:未完成
 */
function pub_isPreLoadFinished()
{
    var isDeviceFinished = false;
    var isFuncTreeFinished = false;
    var isPanelFinished = false;
    
    var windowManager = window.xui.getWidget("ViewManager"); 
    
    var deviceWin = windowManager.getWindowById(Constants.DEVICE_VIEWID);
    if ((null != deviceWin) && ('function' == typeof deviceWin.pub_loadDynamicContent)) 
    {
        isDeviceFinished = true;  
    }
        
    var funcWin = windowManager.getWindowById(Constants.FUNCTION_VIEWID);
    if ((null != funcWin) && ('function' == typeof funcWin.pub_loadDynamicContent))   
    {
        isFuncTreeFinished = true;  
    }
    
    var panelWin = windowManager.getWindowById(Constants.PANEL_VIEWID);
    if ((null != panelWin) && ('function' == typeof panelWin.pub_loadDynamicContent) && ('function' == typeof panelWin.pub_isPreLoadFinished))   
    {
        isPanelFinished = panelWin.pub_isPreLoadFinished();   
    }
    
    return (isDeviceFinished && isFuncTreeFinished && isPanelFinished)
}


/**
 * 集成版本接口：提供给集成版本的预加载处理的接口，用于更新与设备相关的信息。
 */
function pub_updateDynamicInfo(deviceType, deviceVersion, deviceIP, identifier, resID, prochandle, devName, tzOffset,
        zonePattern, tzId, lrRole)
{
    logger.log("enter pub_updateDynamicInfo");
    
    // 设置参数
    this.deviceIp_URLParam = deviceIP;
    this.deviceIP = deviceIP;
    if(null != deviceType)
    {
        deviceType = deviceType.replaceAll("[\\W]+", ""); 
    }
    this.deviceType = deviceType;
    this.deviceVersion = deviceVersion;
    this.devName = decodeURIComponent(devName);
    this.resID = encodeURI(resID);
    this.prochandle = prochandle;
    this.indentifier = identifier;
    this.g_lrRole = lrRole;

    // 初始化vrid信息为设备ip，类型为LR，有些页面会用到，可能未初始化
    this.g_VRID = deviceIP;
    this.g_NeFlag = "LR";
    
    intiLocalTime(tzOffset, zonePattern, tzId);
    
    this.pnpForm.deviceType = deviceType;
    this.pnpForm.deviceVersion = deviceVersion; 
//    requestForChassisInfo();
//    requestForEntityData();

    // 登陆设备
    var url = CommonUtil.getRootPath() + "/vmt/ct/device/DeviceMgrAction.do?methodID=handleLoginDeviceReq" + "&independence=false"
            + "&preLoadFlag=" + preLoadFlag + "&devIP=" + deviceIP + "&checkDevice=true" + "&identifier=" + identifier
            + "&primaryIP" + deviceIP + "&resID=" + encodeURI(resID) + "&prochandle=" + prochandle + "&devType=" + deviceType
            + "&devVersion=" + deviceVersion;
    var req = jse.RpcRequest.create(url);
    
    logger.log("begin pub_updateDynamicInfo handleLoginDeviceReq");
    req.invoke(handleResult, [ "callback_login_();" ]);
}

/**
 * 登陆设备回调处理函数
 */
function callback_login_()
{
    logger.log("enter callback_login_");
    reInitJsonRpcObj();
    
    if (Constants.OPER_OK == resultType)
    {
        var pnpInfoNode = jse.selectSingleNode("/response/data/pnpInfo", doc);
        var isSupportPartitionNode = jse.selectSingleNode("/response/data/isSupportPartition", doc);
        var isSupportPartition = isSupportPartitionNode.getAttribute("value");
        g_IsSupportPartition = ("true" == isSupportPartition ? true : false);

        var isExist = pnpInfoNode.getAttribute("isExist");
        if ("true" == isExist)
        {
            // 处理支持包信息
            var pnpForm = new PnpForm();
            pnpForm.deviceType = pnpInfoNode.getAttribute("deviceType");
            pnpForm.deviceVersion = pnpInfoNode.getAttribute("deviceVersion");
            pnpForm.compatibleReasonId = pnpInfoNode.getAttribute("compatibleReasonId");
            var compatible = pnpInfoNode.getAttribute("compatible");
            pnpForm.compatible = ("true" == compatible ? true : false);

            // 调用支持包下载后的统一处理方法
            procAfterLoadPnpFrom(pnpForm);
        }
        else
        {
            displayWaitingDlg();
        }
        // 向服务器发送心跳请求
        setInterval("heartBeat()", 120000);
    }
    else
    {
        var errorCodeNode = jse.selectSingleNode("/response/errorMessages/errorMessage", doc);
        var errorCode = errorCodeNode.getAttribute("errorCode");
        var errorMsg = jse.getI18nValue("qat:errorcode", errorCode);
        VMTAlert(errorMsg, "win.alertClose();", 150, 450);
    }
}

/**
 * 提示对话框的回掉函数
 */
function alertClose()
{
}

/**
 * 获取设备支持包
 * 
 */
function pub_getDevSupportPkg()
{
    logger.log("enter pub_getDevSupportPkg()");
    jsonrpc.asynInvoke("pnpService", "existPnpPackage", [ deviceType, deviceVersion, deviceIP ], doExistDevPkgCallBack,
            this, []);
}

/**
 * 处理是否存在设备支持包后台返回结果
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function doExistDevPkgCallBack(operResult)
{
    logger.log("enter doExistDevPkgCallBack()");
    if ("OPER_OK" != operResult.resultType)
    {
        // 弹出错误对话框
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return;
    }

    var pnpModel = operResult.returnObj;
    var isExist = pnpModel.exist;
    if (isExist)
    {
        // 调用支持包下载后的统一处理方法
        procAfterLoadPnpFrom(pnpModel.pnpForm);
    }
    else
    {
        displayWaitingDlg();
    }
}

/**
 * 显示等待对话框
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function displayWaitingDlg()
{
    var waitingDialogTip = jse.getI18nValue("qat:public:", "dialog.update_d");
    var message = jse.getI18nValue("qat:public", "label.wait_d");
    
    var length = 400;
    if(jse.topWin.lang == "en_US")
    {
        length = 650;
    }
    
    waitingDialog = CommonDlgReq.openWaitDialogWithPos(length, 200, waitingDialogTip, message, "waiting_bar", null, null);
    waitingDialog.show();

    jsonrpc.asynInvokeWaiting("pnpService", "loadPnpPackage", [ deviceType, deviceVersion, deviceIP ],
            getDevPkgCallBack, this, []);
}

/**
 * 获取设备支持包回调函数
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function getDevPkgCallBack(operResult)
{
    // 关闭等待对话框
    waitingDialog.dispose();
    waitingDialog = null;

    // 如果获取失败，则直接弹出错误信息,点击确定后关闭当前网元管理器
    if (operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, exitWindow, this);
        return;
    }

    var pnpForm = operResult.returnObj.pnpForm;
    if (pnpForm.compatible)
    {
        // 如果是兼容的支持包，则需要提示用户是否继续操作
        var compatibleReasonID = pnpForm.compatibleReasonId;
        var currentNEinfoText = jse.getI18nValue("qat:public", "label.currentneinfo_d");
        var loadFailedReasonText = CommonDlgReq.getResponseErrorReason(operResult);//jse.getI18nValue("qat:errorcode", pnpForm.compatibleReasonId);
        var compatibleText = jse.getI18nValue("qat:public", "lable.pnpcompatibleprompt_d");

        // 动态替换版本信息
        compatibleText = compatibleText.replace("%1", pnpForm.deviceVersion);
        currentNEinfoText = currentNEinfoText + deviceType + "-" + deviceVersion
        var showText = loadFailedReasonText + Constants.HTML_NEWLINE_TAG + currentNEinfoText
                + Constants.HTML_NEWLINE_TAG + compatibleText;

        CommonDlgReq.openYesNoDialog(showText, procAfterLoadPnpFrom, this, [ pnpForm ], exitWindow, this, []);
    }
    else
    {
        // 处理设备支持包
        procAfterLoadPnpFrom(pnpForm);
    }

}

/**
 * 关闭当前网元管理窗口(不做提示，直接关闭窗口)
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-11-17
 * @return
 */
function exitWindow()
{
    window.onbeforeunload = null;
    window.close();
}

/**
 * 下载完设备支持包后的统一处理方法
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function procAfterLoadPnpFrom(pnpForm)
{
    logger.log("enter procAfterLoadPnpFrom()");
    // 设置支持包信息
    pub_setPnpForm(pnpForm.deviceType, pnpForm.deviceVersion, pnpForm.compatible);

    setTimeout("getFuncnodeExtInfo()", 1000);
    requestForChassisInfo(); 
    requestForEntityData(); 

    //获取设备选项信息
    getDeviceOption(); 
    // 显示设备树
    pub_displayDeviceTree();

    // 动态菜单的加载与支持包有依赖，必须放在支持包下载后处理,仅独立场景处理即可
    if ("true" == independence)
    {
        setTimeout("pub_getDynamicMenu(menuBarSystem)", 1000);
    }

}

/**
 * 获取错误对话框中的Label值
 * 
 * @return
 */
function getSupPkgLabelText()
{
    var rootNodeText = jse.getI18nValue("qat:public", "label.update_error_d");
    return rootNodeText;
}

/**
 * 错误对话框的“关闭”按钮事件处理
 * 
 * @return
 */
function pub_errorDlgClose()
{
    // 显示设备导航树
    pub_displayDeviceTree();
}
/**
 * 设置错误对话框大小
 * 
 * @param width 对话框宽度
 * @param height 对话框高度
 */
function setPreferSize(width, height)
{
    devErrorDlg.setPreferSize(width, height);
}

/**
 * 
 * 设备支持包界面关闭事件
 * 
 * @param evt
 * @return
 */
function doCloseDlg(evt)
{
    // 弹出提示界面
    var subDlgContent = subDlg.getContentWin();
    subDlgContent.pub_showNoUpdatingDialog();
    return false;
}

/**
 * 获取windowTag的值
 * 
 * @return
 */
function pub_getWindowTag()
{
    return windowTag;
}

/**
 * 
 * 弹出更新成功的对话框
 */
function pub_showUpdateSuccessDialog()
{
    var message = jse.getI18nValue("qat:public", "label.updatesuccess_d");
    VMTAlert(message, "win.pub_showDevcieTree();", 200, 150);
}

/**
 * 
 * pub_showUpdateSuccessDialog弹出的提示对话框的中的确定按钮的处理事件
 * 
 * @return
 */
function pub_showDevcieTree()
{
    // 显示设备导航树
    pub_displayDeviceTree();
}

/**
 * 处理设备和设备功能树之间的交互
 */
function pub_displayCapability()
{
    logger.log("start pub_displayCapability");

    var title = Resource.getTreeInfoResource("devicepanel_d");
    requestForChassisInfo();
    requestForEntityData();

    if("LR" == g_NeFlag && (!pub_getDeviceWin().pub_isSelectBoardNode()))
    {
        pub_addDevicePanelView("", deviceType, deviceVersion, "", title);
    }

    // 需要设备树传名称
    processVRChange(this.g_VRID, this.g_VRName, g_IsSupportPartition);

    logger.log("end pub_displayCapability");
}