/**
 * 三段式第三段tab页的id，以@分隔
 */
var tabIds = "";

/**
 * 右面特性页Tab变化必须通过调用本文件的方法进行加载
 * 
 */

// 记录最近一个操作的特性Tab信息，删除缓存用
var Current_FeatureID_Info = null;

/**
 * 当前选中的功能树节点的ID
 */
var curFeatureNodeID = null;

/**
 * 功能树的某个节点是否是特性节点
 */
var isCurFeatureNode = false;
/**
 * 是否是设备面板界面
 */
var isDevicePanel = false;

/**
 * 是否是定制URL界面
 */
var isCustomURL = false;

var customURL = null;

/**
 * 视图管理对象
 */
var g_ViewsManager = null;
var resource = new FeaturesResourceMgr();
/**
 * 特性Tab页view控制类
 */
//var g_featureTabViewCtrl ;

/**
 * 显示设备导航树，处理设备切换后的事宜
 */
function pub_displayDeviceTree()
{
    logger.log("enter pub_displayDeviceTree");
    var windowManager = window.xui.getWidget("ViewManager"); 
    if(!preLoadFlag)
    {
        windowManager.setViewURL(Constants.DEVICE_VIEWID, Constants.URL_DEVICEHTML);
       
        isDevicePanel = false;
    }
    else
    {
	    //请求面板机框信息和实体数据
    //	requestForChassisInfo();
//	    requestForEntityData();
	    
        var deviceWin = windowManager.getWindowById(Constants.DEVICE_VIEWID);
        deviceWin.pub_loadDynamicContent();
        
        logger.log("end deviceWin.pub_loadDynamicContent()");
        
        var funcWin = windowManager.getWindowById(Constants.FUNCTION_VIEWID);
        funcWin.pub_loadDynamicContent(devName, deviceIP, "LR", g_IsSupportPartition, isWorkspace);
        
        logger.log("end funcWin.pub_loadDynamicContent");
        
        //更新节点状态信息
        procVRStatusForPreload(deviceIP, devName);
        
        logger.log("end procVRStatusForPreload");
        
        var panelWin = windowManager.getWindowById(Constants.PANEL_VIEWID);
        panelWin.pub_loadDynamicContent(devName, deviceIP, deviceType, deviceVersion, indentifier);
    }

}

var global = new GlobalData();

/**
 * 操作记录信息
 * 
 * @param deviceIP 操作设备的唯一标识，目前只有一个设备，暂时不用，后面用的话再放开。
 * @param vrid 操作的VRID信息
 * @param vrName 操作的VR节点名称（即文本text）---这个是否需要？？要确认一下
 * @param operViewID 操作的视图ID（模板("stencil")/功能(工作区固定为"capability"，主窗体为"capability"+VRID)）
 * @param featureNodeID 特性节点ID（对应树节点信息）//nodeid
 * @param featureNodeText 特性名称（对应树节点ID）//nodeid
 */
function operRecord(vrid, vrName, operViewID, featureNodeID, featureNodeText)
{
    this.vrid = vrid;
    this.vrName = vrName;
    this.operViewID = operViewID;
    this.featureNodeID = featureNodeID;
    this.featureNodeText = featureNodeText;
}

/**
 * 处理设备功能树和配置区之间的交互
 * 
 * @param neType 特性所属域 LR VR
 * @param capabilityTreeNodeID 功能树节点ID
 * @param parentNodeTexts 特性节点的所属特性的父的节点名，直至根
 * @param capabilityTreeNodeText 功能树节点内容
 * @param nodeVersion 节点版本
 * @param isFeatureNode 是否特性节点
 * @param queryType 查询类型
 * @param condition 查询条件
 * @param groupMOtypeXpath 属性组xpath
 * @param appearOnce
 * @param deviceVersion 网元版本
 * @param deviceType 网元类型
 */
function pub_addFeatureViewWithCondition(neType, capabilityTreeNodeID, parentNodeTexts,
        capabilityTreeNodeText, nodeVersion, isFeatureNode, queryType,
        condition, groupMOtypeXpath, appearOnce, deviceVersion, deviceType)
{

    // logger.log("enter pub_addFeatureViewWithCondition");

    if (null == g_ViewsManager)
    {
        g_ViewsManager = new ViewsManager(viewManager);
    }

    curFeatureNodeID = capabilityTreeNodeID;
    isCurFeatureNode = isFeatureNode;
    var capabilityViewID = isWorkspace? Constants.FUNCTION_VIEWID : Constants.FUNCTION_VIEWID + g_VRID;
    
    var title = null;
    if (null == capabilityTreeNodeID)
    {
        title = jse.getI18nValue(Constants.LOCALRESFILE_PATH,
                Constants.KEY_FOR_FEATURETITLE);
    }
    else
    {
        var nodeIDSplits = capabilityTreeNodeID.split("]");
        var nodeLength = nodeIDSplits.length;
        var xpath = nodeIDSplits[nodeLength - 1];
        title = ""; 
        if(null != parentNodeTexts)
        {
            for(var i = parentNodeTexts.length-1; i>=0; i--)
            {
                title = title + parentNodeTexts[i] + "-";
            }
        }
        title = title + Resource.getTreeInfoResource(xpath + "_d");
    }
    // logger.log("enter procFeatureTabChange");
    
    if(null != toTabId && "" != toTabId)
    {
        g_featureTabViewCtrl.setToTabId(toTabId);
        toTabId = null;
    }    
    
    var url = null;
    if (!isFeatureNode)
    {// 非特性节点加载空页面
        url = GlobalConstants.EMPTY_PAGE;

        g_featureTabViewCtrl.setCurrentTabId(Constants.CUSTOMURL_VIEWID);
        
        g_ViewsManager.loadSpecialView(Constants.CUSTOMURL_VIEWID, title, url);

        clearTabPages();
        
        var customFuncNodeTabs = g_featureTabViewCtrl.getFuncnodeTabList();
        if(null == customFuncNodeTabs)
        {
            var beforeViewId = g_featureTabViewCtrl.getBeforeViewId();
            // 隐藏
            viewManager.hideView(Constants.PANEL_VIEWID);
            viewManager.hideView(Constants.FEATURE_VIEWID);
            if(beforeViewId != Constants.FEATURE_VIEWID && beforeViewId != Constants.PANEL_VIEWID
                    && beforeViewId != Constants.CUSTOMURL_VIEWID)
            {
                viewManager.hideView(beforeViewId);
                viewManager.closeView(beforeViewId);
            }  
            
           var lastfirstviewId =  g_featureTabViewCtrl.getLastFirstViewId();
           if(lastfirstviewId != Constants.FEATURE_VIEWID && lastfirstviewId != Constants.PANEL_VIEWID
                   && lastfirstviewId != Constants.CUSTOMURL_VIEWID)
           {
               viewManager.hideView(lastfirstviewId);
               viewManager.closeView(lastfirstviewId);
           }    
           
        }   

        g_featureTabViewCtrl.removeAllTabs();
        g_featureTabViewCtrl.setLastFirstViewId(Constants.CUSTOMURL_VIEWID);
             
    }
    else
    {
        var vrId = g_VRID;
        //url = CommonUtil.getRootPath() + "/vmt/ct/online/view/feature.html";
        url = Constants.URL_MULTIFEATURE_HTML;
        // 获取Tab页定制信息
        var customTabInfo = pub_functionExtInfo(capabilityTreeNodeID);
        if(customTabInfo == null)
        {
	        var nodeIDSplits = capabilityTreeNodeID.split("]");
	        var nodeLength = nodeIDSplits.length;
	        var featureName = nodeIDSplits[nodeLength - 2];
	
	        var xpath = nodeIDSplits[nodeLength - 1];
	        var featureForm = global.getFeatureForm();
	        featureForm.featureName = featureName;
	        featureForm.xpath = xpath;
	        featureForm.isWorkspace = isWorkspace;
	        featureForm.domain = neType;
	        featureForm.condition = condition;
	        featureForm.parentXpath = groupMOtypeXpath;
	        featureForm.isAppearOnce = appearOnce;
            featureForm.featureNodeType = "OBJECT";
            featureForm.funcnodeName = capabilityTreeNodeID;
            featureForm.tabId = Constants.FEATURE_VIEWID;
            featureForm.chassis = pub_getDeviceWin().pub_getChassis();
            featureForm.slot = pub_getDeviceWin().pub_getSlot();
            featureForm.card = null; 
	        
	        var deviceForm = global.getDeviceForm();
	        deviceForm.deviceType = deviceType;
	        deviceForm.deviceVersion = deviceVersion;
	        deviceForm.deviceIp = deviceIP;
	        deviceForm.isSupportPartition = jse.topWin.g_IsSupportPartition;
	        deviceForm.pnpForm = pub_getClonePnpForm();
	        deviceForm.lrRole = g_lrRole;
	        deviceForm.viewType = "vmf";
	        
	        global.setDeviceForm(deviceForm);
	            g_featureTabViewCtrl.setCurrentTabId(Constants.FEATURE_VIEWID);
//	        loadThirdView(title, url);
            title = Resource.getXpathResource(featureName, xpath + "_d");
	        loadThirdView(title, url);   
	
		    // 特性有常规tab页，需要显示
		            //viewManager.showView(Constants.NORMAL_VIEWID);
		
		    isDevicePanel = false;
		            isCustomURL = false;
		    // 将上次打开的第三段TAB页关闭
		    clearTabPages();
		            g_featureTabViewCtrl.removeAllTabs();
		            g_featureTabViewCtrl.setLastFirstViewId(Constants.FEATURE_VIEWID);
		    if (isFeatureNode)
		    {
		        // 更新为当前操作的特性信息
		        Current_FeatureID_Info = new operRecord(g_VRID, g_VRName,
		                capabilityViewID, capabilityTreeNodeID, capabilityTreeNodeText);
	        }
        }
        else
        {
            var featureForm = global.getFeatureForm();
            featureForm.isWorkspace = isWorkspace;
            featureForm.domain = neType;
            featureForm.featureNodeType = "OBJECT";
            featureForm.funcnodeName = capabilityTreeNodeID;
            featureForm.chassis = pub_getDeviceWin().pub_getChassis();
            featureForm.slot = pub_getDeviceWin().pub_getSlot();
            featureForm.card = null;
            var deviceForm = global.getDeviceForm();
            deviceForm.deviceType = deviceType;
            deviceForm.deviceVersion = deviceVersion;
            deviceForm.deviceIp = deviceIP;
            deviceForm.isSupportPartition = jse.topWin.g_IsSupportPartition;
            deviceForm.pnpForm = pub_getClonePnpForm();
            deviceForm.lrRole = g_lrRole;
            deviceForm.viewType = "vmf";
            global.setDeviceForm(deviceForm);
            // 移除原有的Tab页
            g_featureTabViewCtrl.removeAllTabs();
            g_featureTabViewCtrl.setFuncnodeExtInfo(customTabInfo);
            var funcnodeTabList = customTabInfo.funcnodeTabList.list ;
            if(null == funcnodeTabList || funcnodeTabList.length == 0)
            {
                var xpath = nodeIDSplits[nodeLength - 1];
                var nodeIDSplits = capabilityTreeNodeID.split("]");
                var nodeLength = nodeIDSplits.length;
                var featureName = nodeIDSplits[nodeLength - 2];
                featureForm.featureName = featureName;
                featureForm.xpath = xpath;
                featureForm.condition = condition;
                featureForm.parentXpath = groupMOtypeXpath;
                featureForm.isAppearOnce = appearOnce;
                var tabId = "vmt]" + xpath;
                featureForm.tabId = "vmt]" + xpath;
                g_featureTabViewCtrl.setCurrentTabId(tabId);
                g_featureTabViewCtrl.setFirstViewId(tabId);
                g_featureTabViewCtrl.addTabType(tabId,"OBJECT");
                //var title = FeaturesResourceMgr.getSchemaResource(xpath);
                var title = Resource.getTabInfoResource(xpath);
                 //var url = CommonUtil.getRootPath() + "/vmt/ct/online/view/feature.html";
                url = Constants.URL_MULTIFEATURE_HTML;
                var beforeViewId = g_featureTabViewCtrl.getBeforeViewId();
                g_featureTabViewCtrl.insertAfterView(beforeViewId,tabId,title,url);
                g_ViewsManager.hideCurrentView(tabId);
                g_featureTabViewCtrl.setLastFirstViewId(tabId);
                // 隐藏Feature的Tab页
                viewManager.hideView(Constants.FEATURE_VIEWID);
                // 隐藏面板Tab页
                viewManager.hideView(Constants.PANEL_VIEWID);
                // 隐藏
                viewManager.hideView(Constants.CUSTOMURL_VIEWID);
                if(beforeViewId != Constants.FEATURE_VIEWID && beforeViewId != Constants.PANEL_VIEWID
                        && beforeViewId != Constants.CUSTOMURL_VIEWID)
                {
                    viewManager.hideView(beforeViewId);
                    viewManager.closeView(beforeViewId);
                }   
//              g_featureTabViewCtrl.addView(tabId, title, url);                                             
            }
            else if(funcnodeTabList.length > 0)
            {
                 //var url = CommonUtil.getRootPath() + "/vmt/ct/online/view/feature.html";
                url = Constants.URL_MULTIFEATURE_HTML;
                g_featureTabViewCtrl.initTabUrls(url);
                // 添加Tab页信息
                g_featureTabViewCtrl.setLastFirstViewId(g_featureTabViewCtrl.getBeforeViewId());
                g_featureTabViewCtrl.initTabData();  
                g_ViewsManager.hideCurrentView(g_featureTabViewCtrl.getLastFirstViewId());
            }            
        }        
        
        g_featureTabViewCtrl.removeTab(customURL);
        customURL = null;
    }

    // logger.log("exit pub_addFeatureViewWithCondition");
}

/**
 * 在页面切换时，将常规TAB页设置为空白页，将高级和孩子TAB页关闭
 */
function clearTabPages()
{
    // 点击功能树的节点时，将刚才的常规属性页设置为空白
    if (!viewManager.isHide(Constants.NORMAL_VIEWID))
    {
        var normalTitle = jse.getI18nValue("qat:public", "viewtitle.normal_d");
        viewManager.setViewTitle(Constants.NORMAL_VIEWID, normalTitle);
        viewManager.setViewURL(Constants.NORMAL_VIEWID, GlobalConstants.EMPTY_PAGE);
        viewManager.activateView(Constants.NORMAL_VIEWID);
    }
    if (tabIds != "")
    {
        var tabId = tabIds.split("@");
        for ( var i = 0; i < tabId.length; i++)
        {
            viewManager.closeView(tabId[i]);
        }
        tabIds = "";
    }
    if (isDevicePanel)
    {
        viewManager.hideView(Constants.NORMAL_VIEWID);
    }
}
/**
 * 当无任何选中节点时，加载空白Feature页面方法，切换VR时会主动调用
 * 
 */
function loadBlankFeatureView(ViewID)
{
    // //通知前进后退，特性Tab页变化
    // procFeatureTabChange(null, null, null, false);

    // 更新当前特性页是否为空白页标识
    Flag_CurrentFeatureView_IsBlankTab = true;

    var FeatureViewTitle = null;
    if (Constants.PROFILE_VIEWID == ViewID)
    {
        FeatureViewTitle = jse.getI18nValue(Constants.LOCALRESFILE_PATH,
                Constants.KEY_FOR_TEMPLETTITLE);
    }
    else
    {
        FeatureViewTitle = jse.getI18nValue(Constants.LOCALRESFILE_PATH,
                Constants.KEY_FOR_FEATURETITLE);
    }

    var reg = new RegExp("\\d+\.\\d+\.\\d+$");
    if (reg.test(CurrentVR_ID))
    {
        return;
    }
    loadFeatureView(FeatureViewTitle, "");
}

function loadFeatureView(TitleName, url)
{
    viewManager.setViewTitle(Constants.FEATURE_VIEWID, TitleName);
    viewManager.setViewURL(Constants.FEATURE_VIEWID, url);
    viewManager.activateView(Constants.FEATURE_VIEWID);
}

function loadThirdView(titleName, url)
{
    g_ViewsManager.loadSpecialView(Constants.FEATURE_VIEWID, titleName, url);
// g_ViewsManager.this._currentViewName = Constants.FEATURE_VIEWID;
}


/**
 * 添加设备面板界面
 */
function pub_addDevicePanelView(capabilityTreeNodeID, deviceType,
        deviceVersion, urlPath, title)
{
     logger.log("start mgrcapability pub_addDevicePanelView");
     
    if (null == g_ViewsManager)
    {
        g_ViewsManager = new ViewsManager(viewManager);
    }

    var prochandle = jse.topWin.prochandle;
    var devName = jse.topWin.devName;
    
    // 面板url
    urlPath = CommonUtil.getRootPath() + "/panel/index/index.html";
    
    var url = "";

    if(preLoadFlag)
    {
        url = urlPath + "?isDenpence=" 
        + independence + "&&resID=" + resID + "&&indentifier="
        + indentifier + "&&prochandle=" + prochandle + "&&language="
        + language + "&&preLoadFlag=" + preLoadFlag + "&&moduleName=" + moduleName;
    }
    else
    {
        url = urlPath + "?deviceIP=" + deviceIP + "&&deviceType=" + deviceType
        + "&&deviceVersion=" + deviceVersion + "&&lrRole=" + g_lrRole + "&&domain=" + g_NeFlag
        + "&&isDenpence=" + independence + "&&resID=" + resID + "&&indentifier="
        + indentifier + "&&prochandle=" + prochandle + "&&language="
        + language + "&deviceName=" + devName+ "&&moduleName=" + moduleName;
    }
    
    
    // 处理前进后退，特性Tab页变化，增加一个新操作；工作区的功能viewID为"capability"，跟这个不一样
    // procFeatureTabChange(capabilityTreeNodeID, title,
    // Constants.FUNCTION_VIEWID
    // + g_VRID, true);

     logger.log("start mgrcapability loadpanelView");

    // loadFeatureView(title, url);
    g_ViewsManager.loadSpecialView(Constants.PANEL_VIEWID, title, url);
    g_featureTabViewCtrl.removeAllTabs();
    g_featureTabViewCtrl.removeTab(customURL);
    logger.log("end mgrcapability loadpanelView");

    isDevicePanel = true;
    isCustomURL = false;
    customURL = null;
    clearTabPages();

    logger.log("end mgrcapability pub_addDevicePanelView");
}
/**
 * 添加定制URL页面
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-5-15
 * @param capabilityTreeNodeID 树节点id
 * @param deviceType 设备类型
 * @param deviceVersion 设备版本 
 * @return {}
 */
function pub_addCustomUrlView(capabilityTreeNodeID, deviceType,
        deviceVersion, urlPath, title)
{
    if (null == g_ViewsManager)
    {
        g_ViewsManager = new ViewsManager(viewManager);
    }
    var prochandle = jse.topWin.prochandle;
    var devName = jse.topWin.devName;
    
    var deviceForm = global.getDeviceForm();
    deviceForm.deviceType = deviceType;
    deviceForm.deviceVersion = deviceVersion;
    deviceForm.deviceIp = deviceIP;
    deviceForm.isSupportPartition = jse.topWin.g_IsSupportPartition;
    deviceForm.pnpForm = pub_getClonePnpForm();
    deviceForm.lrRole = g_lrRole;
    deviceForm.viewType = "vmf";
    global.setDeviceForm(deviceForm);
    
    //定制URL
    var url = urlPath;
    logger.log("start mgrcapability load customUrl");
    g_featureTabViewCtrl.removeAllTabs();
    var tabId = url;
    g_featureTabViewCtrl.setCurrentTabId(tabId);
    g_featureTabViewCtrl.setFirstViewId(tabId);
    var beforeViewId = g_featureTabViewCtrl.getCustomUrlBeforeViewId(url);
    g_featureTabViewCtrl.insertAfterView(beforeViewId,tabId,title,url);
    g_ViewsManager.hideCurrentView(tabId);
    g_featureTabViewCtrl.setLastFirstViewId(tabId);
    // 隐藏Feature的Tab页
    viewManager.hideView(Constants.FEATURE_VIEWID);
    // 隐藏面板Tab页
    viewManager.hideView(Constants.PANEL_VIEWID);
    // 隐藏
    viewManager.hideView(Constants.CUSTOMURL_VIEWID);
    if(beforeViewId != Constants.FEATURE_VIEWID && beforeViewId != Constants.PANEL_VIEWID
            && beforeViewId != Constants.CUSTOMURL_VIEWID && beforeViewId != tabId)
    {
        viewManager.hideView(beforeViewId);
        viewManager.closeView(beforeViewId);
    }
    if (beforeViewId == tabId)
    {
    	viewManager.setViewTitle(tabId, title);
        viewManager.setViewURL(tabId, url);
    }
    
    logger.log("end mgrcapability load customUrl");
    isCustomURL = true;
    customURL = url;
    
    clearTabPages();
    logger.log("end mgrcapability pub_addCustomUrlView");
}
// GlobalData为单例
function pub_getPubData()
{
	//返回的cloneGlobal可能有问题,如果此函数中更新了global,则可能有问题
    var cloneGlobal = global.clone();

    var currentFeatureId = g_featureTabViewCtrl.getCurrentTabId();
    var funcnodeTabList = g_featureTabViewCtrl.getFuncnodeTabList();
    if((currentFeatureId == Constants.FEATURE_VIEWID) || (currentFeatureId == null) || ( funcnodeTabList == null) || (funcnodeTabList.length == 0))
    {
        return cloneGlobal;
    }
    // 获取Tab页定制信息
    var customTabInfo = g_featureTabViewCtrl.getTabInfo(currentFeatureId);
    var currentTabType = g_featureTabViewCtrl.getCurrentTabType(currentFeatureId);
    var xpaths = customTabInfo.xpath.split("/");    
    var featureName = xpaths[1];
    var featureForm = global.getFeatureForm();
    featureForm.featureName = featureName;
    featureForm.featureNodeType = currentTabType;
    featureForm.tabId = currentFeatureId;
    featureForm.chassis = pub_getDeviceWin().pub_getChassis();
    featureForm.slot = pub_getDeviceWin().pub_getSlot();
    featureForm.card = null;
    if(currentTabType == "ATTRIBUTEGROUP")
    {
        featureForm.xpath = customTabInfo.moXpath;
        featureForm.groupXpath = customTabInfo.xpath;
        featureForm.isAppearOnce = true;
    }
    else  if(currentTabType == "OBJECT") 
    {
        featureForm.xpath = customTabInfo.xpath;
        featureForm.groupXpath = null;
        featureForm.isAppearOnce = false;
    }
    return cloneGlobal;
}

/**
 * 加载模板管理视图
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-9
 * @param title 标题
 * @return
 */
function pub_loadTempletMgrView(title)
{
    if (null == g_ViewsManager)
    {
        g_ViewsManager = new ViewsManager(viewManager);
    }
    
    var url ="";
    title = jse.getI18nValue("qat:public", "viewtitle.templetManager_d");
    
    g_ViewsManager.loadSpecialView(Constants.TEMPLET_TEMPLETMGRVIEW, title, url);
}

/**
 * 对外接口：供视图设置是否已经加载完毕
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R3,2010-4-1
 * @param viewName ViewID
 * @return
 */
function pub_setSpecialViewIsLoad(viewName)
{
    g_ViewsManager.setSpecialViewIsLoad(viewName)
}

/**
 * 添加模板视图
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-7
 * @return
 */
function pub_addTempletView()
{
    
}
function pub_getFeatureTabViewCtrl()
{
    return g_featureTabViewCtrl;
}
