
/**
 * 标题页面视图
 */
var TopPageView = null;
/**
 * 主页面视图
 */
var MainPageView = null;

/**
 * 返回报文解析成DOM对象
 */
var doc = null;
/**
 * 是否已经登录设备标识
 */
var isLoginDev = false;
/**
 * 语言标识符
 */
var flag = true;
/**
 * 子对话框对象
 */
var subDlg = null;
/**
 * 错误对话框的对象
 */
var errorDlg = null;
/**
 * 获取常量对象
 */
var Constants = new Constants();

var waitDialog = null;

var pageType = "online";

var autoFlag = false;

var req = null;
/**
 * 定位到的node，tab
 */
 var toTabId = "";
 var toNodeId = "";

/**
 * 重写onbeforeunload事件
 */
window.onbeforeunload = logoutSystemWarning;

/**
 * 重写onunload事件
 */
window.onunload = logoutSystem;
/**
 * 是否显示警告对话框
 */
var isShowWarning = true;

/**
 * 在线页面警告中英文资源
 */
var onlinewarning = null;

var wsWin = null;
/**
 * 告警板
 */
var alarmPanel = null;
/**
 * 故障管理菜单
 */
var faultMenuBar = null;
var hasItems = false;

/**
 * 使用栈方式，保存dialogId
 *
 */
var g_dialogIds = [];
/**
 * 映射表,在device.xui界面文件中定义的事件都在此映射表中做 映射 并在此文件中处理
 */
var signalMap =
{
    onAlarm: doAlarm,
    on_load_ui :doLoad,
    onviewchanged:onviewchanged
};

/**
 * 初始化方法
 */
function init()
{

    //性能时间戳日志，发布版本关闭
    logger.log("enter index init()");

    // 设置语言
    jse.setLanguage(lang);


    window.xui = new jse.XUI();
    window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());

    var xuiUrl = getXuiUrl();
    if("true" == independence)
    {
        //窗体最大化
        this.moveTo(0, 0);
        this.resizeTo(screen.availWidth, screen.availHeight);
    	window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/mainframe/index.xui", signalMap);
    }
    else
    {
    	window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/mainframe/indexintegration.xui", signalMap);
    }

    logger.log("exit index init()");
}

var deviceText = null;

var functionText = null;

var chassisInfos = null;

var entityData = null;

var g_loadTempletTreeNum = 0;

/**
 * 加载页面初始设置
 */
function doLoad()
{
    logger.log("enter index doLoad()");

    initExtendWidget();
	deviceText = null;
	functionText = null;
	chassisInfos = null;
	entityData = null;

    //requestForDeviceTree();
    //requestForFunctionTree();
	if(!preLoadFlag)
	{
	    requestForChassisInfo();
	    requestForEntityData();
	}


    // 获取界面显示的中英文资源并显示
    var topWin = jse.topWin;
    var onLineTitleNameBegin = jse.getI18nValue("qat:public",
            "qat.onLine_title_d")
            + Constants.TITLE_SEPARATE + topWin.devName
            + Constants.TITLE_LEFT_BRACKET + topWin.deviceIp_URLParam
            + Constants.TITLE_RIGHT_BRACKET;

    window.document.title = onLineTitleNameBegin;

    onlinewarning = jse.getI18nValue("qat:public", "dailog.lable.onlinewarning_d");
    windowLoad();

    //非预加载方式才设置心跳
    if(!preLoadFlag)
    {
        //向服务器发送心跳请求
        heartBeat();
        setInterval("heartBeat()", 120000);
    }

    logger.log("exit index doLoad()");
}
/**
* 初始化告警板
*/
function initAlarmPanel()
{
    if("true" == independence)
    {
    	alarmPanel = new AlarmPanel();

    	alarmPanel.critical_toolbutton = window.xui.getWidget("Critical");
    	alarmPanel.major_toolbutton = window.xui.getWidget("Major");
    	alarmPanel.minor_toolbutton = window.xui.getWidget("Minor");
    	alarmPanel.warning_toolbutton = window.xui.getWidget("Warning");

    	alarmPanel.setPreferSizes();
    	alarmPanel.setBackgroundColors();
    	alarmPanel.setAlarmPanelInterval();
    	alarmPanel.searcherAndTimer();
    }
}

function pub_setAlarmPanelInterval()
{
    if("true" == independence)
    {
        window.setTimeout("initAlarmPanel();",3000);
    }
}

function closeWaiting()
{
	if (null != waitDialog && typeof(waitDialog.dispose) !="undefined")
	{
		waitDialog.dispose();
	}
}

function heartBeat()
{
	var topWin = jse.topWin;
	var url = CommonUtil.getRootPath() + "/vmt/security/heartbeat.do?PageType=ONLINE&deviceIP=" + topWin.deviceIp_URLParam;
	var req = jse.RpcRequest.create(url);
	req.invoke(doNull);
}
function doNull()
{

}

function closeDeviceMgrPageForTimeOut()
{
    opener.closeDeviceMgrPageForTimeOut();
}

/**
 * 退出设备管理页面警告信息
 */
function logoutSystemWarning()
{
    var warning = onlinewarning;
    if (isShowWarning)
    {
        return warning;
    }
    else
    {
        return;
    }
}

/**
 * 退出事件处理
 *
 * @return
 */
function logoutSystem()
{
	if(null != req)
	{
		req.abort();
	}
    if(isColseByDevMgr == true)
    {
    }
    else
    {
        // 回调父窗口，退出设备
        opener.closeOnLineWin(deviceIp_URLParam, false);
    }
}

/**
 * 退出工具回调函数
 */
function handleLogoutResponse(errorCode, request)
{
    if (errorCode == 0)
    {
        // 获取异步请求过来的文本内容
        var text = request.responseText;
        // 将 xml字符串解析为 DOM 对象
        doc = jse.loadXML(text);
        // 获取节点
        var node = jse.selectSingleNode("/response/operResultType", doc);

        // 获取节点 resultType 属性值
        var resultType = node.getAttribute("resultType");

        // 是否需要更新标识
        var isUpdate = null;
        // 处理请求成功情况下
        if (Constants.OPER_NOK == resultType)
        {
            // 显示错误信息
            VMTError("win.errorClose();");
        }
    }
}

/**
 * 关闭错误对话框
 *
 * @return
 */
function errorClose()
{
// errorDlg.dispose();
}

/**
 * 设置错误对话框大小
 *
 * @param width
 * @param height
 */
function setPreferSize(width, height)
{
    errorDlg.setPreferSize(width, height);
}

/**
 * 刷新页面回调方法
 */
function handleRefreshResponse()
{
    if (Constants.OPER_OK == resultType)
    {
        // 刷新主界面
        enterSystem();
    }
}

/**
 * 请求模板管理页面
 *
 * @return
 */
function doTempletMgr()
{
    opener.doTempletMgr();
}

/**
 * 请求注销
 *
 * @return
 */
function doExit()
{
    var message = jse.getI18nValue("qat:public", "label.logoutne_d");
    var dialogTitle = jse.getI18nValue("qat:public", "label.tip_d");
    VMTWarning(message, "win.logOutSys();", "300", "150", dialogTitle);
}

/**
 * 【退出网元】
 */
function logOutSys()
{
    opener.logOutSys();
}

/**
 * 退出系统
 */
function pub_Exit()
{
    if ("true" == independence)
    {
        // 转向登录页面
        window.location.href = CommonUtil.getRootPath() + "/vmt/index.html";
    }
    else
    {
        window.close();
    }
}

/**
 * 在线topwin窗体将子窗体点击的帮助处理事件传递给设备管理页面
 */
function pub_doHelp(title)
{
    opener.pub_doHelpGetHelpWin(title);
}

/**
 * 刷新页面
 */
function pub_refresh()
{
    // independence = "false";
    // 6.1添加,集成时不清除session
    if("true" == independence)
    {
        // 请求刷新界面
        var req = jse.RpcRequest.create(CommonUtil.getRootPath() + "/vmt/security/logoutaction.do?methodID=switchlanguage");
        req.invoke(handleResult,["handleRefreshResponse();"]);
    }
    else
    {
       //刷新主界面
        enterSystem();
    }
}

/**
 * 供集成调用，在关闭网元管理器的时候退出网元
 * @return
 */
function pub_ExitDevice()
{
	//var windowMgr = window.xui.getWidget("ViewManager") ;
	pub_ExitCurrentDevice();
}

/**
 * 集成装载index页面,该方法提供定位到设备面板的功能.供集成网管前台调用
 * @return
 */
function pub_alarmDevicePanel(resID)
{
    TimeOperation.doObjSetTimeout(this, this.pub_getAlarmPanelDevice, [resID], 1000);
//	setTimeout("pub_getAlarmPanelDevice(resID);", 1000);
	//pub_getAlarmPanelDevice(resID);
}

/**
 * 调用网元面板的接口
 * @param args 参数
 * @return
 */
function pub_callPanelInterface(args)
{
    pub_panelCommonInterface(args);
}

/**
 * 面板打开时设置，集成前台调用
 * @param color
 * @return
 */
function pub_updateBoardNormalColor(color)
{
	var windowMgr = window.xui.getWidget("ViewManager") ;
	pub_setBoardNormalColor(color);
	pub_setAlarmNumColor(color);
}

function pub_getResID()
{
    return resID;
}

function pub_getAlarmPanel()
{
    return alarmPanel;
}

function pub_getIsDependence()
{
    return independence;
}
function dp(obj)
{
	var names = "";
	for( name in obj)
	{
		names += name + "\n";
	}
	alert(names);
}
/**
 * 处理告警板的跳转
 * @param evt
 * @return
 */
function doAlarm(evt)
{
	var topWin = jse.topWin;
	var devType = topWin.devType;
	var devVersion = topWin.devVersion;
	var url = CommonUtil.getRootPath() + "/vmt/xpath/queryXpathAction.do?devType="+devType+"&devVersion="+devVersion
	          +"&keys=fm_activeAlarm,fm_activeAlarmLevel&xpathType=pnp"
	var req = jse.RpcRequest.create(url);
	req.invoke(callbackDoAlarm,[evt.id]);
}

/**
 *
 * @param errorCode
 * @param request
 */
function callbackDoAlarm(errorCode, request,evtId)
{
	var xpaths = request.responseText;
	var array = xpaths.split(",");
	var activeAlarmXpath = array[0];
	var levelXpath = array[1];
	var faultItem = "";
	var items = faultMenuBar._items;
	for ( var item in items)
	{
		if(-1 != item.indexOf(activeAlarmXpath))
		{
			faultItem = item;
			break;
		}
	}
	var condition = levelXpath + "@xpath_value@" + evtId;
	pub_locateFaultManagement(faultItem,condition);
}

/**
 * 增加故障管理菜单项
 * @param ids 菜单项id数组
 * @param texts 菜单项名称数组
 * @return
 */
function addFaultMenuItems(ids,texts)
{
	if("true" == independence && !hasItems)
    {
		hasItems = true;
    	faultMenuBar = window.xui.getWidget("menuBarSystem");
    	for ( var i = 0; i < ids.length; i++)
    	{
    		faultMenuBar.addItem("menuFault",ids[i],{text:texts[i],action:doFaultManagement});
		}
    }
}

/**
 * 处理故障管理菜单
 * @param evt
 * @return
 */
function doFaultManagement(evt)
{
	var windowMgr = window.xui.getWidget("ViewManager");
	pub_locateFaultManagement(evt.id,"all");
}

/**
 * 以下为merge C01代码，优化面板加载效率
 */
/***************************************************************************/
function requestForDeviceTree()
{
	var req = jse.RpcRequest
            .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/device/DeviceNavigatorMgrAction.do?methodID=handleListLRVRRequest"));

    // 显示设备树;
    req.invoke(callbackDeviceTreeInfo);
}

function callbackDeviceTreeInfo(errorCode, request)
{
    deviceText = request;
}

function requestForLRFunctionTree()
{
//    var req = jse.RpcRequest.create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/capability/FunctionTreeNavAction.do?methodID=functiontree&neName="
//        + g_VRName
//        + "&neID=" + g_VRID
//        + "&isWorkspace=false&isSupportPartition=false&isOffline=false"));
//
//
    var req = jse.RpcRequest
    .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/capability/FunctionTreeNavAction.do?methodID=functiontree&neName=LR"
            + "&neID="
            + deviceIp_URLParam
            + "&isWorkspace="
            + isWorkspace
            + "&isOffline="
            + "false"
            + "&isSupportPartition=false"
            + "&pnpDeviceType="
            + pnpForm.deviceType
            + "&pnpDeviceVersion=" + pnpForm.deviceVersion + "&compatible=" + pnpForm.compatible));


    req.invoke(callbackFunctreeInfo);
}

function callbackFunctreeInfo(errorCode, request)
{
    functionText = request;
}

function requestForChassisInfo()
{
	if(null == pnpForm.deviceType || "null" == pnpForm.deviceType || null != chassisInfos)
	{
		return;
	}
	logger.log("start main_index requestForChassisInfo");

	var url = CommonUtil.getRootPath() + "/devicepanel/index.do" + "?deviceIP=" + deviceIp_URLParam + "&&deviceType=" + pnpForm.deviceType
			+ "&&deviceVersion=" + pnpForm.deviceVersion + "&&isDenpence="
			+ independence + "&&resID=" + resID + "&&indentifier="
			+ indentifier + "&&prochandle=" + prochandle;
	var req = jse.RpcRequest.create(url);
	req.setWaiting(false);
	req.invoke(callbackChassisInfo);
}

function callbackChassisInfo(errorCode, request)
{
	chassisInfos = request.responseText;
	logger.log("end main_index requestForChassisInfo");
}

function requestForEntityData()
{
	if(null == pnpForm.deviceType || "null" == pnpForm.deviceType || null != entityData)
	{
		return;
	}
	logger.log("start main_index requestForEntityData");

	var panelDataUrl = CommonUtil.getRootPath() + "/devicepanel/handleDevicePanelData.do?deviceIP="
		+ deviceIp_URLParam+ "&deviceType=" + pnpForm.deviceType + "&deviceVersion=" + pnpForm.deviceVersion + "&serverTime=init"+ "&&resID=" + resID
		+ "&&indentifier=" + indentifier + "&&needFreshAlarm=false";

	var req = jse.RpcRequest.create(panelDataUrl);
	req.setWaiting(false);
	req.invoke(callbackEntityData);
}

function callbackEntityData(errorCode, request)
{
	entityData = request;
	logger.log("end main_index requestForEntityData");
}
/** ************************************************************************ */

/**
 * 获取模板树控制器
 * @return 模板树控制器对象
 */
function pub_getTempletTreeCtrl()
{
	var templetTreeTab = viewManager.getWindowById(Constants.PROFILE_VIEWID);
	return templetTreeTab.g_templetTreeCtrl;
}


/**
*定位到指定节点的具体tab
*/
function pub_locateTo(nodeId, tabId)
{	
	//获取窗口对象
	var funcWin = viewManager.getWindowById(Constants.FUNCTION_VIEWID);

	//要定位到的TabId，初始化时激活该tab页
	this.toNodeId = nodeId;
	this.toTabId = tabId;

	//加载节点和tab
	funcWin.selectSpecicalNode(toNodeId);
}

function pub_refreshAlarmNum(alarmNum)
{
	var panelWin = pub_getPanelWin();
	panelWin.pub_refreshAlarmNum(alarmNum);
}
function pub_setAlarmNumColor(color)
{
	var panelWin = pub_getPanelWin();
	panelWin.pub_setAlarmNumColor(color);
}

/**
 * View切换事件处理
 *
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-7
 * @param evt 事件对象
 * @return
 */
function onviewchanged(evt)
{
    var VRActiveView = viewManager.getWindowById(evt.id);

    if ("stencil" == evt.id)
    {
    	resetTemplateMainFrameTitle()

        var nodeStatus = getVRStatusNode(g_VRID);
        if(null == nodeStatus)
        {
            return;
        }

        if(!nodeStatus.templetViewLoad)
        {
            loadTemplateView();

            // 显示模板管理View，隐藏当前显示的View
            loadBlankFeatureView(evt.id);
            g_loadTempletTreeNum++;
        }
        else
        {
            // 根据选中节点加载特性tab
//            pub_loadTempletMgrView();
            var templetTreeTab = viewManager.getWindowById(Constants.PROFILE_VIEWID);
            if (undefined != templetTreeTab)
            {
                // 根据选中结点加载模板实例页面
                templetTreeTab.pub_refreshTempletMgrTab(g_loadTempletTreeNum);
                g_loadTempletTreeNum++;
            }
        }


    }
    else if (getFunctionTreeViewID(g_VRID, g_NeFlag) == evt.id)
    {
    	resetMainFrameTitle();

        var nodeStatus = getVRStatusNode(g_VRID);
        if(null == nodeStatus)
        {
            return;
        }

        if(false == nodeStatus.functionViewLoad)
        {
            loadFunctionURL(null, false);
            loadBlankFeatureView(evt.id);
        }
        else
        {
            var VRActiveView = viewManager.getWindowById(evt.id);
            VRActiveView.addFeatureViewBySelNode();
        }
    }
    else
    {
        g_featureTabViewCtrl.viewChange(evt);
    }
}


/**
 * 刷新模板实例Tab页的标题
 *
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-17
 * @param newTitle 新标题
 */
function pub_refreshTempletMgrTitle(newTitle)
{
    g_ViewsManager.setViewTitle(Constants.TEMPLET_TEMPLETMGRVIEW, newTitle);
}

/**
 * 存放dialogId
 *
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId
 */
function pushDialogId(dialogId)
{
	g_dialogIds.push(dialogId)
}
/**
 * 删除dialogId
 *
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 */
function popDialogId()
{
	g_dialogIds.pop();
}
/**
 * 获取父dialog的ID
 *
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId
 */
function getParentDialogId()
{
	var maxDialogNum = parseInt(pub_getSystemConfigDataMgr().getProperty("maxDialogNum"));
	if(g_dialogIds.length > 0 && g_dialogIds.length <= maxDialogNum)
	{
		return g_dialogIds[g_dialogIds.length-1];
	}
	return "";
}
/**
 * 弹出的对话框是否已经达到最大值
 * 最大值可以在system.ini中进行配置
 *
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId
 */
function isPopMaxdiaglogNUM()
{
	var maxDialogNum = parseInt(pub_getSystemConfigDataMgr().getProperty("maxDialogNum"))
	if(g_dialogIds.length >= maxDialogNum)
	{
        var message = Resource.getReplacedResource(maxDialogNum,"","label.dialognumber_d");
		CommonDlgReq.openAlertDialog(message, null, null);
		return true;
	}
	return false;
}
/**
 * 构造即将弹出dialogId，由于JSE的实现，有相同的dialogid存在，就不在弹出
 * 所有针对接口创建与keyref这种可以嵌套弹出对话框，需要代码构造dialogId
 * dialogID = parentdialogId + curdialogId
 *
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId
 */
function constructDialogId(dialogId)
{
	var parentDialogId = getParentDialogId();
	return parentDialogId + dialogId;
}
Event.observe(window, "load", init);