function Zone(zonePattern)
{
    this.dateDelimiters = new Array("-","/",".");
    this.timeStyles = new Array("HH:mm:ss","hh:mm:ss","hh:mm:ss");
    this.timeTypes = new Array("AM","PM","上午","下午");
    this.bools = new Array(true,false);
    this.regexp = /\d{5}/;
    zonePattern = this.regexp.test(zonePattern)?zonePattern:"00000";
    this.zonePattern = zonePattern;
    
    this.dateDelimiter = this.dateDelimiters[zonePattern.charAt(0)];
    
    this.dateSequence = zonePattern.charAt(1);
    
    this.timeStyle = zonePattern.charAt(2);
    
    this.utcIdentifier = this.bools[zonePattern.charAt(3)];
    
    this.dstIdentifier = this.bools[zonePattern.charAt(4)];
    
    this.getTimeType = function(hours)
    {
        var tt = this.timeTypes[0];
        if(this.timeStyle == "1" && hours >= 12)
        {
            tt = this.timeTypes[1];
        }
        else if (this.timeStyle == "2" && hours < 12)
        {
            tt = this.timeTypes[2];
        }
        else if(this.timeStyle == "2" && hours >= 12) 
        {
            tt = this.timeTypes[3];
        }
        return tt;
    }
    
    this.getDateSequence = function()
    {
        var sequence = "yyyy" + this.dateDelimiter + "MM" + this.dateDelimiter + "dd";
        if(this.dateSequence == "1")
        {
           sequence = "MM" + this.dateDelimiter + "dd" + this.dateDelimiter + "yyyy";
        }
        else if(this.dateSequence == "2")
        {
            sequence = "dd" + this.dateDelimiter + "MM" + this.dateDelimiter + "yyyy";  
        }
           
        return sequence;
    }
    
    this.getIsAMPMSupport = function()
    {
        return this.timeStyle != 0;
    }
        
    /**
     * 获得该类型的JSE排序样式
     * 
     * @param isDateTime 是否含日期时间
     * @param jse时间控件的排序样式
     */
    this.getJSESequenceStyle = function(isDateTime)
    {   
        var style = jse.YMDHMS;
        if(isDateTime)
        {
            if(this.dateSequence == "1")
            {
                style = jse.MDYHMS;           
            }
            else if(this.dateSequence == "2")
            {
                style = jse.DMYHMS;
            }
        }
        else
        {
            style = jse.YMD;
            if(this.dateSequence == "1")
            {
                style = jse.MDY;           
            }
            else if(this.dateSequence == "2")
            {
                style = jse.DMY;
            }
        }
           
        return style;
    }

    
    this.getZonePattern = function()
    {
        return this.getDateSequence() + " " + this.timeStyles[this.timeStyle];
    }
    
    this.getUTCPattern = function()
    {
        return "yyyy-MM-dd HH:mm:ss";
    }
    
    this.getUTCPatternDate = function(localString,ttStr)
    {
        var datetime = localString.split(" ");
        if((null==datetime[0]) || (null==datetime[1]))
        {
            return "";
        }
        var dates = datetime[0].split(this.dateDelimiter);
        var times = datetime[1].split(":");
        dates = cutStartZero(dates);
        times = cutStartZero(times);
        
        var uDates = new Array();
        uDates[0] = dates[0];
        uDates[1] = dates[1];
        uDates[2] = dates[2];
       
        if(this.dateSequence == "1")
        {
            uDates[0] = dates[2];
            uDates[1] = dates[0];
            uDates[2] = dates[1];
        }
        if(this.dateSequence == "2")
        {
            uDates[0] = dates[2];
            uDates[1] = dates[1];
            uDates[2] = dates[0];
        }
        
        var apm = false;
        if ("" != ttStr && null != ttStr)
        {
	        var ttStrs = ttStr.split(" ");
	        if ( ttStrs.length > 0 && (ttStrs[0] == this.timeTypes[1] || ttStrs[0] == this.timeTypes[3]))
	        {
	            
	            apm = true;
	        }
        }
        
        if(this.timeStyle != "0" && apm)
        {
            times[0] = parseInt(times[0]) + 12;
        }   
        
        var month = uDates[1]>9?""+uDates[1]:"0"+uDates[1];
        var day = uDates[2]>9?""+uDates[2]:"0"+uDates[2];
        var hours = times[0]>9?""+times[0]:"0"+times[0];
        var minutes = times[1]>9?""+times[1]:"0"+times[1];
        var seconds = times[2]>9?""+times[2]:"0"+times[2];
        return uDates[0] +"-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds;
        
    }
    
    /**
     * 获取日期字符串
     */
    this.getDateString = function(year, mon, day)
    {
        var uDates = new Array();
        uDates[0] = year;
        uDates[1] = mon;
        uDates[2] = day;
       
        if(this.dateSequence == "1")
        {
            uDates[0] = mon;
            uDates[1] = day;
            uDates[2] = year;
        }
        if(this.dateSequence == "2")
        {
            uDates[0] = day;
            uDates[1] = mon;
            uDates[2] = year;
        }
        
        return uDates.join(this.dateDelimiter);
    }
    
    this.getCurrentPatternDate = function(y,mon,d,h,min,s)
    {
        var month = mon > 9?""+mon:"0"+mon;
        var day = d > 9?""+d:"0"+d;
        var dStr = y + this.dateDelimiter + month + this.dateDelimiter + day;
        if(this.dateSequence == "1")
        {
            dStr = month + this.dateDelimiter + day + this.dateDelimiter + y;
        }
        else if(this.dateSequence == "2")
        {
            dStr = day + this.dateDelimiter + month + this.dateDelimiter + y;
        }
        var hours = h>9?""+h:"0"+h;
        var minutes = min > 9?""+min:"0"+min;
        var seconds = s > 9?""+s:"0"+s;
        var tStr = ":" + minutes + ":" + seconds;
        if(this.timeStyle != "0")
        {
            var tt = this.getTimeType(h);
            h = h >= 12?h-12:h;
            hours = h > 9?""+h:"0"+h;
            tStr = hours + tStr + " " + tt;
        }
        else
        {
            tStr = hours + tStr;
        }
        return dStr + " " + tStr;
    }
}

function gcu_getUTCPatternDateTime(localString)
{
        var datetime = localString.split(" ");
        if(datetime.length == 1 && localString.indexOf(":") < 0)
        {
           var data = localString;
           if(data.indexOf("/") > -1)
           {
             var dates = data.split("/");
             var uDates = new Array();
             uDates[0] = dates[2];
             uDates[1] = dates[0];
             uDates[2] = dates[1];
             data = uDates[0] + "-" + uDates[1] + "-" + uDates[2]
            }
            return  data;
        }
        else if(datetime.length == 1)
        {
            var time = localString.split(".")[0];
            return  time;
        }
        else
        {
            var data = datetime[0];
            if(data.indexOf("/") > -1)
            {
                var dates = data.split("/");
                var uDates = new Array();
                uDates[0] = dates[2];
                uDates[1] = dates[0];
                uDates[2] = dates[1];
                data = uDates[0] + "-" + uDates[1] + "-" + uDates[2]
            }
           //格式化时间格式
           var time = datetime[1];
           var uTime = time.split(".")[0];
           return  data + " " + uTime;
        }
}        

function gcu_transformDateTime(dateTime, type, zonePattern)
{
    var DATE = "date";
    var TIME = "time";
    var DATETIME = "datetime";
    
    if (null == dateTime)
    {
    	return;
    }
    
    if(DATETIME == type || parseInt(type) == 0)
    {
        return dateTime;
    }
    
 	var itype = parseInt(type);
	if(itype == 0)
	{
	    type = DATETIME;
	}
	if(itype == 1)
	{
	    type = DATE;
	}
	if(itype == 2)
	{
	    type = TIME;
	}
	
	var tmp = dateTime;
	if( -1 != tmp.indexOf("@dst_dst@false"))
	{
		tmp = tmp.split("@dst_dst@false")[0];
	}
	if( -1 != tmp.indexOf("@dst_dst@true"))
	{
		tmp = tmp.split("@dst_dst@true")[0];
	}
	if(DATE == type.toLowerCase() || 1 == parseInt(type) )
	{
	    if("" !=dateTime)
	    {
		tmp += " 00:00:00"; 
	    }
	}
	if(TIME == type.toLowerCase() || 2 == parseInt(type) )
	{
	    if(null == zonePattern)
	    {
	        tmp = "1970-01-02 " + tmp;
	    }
	    else
	    {
	        tmp = zonePattern.getDateString("1970", "01", "02") + " " + tmp;
	    }
	}
	
	return tmp;
}
function gcu_getConfigureDateTime(utcDateTime, type) 
{
     var DATE = "date";
    var TIME = "time";
    var DATETIME = "datetime";
	var tmp = utcDateTime;
  	var itype = parseInt(type);
	if(itype == 0)
	{
	    type = DATETIME;
	}
	if(itype == 1)
	{
	    type = DATE;
	}
	if(itype == 2)
	{
	    type = TIME;
	}
	 if(DATE == type.toLowerCase() || 1 == parseInt(type) )
     {
		 tmp = tmp.split(" ")[0]; 
     }
	 if(TIME == type.toLowerCase() || 2 == parseInt(type) )
     {
		 var tmpArray = tmp.split(" ");
		 if (3 <= tmpArray.length)
		 {
		 	tmp = gcu_changAmPmTimeToStandard(tmpArray[1], tmpArray[2])
		 }
		 else
		 {
			tmp = tmpArray[1];		 	
		 }
     }
     tmp = gcu_getUTCPatternDateTime(tmp);
	 return tmp;
}

function gcu_changAmPmTimeToStandard(time, ampm)
{
	if ("pm" == ampm.toLowerCase() || ("下午" == ampm))
	{
		var times = time.split(":");
		var hour = parseInt(times[0]) + 12;
		return hour + ":" + times[1] + ":" + times[2];
	}	
	
	return time;
}

function gcu_getUTCDateTime(utcDateTime, type) 
{
    var DATE = "date";
    var TIME = "time";
    var DATETIME = "datetime";
    
	var tmp = utcDateTime;
 	var itype = parseInt(type);
	
	if(itype == 0)
	{
	    type = DATETIME;
	}
	if(itype == 1)
	{
	    type = DATE;
	}
	if(itype == 2)
	{
	    type = TIME;
	}
	if(DATE == type.toLowerCase() || 1 == parseInt(type) )
    {
		tmp = tmp.split(" ")[0]; 
    }
	if(TIME == type.toLowerCase() || 2 == parseInt(type) )
    {
		tmp = tmp.replace(tmp.split(" ")[0] + " ", "");
    }
	return tmp;
}

function getAttrubuteValue(value, type, dateTimeTransformType) 
{
	if (null == value || "" == value)
	{
		return "";
	}
	
	if(null == type)
    {
        return value;
    }
	
    var DATE = "date";
    var TIME = "time";
    var DATETIME = "datetime";
    
	var tmp = value;
	var itype = parseInt(type);
	
	if(itype == 0)
	{
	    type = DATETIME;
	}
    if(itype == 1)
    {
        type = DATE;
    }
    if(itype == 2)
    {
        type = TIME;
    }
	    
	if (type.toLowerCase() == DATETIME)
    {
		tmp = gcu_transformDateTime(tmp, type.toLowerCase());
		if(dateTimeTransformType == "utc2local")
		{
			tmp = gcu_UTCString2LocalString(tmp,"yyyy-MM-dd HH:mm:ss");
		}
		if(dateTimeTransformType == "local2utc")
		{
			tmp = gcu_LocalString2UTCString(tmp,"yyyy-MM-dd HH:mm:ss");
		}
    	tmp = gcu_getUTCDateTime(tmp, type.toLowerCase());
    }
	else if (type.toLowerCase() == DATE || type.toLowerCase() == TIME)
	{
    	tmp = gcu_getUTCDateTime(tmp, type.toLowerCase());
    }
	
	return tmp;
}
/**
 * 将本地时间字符串（可以含是否DST），格式为pattern所给定的格式，转换成世界标准时间（UTC）字符串，格式为yyyy-MM-dd HH:mm:ss
 * 
 * @param localStringDST 格式为pattern的本地时间字符串（可以含是否DST），如：2010-10-25 14:33:33@dst_dst@true
 * @param pattern 时间格式
 * @return UTC时间字符串
 */
function gcu_LocalString2UTCString(localStringDST, pattern, xpath)
{
    if("" == localStringDST || -1 != localStringDST.indexOf("filter"))
    {
        return "";
    }
    
    if(-1 == localStringDST.indexOf("@dst_dst@") && -1 != localStringDST.indexOf("DST"))
    {
        localStringDST += "@dst_dst@true";
    }
    if(-1 == localStringDST.indexOf("@dst_dst@") && -1 == localStringDST.indexOf("DST"))
    {
        localStringDST += "@dst_dst@false";
    }
    
    var localStr = localStringDST;
    var isDST = false;
    if( -1 != localStringDST.indexOf("@dst_dst@"))
    {
        var localTmp = localStringDST.split("@dst_dst@");
        localStr = localTmp[0];
        isDST = localTmp[1] == "true"?true:false;
    }
    var localString = localStr.substring(0,19);
    var ttStr = localStr.substring(20,localStr.length);;
   
    var top = jse.topWin;
    var tzOffset = parseInt(top.tzOffset);
    var zonePattern = top.zonePattern;
    // 判断是否是tm属性，不进行本地化处理
    localString = zonePattern.getUTCPatternDate(localString,ttStr);
    if (-1 != jse.topWin.pub_getSystemConfigDataMgr().getProperty("notSupportLocaleTime").indexOf(xpath))
    {
    	return localString;
    }
    
    var localMillisenconds = gcu_LocalString2UTC(localString +" UTC+00:00", zonePattern.getUTCPattern()+" Z");
    var localDate = new Date(localMillisenconds);
    localDate = gcu_changeTimeZone(localDate);
    localMillisenconds = localDate.getTime();
    
    var dstOffset = getDSTOffset(localDate);

    var overlap = gcu_isSwitchTime(localString,zonePattern.getUTCPattern());
    
    if(overlap == 1 && tzOffset < 0)
    {
        localMillisenconds -= dstOffset * 3600 * 1000;
    }
    
    if(overlap != 1 && isDST)
    {
        localMillisenconds -= dstOffset * 3600 * 1000;
    }
    dstOffset = isDST?dstOffset:0;
    
    var utcMillisenconds = localMillisenconds + tzOffset*2*60*1000 - dstOffset * 3600 * 1000;
    var utcDate = new Date(utcMillisenconds);
    var utcPattern = new Zone("00011");
    var utcStr = date2String(utcDate,tzOffset,utcPattern);
    
    return utcStr;       
}


function cutStartZero(dts)
{
    for(var i=0;i<dts.length;i++)
    {
        if( dts[i].charAt(0) == "0")
        {
            dts[i] = dts[i].charAt(1);
        }
    }
    return dts;
}

/**
 * 将格式为yyyy-MM-dd HH:mm:ss的世界标准时间字符串转换成pattern所指定的本地字符串
 * 
 * @param utcString 格式为yyyy-MM-dd HH:mm:ss的世界标准时间字符串
 * @param pattern 本地时间字符串格式
 * @return 本地时间字符串
 */
function gcu_UTCString2LocalString(utcString,pattern)
{
    if("" == utcString)
    {
        return utcString;
    }
    
    var top = jse.topWin;
    var tzOffset = parseInt(top.tzOffset);
    var zonePattern = top.zonePattern;
    
    var utcMillisenconds = gcu_LocalString2UTC(utcString +" UTC+00:00", zonePattern.getUTCPattern()+" Z");
    var localMillisenconds = utcMillisenconds;
    var localDate = new Date(localMillisenconds);
    localDate = gcu_changeTimeZone(localDate);
    var localStr = date2String(localDate,tzOffset,zonePattern);
    return localStr;
}

/**
 * 将时间对象转换成pattern所指定的时间格式
 * 
 * @param dateObject 时间对象
 * @param pattern 时间格式
 * @param tzOffset 时区偏量
 * @param hasIdentifier 是否加上时区和夏令时标识
 * @return 时间字符串
 */
function date2String(dateObject,tzOffset,zonePattern)
{
    if(null==dateObject)
    {
        return "";
    }
    var utcDate = dateObject;

    var month = utcDate.getMonth() + 1;
    var day = utcDate.getDate();
    var hours = utcDate.getHours();
    var minutes = utcDate.getMinutes();
    var seconds = utcDate.getSeconds();
    
    var utcStr = zonePattern.getCurrentPatternDate(utcDate.getFullYear(),month,day,hours,minutes,seconds);
    var utcIdentifier = "";
    var dstIdentifier = "";
    if(zonePattern.utcIdentifier)
    {
        utcIdentifier = gcu_getUTCIdentifier(tzOffset);
    }
    if(zonePattern.dstIdentifier)
    {
        dstIdentifier = gcu_getDSTIdentifier(utcDate);
    }
    return utcStr + utcIdentifier + dstIdentifier;
}

/**
 * 根据时间对象和是否显示夏令时标识，获取夏令时标识
 * 
 * @param utcDate 时间对象
 * @return 返回标识，" DST "：处于夏令时并显示时," "：空标识
 */
function gcu_getDSTIdentifier(utcDate)
{
    var dst = (getDST(utcDate))?" DST ":" ";
    return dst;
}

/**
 * 判断时间对象是否处于夏令时重复段
 * 
 * @param argDateTime 时间对象
 * @return 返回时间对象是否处于夏令时重复段，1：处于夏令时重复段，-2：不处于夏令时重复段
 */
function checkDSTOverLapPeriod(argDateTime)
{
    // This DSTOffsetForThisTimeZone value is used for the current time zone
    // As we are unable to get the offset for the overlap period directly.
    var dstOffSet = argDateTime.DSTOffsetForThisTimeZone;
    var time = argDateTime.getTime();
    time -= dstOffSet*60*1000;
    var tmpDate = new Date(time);
    if(tmpDate.getDST() && (argDateTime.getDST() == 0 ))
    {
        // Overlapp Period
        return 1;
    }
    return -2;
}

/**
 * 判断时间对象是否处于夏令时
 * 
 * @param dateObj 时间对象
 * @return 返回是否处于夏令时，true：处于夏令时，false：处于非夏令时
 */
function getDST(dateObj)
{
    var now_local = dateObj;
    var jan_local = new Date(now_local.getFullYear(), 0, 1, 0, 0, 0, 0, 0);
    var jun_local = new Date(now_local.getFullYear(), 5, 1, 0, 0, 0, 0, 0);
    var now_utc = Date.UTC(now_local.getFullYear(), now_local.getMonth(), now_local.getDate(), now_local.getHours(), now_local.getMinutes(), now_local.getSeconds(), now_local.getMilliseconds());
    var jan_utc = Date.UTC(jan_local.getFullYear(), jan_local.getMonth(), jan_local.getDate(), jan_local.getHours(), jan_local.getMinutes(), jan_local.getSeconds(), jun_local.getMilliseconds());
    var jun_utc = Date.UTC(jun_local.getFullYear(), jun_local.getMonth(), jun_local.getDate(), jun_local.getHours(), jun_local.getMinutes(), jun_local.getSeconds(), jan_local.getMilliseconds());
    var now_diff = Math.round((now_utc - now_local.getTime()) / (1000 * 3600));
    var jan_diff = Math.round((jan_utc - jan_local.getTime()) / (1000 * 3600));
    var jun_diff = Math.round((jun_utc - jun_local.getTime()) / (1000 * 3600));
    return jan_diff != jun_diff && now_diff == Math.max(jan_diff, jun_diff);
}

/**
 * 获取当前时区偏量的时区标识，如UTC+08:00
 * 
 * @return 当前时区偏量的时区标识
 */
function gcu_getCurrentDateTimeString(dt)
{
    var top = jse.topWin;
    var tzOffset = parseInt(top.tzOffset);
    return date2String(dt,tzOffset,top.zonePattern);
}

/**
 * 根据时区偏量获取时区标识，如UTC+08:00
 * 
 * @param tzOffset 时区偏量
 * @return 时区偏量对应的时区标识
 */
function gcu_getUTCIdentifier(tzOffset)
{
    var sign = "-";
    if(tzOffset <= 0)
    {
        sign = "+";
        tzOffset = Math.abs(tzOffset);
    }
    var timezone = Math.floor(tzOffset/60);
    timezone = timezone > 9? timezone:"0" + timezone;
    var timezonem = tzOffset%60;
    timezonem = timezonem > 9? timezonem:"0" + timezonem;
    var utcIdentifier = " " + sign + timezone + ":" + timezonem;
    return utcIdentifier;
}

/**
 * 获取时间对象的夏令时（DST）偏量，返回的偏量值的单位为小时
 * 
 * @param dt 时间对象
 * @return 时间对象的夏令时偏量
 */
function getDSTOffset(dt)
{
    var now_local = dt;
    var jan_local = new Date(now_local.getFullYear(), 0, 1, 0, 0, 0, 0, 0);
    var jun_local = new Date(now_local.getFullYear(), 5, 1, 0, 0, 0, 0, 0);
    var now_utc = Date.UTC(now_local.getFullYear(), now_local.getMonth(), now_local.getDate(), now_local.getHours(), now_local.getMinutes(), now_local.getSeconds(), now_local.getMilliseconds());
    var jan_utc = Date.UTC(jan_local.getFullYear(), jan_local.getMonth(), jan_local.getDate(), jan_local.getHours(), jan_local.getMinutes(), jan_local.getSeconds(), jun_local.getMilliseconds());
    var jun_utc = Date.UTC(jun_local.getFullYear(), jun_local.getMonth(), jun_local.getDate(), jun_local.getHours(), jun_local.getMinutes(), jun_local.getSeconds(), jan_local.getMilliseconds());
    var now_diff = ((now_utc - now_local.getTime()) / (1000 * 3600));
    var jan_diff = ((jan_utc - jan_local.getTime()) / (1000 * 3600));
    var jun_diff = ((jun_utc - jun_local.getTime()) / (1000 * 3600));
    return jun_diff - jan_diff;
}

/**
 * 将时间对象的时区转换成当前使用的时区，
 * 
 * @param dt 时间对象
 * @return 转换时区后的时间对象
 */
function gcu_changeTimeZone(dt)
{
    var top = jse.topWin;
    var tzOffset = parseInt(top.tzOffset);
    var tzMilliseconds = dt.getTime() + (dt.getTimezoneOffset() - tzOffset) * 60 * 1000;
    var currentDate = new Date(tzMilliseconds);
    var dstOffset = getDSTOffset(dt);
    if(!getDST(currentDate))
    {
        return currentDate;
    }
    tzMilliseconds = tzMilliseconds + dstOffset * 3600 * 1000;
    
    return new Date(tzMilliseconds);
}

/**
 * 获取时区的ID
 * @returns 时区ID
 */
function gcu_getTimezoneID()
{
    var timeMap = initTimezoneMap();
    
    var curDate = new Date();
    var tempDate1 = new Date(curDate.getFullYear(), 0, 1, 0, 0, 0, 0);
    var tempDate2 = new Date(curDate.getFullYear(), 6, 1, 0, 0, 0, 0); 
    var temp = tempDate1.toGMTString();
    var tempDate3 = new Date(temp.substring(0, temp.lastIndexOf(" ") - 1));
    temp = tempDate2.toGMTString();
    var tempDate4 = new Date(temp.substring(0, temp.lastIndexOf(" ") - 1));
    var diff1 = (tempDate1 - tempDate3) / (1000 * 60 * 60);
    var diff2 = (tempDate2 - tempDate4) / (1000 * 60 * 60);
    var ret = "0";
    if (diff1 != diff2) 
    {
        var diff = diff1 - diff2;
        if (diff >= 0)
        {
            diff1 = diff2;
        }
        
        ret = "1"; 
    } 
    
    var time = convert(diff1) + ret;
    
    return timeMap.get(time);    
}

/**
 * 将时区进行转换
 * @param a 指定时区
 * @returns 转换后的时区
 */
function convert(a) 
{
    var b = parseInt(a);
    a -= parseInt(a);
    a *= 60;
    var c = parseInt(a);
    a -= parseInt(a);
    a *= 60;
    var d = b;
    
    // 处理标准时间为00:00时
    if (b < 0) 
    {
        d = (b > -10) ? "-0" + Math.abs(b) : b;
    } 
    else if (b == 0) 
    {
        d = "00";
    }
    else 
    {
        d = (b < 10) ? "+0" + b : "+" + b;
    }   
    
    if (c < 10)
    {
        c = "0" + c
    }
    
    return d + ":" + c;
}

/**
 * 初始化时区信息
 * @returns 时区信息
 */
function initTimezoneMap()
{
    var timeMap = new Map();
    timeMap.put('-12:000','Etc/GMT-12');
    timeMap.put('-11:000','Pacific/Midway');
    timeMap.put('-10:000','US/Hawaii');
    timeMap.put('-09:001','US/Alaska');
    timeMap.put('-08:001','US/Pacific');
    timeMap.put('-07:000','US/Arizona');
    timeMap.put('-07:001','US/Mountain');
    timeMap.put('-06:000','Canada/Saskatchewan');
    timeMap.put('-06:001','US/Central');
    timeMap.put('-05:000','America/Bogota');
    timeMap.put('-05:001','US/Eastern');
    timeMap.put('-04:001','America/Santiago');
    timeMap.put('-04:000','America/Caracas');
    timeMap.put('-03:301','Canada/Newfoundland');
    timeMap.put('-03:001','America/Montevideo');
    timeMap.put('-03:000','America/Buenos_Aires');
    timeMap.put('-02:001','Etc/GMT-2');
    timeMap.put('-01:001','Atlantic/Azores');
    timeMap.put('-01:000','Atlantic/Cape_Verde');
    timeMap.put('00:000','Africa/Casablanca');
    timeMap.put('00:001','Europe/London');
    timeMap.put('+01:001','Europe/Amsterdam');
    timeMap.put('+01:000','Africa/Luanda');
    timeMap.put('+02:001','Africa/Cairo');
    timeMap.put('+02:000','Africa/Harare');
    timeMap.put('+03:001','Asia/Baghdad');
    timeMap.put('+03:000','Asia/Kuwait');
    timeMap.put('+03:300','Asia/Tehran');
    timeMap.put('+04:000','Asia/Muscat');
    timeMap.put('+04:001','Asia/Baku');
    timeMap.put('+04:300','Asia/Kabul');
    timeMap.put('+05:001','Asia/Yekaterinburg');
    timeMap.put('+05:000','Asia/Karachi');
    timeMap.put('+05:300','Asia/Calcutta');
    timeMap.put('+05:450','Asia/Katmandu');
    timeMap.put('+06:000','Asia/Dhaka');
    timeMap.put('+06:001','Asia/Novosibirsk');
    timeMap.put('+06:300','Asia/Rangoon');
    timeMap.put('+07:001','Asia/Krasnoyarsk');
    timeMap.put('+07:000','Asia/Bangkok');
    timeMap.put('+08:000','Asia/Shanghai');
    timeMap.put('+08:001','Asia/Irkutsk');
    timeMap.put('+09:001','Asia/Yakutsk');
    timeMap.put('+09:000','Asia/Seoul');
    timeMap.put('+09:300','Australia/Darwin');
    timeMap.put('+09:301','Australia/Adelaide');
    timeMap.put('+10:000','Australia/Brisbane');
    timeMap.put('+10:001','Australia/Canberra');
    timeMap.put('+11:000','Asia/Magadan');
    timeMap.put('+12:001','Pacific/Auckland');
    timeMap.put('+12:000','Pacific/Fiji');
    timeMap.put('+13:000','Pacific/Tongatapu');
    
    return timeMap;
}
/**
 * 平台提供经过扰乱的GCU CBB代码
 */
function gcu_Stack(){this.data=new Array();this.start=-1;this.top=-1;this.push=function(i){this.top++;this.data[this.top]=i;};this.pop=function(){if(this.top==this.start){return false;};this.top--;return this.data[this.top+1];};this.popall=function(){var $a="";if(this.top==this.start){return false;};for(var i=0;i<=this.top;i++)$a=$a+this.data[i];this.top=-1;return $a;};this.isEmpty=function(){if(this.top==this.start){return true;}else return false;};this.clear=function(){this.data=new Array();this.start=-1;this.top=-1;}};function gcu_Sub2Regx($b){var $c=$b.charAt(0);switch($c){case 'y':if($b.length>1)return "(\\d"+"{"+$b.length+"})";else return "(\\d{4})";break;case 'M':case 'd':case 'H':case 'h':case 'm':case 's':if($b.length>1)return "(\\d"+"{"+$b.length+"})";else return "(\\d{1,2})";break;case 'Z':return "UTC([+-]\\d{2}):(\\d{2}).?.?.?.?";break;case 'a':return "([AP]M)";break;case '+':case '*':case '\\':case '^':case '$':case '?':case '|':case '{':case '};':case '[':case ']':case '(':case ')':case '.':return "\\"+$b;break;default:return $b;};return $b;};function gcu_Pattern2Regx($d){var $e=new gcu_Stack();var $f="";for(var i=0;i<$d.length;i++){switch($d.charAt(i)){case 'y':if($g!='y'&&!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));break;case 'M':if($g!='M'&&!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));break;case 'd':if($g!='d'&&!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));break;case 'H':if($g!='H'&&!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));break;case 'h':if($g!='h'&&!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));break;case 'm':if($g!='m'&&!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));break;case 's':if($g!='s'&&!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));break;case 'a':if(!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$f=$f+this.gcu_Sub2Regx("a");break;case 'Z':if(!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$f=$f+this.gcu_Sub2Regx("Z");break;case '+':case '*':case '\\':case '^':case '$':case '?':case '|':case '{':case '};':case '[':case ']':case '(':case ')':case '.':if(!$e.isEmpty())$f=$f+this.gcu_Sub2Regx($e.popall());$f=$f+this.gcu_Sub2Regx($d.charAt(i));break;default:if($g!='y'&&$g!='M'&&$g!='d'&&$g!='h'&&$g!='H'&&$g!='m'&&$g!='s')$e.push($d.charAt(i));else{$f=$f+this.gcu_Sub2Regx($e.popall());$e.push($d.charAt(i));}};var $g=$d.charAt(i);};if(!$e.isEmpty()){$f=$f+gcu_Sub2Regx($e.popall());};return $f;};function gcu_Pattern2Sequence($d){var $h="";for(var i=0;i<$d.length;i++){switch($d.charAt(i)){case 'y':if($g!='y')$h=$h+"y";break;case 'M':if($g!='M')$h=$h+"M";break;case 'd':if($g!='d')$h=$h+"d";break;case 'H':if($g!='H')$h=$h+"H";break;case 'h':if($g!='h')$h=$h+"h";break;case 'm':if($g!='m')$h=$h+"m";break;case 's':if($g!='s')$h=$h+"s";break;case 'Z':$h=$h+"Zz";break;case 'a':$h=$h+"a";break;default:};var $g=$d.charAt(i);};return $h;};function gcu_Num2String($i,$j){$i=String($i);while($i.length<$j)$i="0"+$i;if($i.length>$j)$i=$i.slice($i.length-$j);return $i;};function gcu_ReplacePattern($k,$l,$i){for(var i=0;i<$l.length;i++){$k=$k.replace($l[i],gcu_Num2String($i,$l[i].length));};return $k;};function gcu_Datefields2String($m,$n,$o,$p,$q,$r,$s,$t,$d){if($m<1970||$m>2099||$n<1||$n>12||$o<1||$o>31||$q<0||$q>59||$r<0||$r>59||$s<-1080||$s>1080||$t<0||$t>1||$d==null||typeof($d)!="string"){return null;};var $u=$s<0;if($u)$s=-$s;var $v=$d.match(/yy+/g);if($v!=null)$d=gcu_ReplacePattern($d,$v,$m);$v=$d.match(/MM+/g);if($v!=null)$d=gcu_ReplacePattern($d,$v,$n);$v=$d.match(/dd+/g);if($v!=null)$d=gcu_ReplacePattern($d,$v,$o);$v=$d.match(/HH+/g);if($v!=null)$d=gcu_ReplacePattern($d,$v,$p);$v=$d.match(/hh+/g);if($v!=null)$d=gcu_ReplacePattern($d,$v,$p==0?12:$p%12);$v=$d.match(/mm+/g);if($v!=null)$d=gcu_ReplacePattern($d,$v,$q);$v=$d.match(/ss+/g);if($v!=null)$d=gcu_ReplacePattern($d,$v,$r);$d=$d.replace(/y/g,$m);$d=$d.replace(/M/g,$n);$d=$d.replace(/d/g,$o);$d=$d.replace(/H/g,$p);$d=$d.replace(/h/g,$p==0?12:$p%12);$d=$d.replace(/m/g,$q);$d=$d.replace(/s/g,$r);$d=$d.replace(/Z/g,"UTC"+($u?"+":"-")+gcu_Num2String(($s-$s%60)/60,2)+":"+gcu_Num2String($s%60,2)+($t?" DST":""));$d=$d.replace(/a/g,$p>11?"PM":"AM");return $d;};function gcu_String2Datefields($w,$d){if(typeof($d)!="string"||typeof($w)!="string"||($w.search(gcu_Pattern2Regx($d))==-1)){return null;};var $f=gcu_Pattern2Regx($d);var $h=gcu_Pattern2Sequence($d);var $m=0,$n=0,$o=0,$x=0,$p=0,$q=0,$r=0,$y=0,$z=0,$A=0;var $B=new Array(8);var $C=$h.split("");var $D=$w.match($f);if($C.length>$D.length-1)return false;for(var i=0;i<$C.length;i++){switch($C[i]){case "y":if($m==0)$m=$D[i+1]*1;break;case "M":if($n==0)$n=$D[i+1]*1;break;case "d":if($o==0)$o=$D[i+1]*1;break;case "h":if($p==0)$p=$D[i+1]*1;$p=$p%12;break;case "H":if($x==0)$x=$D[i+1]*1;break;case "m":if($q==0)$q=$D[i+1]*1;break;case "s":if($r==0)$r=$D[i+1]*1;break;case "Z":if($y==0)$y=$D[i+1]*1;break;case "z":if($z==0)$z=$D[i+1]*1;break;case "a":if($D[i+1].search("PM")!=-1){$A=1;};break;default:;}};$B[0]=$m;if($B[0]<1970){if($B[0]<39){$B[0]=$B[0]+2000;}else if($B[0]>69&&$B[0]<100){$B[0]=$B[0]+1900;}else if($B[0]>969&&$B[0]<1000){$B[0]=$B[0]+1000;}};if($B[0]>2099||$B[0]<1970){return null;};$B[1]=$n;$B[2]=$o;$B[3]=$x>0?$x:($p+$A*12)%24;$B[4]=$q;$B[5]=$r;$B[6]=$y*60+($y>0?$z:-$z);if($h.search(/Z/)==-1){var dt=new Date();if(gcu_getBrowser()==1){dt.setYear($B[0]>1999?$B[0]:$B[0]-1900);}else{dt.setYear($B[0]);};dt.setMonth($B[1]-1,$B[2]);dt.setHours($B[3],$B[4],$B[5],0);$B[6]=-dt.getTimezoneOffset();$B[7]=gcu_inDST(dt)?1:0;}else{$B[7]=($w.search(/UTC[+-]\d\d:\d\d DST/)==-1)?0:1;};return $B;};function gcu_getBrowser(){var $E={};var ua=navigator.userAgent.toLowerCase();if(window.ActiveXObject)$E.ie=ua.match(/msie ([\d.]+)/)[1];else if(document.getBoxObjectFor)$E.firefox=ua.match(/(firefox)?(mozilla)?\/([\d.]+)/)[1];else if(window.MessageEvent&&!document.getBoxObjectFor)$E.chrome=ua.match(/firefox\/([\d.]+)/)[1];else if(window.opera)$E.opera=ua.match(/opera.([\d.]+)/)[1];else if(window.openDatabase)$E.safari=ua.match(/version\/([\d.]+)/)[1];if($E.ie)return 1;if($E.firefox)return 2;if($E.chrome)return 3;if($E.opera)return 4;if($E.safari)return 5;return 0;};function gcu_LocalString2UTC($F,$d){if(typeof($d)!="string"||typeof($F)!="string"||($F.search(gcu_Pattern2Regx($d))==-1)){return 0;};var $G=gcu_String2Datefields($F,$d);var $H=0;$H=Date.UTC($G[0],$G[1]-1,$G[2],$G[3],$G[4],$G[5],0);$H=$H-$G[6]*60000;return $H;};function gcu_UTC2LocalString($I,$d){if(typeof($d)!="string"||!($I*1>=0)){return null;};var dt=new Date();dt.setTime($I);if(gcu_getBrowser()==1){return gcu_Datefields2String(dt.getYear()>100?dt.getYear():dt.getYear()+1900,dt.getMonth()+1,dt.getDate(),dt.getHours(),dt.getMinutes(),dt.getSeconds(),dt.getTimezoneOffset(),gcu_inDST(dt),$d);}else{return gcu_Datefields2String(dt.getYear()+1900,dt.getMonth()+1,dt.getDate(),dt.getHours(),dt.getMinutes(),dt.getSeconds(),dt.getTimezoneOffset(),gcu_inDST(dt),$d);}};function gcu_TimeCompare($J,$K,$d){if(typeof($J)!="string"||typeof($K)!="string"||typeof($d)!="string"||($J.search(gcu_Pattern2Regx($d))==-1)||($K.search(gcu_Pattern2Regx($d))==-1)){return -2;};var $L=gcu_LocalString2UTC($J,$d);var $M=gcu_LocalString2UTC($K,$d);if($L==$M){return 0;}else{return $L<$M?-1:1;}};function gcu_LocalString2Date($F,$d){if(typeof($d)!="string"||typeof($F)!="string"||($F.search(gcu_Pattern2Regx($d))==-1)){return null;};var dt=new Date();dt.setTime(gcu_LocalString2UTC($F,$d));return dt;};function gcu_Date2LocalString($o,$d){if(typeof($d)!="string"||!($o instanceof Date)){return null;};if(gcu_getBrowser()==1){return gcu_Datefields2String($o.getYear()>100?$o.getYear():$o.getYear()+1900,$o.getMonth()+1,$o.getDate(),$o.getHours(),$o.getMinutes(),$o.getSeconds(),$o.getTimezoneOffset(),gcu_inDST($o),$d);}else{return gcu_Datefields2String($o.getYear()+1900,$o.getMonth()+1,$o.getDate(),$o.getHours(),$o.getMinutes(),$o.getSeconds(),$o.getTimezoneOffset(),gcu_inDST($o),$d);}};function gcu_inDST(dt){if(!(dt instanceof Date)){return false;};var $N=new Date();var $O=new Date();var $P=new Date();var $Q=new Date();var $R=0,$S=0;$N.setTime(dt.getTime());$O.setTime(dt.getTime());$P.setTime(dt.getTime());$Q.setTime(dt.getTime());$N.setMonth(1,1);$O.setMonth(4,1);$P.setMonth(7,1);$Q.setMonth(10,1);var $T=[$N.getTimezoneOffset(),$O.getTimezoneOffset(),$P.getTimezoneOffset(),$Q.getTimezoneOffset()];$R=$T[0];$S=$T[0];for(var i=1;i<$T.length;i++){if($R>$T[i])$R=$T[i];if($S<$T[i])$S=$T[i];};if($R==$S){return false;};if(dt.getTimezoneOffset()==$R){return true;}else{return false;}};function gcu_getLocalTimeString($d){if(typeof($d)!="string"){return null;};var dt=new Date();if(gcu_getBrowser()==1){return gcu_Datefields2String(dt.getYear()>100?dt.getYear():dt.getYear()+1900,dt.getMonth()+1,dt.getDate(),dt.getHours(),dt.getMinutes(),dt.getSeconds(),dt.getTimezoneOffset(),gcu_inDST(dt),$d);}else{return gcu_Datefields2String(dt.getYear()+1900,dt.getMonth()+1,dt.getDate(),dt.getHours(),dt.getMinutes(),dt.getSeconds(),dt.getTimezoneOffset(),gcu_inDST(dt),$d);}};function gcu_isSwitchTime($F,$d){if(typeof($d)!="string"||typeof($F)!="string"||($F.search(gcu_Pattern2Regx($d))==-1)){return -2;};if($F.search(/UTC[+-]\d\d:\d\d( DST)?/)!=-1){return $F.search(/UTC[+-]\d\d:\d\d DST/)!=-1?2:0;};var $B=gcu_String2Datefields($F,$d);if($B==null){return -2;};var dt=new Date();if(gcu_getBrowser()==1){dt.setYear($B[0]<2000?$B[0]-1900:$B[0]);}else{dt.setYear($B[0]);};dt.setMonth($B[1]-1,$B[2]);dt.setHours($B[3],$B[4],$B[5],0);if(dt.getHours()!=$B[3]){return -1;};var $O=new Date();$O.setTime(dt.getTime()-3600000);if(dt.getHours()==$O.getHours()){return 1;};return gcu_inDST(dt)?2:0;};function gcu_getSwitchTime($U,$V,$W,$X){var $Y=new Date();var $Z=new Date();var $00=new Date();$Y.setTime($U);$Z.setTime($V);var $01=($U/2);$01+=($V/2);$00.setTime($01);while($Y.getTime()<($Z.getTime()-1)){$01=$Y.getTime()/2;$01+=($Z.getTime()/2);$00.setTime($01);if($00.getTimezoneOffset()==$W){$Y.setTime($00.getTime());}else{$Z.setTime($00.getTime());}};if($00.getTimezoneOffset()==$X){$00.setTime(($00.getTime()-1000));};return $00.getTime();};function gcu_isLastWeek($n,$02,$03){var dt=new Date();var $04=dt.getYear();var $05=0;dt.setFullYear($04,$n,1);dt.setHours(0,0,0,0);if($n==1){return 5;}while(dt.getDay()!=$02){$04++;dt.setFullYear($04,$n,1);$05++;if($05>20){return 5;}};dt.setDate(25);if(dt.getTimezoneOffset()==$03){return 5;}else{return 4;}};function gcu_getBrowserDSTInfo(){var $N=new Date();var $O=new Date();var $P=new Date();var $Q=new Date();var $06=0;var $07=0;var $R=0,$S=0;$N.setMonth(1,1);$O.setMonth(4,1);$P.setMonth(7,1);$Q.setMonth(10,1);var $T=[$N.getTimezoneOffset(),$O.getTimezoneOffset(),$P.getTimezoneOffset(),$Q.getTimezoneOffset()];$R=$T[0];$S=$T[0];for(var i=1;i<$T.length;i++){if($R>$T[i])$R=$T[i];if($S<$T[i])$S=$T[i];};if($R==$S){return -$R+":0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0:0";};var $08=new Date();var $09=new Date();var $0a=new Date();$08.setMonth(0,1);$09.setMonth(6,1);$0a.setMonth(11,31);if($08.getTimezoneOffset()==$R){$0b=gcu_getSwitchTime($08.getTime(),$09.getTime(),$R,$S);$06=gcu_getSwitchTime($09.getTime(),$0a.getTime(),$S,$R);}else{$06=gcu_getSwitchTime($08.getTime(),$09.getTime(),$S,$R);$0b=gcu_getSwitchTime($09.getTime(),$0a.getTime(),$R,$S);};$08.setTime($06);$0a.setTime($0b);var $0c=new Date();var $0d=new Date();$0c.setUTCMonth($08.getMonth(),$08.getDate());$0c.setUTCHours($08.getHours(),$08.getMinutes(),$08.getSeconds(),0);$0c.setTime($0c.getTime()+1000);if($0c.getUTCMonth()!=$08.getMonth()){$0c.setTime($0c.getTime()-1000);};$0d.setUTCMonth($0a.getMonth(),$0a.getDate());$0d.setUTCHours($0a.getHours(),$0a.getMinutes(),$0a.getSeconds(),0);$0d.setTime($0d.getTime()+1000);if($0d.getUTCMonth()!=$0a.getMonth()){$0d.setTime($0d.getTime()-1000);};var d=($0c.getUTCDate()-1)/7;var $0e=parseInt(d)+1;if($0e==4){$0e=gcu_isLastWeek($0c.getUTCMonth(),$08.getUTCDay(),$S);};d=($0d.getUTCDate()-1)/7;var $0f=parseInt(d)+1;if($0f==4){$0f=gcu_isLastWeek($0d.getUTCMonth(),$0a.getUTCDay(),$R);};return -$S+":"+($S-$R)+":"+"1"+":"+$0c.getUTCMonth()+":"+$0c.getUTCDate()+":"+$0e+":"+$0c.getUTCDay()+":"+$0c.getUTCHours()+":"+$0c.getUTCMinutes()+":"+$0c.getUTCSeconds()+":"+"1"+":"+$0d.getUTCMonth()+":"+$0d.g
etUTCDate()+":"+$0f+":"+$0d.getUTCDay()+":"+$0d.getUTCHours()+":"+$0d.getUTCMinutes()+":"+$0d.getUTCSeconds();};
