/**
 * 视图管理类,用于管理特性、面板视图之间的切换
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 * @param viewManagerObj viewManager对象
 * @return
 */
function ViewsManager(viewManagerObj)
{
    // 视图管理对象
    this._viewManager = viewManagerObj;

    // 用于保存对话框
    this._manageViewMaps = new Map();

    // 用于保存当前操作的对话框
    this._currentViewName = Constants.FEATURE_VIEWID;
}

/**
 * 设置指定视图的标题
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-17
 * @param name 视图id
 * @param titleName 视图标题名称
 */
ViewsManager.prototype.setViewTitle = function(name, titleName)
{
    this._viewManager.setViewTitle(name, titleName);
}

/**
 * 加载指定视图
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 * @param name 视图id
 * @param titleName 视图标题名称
 * @param url 视图对应的url信息
 * @return
 */
ViewsManager.prototype.loadSpecialView = function(name, titleName, url)
{
    // alert(name);
    // alert(url);

    var isViewLoad = false;
    var specialView = this._manageViewMaps.get(name);
    if (null != specialView)
    {
        isViewLoad = specialView.getIsLoad();
    }

    // 视图已经加载过
    if (isViewLoad)
    {
        this._viewManager.showView(name);
        this._viewManager.setViewTitle(name, titleName);
        this._viewManager.activateView(name);
        // 隐藏当前视图
        this.hideCurrentView(name);

        // 进行显示处理
        specialView.procBeforeShow();
		
		if (name == "templeMgr")
		{
			var templetInstanceTab = this._viewManager.getWindowById(name);
			templetInstanceTab.pub_setCurrentTabId("normal");
		}
    }
    else
    {
        // 未加载过则进行加载
        var isExist = this._viewManager.hasView(name);
        // 离线时第一次切换到特性会出现帮助，去除该显示
        // if(Constants.FEATURE_VIEWID == this._currentViewName && this._currentViewName != name)
        // {
        // alert("1");
        // this._viewManager.setViewURL(Constants.FEATURE_VIEWID, GlobalConstants.EMPTY_PAGE);
        // }
        if (!isExist)
        {
            // 不存在则插入相应的视图页面
            this._viewManager.insertAfter(this._currentViewName, name,
            {
                title : titleName,
                url : url,
                detachedSize : [ 400, 300 ],
                location : "center",
                style : jse.UNDRAG | jse.UNCLOSE | jse.UNFLOAT
            });

            // 插入后将当前视图隐藏
            this.hideCurrentView(name);
        }
        else
        {
            this._viewManager.setViewURL(name, url);
            //特性界面预加载时，只是加载该界面的js文件和绘制xui，不显示该界面
            var isFeatureView = (url.indexOf(Constants.FEATURE_VIEWID) != -1);
            var isPreLoadPage = (url.indexOf("preLoadPage=true") != -1); 
            var isPreLoadFeatureView = (isFeatureView && isPreLoadPage);
            if(!isPreLoadFeatureView)
            {
                this._viewManager.showView(name);
                this._viewManager.setViewTitle(name, titleName);
                this._viewManager.activateView(name);
                this.hideCurrentView(name); 
            }
        }
    }

    // 视图对象
    var viewObj = this.creatViewObject(name, this._viewManager.getWindowById(name));

    // 等面板改完后再修改此处，暂时放到这里置为true，应该放到相应的视图加载处理中设置
    viewObj.setIsLoad(true);

    // 放入管理map中
    this._manageViewMaps.put(name, viewObj);

}

ViewsManager.prototype.addView = function(id,title,url)
{
    if(this._viewManager(id))
    {
        return;
    }
    this._viewManager.addView(id,
    {
        title : title,
        url : url,
        detachedSize : [ 500, 400 ],
        location : "center",
        style : jse.UNCLOSE | jse.UNDRAG | jse.UNFLOAT
    });
}
/**
 * 设置指定视图是否已经加载完毕接口
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-4-1
 * @param ViewName 视图id
 * @return
 */
ViewsManager.prototype.setSpecialViewIsLoad = function(viewName)
{
    var specialView = this._manageViewMaps.get(viewName);
    if (null != specialView)
    {
        // 设置已经加载完毕
        specialView.setIsLoad(true);
    }
}

/**
 * 隐藏当前显示视图处理,并更新信息
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 * @param showViewName 要显示的视图id
 * @return
 */
ViewsManager.prototype.hideCurrentView = function(showViewName)
{
    if (this._currentViewName != showViewName)
    {
        // 获取当前视图对象，进行隐藏前处理
        var currentObj = this._manageViewMaps.get(this._currentViewName);
        if (null != currentObj)
        {
            currentObj.procBeforeHide();
        }

        // 隐藏当前视图
        this._viewManager.hideView(this._currentViewName);
        // 将当前显示对话框修改
        this._currentViewName = showViewName;
    }
}

/**
 * 创建相应的视图类对象
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-4-1
 * @param ViewName 视图id
 * @param winObj 视图内容
 * @return
 */
ViewsManager.prototype.creatViewObject = function(ViewName, winObj)
{
    var viewObject = null;
    switch (ViewName)
    {
        case Constants.FEATURE_VIEWID:// 特性视图对象
        {
            viewObject = new FeatureView(ViewName, winObj);
            break;
        }
        case Constants.PANEL_VIEWID:// 面板视图对象
        {
            viewObject = new PanelView(ViewName, winObj);
            break;
        }
        case Constants.FEATURE_TREEEDITVIEW: // 离线树表编辑视图对象
        {
            viewObject = new FeatureTreeEditView(ViewName, winObj);
            break;
        }
        case Constants.TEMPLET_TEMPLETMGRVIEW: // 模板管理视图对象
        {
            viewObject = new TempletMgrView(ViewName, winObj);
            break;
        }
        default:
        {
            viewObject = new ViewObject(ViewName, winObj);
        }
    }

    return viewObject;
}

/**
 * 类继承方式（后续会放到公共处理中，暂时放这）
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 * @param subClass 子类对象
 * @param superClass 父类对象
 * @return
 */
function extend(subClass, superClass)
{
    var F = function()
    {
    };
    F.prototype = superClass.prototype;
    subClass.prototype = new F();
    subClass.prototype.constructor = subClass;

    subClass.superclass = superClass.prototype;
    if (superClass.prototype.constructor == Object.prototype.constructor)
    {
        superClass.prototype.constructor = superClass;
    }
}

/**
 * 视图对象基类，后续若新增定制界面（与特性管理/面板并列），如有特殊处理需要重写该基类方法
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 * @param name 视图名称
 * @param winObj 视图win对象
 * @return
 */
function ViewObject(name, winObj)
{
    this._viewName = name;
    this._isLoad = false;
    this._winObj = winObj;
}

/**
 * 设置是否加载过
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 * @param isLoad 是否已经加载
 * @return
 */
ViewObject.prototype.setIsLoad = function(isLoad)
{
    this._isLoad = isLoad;
}

/**
 * 获取是否加载过
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
ViewObject.prototype.getIsLoad = function()
{
    return this._isLoad;
}

/**
 * 显示视图前的处理
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
ViewObject.prototype.procBeforeShow = function()
{
    if ((null != this._winObj) && typeof (this._winObj.pub_refreshLocalView) == "function")
    {
        // 刷新页面
        this._winObj.pub_refreshLocalView();
    }
}

/**
 * 隐藏视图前的处理
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
ViewObject.prototype.procBeforeHide = function()
{
}

/**
 * 离线树表视图
 * 
 * @author c00149107
 * @since iManager U2000 V1R3,2010-9-1
 */
function FeatureTreeEditView(name, winObj)
{
    FeatureView.superclass.constructor.call(this, name, winObj);
}

// 指定基类
extend(FeatureTreeEditView, ViewObject);

/**
 * 刷新离线树表
 * 
 * @author c00149107
 * @since iManager U2000 V1R3,2010-9-1
 */
FeatureTreeEditView.prototype.procBeforeShow = function()
{
    if ((null != this._winObj) && typeof (this._winObj.pub_refreshLocalView) == "function")
    {
        // 刷新页面
        this._winObj.pub_refreshLocalView();
    }
}

/**
 * 特性视图
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
function FeatureView(name, winObj)
{
    FeatureView.superclass.constructor.call(this, name, winObj);
}

// 指定基类
extend(FeatureView, ViewObject);

/**
 * 特性视图
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
FeatureView.prototype.procBeforeShow = function()
{
    if ((null != this._winObj) && typeof (this._winObj.pub_refreshLocalView) == "function")
    {
        // 刷新页面
        this._winObj.pub_refreshLocalView();
    }
}

/**
 * 面板视图
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
function PanelView(name, winObj)
{
    PanelView.superclass.constructor.call(this, name, winObj);
}

// 指定基类
extend(PanelView, ViewObject);

/**
 * 隐藏面板视图前的处理
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
PanelView.prototype.procBeforeHide = function()
{
    if ((null != this._winObj) && typeof (this._winObj.pub_procHideView) == "function")
    {
        _winObj.pub_procHideView();
    }
}

/**
 * 显示面板视图前的处理
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-3-24
 */
PanelView.prototype.procBeforeShow = function()
{
    if ((null != this._winObj) && ('undefined' != typeof this._winObj.pub_procShowView)
            && (this._winObj.pub_procShowView instanceof Function))
    {
        this._winObj.pub_procShowView();
    }
}

/**
 * 模板管理视图
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-7
 * @return
 */
function TempletMgrView(name, winObj)
{
    // TempletMgrView.superclass.constructor.call(this, name, winObj);
    ViewObject.call(this, name, winObj);
}

// 指定基类
// extend(TempletMgrView, ViewObject);
TempletMgrView.prototype = new ViewObject();
/**
 * 刷新模板管理表内容
 * 
 * @author c00149107
 * @since iManager U2000 V1R3,2010-9-1
 */
TempletMgrView.prototype.procBeforeShow = function()
{
    if ((null != this._winObj) && typeof (this._winObj.pub_refreshLocalView) == "function")
    {
        // 刷新页面
        this._winObj.pub_refreshLocalView();
    }
}