jse.require("jse.widget.dialog");

/**
 * 返回报文解析成DOM对象
 */
var doc = null;
/**
 * 是否已经登录设备标识
 */
var isLoginDev = false;
/**
 * 语言标识符
 */
var flag = true;
/**
 * 子对话框对象
 */
var subDlg = null;
/**
 * 错误对话框的对象
 */
var errorDlg = null;
/**
 * 返回报文解析成DOM对象
 */
var doc = null;

var deviceMgrWin = null;
/**
 * 获取常量对象
 */
var Constants = new Constants();

var isShowDevMgrWarning = true;
var MainPageView = null;

var pageType = "devicemgr";

var g_jsonrpc = null;

/**
 * 映射表,在device.xui界面文件中定义的事件都在此映射表中做 映射 并在此文件中处理
 */
var signalMap =
{
    on_load_ui :doLoad
};
/**
 * 初始化方法
 * 
 * @return
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/systemmgr/deviceframe/devicewindow.xui", signalMap);
}

/**
 * 加载页面初始设置
 */
function doLoad()
{
    MainPageView = window.xui.getWidget("MainPageView");
    deviceMgrWin = MainPageView.getContentWin();
    // 设置语言标识
    if ("zh_CN" == lang)
    {
        flag = true;
    }
    else
    {
        flag = false;
    }
    // 设置语言
    jse.setLanguage(lang);
    // 获取界面控件

    // 获取界面显示的中英文资源并显示
    window.document.title = jse.getI18nValue("qat:public", "qat.title_d");
}

function closeDeviceMgrPageForTimeOut()
{
    isShowDevMgrWarning = false;
    if (navigator.userAgent.indexOf("MSIE") > 0)
    {
        window.close();
    }
    if (navigator.userAgent.indexOf("Firefox") > 0)
    {
        window.location.href = CommonUtil.getRootPath() + "/vmt/index.html";   
    }
}

/**
 * 退出系统
 */
function pub_Exit()
{
    deviceMgrWin.isShowDeviceMgrWarning = true;
    if ("true" == independence)
    {
        // 转向登录页面
        window.location.href = CommonUtil.getRootPath() + "/vmt/index.html";
    }
    else
    {
        window.close();
    }
}

function doExit()
{
    MainPageView.getContentWin().doExit();
}

/**
 * 重写onbeforeunload事件
 */
window.onbeforeunload = logoutSystemWarning;

/**
 * 重写onunload事件
 */
window.onunload = logoutSystem;

/**
 * 退出设备管理页面警告信息
 */
function logoutSystemWarning()
{
    var warning = jse.getI18nValue("qat:public", "label.existne_d");

    if (isShowDevMgrWarning)
    {
        return warning;
    }
    else
    {
        return;
    }

    return warning;
}

/**
 * 退出事件处理
 * 
 * @return
 */
function logoutSystem()
{
    var req = jse.RpcRequest
            .create(CommonUtil.getRootPath() + "/vmt/security/logoutaction.do?methodID=logout&pageType=DEVICEMGR");
    req.invoke(handleLogoutResponse);
}

/**
 * 退出工具回调函数
 */
function handleLogoutResponse(errorCode, request)
{
    if (errorCode == 0)
    {
        // 获取异步请求过来的文本内容
        var text = request.responseText;
        // 将 xml字符串解析为 DOM 对象
        doc = jse.loadXML(text);
        // 获取节点
        var node = jse.selectSingleNode("/response/operResultType", doc);

        // 获取节点 resultType 属性值
        var resultType = node.getAttribute("resultType");

        // 是否需要更新标识
        var isUpdate = null;
        // 处理请求成功情况下
        if (Constants.OPER_NOK == resultType)
        {
            // 显示错误信息
            VMTError("win.errorClose();");
        }
    }
}

/**
 * 关闭错误对话框
 * 
 * @return
 */
function errorClose()
{
//    errorDlg.dispose();
}

/**
 * 设置错误对话框大小
 * 
 * @param width
 * @param height
 */
function setPreferSize(width, height)
{
    errorDlg.setPreferSize(width, height);
}

/**
 * 刷新页面
 */
function pub_refresh()
{
    // 请求刷新界面
    var req = jse.RpcRequest
            .create(CommonUtil.getRootPath() + "/vmt/security/logoutaction.do?methodID=switchlanguage");
    req.invoke(handleResult, [ "handleRefreshResponse();" ]);
}

/**
 * 刷新页面回调方法
 */
function handleRefreshResponse()
{
    if (Constants.OPER_OK == resultType)
    {
        // 刷新主界面
        enterSystem();
    }
}
/**
 * 设置语言按钮的状态
 */
function setLangBtnState(flag)
{
    var langBtn = topPageWin.xui.getWidget("toolbtnLanguage");
    langBtn.setEnabled(flag);
}

/**
 * 获取json对象接口
 * @author w00131173
 * @since iManager U2000 V1R6,2012-6-19
 */
function pub_getJsonRpcObj()
{
    if(null == g_jsonrpc)
    {
        g_jsonrpc = new VmtJsonRPC();
    }
    
    return g_jsonrpc;
}

Event.observe(window, "load", init);