/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.translator.impl;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.debug.TimeRecStack;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.domain.PreciseQueryCondition;
import com.huawei.vmf.qat.persistence.domain.RowData;
import com.huawei.vmf.qat.persistence.domain.TableDesc;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.SyncData;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import com.huawei.vmf.qat.persistence.syncdata.alone.SynDataRequstHelper;
import com.huawei.vmf.qat.persistence.translator.DBDataTranslator;
import com.huawei.vmf.qat.schemaprocessor.infomodel.AttributeType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.BasicType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.MOType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.PropertyType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.Type;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import com.huawei.vmf.qat.xmlprocessor.infomodel.MOXMLBuilder;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DBDataTranslatorImpl
implements DBDataTranslator {
    private static final int HEX = 16;
    private Logger logger = RunLogger.getRunLogger();
    private MOXMLBuilder moXMLBuilder;
    private Map<PolicyQuery.DTV, ContentScan> dtv2Scan = new HashMap<PolicyQuery.DTV, ContentScan>();

    @Override
    public String xpath2colName(String xPath, String objXpath) {
        if (!objXpath.endsWith("/")) {
            objXpath = objXpath + "/";
        }
        String relXpath = TableDesc.getRelXpathFromAbsXpath(xPath, objXpath);
        if (-1 != xPath.indexOf("]")) {
            return Activator.svcFactory.getPolicyQueryService().propStr2ColName(relXpath);
        }
        return Activator.svcFactory.getPolicyQueryService().relXpath2ColName(relXpath);
    }

    @Override
    public String colName2Xpath(String col, String objXpath) {
        if (!objXpath.endsWith("/")) {
            objXpath = objXpath + "/";
        }
        String relXpath = "";
        String propName = Activator.svcFactory.getPolicyQueryService().colName2PropName(col);
        relXpath = null == propName ? Activator.svcFactory.getPolicyQueryService().colName2RelXpath(col) : Activator.svcFactory.getPolicyQueryService().colName2RelXpath(col) + "]" + propName;
        return TableDesc.getAbsXpathFromRelXpath(relXpath, objXpath);
    }

    @Override
    public DevConfig getDevCfgByIdentifyAndVR(String devIP, int devID, int vrID) {
        DevChange.DevIdentify dv = new DevChange.DevIdentify(devIP, devID);
        return Activator.svcFactory.getDevChangeService().constructCfgsWithDev(dv, vrID);
    }

    @Override
    public List<RowData> parseMOListToRowData(List<LightMO> mos, String currentMOXpath) {
        ArrayList<RowData> rowDataList = new ArrayList<RowData>();
        for (LightMO mo : mos) {
            rowDataList.add(this.parseMOToRowData(mo, currentMOXpath));
        }
        return rowDataList;
    }

    @Override
    public boolean parseSyncAllData(String DevIP, int iDevID, String devType, String devVersion, String filePath, int iFlowID, String sysUpTime) {
        if (!this.hasCachePolicy(devType, devVersion)) {
            return true;
        }
        SyncData syncData = Activator.svcFactory.getSyncDataService();
        DevChange.DevInfo dv = new DevChange.DevInfo(new DevChange.DevIdentify(DevIP, iDevID), devType, devVersion);
        List<DevConfig> devCfgList = DevMgr.instance().getPersistDevCfg(dv.devIdentify);
        if (null == devCfgList || devCfgList.size() == 0) {
            try {
                DevMgr.instance().addDev(dv);
                devCfgList = DevMgr.instance().getPersistDevCfg(dv.devIdentify);
            }
            catch (PersistenceException e1) {
                this.logger.error("parseSyncAllData DevMgr addDev error,dv=" + dv);
            }
        }
        for (DevConfig devCfg : devCfgList) {
            syncData.reNewCfgDB(devCfg);
            syncData.syncBegin(devCfg);
            syncData.createTable(devCfg);
        }
        TimeRecStack tr = new TimeRecStack("SyncAll", System.out, 0);
        tr.setPrint(true);
        try {
            tr.start("construct db");
            boolean r = SynDataRequstHelper.getFullSyncData(syncData, dv, filePath);
            for (DevConfig devCfg : devCfgList) {
                syncData.syncEnd(devCfg, r, iFlowID, 0L);
            }
            tr.stop();
            if (!r) {
                this.logger.error("syncall failed!!!");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("parse package error, syncAll failed!");
            for (DevConfig devCfg : devCfgList) {
                syncData.syncEnd(devCfg, false, iFlowID, 0L);
            }
            return false;
        }
        AloneDeploySchedule.addDevToDevMap(dv, iFlowID, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK);
        this.logger.info("SyncAll in DB success dev= " + dv);
        return true;
    }

    @Override
    public boolean parseIncrSyncData(String devIP, int devID, String devType, String devVersion, Map<DevConfig, List<String>> replys, int iFlowID) {
        if (!this.hasCachePolicy(devType, devVersion)) {
            return true;
        }
        SyncData syncData = Activator.svcFactory.getSyncDataService();
        Set<Map.Entry<DevConfig, List<String>>> replyEntry = replys.entrySet();
        for (Map.Entry<DevConfig, List<String>> entry : replyEntry) {
            DevConfig cfg = entry.getKey();
            List<String> replyList = entry.getValue();
            syncData.incInit(cfg);
            try {
                for (String content : replyList) {
                    if (syncData.incSync(cfg, new StringBuffer(content))) continue;
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DevChange.DevInfo dv = new DevChange.DevInfo(new DevChange.DevIdentify(devIP, devID), devType, devVersion);
        AloneDeploySchedule.addDevToDevMap(dv, iFlowID, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK);
        return true;
    }

    @Override
    public String genFullSyncContent(String devType, String devVersion, String content) {
        if (!this.hasCachePolicy(devType, devVersion)) {
            return content;
        }
        content = "<mylabel>" + content + "</mylabel>";
        PolicyQuery o = Activator.svcFactory.getPolicyQueryService();
        PolicyQuery.DTV dtv = new PolicyQuery.DTV(devType, devVersion);
        ContentScan scan = this.getScanContent(dtv, new InputSource(new StringReader(content)));
        if (null == scan) {
            String errMsg = "getScanContent from (" + content + ") failed!";
            this.logger.error(errMsg);
            return null;
        }
        List adapterXpathList = scan.xpathList;
        StringBuilder sb = new StringBuilder();
        o.getSynAllCont4Adapter(sb, dtv, adapterXpathList);
        return sb.toString();
    }

    private boolean hasCachePolicy(String devType, String devVersion) {
        PolicyQuery.DTV dtv;
        PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
        return pq.getTableDesc(dtv = new PolicyQuery.DTV(devType, devVersion)) != null;
    }

    private ContentScan getScanContent(PolicyQuery.DTV dtv, InputSource inContent) {
        ContentScan scan = this.dtv2Scan.get(dtv);
        if (scan == null) {
            scan = new ContentScan(dtv);
            this.dtv2Scan.put(dtv, scan);
        }
        scan.init(dtv);
        try {
            boolean r = this.genXpthList(inContent, scan);
            if (r) {
                return scan;
            }
        }
        catch (Exception e) {
            String errMsg = "getScanContent from Stream(" + inContent.toString() + ") failed!";
            this.logger.error(e + errMsg);
        }
        return null;
    }

    private boolean genXpthList(InputSource content, ContentScan scan) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(content, (DefaultHandler)scan);
        }
        catch (Exception e) {
            String errMsg = e + "\ngenRowData failed!";
            this.logger.error(errMsg);
            return false;
        }
        return true;
    }

    @Override
    public PreciseQueryCondition parseMOToDBQueryCondition(LightMO mo, String currentMOXpath) {
        String attrXpath;
        PreciseQueryCondition queryCondition = new PreciseQueryCondition();
        ArrayList<String> queryColNames = new ArrayList<String>();
        MOType moType = mo.getRootMO().getMOType().getSchema().getMOType(currentMOXpath);
        List<LightMO> currentMOList = this.getChildMoFromRootMOByXpath(mo, currentMOXpath);
        if (CollectionUtils.isEmpty(currentMOList)) {
            return queryCondition;
        }
        Set<String> queryAttributes = currentMOList.get(0).getAttributes().keySet();
        List<AttributeType> allAttributeType = this.getAllAttributeTypeList(moType, queryAttributes);
        for (AttributeType attrType : allAttributeType) {
            attrXpath = attrType.getXPath();
            queryColNames.add(attrXpath);
            List propertyList = attrType.getPropTypeList();
            for (PropertyType property : propertyList) {
                queryColNames.add(this.getColName(attrXpath, property.getName()));
            }
        }
        Iterator<LightMO> i$ = currentMOList.iterator();
        while (i$.hasNext()) {
            LightMO currentMO;
            LightMO tempMO = currentMO = i$.next();
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            for (AttributeType attrType : allAttributeType) {
                attrXpath = attrType.getXPath();
                MOType tmpMOType = moType;
                while (!attrType.getParent().getXPath().equals(tmpMOType.getXPath()) && null != (tmpMOType = tmpMOType.getParent())) {
                    tempMO = tempMO.getParent();
                }
                String value = tempMO.getAttributeValue(attrType);
                if (null != (value = this.translatorValue(value, attrType.getBasicType())) && !value.equals("")) {
                    conditionMap.put(this.xpath2colName(attrXpath, currentMOXpath), value);
                }
                List propertyList = attrType.getPropTypeList();
                for (PropertyType property : propertyList) {
                    value = tempMO.getAttributeProperty(attrXpath, property);
                    if (null == (value = this.translatorValue(value, property.getBasicType())) || value.equals("")) continue;
                    conditionMap.put(this.xpath2colName(this.getColName(attrXpath, property.getName()), currentMOXpath), value);
                }
            }
            queryCondition.addMatchCond(conditionMap);
        }
        return queryCondition;
    }

    private List<LightMO> getChildMoFromRootMOByXpath(LightMO mo, String childMOXpath) {
        return this.getChildMoByXpath(mo.getRootMO(), childMOXpath);
    }

    private List<LightMO> getChildMoByXpath(LightMO mo, String childMOXpath) {
        ArrayList<LightMO> childMOList = new ArrayList<LightMO>();
        List<LightMO> tmpChildMOList = mo.getChildren(childMOXpath);
        if (!CollectionUtils.isEmpty((Collection)tmpChildMOList)) {
            childMOList.addAll(tmpChildMOList);
        } else {
            for (LightMO childMO : mo.getAllChildren()) {
                tmpChildMOList = this.getChildMoByXpath(childMO, childMOXpath);
                childMOList.addAll(tmpChildMOList);
            }
        }
        return childMOList;
    }

    @Override
    public RowData parseMOToRowData(LightMO mo, String currentMOXpath) {
        List propertys;
        HashMap<String, String> colDataMap = new HashMap<String, String>();
        LightMO currentMO = (LightMO)mo.getRootMO().getChildren(currentMOXpath).get(0);
        Map attributes = currentMO.getAttributes();
        MOType currentMOType = currentMO.getMOType();
        colDataMap.putAll(attributes);
        Set attributeXpaths = attributes.keySet();
        for (String attributeXpath : attributeXpaths) {
            propertys = currentMOType.getAttrType(attributeXpath).getPropTypeList();
            for (PropertyType property : propertys) {
                colDataMap.put(this.getColName(attributeXpath, property.getName()), currentMO.getAttributeProperty(attributeXpath, property));
            }
        }
        LightMO parentMO = currentMO.getParent();
        if (null != parentMO) {
            MOType tempMOType = parentMO.getMOType();
            List keyAttrTypes = tempMOType.getKeyAttributeTypeList();
            for (AttributeType attrType : keyAttrTypes) {
                String attrXpath = attrType.getXPath();
                colDataMap.put(attrXpath, parentMO.getAttributeValue(attrType));
                propertys = tempMOType.getPropTypeList();
                for (PropertyType property : propertys) {
                    colDataMap.put(this.getColName(attrXpath, property.getName()), parentMO.getAttributeProperty(attrXpath, property));
                }
            }
        }
        return new RowData(colDataMap);
    }

    @Override
    public List<LightMO> parseRowDataToMO(List<RowData> rowDatas, MOType moType, String currentMOXpath) {
        this.logger.info("begin parseRowDataToMO, moType=" + moType);
        ArrayList<LightMO> moList = new ArrayList<LightMO>();
        if (0 == rowDatas.size()) {
            return moList;
        }
        Set<String> colNames = rowDatas.get(0).getCvs().keySet();
        HashSet<String> xpathNames = new HashSet<String>();
        for (String colName : colNames) {
            xpathNames.add(this.colName2Xpath(colName, currentMOXpath));
        }
        List<AttributeType> attrTypes = this.getAllAttributeTypeList(moType, xpathNames);
        LightMO mo = null;
        LightMO tempMo = null;
        LightMO parentMo = null;
        MOType tempType = null;
        for (RowData rowData : rowDatas) {
            Map<String, String> colDatas = rowData.getCvs();
            mo = this.moXMLBuilder.createMO((Type)moType);
            tempType = moType;
            tempMo = mo;
            while (true) {
                this.parseAttribute(colDatas, tempMo, tempType, attrTypes);
                tempType = tempType.getParent();
                if (null == tempType) break;
                parentMo = this.moXMLBuilder.createMO((Type)tempType);
                parentMo.addChild(tempMo);
                tempMo = parentMo;
            }
            moList.add(mo);
        }
        this.logger.info("end parseRowDataToMO, moType=" + moType);
        return moList;
    }

    public void setMoXMLBuilder(MOXMLBuilder moXMLBuilder) {
        this.moXMLBuilder = moXMLBuilder;
    }

    private void evaluateMO(LightMO tempMo, AttributeType attrType, Map<String, String> colDataMap) {
        String value = colDataMap.get(this.xpath2colName(attrType.getXPath(), attrType.getParent().getXPath()));
        if (null == value) {
            return;
        }
        if (BasicType.HEXBINARY.equals((Object)attrType.getBasicType())) {
            if (value.startsWith("0x")) {
                value = value.substring("0x".length());
            }
            tempMo.setAttributeValue(attrType, "0x" + Long.toHexString(Long.valueOf(value.toString())));
        } else if (BasicType.DATETIME.equals((Object)attrType.getBasicType())) {
            value = value.replaceAll("T", " ");
            tempMo.setAttributeValue(attrType, value.toString());
        } else {
            tempMo.setAttributeValue(attrType, value.toString());
        }
        this.evaluateMOProperty(tempMo, attrType, colDataMap);
    }

    private void evaluateMOProperty(LightMO tempMo, AttributeType attrType, Map<String, String> colDataMap) {
        List propertys = attrType.getPropTypeList();
        for (PropertyType property : propertys) {
            String propertyXpath = PolicyMgr.ObjPolicy.constructProp(attrType.getXPath(), property.getName());
            String value = colDataMap.get(this.xpath2colName(propertyXpath, attrType.getParent().getXPath()));
            if (null == value) {
                return;
            }
            if (BasicType.HEXBINARY.equals((Object)attrType.getBasicType())) {
                tempMo.setAttributePropertyValue(attrType.getXPath(), property, "0x" + Long.toHexString(Long.valueOf(value.toString())));
                continue;
            }
            tempMo.setAttributePropertyValue(attrType.getXPath(), property, value.toString());
        }
    }

    private List<AttributeType> getAllAttributeTypeList(MOType moType, Set<String> queryAttributes) {
        ArrayList<AttributeType> attrTypeList = new ArrayList<AttributeType>();
        for (String attribute : queryAttributes) {
            attrTypeList.add(moType.getAttrType(attribute));
        }
        for (MOType parentMOType = moType.getParent(); null != parentMOType; parentMOType = parentMOType.getParent()) {
            attrTypeList.addAll(parentMOType.getKeyAttributeTypeList());
        }
        return attrTypeList;
    }

    private String getColName(String attributeXpath, String propertyName) {
        return attributeXpath + "]" + propertyName;
    }

    private void parseAttribute(Map<String, String> colDataMap, LightMO tempMo, MOType tempMOType, List<AttributeType> attrTypes) {
        for (AttributeType attrType : attrTypes) {
            if (null == attrType || !attrType.getParent().getXPath().equals(tempMOType.getXPath())) continue;
            this.evaluateMO(tempMo, attrType, colDataMap);
        }
    }

    private String translatorValue(String value, BasicType basicType) {
        if (null == value) {
            return null;
        }
        if (value.trim().isEmpty()) {
            return "";
        }
        if (!(BasicType.STRING.equals((Object)basicType) || BasicType.DATETIME.equals((Object)basicType) || BasicType.TIME.equals((Object)basicType) || BasicType.BITMAP.equals((Object)basicType) || BasicType.DATE.equals((Object)basicType) || BasicType.DURATION.equals((Object)basicType) || !BasicType.HEXBINARY.equals((Object)basicType))) {
            if (value.startsWith("0x")) {
                value = value.substring(2, value.length());
            }
            value = Long.toString(Long.valueOf(value, 16));
        }
        return value;
    }

    public class ContentScan
    extends DefaultHandler {
        private Stack<String> elemXpath = new Stack();
        private List<String> xpathList = new ArrayList<String>();
        private SCAN_STATE pre1State = SCAN_STATE.origin;
        private SCAN_STATE pre2State = SCAN_STATE.origin;
        private StringBuilder xpathSb = new StringBuilder(50);

        public ContentScan(PolicyQuery.DTV dtv) {
            this.init(dtv);
        }

        public void init(PolicyQuery.DTV dtv) {
            this.elemXpath.clear();
            this.xpathList.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.elemXpath.push(qName);
            String curXpath = this.getCurXpath();
            if (!curXpath.equals("/mylabel")) {
                this.xpathList.add(curXpath.replace("/mylabel", ""));
            }
            this.stateChg(SCAN_STATE.S);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.stateChg(SCAN_STATE.E);
            this.elemXpath.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stateChg(SCAN_STATE.D);
        }

        private void stateChg(SCAN_STATE s) {
            this.pre2State = this.pre1State;
            this.pre1State = s;
        }

        private String getCurXpath() {
            this.xpathSb.setLength(0);
            for (String elem : this.elemXpath) {
                this.xpathSb.append('/');
                this.xpathSb.append(elem);
            }
            return this.xpathSb.toString();
        }
    }

    static enum SCAN_STATE {
        origin,
        S,
        D,
        E;

    }
}

