/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.netconf.datadefination.RspCmd;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.SyncData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;

public class SynDataRequstHelper {
    private static final int CHECK_INTERVAL = 2000;
    private static final int CHECK_TIMES = 300;
    private static final String FULL_SYNC_ERROR_FILE_NAME = "error.xml";
    private static Logger logger = RunLogger.getRunLogger();

    private static void parseZipFile(SyncData syncData, DevChange.DevInfo dev, List<ZipEntry> entries, Enumeration<? extends ZipEntry> en, String zipFilePath) throws IOException, PersistenceException {
        while (en.hasMoreElements()) {
            ZipEntry zipEntry = en.nextElement();
            if (!zipEntry.isDirectory() && !zipEntry.toString().endsWith("zip")) {
                entries.add(zipEntry);
                continue;
            }
            if (!zipEntry.toString().endsWith("zip")) continue;
            File zipFile = new File(zipFilePath);
            SynDataRequstHelper.unZipFiles(syncData, dev, zipFile, zipFilePath.substring(0, zipFilePath.length() - 4));
        }
    }

    public static void unZipFiles(SyncData syncData, DevChange.DevInfo dev, File zipFile, String descDir) throws IOException, PersistenceException {
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            String zipEntryName = entry.getName();
            InputStream in = zip.getInputStream(entry);
            String outPath = (descDir + zipEntryName).replaceAll("\\*", "/");
            File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if (new File(outPath).isDirectory()) continue;
            System.out.println(outPath);
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                out.write(buf1, 0, len);
            }
            SynDataRequstHelper.getFullSyncData(syncData, dev, outPath);
            in.close();
            out.close();
        }
        System.out.println("******************\u89e3\u538b\u5b8c\u6bd5********************");
    }

    public static boolean getFullSyncData(SyncData syncData, DevChange.DevInfo dev, String strFileName) throws PersistenceException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(strFileName);
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            SynDataRequstHelper.parseZipFile(syncData, dev, entries, en, strFileName);
            SynDataRequstHelper.checkErrorMessage(entries, zipFile);
            Collections.sort(entries, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry entry1, ZipEntry entry2) {
                    return this.getFileIndex(entry1) - this.getFileIndex(entry2);
                }

                private int getFileIndex(ZipEntry entry) {
                    String fileName = entry.getName();
                    int startIndex = fileName.lastIndexOf("_");
                    String num = fileName.substring(startIndex + 1, fileName.indexOf("."));
                    return Integer.parseInt(num);
                }
            });
            for (ZipEntry zipEntry : entries) {
                InputStream stream = null;
                try {
                    stream = zipFile.getInputStream(zipEntry);
                    String content = SynDataRequstHelper.readFile(stream);
                    RspCmd reply = new RspCmd(content);
                    Integer vrID = reply.getVrID() == null ? 0 : reply.getVrID();
                    DevConfig cfg = Activator.svcFactory.getDevChangeService().constructCfgsWithDev(dev.devIdentify, vrID);
                    if (!DevMgr.instance().isPersistDevCfg(cfg)) {
                        String errMsg = "cfg[" + cfg + "] had been synced, but hadn't been persisted!";
                        logger.warn(errMsg);
                        continue;
                    }
                    if (syncData.syncAllFromStream(cfg, new StringBufferInputStream(content))) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (NetconfException e) {
                    throw new PersistenceException("getFullSyncData RspCmd exception");
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new PersistenceException("getFullSyncData exception happend");
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    throw new PersistenceException("getFullSyncData close zipFile exception happend");
                }
            }
        }
    }

    public static String readFile(File filePath) {
        try {
            return FileCopyUtils.copyToString((Reader)new FileReader(filePath));
        }
        catch (FileNotFoundException e) {
            logger.error("read file to string exception.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("read file to string exception.", (Throwable)e);
        }
        return null;
    }

    public static String readFile(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        FileCopyUtils.copy((InputStream)in, (OutputStream)out);
        return out.toString("UTF-8");
    }

    public static boolean waitFile(SyncData syncData, DevChange.DevInfo dev, String absoulateFileName) {
        long start = System.currentTimeMillis();
        logger.info("waiting for ftp data:{}", (Object)absoulateFileName);
        File goalFile = new File(absoulateFileName);
        int index = 0;
        while (index++ < 300) {
            if (goalFile.exists()) {
                logger.info(absoulateFileName + " is exist, waiting time={} (ms)", (Object)(goalFile.lastModified() - start));
                return true;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                logger.error("waitFile interrupted!!!");
            }
        }
        return false;
    }

    private static void checkErrorMessage(List<ZipEntry> zipEntrys, ZipFile zipFile) throws PersistenceException {
        if (CollectionUtils.isEmpty(zipEntrys)) {
            return;
        }
        for (ZipEntry zipEntry : zipEntrys) {
            String name = zipEntry.getName();
            if (!name.contains(FULL_SYNC_ERROR_FILE_NAME)) continue;
            InputStream stream = null;
            try {
                stream = zipFile.getInputStream(zipEntry);
                String content = SynDataRequstHelper.readFile(stream);
                logger.error("full sync zip file[" + zipFile.getName() + "] return error.xml:" + content);
            }
            catch (Exception e) {
                logger.error("parse full sync error file error. fileName=" + name, (Throwable)e);
                throw new PersistenceException("checkErrorMessage RspCmd exception");
            }
            finally {
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        logger.error("close full sync error.xml error. zipFile=" + zipFile.getName());
                    }
                }
            }
            throw new PersistenceException("checkErrorMessage exception");
        }
    }

    private static String extractFeatureName(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        int slash = name.indexOf(47);
        int underline = name.indexOf(95, slash);
        return name.substring(slash + 1, underline);
    }
}

