/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.common.ftpagent.FTPMgr;
import com.huawei.vmf.common.ftpagent.FtpInfo;
import com.huawei.vmf.common.netconf.DefaultNetconfClientFactory;
import com.huawei.vmf.netconf.datadefination.RpcErrorInfo;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.service.INetconfClient;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.debug.TimeRecStack;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.SyncData;
import com.huawei.vmf.qat.persistence.service.impl.PolicyQuery1Cfg1DB;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import com.huawei.vmf.qat.persistence.syncdata.alone.GetFtpSftpParam;
import com.huawei.vmf.qat.persistence.syncdata.alone.SynDataRequstHelper;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;

public class SynAllDevTask {
    private String absoulateFileName = "";
    private DevChange.DevInfo dev = null;
    private int flowId = -1;
    private Logger logger = RunLogger.getRunLogger();

    public boolean getSyncZipFromNe(DevChange.DevInfo dev) {
        this.dev = dev;
        return this.sendFullSynRequest();
    }

    public boolean syncAll(SyncData syncData, DevChange.DevInfo dev) {
        this.dev = dev;
        TimeRecStack tr = new TimeRecStack("SyncAll", System.out, 0);
        tr.setPrint(true);
        tr.start("send rpc");
        if (!this.sendFullSynRequest()) {
            this.failedAction(syncData);
            return false;
        }
        tr.stop();
        tr.start("wait ftp");
        boolean r = SynDataRequstHelper.waitFile(syncData, dev, this.absoulateFileName);
        if (!r) {
            this.failedAction(syncData);
            this.logger.error("waitFile error, syncAll failed!");
            return r;
        }
        tr.stop();
        try {
            tr.start("construct db");
            List<DevConfig> devCfgList = DevMgr.instance().getPersistDevCfg(dev.devIdentify);
            for (DevConfig devCfg : devCfgList) {
                syncData.reNewCfgDB(devCfg);
                syncData.syncBegin(devCfg);
                syncData.createTable(devCfg);
            }
            r = SynDataRequstHelper.getFullSyncData(syncData, dev, this.absoulateFileName);
            for (DevConfig devCfg : devCfgList) {
                syncData.syncEnd(devCfg, r, this.flowId, 0L);
            }
            tr.stop();
            if (!r) {
                this.logger.error("syncall failed!!!");
                this.failedAction(syncData);
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("parse package error, syncAll failed!");
            this.failedAction(syncData);
            return false;
        }
        AloneDeploySchedule.addDevToDevMap(this.dev, this.flowId, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK);
        return true;
    }

    protected boolean sendFullSynRequest() {
        try {
            int ret = DefaultNetconfClientFactory.testConnective((String)this.dev.devIdentify.getIp(), null);
            if (0 != ret) {
                this.logger.error("FullSync failed, device netconf protocol is not connected., DEV: " + this.dev);
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("FullSync error, testConnective exception. " + e + ", Dev: " + this.dev);
            return false;
        }
        StringBuilder sbFNPrefix = new StringBuilder();
        StringBuilder sbAbsolutPath = new StringBuilder();
        IRpcReply rpcReply = this.notifyDevFile(this.dev, this.genFullSyncContent(this.dev), sbAbsolutPath, sbFNPrefix);
        if (null == rpcReply) {
            this.logger.error("sendFullSynRequest error, Device did not response any rpcReply., DEV: " + this.dev);
            return false;
        }
        if (rpcReply.isOK()) {
            this.flowId = rpcReply.getFlowID();
            sbFNPrefix.append("_cp").append(rpcReply.getFlowID()).append(".zip");
            this.absoulateFileName = sbAbsolutPath.toString() + File.separator + sbFNPrefix.toString();
            return true;
        }
        String errMsg = "sendFullSynRequest error: " + ((RpcErrorInfo)rpcReply.getErrorInfos().iterator().next()).getErrMsg().toString() + ", Dev: " + this.dev;
        System.err.println(errMsg);
        this.logger.error(errMsg);
        return false;
    }

    private void failedAction(SyncData syncData) {
        List<DevConfig> devCfgList = DevMgr.instance().getPersistDevCfg(this.dev.devIdentify);
        for (DevConfig devCfg : devCfgList) {
            syncData.reNewCfgDB(devCfg);
            syncData.syncBegin(devCfg);
            syncData.createTable(devCfg);
            syncData.syncEnd(devCfg, false, this.flowId, 0L);
        }
        AloneDeploySchedule.deleteDevFromDevMap(this.dev);
        AloneDeploySchedule.addDevToQueue(this.dev, AloneDeploySchedule.queneDevFullSync);
    }

    private String genFullSyncContent(DevChange.DevInfo dev) {
        PolicyQuery1Cfg1DB o = new PolicyQuery1Cfg1DB();
        PolicyQuery.DTV dtv = new PolicyQuery.DTV(dev.neType, dev.ver);
        StringBuilder sb = new StringBuilder();
        o.getSyncAllContent(sb, dtv);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRpcReply notifyDevFile(DevChange.DevInfo dev, String content, StringBuilder sbAbsolutPath, StringBuilder sbFNPrefix) {
        INetconfClient client = DefaultNetconfClientFactory.getNetconfClient((String)"SyncData", (String)dev.devIdentify.getIp(), (boolean)true, null);
        IRpcReply rpcReply = null;
        String fileName = dev.devIdentify.getIp() + "_" + System.currentTimeMillis();
        sbFNPrefix.append(fileName);
        try {
            FtpInfo ftpInfo = new FtpInfo();
            if ("independent".equals(System.getProperty("deploymentMode"))) {
                GetFtpSftpParam getFtp = new GetFtpSftpParam();
                ftpInfo = getFtp.getFtpInfo();
            } else {
                ftpInfo = FTPMgr.getInstance().queryFtpInfo(dev.devIdentify.getIp());
            }
            rpcReply = client.syncFull(FilterType.SUBTREE, content, fileName, ftpInfo.getUserName(), ftpInfo.getPassword(), ftpInfo.getServerIP(), ftpInfo.getPort(), ftpInfo.getServerVmfRelativePath());
            sbAbsolutPath.append(ftpInfo.getServerVmfRootPath());
            IRpcReply iRpcReply = rpcReply;
            return iRpcReply;
        }
        catch (NetconfException e) {
            this.logger.error("netConfSyncHandle.sync() exception", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            DefaultNetconfClientFactory.close((INetconfClient)client);
        }
        return null;
    }
}

