/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import com.huawei.vmf.qat.persistence.syncdata.alone.Stub;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class IncrSyncPoll
extends Thread {
    private final int SLEEP_INTERVAL = 10;
    private final int DEFAULT_RANGE_FOR_SLEEP = 1000;
    private volatile boolean isRunning = true;
    private Logger logger = RunLogger.getRunLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isRunning) {
                this.logger.info("IncrSyncPoll thread is alive");
                System.out.println("IncrSyncPoll thread is alive");
                DevChange.DevInfo data = AloneDeploySchedule.queneDevIncrSync.poll(2L, TimeUnit.SECONDS);
                if (null != data) {
                    Stub.instance().forceIncrSync(data);
                }
                Thread.sleep(this.SLEEP_INTERVAL * this.DEFAULT_RANGE_FOR_SLEEP);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void quit() {
        this.isRunning = false;
    }
}

