/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.common.netconf.DefaultNetconfClientFactory;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.service.INetconfClient;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.SyncData;
import com.huawei.vmf.qat.persistence.service.impl.PolicyQuery1Cfg1DB;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class IncrSyncDataReqTask {
    private Logger logger = RunLogger.getRunLogger();
    private Map<DevConfig, List<String>> replys = new HashMap<DevConfig, List<String>>();

    public boolean incSync(DevChange.DevInfo dev, int sourceFlowID, int targetFlowID) {
        SyncData syncData = Activator.svcFactory.getSyncDataService();
        if (!this.doIncrSyncTask(dev, sourceFlowID, targetFlowID)) {
            return false;
        }
        if (!this.handleRpcReplys(syncData, targetFlowID)) {
            List<DevConfig> devCfgList = DevMgr.instance().getPersistDevCfg(dev.devIdentify);
            for (DevConfig devCfg : devCfgList) {
                syncData.reNewCfgDB(devCfg);
            }
            AloneDeploySchedule.deleteDevFromDevMap(dev);
            AloneDeploySchedule.addDevToQueue(dev, AloneDeploySchedule.queneDevFullSync);
            return false;
        }
        AloneDeploySchedule.addDevToDevMap(dev, targetFlowID, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doIncrSyncTask(DevChange.DevInfo dev, int sourceFlowID, int targetFlowID) {
        String content = this.genIncrSyncContent(dev);
        if (content.trim().equals("")) {
            this.logger.info("IncrSyncDataReqImpl.content is null, no need deploy to device");
            return false;
        }
        try {
            int ret = DefaultNetconfClientFactory.testConnective((String)dev.devIdentify.getIp(), null);
            if (0 != ret) {
                this.logger.error("IncrTask failed, device netconf protocol is not connected. " + dev);
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("IncrTask error, testConnective exception. " + e);
            return false;
        }
        INetconfClient client = DefaultNetconfClientFactory.getNetconfClient((String)"SyncData", (String)dev.devIdentify.getIp(), (boolean)true, null);
        IRpcReply rpcReply = null;
        try {
            rpcReply = client.syncIncrement(FilterType.SUBTREE, content, (long)sourceFlowID, (long)targetFlowID);
            if (rpcReply == null) {
                this.logger.error("get null rpcreply while incSync!!!");
                boolean bl = false;
                return bl;
            }
            while (rpcReply != null) {
                DevConfig cfg;
                List<String> allReply;
                int vrId = 0;
                if (null != rpcReply.getVrID()) {
                    vrId = rpcReply.getVrID();
                }
                if ((allReply = this.replys.get(cfg = Activator.svcFactory.getDevChangeService().constructCfgsWithDev(dev.devIdentify, vrId))) == null) {
                    allReply = new ArrayList<String>();
                    this.replys.put(cfg, allReply);
                }
                allReply.add(rpcReply.getContent());
                int setId = rpcReply.getSetID();
                if (setId > 0) {
                    rpcReply = client.getNext(setId, false);
                    continue;
                }
                rpcReply = null;
            }
        }
        catch (NetconfException e) {
            this.logger.error("querySerialNumNetconfHandle.sync() error", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            DefaultNetconfClientFactory.close((INetconfClient)client);
        }
        return true;
    }

    private String genIncrSyncContent(DevChange.DevInfo dev) {
        PolicyQuery1Cfg1DB o = new PolicyQuery1Cfg1DB();
        PolicyQuery.DTV dtv = new PolicyQuery.DTV(dev.neType, dev.ver);
        StringBuilder sb = new StringBuilder();
        o.getIncrSyncContent(sb, dtv);
        return sb.toString();
    }

    private boolean handleRpcReplys(SyncData syncData, int targetFlowID) {
        Set<Map.Entry<DevConfig, List<String>>> replyEntry = this.replys.entrySet();
        for (Map.Entry<DevConfig, List<String>> entry : replyEntry) {
            DevConfig cfg = entry.getKey();
            List<String> replyList = entry.getValue();
            syncData.incInit(cfg);
            try {
                for (String content : replyList) {
                    if (syncData.incSync(cfg, new StringBuffer(content))) continue;
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

