/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.common.netconf.DefaultNetconfClientFactory;
import com.huawei.vmf.netconf.datadefination.RpcErrorInfo;
import com.huawei.vmf.netconf.datadefination.RspCmd;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.service.INetconfClient;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.service.DevChange;
import org.slf4j.Logger;

public class GetSerialNumTask {
    private final String CUR_SERIAL_TAG = "curCfgChgFlowId";
    private String flowContent = "";
    private Logger logger = RunLogger.getRunLogger();
    private final String SERIAL_FEATURE_TAG = "cfg";
    private final String SERIAL_TAG = "cfgChgFlowId";
    private final String SERIAL_XPATH = "/cfg/cfgChgFlowId";
    private final String SLASH = "/";
    private final String XML_ELEMENT_POSTFIX = ">";
    private final String XML_ELEMENT_PREFIX = "<";

    public static void main(String[] args) throws Exception {
        GetSerialNumTask getSerial = new GetSerialNumTask();
        getSerial.genFlowSyncContent();
        assert (getSerial.flowContent.equals("<cfg xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\" ><cfgChgFlowId><curCfgChgFlowId/></cfgChgFlowId></cfg>"));
        String FlowContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rpc-reply message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\" flow-id=\"410\" hwcontext=\"\"><data><cfg xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><cfgChgFlowId><curCfgChgFlowId>532</curCfgChgFlowId></cfgChgFlowId></cfg></data></rpc-reply>";
        RspCmd flowReply = new RspCmd(FlowContent);
        GetSerialNumTask task = new GetSerialNumTask();
        DevChange.DevInfo dev = new DevChange.DevInfo(new DevChange.DevIdentify("", 0), "", "");
        assert (-1 == task.getDevFlowID(dev));
        int iFlowID = task.handleRpcReply(flowReply.getContent());
        assert (iFlowID == 532);
        task.genFlowSyncContent();
        assert (task.flowContent.equals("<cfg xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\" ><cfgChgFlowId><curCfgChgFlowId/></cfgChgFlowId></cfg>"));
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable ee) {
            System.out.println("success!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDevFlowID(DevChange.DevInfo dev) {
        this.logger.info("DBCache getDevFlowID, devIP=" + dev.devIdentify.getIp());
        try {
            this.logger.info("DBCache getDevFlowID testConnective,devIP=" + dev.devIdentify.getIp());
            int ret = DefaultNetconfClientFactory.testConnective((String)dev.devIdentify.getIp(), null);
            if (0 != ret) {
                this.logger.error("Get FlowID failed, device netconf protocol is not connected. DEV:" + dev);
                return -1;
            }
            this.logger.info("DBCache getDevFlowID testConnective end,devIP=" + dev.devIdentify.getIp());
        }
        catch (Exception e) {
            this.logger.error("Get FlowID error, testConnective exception. " + e + ", Dev: " + dev);
            return -1;
        }
        INetconfClient client = DefaultNetconfClientFactory.getNetconfClient((String)"SyncData", (String)dev.devIdentify.getIp(), (boolean)true, null);
        IRpcReply rpcReply = null;
        try {
            this.genFlowSyncContent();
            rpcReply = client.get(FilterType.SUBTREE, this.flowContent, this.flowContent, false);
        }
        catch (NetconfException e) {
            this.logger.error("getDevFlowID error, deploy get flow packet to device exception: " + (Object)((Object)e) + ", Dev: " + dev);
            e.printStackTrace();
        }
        finally {
            DefaultNetconfClientFactory.close((INetconfClient)client);
        }
        if (null == rpcReply) {
            this.logger.error("getDevFlowID error, rpcReply is null, DEV: " + dev);
            return -1;
        }
        if (rpcReply.isOK()) {
            int flowId = this.handleRpcReply(rpcReply.getContent());
            this.logger.info("DBCache getDevFlowID end, devIP=" + dev.devIdentify.getIp());
            return flowId;
        }
        this.logger.error("getDevFlowID error, repReply return error info:{}" + ((RpcErrorInfo)rpcReply.getErrorInfos().iterator().next()).getErrMsg().toString() + ", Dev: " + dev);
        return -1;
    }

    private String addFix(String string) {
        String result = this.XML_ELEMENT_PREFIX + string + this.XML_ELEMENT_POSTFIX;
        return result;
    }

    private void genFlowSyncContent() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addFix(this.SERIAL_FEATURE_TAG + " xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\" "));
        buffer.append(this.addFix(this.SERIAL_TAG));
        buffer.append('<').append(this.CUR_SERIAL_TAG).append('/').append('>');
        buffer.append(this.addFix(this.SLASH + this.SERIAL_TAG));
        buffer.append(this.addFix(this.SLASH + this.SERIAL_FEATURE_TAG));
        this.flowContent = buffer.toString();
    }

    private String getFlowContent() {
        return this.flowContent;
    }

    private int handleRpcReply(String content) {
        String strFlowId = content.substring(content.indexOf("<curCfgChgFlowId>") + 17, content.indexOf("</curCfgChgFlowId>"));
        return Integer.parseInt(strFlowId);
    }
}

