/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.common.ftpagent.FtpInfo;
import com.huawei.vmf.common.tool.PlatformCipherTool;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.slf4j.Logger;

public class GetFtpSftpParam {
    private Logger logger = RunLogger.getRunLogger();

    public FtpInfo getFtpInfo() {
        FtpInfo ftpInfo = new FtpInfo();
        String serverPort = "21";
        String userName = "";
        String password = "";
        String ftpServerRootPath = "";
        String serverIp = this.getLocalIp();
        Properties ftpParameters = this.readOptionsFile();
        if (ftpParameters == null) {
            return null;
        }
        serverPort = null != ftpParameters.getProperty("ftpPort") ? ftpParameters.getProperty("ftpPort") : serverPort;
        userName = null != ftpParameters.getProperty("ftpUsername") ? ftpParameters.getProperty("ftpUsername") : userName;
        password = null != ftpParameters.getProperty("ftpPassword") ? this.decrypt(ftpParameters.getProperty("ftpPassword")) : password;
        serverIp = null != ftpParameters.getProperty("ipAddress") ? ftpParameters.getProperty("ipAddress") : serverIp;
        ftpServerRootPath = ftpParameters.getProperty("rootDir");
        ftpInfo.setPort(Integer.parseInt(serverPort));
        ftpInfo.setPassword(password);
        ftpInfo.setServerIP(serverIp);
        ftpInfo.setServerRootPath(ftpServerRootPath);
        ftpInfo.setUserName(userName);
        String NEMGR_VMF = "nemgr_vmf";
        String SYNCRSP = "syncRsp";
        String dir = ftpServerRootPath + File.separator + "nemgr_vmf" + File.separator + "syncRsp";
        File dbDir = new File(dir);
        if (!dbDir.exists() && !dbDir.mkdir()) {
            this.logger.error("Create ftp dir<" + dir + ">failed");
        }
        ftpInfo.setServerVmfRelativePath("nemgr_vmf" + File.separator + "syncRsp");
        return ftpInfo;
    }

    private String decrypt(String message) {
        return new String(PlatformCipherTool.decrypt((String)message));
    }

    private String getLocalIp() {
        String serverIp = "";
        try {
            serverIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger.error("can not get local ip address.", (Throwable)e);
        }
        return serverIp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readOptionsFile() {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(PolicyMgr.FTP_PARAMETERS);
            properties.load(fis);
        }
        catch (IOException ex) {
            this.logger.error("Failed to init i18n message resource.", (Throwable)ex);
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                this.logger.error("Failed to close a file inputstream.", (Throwable)ex);
            }
        }
        return properties;
    }
}

