/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import com.huawei.vmf.qat.persistence.syncdata.alone.GetSerialNumTask;
import java.util.Set;
import org.slf4j.Logger;

public class DevMapPollForIncrSync
extends Thread {
    private static final int INVALID_VALUE = -1;
    private static final int MAX_FLOWID_INTERVAL = 100;
    private final int DEFAULT_RANGE_FOR_SLEEP = 1000;
    private final int SLEEP_INTERVAL = 10;
    private static boolean isRunning = true;
    public GetSerialNumTask getSerial = new GetSerialNumTask();
    private Logger logger = RunLogger.getRunLogger();

    @Override
    public void run() {
        while (true) {
            if (!isRunning) break;
            this.logger.info("DevMapPoll thread is alive");
            System.out.println("DevMapPoll thread is alive");
            Set<DevChange.DevInfo> mDevSet = AloneDeploySchedule.mDevAll.keySet();
            for (DevChange.DevInfo devInfo : mDevSet) {
                int iSourceFlowID = AloneDeploySchedule.mDevAll.get(devInfo).getFlowID();
                if (-1 == iSourceFlowID) continue;
                int iTargetFlowID = this.getSerial.getDevFlowID(devInfo);
                if (-1 == iTargetFlowID) {
                    this.logger.info("getDevFlowID failed from dev[" + devInfo + "]");
                    continue;
                }
                if (iTargetFlowID - iSourceFlowID > 100) {
                    AloneDeploySchedule.addDevToQueue(devInfo, AloneDeploySchedule.queneDevFullSync);
                    continue;
                }
                if (iTargetFlowID - iSourceFlowID <= 0) continue;
                AloneDeploySchedule.addDevToQueue(devInfo, AloneDeploySchedule.queneDevIncrSync);
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void quit() {
        isRunning = false;
    }
}

