/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata.alone;

import com.huawei.vmf.common.ftpagent.FtpInfo;
import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.CommunicationArgumentMgr;
import com.huawei.vmf.qat.common.json.JSONRPCContextHolder;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.service.DBCommonOper;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.SyncData;
import com.huawei.vmf.qat.persistence.syncdata.alone.DevMapPollForIncrSync;
import com.huawei.vmf.qat.persistence.syncdata.alone.FullSyncPoll;
import com.huawei.vmf.qat.persistence.syncdata.alone.GetFtpSftpParam;
import com.huawei.vmf.qat.persistence.syncdata.alone.GetSerialNumTask;
import com.huawei.vmf.qat.persistence.syncdata.alone.IncrSyncDataReqTask;
import com.huawei.vmf.qat.persistence.syncdata.alone.IncrSyncPoll;
import com.huawei.vmf.qat.persistence.syncdata.alone.Stub;
import com.huawei.vmf.qat.persistence.syncdata.alone.SynAllDevTask;
import com.huawei.vmf.qat.security.support.SessionDataHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class AloneDeploySchedule
extends Stub {
    public static boolean isAutoStartThread = true;
    public static Map<DevChange.DevInfo, DevMapInfo> mDevAll = new HashMap<DevChange.DevInfo, DevMapInfo>();
    public static BlockingQueue<DevChange.DevInfo> queneDevFullSync = new LinkedBlockingQueue<DevChange.DevInfo>();
    public static BlockingQueue<DevChange.DevInfo> queneDevIncrSync = new LinkedBlockingQueue<DevChange.DevInfo>();
    private static final ReentrantLock lock = new ReentrantLock(true);
    private final int MAX_FLOWID_INTERVAL = 100;
    private static Logger logger = RunLogger.getRunLogger();
    private IncrSyncPoll incrSyncQuene = new IncrSyncPoll();
    private FullSyncPoll fullSyncQuene = new FullSyncPoll();
    private DevMapPollForIncrSync devMapPoll = new DevMapPollForIncrSync();

    public AloneDeploySchedule() {
        if (isAutoStartThread) {
            this.startAllThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDevToDevMap(DevChange.DevInfo dev, int iSourceFlowID, int iSyncStatus) {
        ReentrantLock lock = AloneDeploySchedule.lock;
        lock.lock();
        try {
            DevMapInfo dmi = new DevMapInfo(iSourceFlowID, iSyncStatus);
            mDevAll.put(dev, dmi);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDevToQueue(DevChange.DevInfo dev, BlockingQueue<DevChange.DevInfo> queue) {
        if (queue.contains(dev)) {
            logger.info("there is a same dev in the queue, DEV=" + dev.devIdentify.getIp());
            return;
        }
        ReentrantLock lock = AloneDeploySchedule.lock;
        lock.lock();
        try {
            queue.offer(dev);
        }
        catch (Exception e) {
            logger.error("put dev {} to queue quene failed", (Object)dev);
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDevFromDevMap(DevChange.DevInfo dev) {
        ReentrantLock lock = AloneDeploySchedule.lock;
        lock.lock();
        try {
            if (mDevAll.containsKey(dev)) {
                mDevAll.remove(dev);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDevFromQueue(DevChange.DevInfo dev) {
        ReentrantLock lock = AloneDeploySchedule.lock;
        lock.lock();
        try {
            if (queneDevFullSync.contains(dev)) {
                queneDevFullSync.remove(dev);
            }
        }
        catch (Exception e) {
            logger.error("remove dev {} from queue quene failed", (Object)dev);
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void startAllThread() {
        if (this.threadStarted(this.incrSyncQuene) || this.threadStarted(this.fullSyncQuene) || this.threadStarted(this.devMapPoll)) {
            System.out.println("some sync thread already running, you should first stop it!");
        } else {
            this.incrSyncQuene = new IncrSyncPoll();
            this.incrSyncQuene.start();
            this.fullSyncQuene = new FullSyncPoll();
            this.fullSyncQuene.start();
            this.devMapPoll = new DevMapPollForIncrSync();
            this.devMapPoll.start();
        }
    }

    @Override
    public void stopAllThread() {
        this.incrSyncQuene.quit();
        this.fullSyncQuene.quit();
        this.devMapPoll.quit();
        try {
            if (this.threadStarted(this.incrSyncQuene)) {
                this.incrSyncQuene.join();
            }
            if (this.threadStarted(this.fullSyncQuene)) {
                this.fullSyncQuene.join();
            }
            if (this.threadStarted(this.devMapPoll)) {
                this.devMapPoll.join();
            }
        }
        catch (InterruptedException e) {
            System.out.println("join interrupted, please stop again!");
        }
    }

    @Override
    public void addDev(DevChange.DevInfo dev) {
        if (!this.isPersistentDB(dev)) {
            return;
        }
        AloneDeploySchedule.addDevToQueue(dev, queneDevFullSync);
    }

    @Override
    public void delDev(DevChange.DevInfo dev) {
        AloneDeploySchedule.deleteDevFromQueue(dev);
        AloneDeploySchedule.deleteDevFromDevMap(dev);
    }

    @Override
    public boolean isInDevMap(DevChange.DevIdentify dv) {
        HttpServletRequest currentRequest = JSONRPCContextHolder.getHttpServletRequest();
        HttpServletRequest lastRequest = SessionDataHolder.getLastRequest();
        if (null != lastRequest && lastRequest == currentRequest) {
            logger.info("no need judge flowID, devIP=" + dv.getIp());
            return true;
        }
        logger.info("need judge flowID, devIP=" + dv.getIp());
        Set<DevChange.DevInfo> setDevs = mDevAll.keySet();
        for (DevChange.DevInfo setDev : setDevs) {
            if (!setDev.devIdentify.getIp().equals(dv.getIp()) && setDev.devIdentify.getDevID() != dv.getDevID()) continue;
            GetSerialNumTask getSerial = new GetSerialNumTask();
            int iTargetFlowID = getSerial.getDevFlowID(setDev);
            int iSourceFlowID = -1;
            if (-1 == mDevAll.get(setDev).iFlowID) {
                List<DevConfig> lDevCfg;
                DBCommonOper db = Activator.svcFactory.getDBCommonOperService();
                String devBaseInfo = db.getDevBaseInfo((lDevCfg = Activator.svcFactory.getDevChangeService().constructCfgsWithDev(setDev.devIdentify)).get(0));
                if (null != devBaseInfo) {
                    iSourceFlowID = Integer.parseInt(devBaseInfo);
                }
            } else {
                iSourceFlowID = mDevAll.get(setDev).iFlowID;
            }
            logger.info("iSourceFlowID=" + iSourceFlowID + ",iTargetFlowID=" + iTargetFlowID);
            if (iTargetFlowID > iSourceFlowID) continue;
            SessionDataHolder.setLastRequest((HttpServletRequest)currentRequest);
            return true;
        }
        return false;
    }

    @Override
    public void forceIncrSync(DevChange.DevInfo dvInfo) {
        if (!mDevAll.containsKey(dvInfo)) {
            AloneDeploySchedule.addDevToQueue(dvInfo, queneDevFullSync);
            return;
        }
        if (!this.isPersistentDB(dvInfo)) {
            return;
        }
        int iSyncStatus = this.getSyncStatus(dvInfo);
        if (SYNC_STATUS_ENUM.FULL_SYNC_ING == iSyncStatus || SYNC_STATUS_ENUM.INCR_SYNC_ING == iSyncStatus) {
            System.out.println("sync has return, becase sync is running," + dvInfo);
            return;
        }
        this.setSyncStatus(dvInfo, SYNC_STATUS_ENUM.INCR_SYNC_ING);
        logger.info("incrsync is running," + dvInfo);
        System.out.println("incrsync is running," + dvInfo);
        IncrSyncDataReqTask incSync = new IncrSyncDataReqTask();
        GetSerialNumTask getSerial = new GetSerialNumTask();
        int iSourceFlowID = mDevAll.get(dvInfo).getFlowID();
        int iTargetFlowID = getSerial.getDevFlowID(dvInfo);
        if (100 < iTargetFlowID - iSourceFlowID) {
            AloneDeploySchedule.addDevToQueue(dvInfo, queneDevFullSync);
        } else if (0 < iTargetFlowID - iSourceFlowID) {
            if (incSync.incSync(dvInfo, iSourceFlowID, iTargetFlowID)) {
                logger.info("incrsync success," + dvInfo);
                System.out.println("\u589e\u91cf\u540c\u6b65\u6267\u884c\u6210\u529f" + dvInfo);
            } else {
                logger.info("incrsync failed," + dvInfo);
                System.out.println("\u589e\u91cf\u540c\u6b65\u6267\u884c\u5931\u8d25" + dvInfo);
            }
        }
        this.setSyncStatus(dvInfo, SYNC_STATUS_ENUM.SYNC_OK);
        logger.info("incrsync is end," + dvInfo);
        System.out.println("incrsync is end," + dvInfo);
    }

    private boolean isPersistentDB(DevChange.DevInfo dvInfo) {
        PolicyQuery.DTV dtv;
        PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
        return pq.getTableDesc(dtv = new PolicyQuery.DTV(dvInfo.neType, dvInfo.ver)) != null;
    }

    private void setSyncStatus(DevChange.DevInfo dv, int iSyncStatus) {
        if (null != mDevAll.get(dv)) {
            int iFlowID = mDevAll.get(dv).getFlowID();
            AloneDeploySchedule.addDevToDevMap(dv, iFlowID, iSyncStatus);
        } else {
            AloneDeploySchedule.addDevToDevMap(dv, -1, iSyncStatus);
        }
    }

    private int getSyncStatus(DevChange.DevInfo dvInfo) {
        if (null != mDevAll.get(dvInfo)) {
            return mDevAll.get(dvInfo).iSyncStatus;
        }
        return -1;
    }

    @Override
    public void forceSyncAll(DevChange.DevInfo dvInfo) {
        if (!this.isPersistentDB(dvInfo)) {
            return;
        }
        if (mDevAll.containsKey(dvInfo)) {
            int iSyncStatus = this.getSyncStatus(dvInfo);
            if (SYNC_STATUS_ENUM.FULL_SYNC_ING == iSyncStatus) {
                return;
            }
            if (SYNC_STATUS_ENUM.INCR_SYNC_ING == iSyncStatus) {
                AloneDeploySchedule.addDevToQueue(dvInfo, queneDevFullSync);
                return;
            }
        }
        this.setSyncStatus(dvInfo, SYNC_STATUS_ENUM.FULL_SYNC_ING);
        SynAllDevTask fullSyncRequest = new SynAllDevTask();
        SyncData syncData = Activator.svcFactory.getSyncDataService();
        if (fullSyncRequest.syncAll(syncData, dvInfo)) {
            logger.info("fullsync success," + dvInfo);
            System.out.println("\u5168\u91cf\u540c\u6b65\u6267\u884c\u6210\u529f" + dvInfo);
        } else {
            logger.info("fullsync failed," + dvInfo);
            this.setSyncStatus(dvInfo, SYNC_STATUS_ENUM.SYNC_OK);
            System.out.println("\u5168\u91cf\u540c\u6b65\u6267\u884c\u5931\u8d25" + dvInfo);
        }
    }

    public static void main(String[] args) throws InterruptedException, PersistenceException {
        isAutoStartThread = false;
        System.setProperty("deploymentMode", "independent");
        PolicyMgr.PNP_DIR = ".\\testdir\\pnpp";
        PolicyMgr.FTP_PARAMETERS = ".\\testdir\\ftp\\options.ini";
        PolicyMgr.instance().refreshPolicy();
        GetFtpSftpParam getFtp = new GetFtpSftpParam();
        FtpInfo ftpInfo = getFtp.getFtpInfo();
        assert (ftpInfo.getPort() == 21);
        assert (ftpInfo.getPassword().equals("Changeme_123"));
        assert (ftpInfo.getServerIP().equals("10.108.104.127"));
        assert (ftpInfo.getServerRootPath().equals("D:\\"));
        assert (ftpInfo.getUserName().equals("ftpuser"));
        assert (ftpInfo.getServerVmfRelativePath().equals("nemgr_vmf" + File.separator + "syncRsp"));
        ArrayList<DevChange.DevInfo> devList = new ArrayList<DevChange.DevInfo>();
        for (int i = 0; i < 3; ++i) {
            String strIP = "10.107.227.3" + i;
            DevChange.DevIdentify devIdent = new DevChange.DevIdentify(strIP, 0);
            DevChange.DevInfo devInfo = new DevChange.DevInfo(devIdent, "CX600", "V800R005C00");
            CommunicateArg comArg = new CommunicateArg(devInfo.devIdentify.getIp(), "vmfa", "a5D3F2BB751E66CBCDDADC051817363D", 22);
            comArg.setLoginTimeout(60L);
            comArg.setResponseTimeout(60L);
            try {
                CommunicationArgumentMgr.addCommunicateArg((CommunicateArg)comArg);
            }
            catch (NetconfException e) {
                e.printStackTrace();
            }
            devList.add(devInfo);
        }
        DevMgr.instance().initDev(devList);
        assert (queneDevFullSync.size() == 3);
        assert (mDevAll.size() == 3);
        DevChange.DevIdentify devIden = new DevChange.DevIdentify("10.107.227.32", 0);
        DevChange.DevInfo dev = new DevChange.DevInfo(devIden, "CX600", "V800R005C00");
        AloneDeploySchedule.deleteDevFromQueue(dev);
        AloneDeploySchedule.deleteDevFromDevMap(dev);
        assert (queneDevFullSync.size() == 2);
        assert (mDevAll.size() == 2);
        DevMgr.instance().addDev(dev);
        Stub.instance().startAllThread();
        Thread.sleep(60000L);
        if (isAutoStartThread) assert (queneDevFullSync.size() == 0);
        assert (mDevAll.size() == 3);
        Stub.instance().stopAllThread();
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable e) {
            System.out.println("success!");
        }
    }

    private boolean threadStarted(Thread th) {
        return th.getState() != Thread.State.TERMINATED && th.getState() != Thread.State.NEW;
    }

    public static class DevMapInfo {
        private int iFlowID;
        private int iSyncStatus;

        public DevMapInfo(int iFlowID, int iSyncStatus) {
            this.iFlowID = iFlowID;
            this.iSyncStatus = iSyncStatus;
        }

        public void setFlowID(int iFlowID) {
            this.iFlowID = iFlowID;
        }

        public int getFlowID() {
            return this.iFlowID;
        }

        public void setSyncStatus(int iFlowID) {
            this.iSyncStatus = iFlowID;
        }

        public int getSyncStatus() {
            return this.iSyncStatus;
        }
    }

    public static final class SYNC_STATUS_ENUM {
        public static final Integer SYNC_OK = -2;
        public static final Integer SYNC_FAILED = -3;
        public static final Integer FULL_SYNC_ING = -5;
        public static final Integer INCR_SYNC_ING = -6;
    }
}

