/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.domain.RowData;
import com.huawei.vmf.qat.persistence.domain.TableDesc;
import com.huawei.vmf.qat.persistence.service.DBCommonOper;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.SyncData;
import com.huawei.vmf.qat.persistence.service.impl.DBCommonOper1Cfg1DB;
import com.huawei.vmf.qat.persistence.syncdata.RDScan;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.springframework.util.FileCopyUtils;
import org.xml.sax.helpers.DefaultHandler;

public class SyncDataImpl
implements SyncData {
    private Map<DevConfig, DBCommonOper> cfg2db = new HashMap<DevConfig, DBCommonOper>();
    private Map<PolicyQuery.DTV, RDScan> dtv2Scan = new HashMap<PolicyQuery.DTV, RDScan>();
    private Logger logger = RunLogger.getRunLogger();
    private Map<DevConfig, Map<String, Map<String, String>>> mHasAddedToDB = new HashMap<DevConfig, Map<String, Map<String, String>>>();

    @Override
    public boolean reNewCfgDB(DevConfig cfg) {
        try {
            this.init(cfg);
            DBCommonOper db = this.cfg2db.get(cfg);
            db.delCfg(cfg);
            db.enterOneMode();
            db.addCfg(cfg);
            db.useLastDBUrl(true);
        }
        catch (Exception e) {
            String errMsg = e + "\nreNewCfgDB failed in sync process! cfg=" + cfg;
            this.logger.error(errMsg);
            System.err.println(errMsg);
            return false;
        }
        return true;
    }

    @Override
    public boolean createTable(DevConfig cfg) {
        DBCommonOper db = this.cfg2db.get(cfg);
        PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
        PolicyQuery.DTV dtv = DevMgr.instance().getDTVByIdentify(cfg.getIdentify());
        List<TableDesc> tbs = pq.getTableDesc(dtv);
        for (TableDesc tb : tbs) {
            try {
                db.addTB(cfg, tb);
            }
            catch (Exception e) {
                String errMsg = e + "\ncreateTable failed in sync process! cfg=" + cfg;
                this.logger.error(errMsg);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean syncBegin(DevConfig cfg) {
        return this.cfg2db.get(cfg).syncBegin(cfg);
    }

    @Override
    public boolean syncEnd(DevConfig cfg, boolean success, int flowId, long devStartTime) {
        DBCommonOper db = this.cfg2db.get(cfg);
        boolean r = db.syncEnd(cfg, success, flowId, devStartTime);
        db.leaveOneMode();
        return r;
    }

    public static void main(String[] args) throws Exception {
        AloneDeploySchedule.isAutoStartThread = false;
        DevChange devChg = Activator.svcFactory.getDevChangeService();
        PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
        String testDir = ".\\testdir\\SyncData\\";
        PolicyMgr.PNP_DIR = testDir + "pnpp";
        DBCommonOper1Cfg1DB.DBFILE_DIR = testDir + "db";
        PolicyMgr.instance().refreshPolicy();
        String ip = "SyncData_Dev";
        String neType = "NE5000E";
        String neVer = "V800R003C00SPC300";
        DevChange.DevInfo dev = new DevChange.DevInfo(new DevChange.DevIdentify(ip, 0), neType, neVer);
        ArrayList<DevChange.DevInfo> devList = new ArrayList<DevChange.DevInfo>();
        devList.add(dev);
        DevMgr.instance().initDev(devList);
        PolicyQuery.DTV dtv = new PolicyQuery.DTV(neType, neVer);
        DevConfig cfg = DevConfig.newVRConfig(new DevChange.DevIdentify(ip, 0), 0);
        SyncDataImpl sync = new SyncDataImpl();
        assert (sync.reNewCfgDB(cfg));
        assert (sync.syncBegin(cfg));
        assert (sync.createTable(cfg));
        FileInputStream syncAllFile = new FileInputStream(testDir + "incSyncPkg.xml");
        ByteArrayOutputStream out = new ByteArrayOutputStream(syncAllFile.available());
        FileCopyUtils.copy((InputStream)syncAllFile, (OutputStream)out);
        StringBuffer sb = new StringBuffer(out.toString());
        assert (sync.incSync(cfg, sb));
        assert (sync.syncEnd(cfg, true, 0, 0L));
        String xpath = "/l2vpn/instances/instance/acs/ac/";
        List<RDScan.RD> rst = sync.dtv2Scan.get(dtv).getResultXpath2RDList().get(xpath);
        assert (rst.get((int)0).t == RDScan.RD.T.add);
        assert (rst.get((int)1).t == RDScan.RD.T.del);
        assert (rst.get((int)2).t == RDScan.RD.T.add);
        assert (rst.get((int)3).t == RDScan.RD.T.mdf);
        devChg.del(dev);
        testDir = ".\\testdir\\SyncData\\";
        PolicyMgr.PNP_DIR = testDir + "pnpp";
        DBCommonOper1Cfg1DB.DBFILE_DIR = testDir + "db";
        PolicyMgr.instance().refreshPolicy();
        ip = "SyncData_Dev";
        neType = "NE5000E";
        neVer = "V800R003C00SPC300";
        dev = new DevChange.DevInfo(new DevChange.DevIdentify(ip, 0), neType, neVer);
        devChg.add(dev);
        PolicyQuery.DTV dtv2 = new PolicyQuery.DTV(neType, neVer);
        DevConfig cfg2 = DevConfig.newVRConfig(new DevChange.DevIdentify(ip, 0), 0);
        SyncDataImpl sync2 = new SyncDataImpl();
        sync2.reNewCfgDB(cfg2);
        assert (sync2.syncBegin(cfg2));
        assert (sync2.createTable(cfg2));
        FileInputStream syncAllFile2 = new FileInputStream(testDir + "syncAllData\\pkg.xml");
        assert (sync2.syncAllFromStream(cfg2, syncAllFile2));
        assert (sync2.syncEnd(cfg2, true, 0, 0L));
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable ee) {
            System.out.println("success!");
        }
    }

    @Override
    public boolean incSync(DevConfig cfg, StringBuffer incRsp) {
        ByteArrayInputStream in = new ByteArrayInputStream(incRsp.toString().getBytes());
        return this.syncAllFromStream(cfg, in, true);
    }

    @Override
    public void incInit(DevConfig cfg) {
        this.init(cfg);
        DBCommonOper db = this.cfg2db.get(cfg);
        db.enterOneMode();
        db.useLastDBUrl(true);
    }

    @Override
    public boolean syncAllFromStream(DevConfig cfg, InputStream inContent) {
        return this.syncAllFromStream(cfg, inContent, false);
    }

    private void init(DevConfig cfg) {
        DBCommonOper1Cfg1DB db = new DBCommonOper1Cfg1DB();
        this.cfg2db.put(cfg, db);
        this.mHasAddedToDB.remove(cfg);
    }

    private boolean syncAllFromStream(DevConfig cfg, InputStream inContent, boolean isIncSync) {
        boolean ret = true;
        RDScan scan = this.getScan(cfg, isIncSync);
        try {
            boolean r = this.genRowData(cfg, inContent, scan);
            if (!r) {
                ret = false;
                return ret;
            }
        }
        catch (Exception e) {
            String errMsg = "sync from Stream(" + inContent.toString() + ") failed!";
            this.logger.error(e + errMsg);
        }
        return this.flushSyncAll(cfg, scan);
    }

    private boolean batchFlush(List<RDScan.RD> rds, RDScan scan, DevConfig cfg) {
        block12: {
            if (rds.size() <= 0) {
                return true;
            }
            DBCommonOper db = this.cfg2db.get(cfg);
            String objXpath = rds.get((int)0).xpath;
            Map<String, List<TableDesc>> obj2Tbs = scan.getObjXpath2Tbs();
            List<TableDesc> tbs = obj2Tbs.get(objXpath);
            RDScan.RD.T t = rds.get((int)0).t;
            try {
                if (t == RDScan.RD.T.add) {
                    for (TableDesc tb : tbs) {
                        List<RowData> rows = this.convertRD2RowList(rds, tb);
                        db.addRows(cfg, tb, rows);
                    }
                    break block12;
                }
                if (t == RDScan.RD.T.mdf) {
                    for (TableDesc tb : tbs) {
                        List<RowData> rows = this.convertRD2RowList(rds, tb);
                        db.mdfRows(cfg, tb, rows);
                    }
                    break block12;
                }
                if (t == RDScan.RD.T.del) {
                    for (TableDesc tb : tbs) {
                        for (RDScan.RD rd : rds) {
                            List<String> kvs = this.getKeyValues(rd, tb);
                            try {
                                db.delRowByKeys(cfg, tb, kvs);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                String errMsg = e + "\ndel failed while sync!";
                                this.logger.warn(errMsg);
                            }
                        }
                    }
                    break block12;
                }
                this.logger.error("batchFlush error, unkown RD type!");
                return false;
            }
            catch (Exception e) {
                String errMsg = e + "\nbatchFlush failed!";
                System.err.println(errMsg);
                this.logger.error(errMsg);
                return false;
            }
        }
        return true;
    }

    private RowData convertRD2Row(RDScan.RD rd, TableDesc tb) {
        RowData row = new RowData();
        Set<String> absColXpathList = rd.rd.cvs.keySet();
        for (String absColXpath : absColXpathList) {
            String v;
            String col = null;
            String propName = PolicyMgr.ObjPolicy.getPropName(absColXpath);
            if (propName != null) {
                String absXpath = PolicyMgr.ObjPolicy.getPropXpath(absColXpath);
                String relXpath = TableDesc.getRelXpathFromAbsXpath(absXpath, tb.getObjXpath());
                String propStr = PolicyMgr.ObjPolicy.constructProp(relXpath, propName);
                PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
                col = pq.propStr2ColName(propStr);
            } else {
                col = tb.getColNameByAbsXpath(absColXpath);
            }
            if (col == null || (v = rd.rd.cvs.get(absColXpath)) == null) continue;
            row.cvs.put(col, v);
        }
        return row.cvs.size() != 0 ? row : null;
    }

    private List<RowData> convertRD2RowList(List<RDScan.RD> rds, TableDesc tb) throws PersistenceException {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        for (RDScan.RD rd : rds) {
            if (!rd.xpath.equals(tb.getObjXpath())) continue;
            RowData row = this.convertRD2Row(rd, tb);
            if (row == null) {
                this.logger.warn("RD is not in this table!");
                this.logger.warn("\ntable=" + tb);
                this.logger.warn("\nRD=" + rd.rd);
                continue;
            }
            rows.add(row);
        }
        return rows;
    }

    private boolean flushSyncAll(DevConfig cfg, RDScan scan) {
        block1: {
            ArrayList<RDScan.RD> allRd = new ArrayList<RDScan.RD>();
            int next = 0;
            do {
                allRd.clear();
                int old = next;
                next = this.getBundleRdList(cfg, scan, next, allRd);
                if (next == old) break block1;
            } while (this.batchFlush(allRd, scan, cfg));
            return false;
        }
        return true;
    }

    private boolean genRowData(DevConfig cfg, InputStream content, RDScan scan) throws PersistenceException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(content, (DefaultHandler)scan);
        }
        catch (Exception e) {
            String errMsg = e + "\ngenRowData failed!";
            this.logger.error(errMsg);
            return false;
        }
        return true;
    }

    private int getBundleRdList(DevConfig cfg, RDScan scan, int start, List<RDScan.RD> rds) {
        List<RDScan.RD> allRds = scan.getResultRDList();
        int allNum = allRds.size();
        if (start >= allNum) {
            return start;
        }
        int idx = start;
        RDScan.RD.T t = allRds.get((int)idx).t;
        String objXpath = allRds.get((int)idx).xpath;
        while (idx < allNum) {
            RDScan.RD rd = allRds.get(idx);
            if (rd.t == RDScan.RD.T.none) {
                ++idx;
                continue;
            }
            boolean hasBeenAdded = this.hasAddBefore(cfg, scan, rd);
            if (rd.t == RDScan.RD.T.add && hasBeenAdded) {
                rd.t = RDScan.RD.T.mdf;
                if (idx != start) continue;
                t = rd.t;
                continue;
            }
            if (rd.t != t || !rd.xpath.equals(objXpath)) break;
            rds.add(rd);
            ++idx;
            if (rd.t == RDScan.RD.T.add && !hasBeenAdded) {
                this.addRow(cfg, scan, rd);
                continue;
            }
            if (rd.t != RDScan.RD.T.del) continue;
            this.delRow(cfg, scan, rd);
        }
        return idx;
    }

    private boolean hasAddBefore(DevConfig cfg, RDScan scan, RDScan.RD rd) {
        Map<String, Map<String, String>> xpath2Rows = this.mHasAddedToDB.get(cfg);
        if (xpath2Rows == null) {
            return false;
        }
        Map<String, String> rows = xpath2Rows.get(rd.xpath);
        if (rows == null) {
            return false;
        }
        String id = this.rdkeys2StrId(cfg, scan, rd);
        return rows.get(id) != null;
    }

    private String rdkeys2StrId(DevConfig cfg, RDScan scan, RDScan.RD rd) {
        TableDesc tb = scan.getObjXpath2Tbs().get(rd.xpath).get(0);
        List<String> keyXpaths = tb.getKeysAbsXpath();
        StringBuilder r = new StringBuilder();
        for (String k : keyXpaths) {
            String v = rd.rd.cvs.get(k);
            r.append(k);
            r.append('\r');
            r.append(v);
            r.append('\r');
        }
        return r.toString();
    }

    private void addRow(DevConfig cfg, RDScan scan, RDScan.RD rd) {
        String objXpath;
        Map<String, String> addedRows;
        TableDesc tb = scan.getObjXpath2Tbs().get(rd.xpath).get(0);
        Map<String, Map<String, String>> objXpath2Rows = this.mHasAddedToDB.get(cfg);
        if (null == objXpath2Rows) {
            objXpath2Rows = new HashMap<String, Map<String, String>>();
            this.mHasAddedToDB.put(cfg, objXpath2Rows);
        }
        if ((addedRows = objXpath2Rows.get(objXpath = tb.getObjXpath())) == null) {
            addedRows = new HashMap<String, String>();
            objXpath2Rows.put(objXpath, addedRows);
        }
        String id = this.rdkeys2StrId(cfg, scan, rd);
        addedRows.put(id, "");
    }

    private void delRow(DevConfig cfg, RDScan scan, RDScan.RD rd) {
        Map<String, Map<String, String>> xpath2Rows = this.mHasAddedToDB.get(cfg);
        if (xpath2Rows == null) {
            return;
        }
        Map<String, String> rows = xpath2Rows.get(rd.xpath);
        if (rows == null) {
            return;
        }
        String id = this.rdkeys2StrId(cfg, scan, rd);
        rows.remove(id);
    }

    private List<String> getKeyValues(RDScan.RD rd, TableDesc tb) {
        ArrayList<String> kvs = new ArrayList<String>();
        List<String> keyXpaths = tb.getKeysAbsXpath();
        for (String keyXpath : keyXpaths) {
            String kv = rd.rd.cvs.get(keyXpath);
            kvs.add(kv);
        }
        return kvs;
    }

    private RDScan getScan(DevConfig cfg, boolean isIncSync) {
        RDScan r;
        PolicyQuery.DTV dtv = DevMgr.instance().getDTVByIdentify(cfg.getIdentify());
        if (dtv == null) {
            this.logger.error("there must be some error while getScan, could not find dtv! cfg=" + cfg);
        }
        if ((r = this.dtv2Scan.get(dtv)) == null) {
            r = new RDScan(dtv, isIncSync);
            this.dtv2Scan.put(dtv, r);
        }
        r.init(dtv, isIncSync, false);
        return r;
    }
}

