/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.syncdata;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.RowData;
import com.huawei.vmf.qat.persistence.domain.TableDesc;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RDScan
extends DefaultHandler {
    private Logger logger = RunLogger.getRunLogger();
    static String INCSYNC_DIFFATTR_NAME = "difference";
    private Stack<String> elemXpath = new Stack();
    private StringBuilder xpathSb = new StringBuilder(50);
    private Stack<RD> rdPartStack = new Stack();
    private SCAN_STATE pre1State = SCAN_STATE.origin;
    private SCAN_STATE pre2State = SCAN_STATE.origin;
    private String lastData = "";
    private Map<String, List<RD>> xpath2ObjRdList = new HashMap<String, List<RD>>();
    private List<RD> objRdList = new ArrayList<RD>();
    private Map<String, List<TableDesc>> objXpath2Tbs = new HashMap<String, List<TableDesc>>();
    private Map<String, List<String>> key2ObjXpathList = new HashMap<String, List<String>>();
    private Map<String, Set<String>> objXpath2SelfKeys = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> objXpath2ParentKeys = new HashMap<String, Set<String>>();
    private PolicyQuery policyQry = Activator.svcFactory.getPolicyQueryService();
    private boolean isIncSync = false;

    public static void main(String[] args) throws Exception {
        PolicyMgr.PNP_DIR = ".\\testdir\\RDScan\\pnpp3";
        PolicyMgr.instance().refreshPolicy();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        PolicyQuery.DTV dtv = new PolicyQuery.DTV("unkown", "V800R006C00");
        FileInputStream pkg = new FileInputStream(".\\testdir\\RDScan\\pkg3.xml");
        RDScan scan = new RDScan(dtv, false);
        factory.newSAXParser().parse((InputStream)pkg, (DefaultHandler)scan);
        Map<String, List<RD>> rst = scan.getResultXpath2RDList();
        assert (rst.size() == 0);
        PolicyMgr.PNP_DIR = ".\\testdir\\RDScan\\pnpp3";
        PolicyMgr.instance().refreshPolicy();
        factory = SAXParserFactory.newInstance();
        dtv = new PolicyQuery.DTV("NetEngine5000E", "V800R006C00");
        pkg = new FileInputStream(".\\testdir\\RDScan\\pkg3.xml");
        scan = new RDScan(dtv, false);
        factory.newSAXParser().parse((InputStream)pkg, (DefaultHandler)scan);
        rst = scan.getResultXpath2RDList();
        String objXpath = "/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/";
        String propXpath = "/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/vrfName";
        String propName = "vrfId";
        String propStr = PolicyMgr.ObjPolicy.constructProp(propXpath, propName);
        assert (rst.get((Object)objXpath).get((int)0).rd.cvs.get(propStr).equals("12345"));
        PolicyMgr.PNP_DIR = ".\\testdir\\RDScan\\pnpp2";
        PolicyMgr.instance().refreshPolicy();
        factory = SAXParserFactory.newInstance();
        dtv = new PolicyQuery.DTV("NetEngine5000E", "V800R006C00");
        pkg = new FileInputStream(".\\testdir\\RDScan\\pkg22.xml");
        scan = new RDScan(dtv, false);
        factory.newSAXParser().parse((InputStream)pkg, (DefaultHandler)scan);
        rst = scan.getResultXpath2RDList();
        assert (rst.size() == 2);
        List<RD> ifRds = rst.get("/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/l3vpnIfs/l3vpnIf/");
        List<RD> l3vpnRds = rst.get("/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/");
        assert (ifRds.size() == 33);
        String vrfNameXpath = "/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/vrfName";
        assert (ifRds.get((int)0).rd.cvs.get(vrfNameXpath).equals("_public_"));
        assert (ifRds.get((int)20).rd.cvs.get(vrfNameXpath).equals("_public_"));
        assert (ifRds.get((int)32).rd.cvs.get(vrfNameXpath).equals("_public_"));
        assert (l3vpnRds.size() == 9);
        assert (l3vpnRds.get((int)0).rd.cvs.get(vrfNameXpath).equals("_public_"));
        assert (l3vpnRds.get((int)8).rd.cvs.get(vrfNameXpath).equals("zleil_8"));
        PolicyMgr.PNP_DIR = ".\\testdir\\RDScan\\pnpp2";
        PolicyMgr.instance().refreshPolicy();
        factory = SAXParserFactory.newInstance();
        dtv = new PolicyQuery.DTV("NetEngine5000E", "V800R006C00");
        pkg = new FileInputStream(".\\testdir\\RDScan\\pkg2.xml");
        scan = new RDScan(dtv, false);
        factory.newSAXParser().parse((InputStream)pkg, (DefaultHandler)scan);
        rst = scan.getResultXpath2RDList();
        assert (rst.size() == 2);
        RD ifRd = rst.get("/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/l3vpnIfs/l3vpnIf/").get(0);
        RD l3vpnRd = rst.get("/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/").get(0);
        assert (ifRd.rd.toString().equals("[/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/l3vpnIfs/l3vpnIf/ifName=NULL0,/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/l3vpnIfs/l3vpnIf/ipv4Addr=,/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/l3vpnIfs/l3vpnIf/subnetMask=,/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/vrfName=_public_,]"));
        assert (l3vpnRd.rd.toString().equals("[/l3vpn/l3vpncomm/l3vpnInstances/l3vpnInstance/vrfName=_public_,]"));
        String testDir = ".\\testdir\\RDScan\\";
        PolicyMgr.PNP_DIR = testDir + "pnpp";
        PolicyMgr.instance().refreshPolicy();
        DevMgr.instance().initDev(new ArrayList<DevChange.DevInfo>());
        PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
        PolicyQuery.DTV dtv2 = new PolicyQuery.DTV("NE5000E", "V800R003C00SPC300");
        String instXpath = "/l2vpn/instances/instance/";
        List<TableDesc> ts = pq.getTableDesc(dtv2, instXpath);
        assert (ts.size() == 1);
        assert (ts.get(0).getAllCols().size() == 3);
        assert (ts.get(0).getKeys().size() == 1);
        FileInputStream pkg2 = new FileInputStream(testDir + "pkg.xml");
        RDScan scan2 = new RDScan(dtv2, true);
        SAXParserFactory factory2 = SAXParserFactory.newInstance();
        factory2.newSAXParser().parse((InputStream)pkg2, (DefaultHandler)scan2);
        Map<String, List<RD>> rst2 = scan2.getResultXpath2RDList();
        assert (rst2.get(instXpath).size() == 1);
        RD rd = rst2.get(instXpath).get(0);
        assert (rd.t == RD.T.mdf);
        assert (rd.rd.cvs.get(instXpath + "name").equals("testvpn"));
        assert (rd.rd.cvs.get(instXpath + "encap").equals("ethernet"));
        assert (rd.rd.cvs.get(instXpath + "tdmPara/tdmAttr1").equals("tdmParaV"));
        String pwXpath = "/l2vpn/instances/instance/pws/pw/";
        assert (rst2.get((Object)pwXpath).get((int)0).t == RD.T.none);
        assert (rst2.get((Object)pwXpath).get((int)1).t == RD.T.none);
        String acXpath = "/l2vpn/instances/instance/acs/ac/";
        rd = rst2.get(acXpath).get(0);
        assert (rd.t == RD.T.add);
        assert (rd.rd.cvs.get(acXpath + "ifName").equals("Ethernet 1/1/1.1"));
        assert (rd.rd.cvs.get(acXpath + "status").equals("status_xx"));
        rd = rst2.get(acXpath).get(1);
        assert (rd.t == RD.T.del);
        assert (rd.rd.cvs.get(acXpath + "ifName").equals("Ethernet 1/1/1.2"));
        assert (rd.rd.cvs.get(acXpath + "status").equals("status_xx"));
        rd = rst2.get(acXpath).get(2);
        assert (rd.t == RD.T.mdf);
        assert (rd.rd.cvs.get(acXpath + "ifName").equals("Ethernet 1/1/1.3"));
        assert (rd.rd.cvs.get(acXpath + "status").equals("status_xx"));
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable ee) {
            System.out.println("success!");
        }
    }

    public RDScan(PolicyQuery.DTV dtv, boolean isIncSync) {
        this.init(dtv, isIncSync, true);
    }

    public void init(PolicyQuery.DTV dtv, boolean isIncSync, boolean isFirst) {
        this.isIncSync = isIncSync;
        this.elemXpath.clear();
        this.xpathSb = new StringBuilder();
        this.rdPartStack.clear();
        this.pre1State = SCAN_STATE.origin;
        this.pre2State = SCAN_STATE.origin;
        this.lastData = "";
        this.xpath2ObjRdList.clear();
        this.objRdList.clear();
        if (!isFirst) {
            return;
        }
        this.objXpath2Tbs.clear();
        this.objXpath2SelfKeys.clear();
        this.objXpath2ParentKeys.clear();
        this.key2ObjXpathList.clear();
        List<TableDesc> tbs = Activator.svcFactory.getPolicyQueryService().getTableDesc(dtv);
        if (null == tbs) {
            String errMsg = "RDScan.init failed, getTableDesc return null";
            System.err.println(errMsg);
            this.logger.error(errMsg);
            return;
        }
        for (TableDesc tb : tbs) {
            String objXpath = this.policyQry.tbName2Xpath(tb.getName());
            if (!this.objXpath2Tbs.containsKey(objXpath)) {
                ArrayList<TableDesc> tbList = new ArrayList<TableDesc>();
                tbList.add(tb);
                this.objXpath2Tbs.put(objXpath, tbList);
            } else {
                this.objXpath2Tbs.get(objXpath).add(tb);
            }
            HashSet<String> parentKeys = new HashSet<String>();
            HashSet<String> selfKeys = new HashSet<String>();
            List<String> tbKeys = tb.getKeys();
            if (tbKeys != null) {
                for (String k : tbKeys) {
                    if (!objXpath.endsWith("/")) {
                        objXpath = objXpath + "/";
                    }
                    String keyRelXpath = this.policyQry.colName2RelXpath(k);
                    String keyXpath = this.genObsXpath(objXpath, keyRelXpath);
                    if (keyRelXpath.startsWith("..")) {
                        parentKeys.add(keyXpath);
                    } else {
                        selfKeys.add(keyXpath);
                    }
                    List<String> objXpathList = this.key2ObjXpathList.get(keyXpath);
                    if (objXpathList == null) {
                        objXpathList = new ArrayList<String>();
                        this.key2ObjXpathList.put(keyXpath, objXpathList);
                    }
                    objXpathList.add(objXpath);
                }
            }
            this.objXpath2ParentKeys.put(objXpath, parentKeys);
            this.objXpath2SelfKeys.put(objXpath, selfKeys);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("rpc-reply") || qName.equals("data")) {
            return;
        }
        this.elemXpath.push(qName);
        this.stateChg(SCAN_STATE.S);
        String curXpath = this.getCurXpath();
        RD.T t = this.getRDType(uri, attributes);
        HashSet<String> keys = new HashSet<String>();
        Set<String> keysOrign = this.objXpath2ParentKeys.get(curXpath + "/");
        if (keysOrign != null) {
            for (String key : keysOrign) {
                keys.add(key);
            }
        }
        RD rd = new RD(t, curXpath, keys);
        this.genProps(attributes, rd);
        this.rdPartStack.push(rd);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("rpc-reply") || qName.equals("data")) {
            return;
        }
        RD currRD = (RD)this.rdPartStack.lastElement();
        RD uperRD = null;
        int len = this.rdPartStack.size();
        if (len >= 2) {
            uperRD = (RD)this.rdPartStack.get(len - 2);
        }
        if (this.isPreSD()) {
            String attrXpath = currRD.xpath;
            String attrValue = this.lastData;
            uperRD.rd.cvs.put(attrXpath, attrValue);
            uperRD.rd.cvs.putAll(currRD.rd.cvs);
        } else if (this.isPreS()) {
            String attrXpath = currRD.xpath;
            String attrValue = this.lastData = "";
            uperRD.rd.cvs.put(attrXpath, attrValue);
        } else if (this.isPreE() || this.isPreED()) {
            String xpath = currRD.xpath;
            if (this.isPersistObj(xpath + "/")) {
                if (!xpath.endsWith("/")) {
                    xpath = xpath + "/";
                }
                currRD.xpath = xpath;
                List<RD> rdList = this.xpath2ObjRdList.get(xpath);
                if (rdList == null) {
                    rdList = new ArrayList<RD>();
                    this.xpath2ObjRdList.put(xpath, rdList);
                }
                rdList.add(currRD);
                this.objRdList.add(currRD);
                Set<String> ks = this.objXpath2SelfKeys.get(xpath);
                if (ks != null) {
                    for (String key : ks) {
                        String value = currRD.rd.cvs.get(key);
                        this.updateRDParentKey(key, value);
                    }
                }
            } else {
                Set<String> attrs = currRD.rd.cvs.keySet();
                if (attrs != null) {
                    for (String attr : attrs) {
                        String v = currRD.rd.cvs.get(attr);
                        if (uperRD != null) {
                            uperRD.rd.cvs.put(attr, v);
                        }
                        String value = currRD.rd.cvs.get(attr);
                        this.updateRDParentKey(attr, value);
                    }
                }
            }
        }
        this.stateChg(SCAN_STATE.E);
        this.elemXpath.pop();
        this.rdPartStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastData = new String(ch, start, length);
        this.stateChg(SCAN_STATE.D);
    }

    public Map<String, List<RD>> getResultXpath2RDList() {
        return this.xpath2ObjRdList;
    }

    public List<RD> getResultRDList() {
        return this.objRdList;
    }

    public Map<String, List<TableDesc>> getObjXpath2Tbs() {
        return this.objXpath2Tbs;
    }

    private void genProps(Attributes attributes, RD rd) {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String propName = attributes.getQName(i);
            if (propName.equals(INCSYNC_DIFFATTR_NAME) || propName.equals("xmlns") || propName.equals("format-version") || propName.equals("content-version")) continue;
            String value = attributes.getValue(i);
            String xpath = rd.xpath;
            if (xpath.endsWith("/")) {
                xpath.substring(0, xpath.length() - 1);
            }
            String propStr = PolicyMgr.ObjPolicy.constructProp(xpath, propName);
            rd.rd.cvs.put(propStr, value);
        }
    }

    private void updateRDParentKey(String attr, String value) {
        List<String> objXpathList = this.key2ObjXpathList.get(attr);
        if (objXpathList != null) {
            for (String objXpath : objXpathList) {
                List<RD> rdList = this.xpath2ObjRdList.get(objXpath);
                if (rdList == null) continue;
                for (RD rd : rdList) {
                    if (!rd.unkownParentKeys.contains(attr)) continue;
                    rd.rd.cvs.put(attr, value);
                    rd.unkownParentKeys.remove(attr);
                }
            }
        }
    }

    private boolean isPersistObj(String xpath) {
        return this.objXpath2Tbs.containsKey(xpath);
    }

    private boolean isPreED() {
        return this.pre2State == SCAN_STATE.E && this.pre1State == SCAN_STATE.D;
    }

    private boolean isPreE() {
        return this.pre1State == SCAN_STATE.E;
    }

    private boolean isPreSD() {
        return this.pre2State == SCAN_STATE.S && this.pre1State == SCAN_STATE.D;
    }

    private boolean isPreS() {
        return this.pre1State == SCAN_STATE.S;
    }

    private void stateChg(SCAN_STATE s) {
        this.pre2State = this.pre1State;
        this.pre1State = s;
    }

    private RD.T getRDType(String uri, Attributes attrs) {
        String diff = attrs.getValue(uri, INCSYNC_DIFFATTR_NAME);
        if (this.isIncSync) {
            if (diff == null) {
                return RD.T.none;
            }
            if (diff.equals("modify")) {
                return RD.T.mdf;
            }
            if (diff.equals("delete")) {
                return RD.T.del;
            }
            if (diff.equals("create")) {
                return RD.T.add;
            }
            String errMsg = "unknown diff value while incSync. diff=" + diff;
            this.logger.error(errMsg);
            System.out.println(errMsg);
            return RD.T.none;
        }
        return RD.T.add;
    }

    private String getCurXpath() {
        this.xpathSb.setLength(0);
        for (String elem : this.elemXpath) {
            this.xpathSb.append('/');
            this.xpathSb.append(elem);
        }
        return this.xpathSb.toString();
    }

    private String genObsXpath(String prefix, String rel) {
        int i;
        String[] relSplits;
        int upperNum = 0;
        for (String pice : relSplits = rel.split("/")) {
            if (!pice.equals("..")) continue;
            ++upperNum;
        }
        StringBuilder r = new StringBuilder();
        String[] prefixSplits = prefix.split("/");
        for (i = 0; i < prefixSplits.length - upperNum; ++i) {
            if (prefixSplits[i].equals("")) continue;
            r.append("/");
            r.append(prefixSplits[i]);
        }
        for (i = upperNum; i < relSplits.length; ++i) {
            if (relSplits[i].equals("")) continue;
            r.append("/");
            r.append(relSplits[i]);
        }
        return r.toString();
    }

    static enum SCAN_STATE {
        origin,
        S,
        D,
        E;

    }

    static class RD {
        T t;
        final RowData rd = new RowData();
        String xpath;
        final Set<String> unkownParentKeys;

        RD(T t, String xpath, Set<String> unkownParentKeys) {
            this.t = t;
            this.xpath = xpath;
            this.unkownParentKeys = unkownParentKeys;
        }

        static enum T {
            add,
            del,
            mdf,
            none;

        }
    }
}

