/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.service.impl;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.TableDesc;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.syncdata.alone.Stub;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class PolicyQuery1Cfg1DB
implements PolicyQuery {
    public static int DEFAULT_STR_LEN = 4096;
    public static final String NETCONF_NAMESPACE = " xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\" ";
    public static final String OPER_TYPE = "type=\"oper\"";
    private static final String tbPrifix = "T";
    private static final String attrPrifix = "A";
    private Logger logger = RunLogger.getRunLogger();

    @Override
    public boolean getSyncStatus(DevChange.DevIdentify dv, String xpath) {
        try {
            List<TableDesc> tableDesc = this.getTableDesc(dv, xpath);
            if (null != tableDesc && !tableDesc.isEmpty() && Stub.instance().isInDevMap(dv) && Activator.svcFactory.getDBCommonOperService().checkDevConsist(dv)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        XpathModeTree tree = new XpathModeTree();
        tree.addXpath("/a/a");
        tree.addXpath("/a/f");
        tree.addXpath("/a/g2/b");
        tree.addXpath("/a/g2/g/g/a");
        tree.addXpath("/a/g1/a");
        tree.addXpath("/a/g2/g/b");
        tree.addXpath("/a/g2/a");
        tree.addXpath("/a/g2/g/a");
        tree.addXpath("/a/g1/b");
        tree.addXpath("/a/c");
        tree.genPkg();
        assert (tree.sb.toString().equals("<a  xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\" ><a/><f/><c/><g2><b/><a/><g><b/><a/><g><a/></g></g></g2><g1><a/><b/></g1></a>"));
        PolicyQuery1Cfg1DB o = new PolicyQuery1Cfg1DB();
        assert (o.xpath2TbNamePrefix("/a/b/c/").equals("T_a_b_c_"));
        assert (o.xpath2TbNamePrefix("/a/b/c").equals("T_a_b_c_"));
        assert (o.relXpath2ColName("a/b/c").equals("Aa_b_c"));
        assert (o.relXpath2ColName("../a/b/c").equals("A_0__0__a_b_c"));
        assert (o.colName2RelXpath("Aa_b_c").equals("a/b/c"));
        assert (o.colName2RelXpath("A_0__0__a_b_c").equals("../a/b/c"));
        PolicyMgr.PNP_DIR = ".\\testdir\\pnpp";
        PolicyQuery.DTV dtv = new PolicyQuery.DTV("NE5000E", "V800R003C00SPC300");
        PolicyMgr.instance().refreshPolicy();
        DevMgr.instance().initDev(new ArrayList<DevChange.DevInfo>());
        List<TableDesc> tbs = o.getTableDesc(dtv);
        List<TableDesc> tbtest = o.getTableDesc(dtv, "/ifm");
        assert (tbs.size() == 2);
        assert (tbs.get(1).getName().equals(o.xpath2TbNamePrefix("/ifm/interfaces/interface")));
        assert (tbs.get(1).getAllCols().size() == 3);
        assert (tbs.get(1).getAllConstrains().size() == 1);
        StringBuilder sb = new StringBuilder();
        o.getSyncAllContent(sb, dtv);
        assert (sb.toString().equals("<ifm  xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\" ><interfaces2><interface><ifName/><phyType/><description/></interface></interfaces2><interfaces><interface><ifName/><phyType/><description/></interface></interfaces></ifm>"));
        sb.setLength(0);
        tbs.clear();
        TableDesc tbPw = new TableDesc();
        ArrayList<String> tbPwCols = new ArrayList<String>();
        ArrayList<TableDesc.ColType> tbPwColsTypes = new ArrayList<TableDesc.ColType>();
        tbPw.setName(o.xpath2TbNamePrefix("/l2vpn/insts/inst/pws/pw/"));
        tbPwCols.add(o.relXpath2ColName("pwId"));
        tbPwColsTypes.add(TableDesc.ColType.genINT32());
        tbPwCols.add(o.relXpath2ColName("peerIp"));
        tbPwColsTypes.add(TableDesc.ColType.genINT32());
        tbPwCols.add(o.relXpath2ColName("../../name"));
        tbPwColsTypes.add(TableDesc.ColType.genINT32());
        tbPw.addCols(tbPwCols, tbPwColsTypes);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(o.relXpath2ColName("pwId"));
        keys.add(o.relXpath2ColName("../../name"));
        tbPw.addKey(keys);
        tbs.add(tbPw);
        TableDesc tbInst = new TableDesc();
        ArrayList<String> tbInstCols = new ArrayList<String>();
        ArrayList<TableDesc.ColType> tbInstColsTypes = new ArrayList<TableDesc.ColType>();
        tbInst.setName(o.xpath2TbNamePrefix("/l2vpn/insts/inst"));
        tbInstCols.add(o.relXpath2ColName("name"));
        tbInstColsTypes.add(TableDesc.ColType.genINT32());
        tbInstCols.add(o.relXpath2ColName("encap"));
        tbInstColsTypes.add(TableDesc.ColType.genINT32());
        tbInstCols.add(o.relXpath2ColName("status"));
        tbInstColsTypes.add(TableDesc.ColType.genINT32());
        tbInst.addCols(tbInstCols, tbInstColsTypes);
        keys.clear();
        keys.add(o.relXpath2ColName("name"));
        tbInst.addKey(keys);
        tbs.add(tbInst);
        o.getSyncAllContent(sb, tbs);
        assert (sb.toString().equals("<l2vpn  xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\" ><insts><inst><name/><encap/><status/><pws><pw><pwId/><peerIp/></pw></pws></inst></insts></l2vpn>"));
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable e) {
            System.out.println("success!");
        }
    }

    @Override
    public void getIncrSyncContent(StringBuilder sb, PolicyQuery.DTV dtv) {
        List<TableDesc> tbs = this.getTableDesc(dtv);
        if (null == tbs) {
            this.logger.warn("getIncrSyncContent failed,getTableDesc return null");
            return;
        }
        HashMap<String, String> mFeature = new HashMap<String, String>();
        this.getFeatureMapInfo(mFeature, tbs);
        Set keys = mFeature.keySet();
        for (String k : keys) {
            sb.append("<");
            sb.append(k);
            sb.append(NETCONF_NAMESPACE);
            sb.append("/>");
        }
    }

    @Override
    public void getSyncAllContent(StringBuilder sb, PolicyQuery.DTV dtv) {
        List<TableDesc> tbs = this.getTableDesc(dtv);
        if (null == tbs) {
            return;
        }
        this.getSyncAllContent(sb, tbs);
    }

    @Override
    public void getSynAllCont4Adapter(StringBuilder sb, PolicyQuery.DTV dtv, List<String> xpathList) {
        List<TableDesc> tbs = this.getTableDesc(dtv);
        if (null == tbs) {
            return;
        }
        this.getSynAllCont4Adapter(sb, tbs, xpathList);
    }

    @Override
    public void getSyncAllContentByAttrs(StringBuilder sb, List<String> attrXpathList) {
        XpathModeTree tree = new XpathModeTree();
        for (String absXpath : attrXpathList) {
            tree.addXpath(absXpath);
        }
        tree.genPkg();
        sb.append((CharSequence)tree.sb);
    }

    @Override
    public List<TableDesc> getTableDesc(DevChange.DevIdentify devIdentify, String xpath) {
        xpath = this.adjustObjXpath(xpath);
        PolicyQuery.DTV dtv = DevMgr.instance().getDTVByIdentify(devIdentify);
        if (dtv == null) {
            return null;
        }
        return this.getTableDesc(dtv, xpath);
    }

    @Override
    public List<TableDesc> getTableDesc(PolicyQuery.DTV dtv) {
        PolicyMgr.DevPolicy dp = PolicyMgr.instance().getPolicy(dtv);
        if (dp == null) {
            return null;
        }
        ArrayList<TableDesc> r = new ArrayList<TableDesc>();
        Set<String> xpaths = dp.xpath2Policy.keySet();
        for (String xpath : xpaths) {
            List<TableDesc> objTb = this.getTableDesc(dtv, xpath);
            if (objTb == null) continue;
            r.addAll(objTb);
        }
        return r.size() != 0 ? r : null;
    }

    @Override
    public List<TableDesc> getTableDesc(PolicyQuery.DTV dtv, String xpath) {
        xpath = this.adjustObjXpath(xpath);
        TableDesc td = new TableDesc();
        PolicyMgr.DevPolicy dp = PolicyMgr.instance().getPolicy(dtv);
        if (dp == null) {
            return null;
        }
        PolicyMgr.ObjPolicy op = dp.xpath2Policy.get(xpath);
        if (op == null) {
            return null;
        }
        String tbName = this.xpath2TbNamePrefix(xpath);
        td.setName(tbName);
        try {
            List<String> cols = this.convertRelAttrXpath2ColNameList(op.cfgAttrs);
            List<String> propCols = this.convertPropStr2ColNameList(op.props);
            cols.addAll(propCols);
            List<TableDesc.ColType> types = this.getAttrTypes(op.cfgAttrTypes);
            List<TableDesc.ColType> propTypes = this.getAttrTypes(op.propTypes);
            types.addAll(propTypes);
            List<String> keys = this.convertRelAttrXpath2ColNameList(op.keys);
            td.addCols(cols, types);
            td.addKey(keys);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("getTableDesc error! " + e);
        }
        ArrayList<TableDesc> r = new ArrayList<TableDesc>();
        r.add(td);
        return r.size() != 0 ? r : null;
    }

    @Override
    public String relXpath2ColName(String relXpath) {
        return attrPrifix + relXpath.replace(".", "_0_").replace('/', '_');
    }

    @Override
    public String colName2RelXpath(String col) {
        if (null == this.colName2PropName(col)) {
            return col.substring(attrPrifix.length()).replace("_0_", ".").replace('_', '/');
        }
        return col.substring(attrPrifix.length()).substring(0, col.indexOf("_1_") - attrPrifix.length());
    }

    @Override
    public String propStr2ColName(String propStr) {
        return this.relXpath2ColName(propStr).replace("]", "_1_");
    }

    @Override
    public String colName2PropName(String col) {
        int idx = col.indexOf("_1_");
        if (idx == -1) {
            return null;
        }
        return col.substring(idx + 3);
    }

    @Override
    public String tbName2Xpath(String tbName) {
        try {
            return tbName.substring(tbPrifix.length()).replace('_', '/');
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String xpath2TbNamePrefix(String xpath) {
        xpath = this.adjustObjXpath(xpath);
        return tbPrifix + xpath.replace('/', '_');
    }

    private void getFeatureMapInfo(Map<String, String> mFeature, List<TableDesc> tbs) {
        for (TableDesc tb : tbs) {
            String objXpath = this.tbName2Xpath(tb.getName());
            String[] splits = objXpath.split("/");
            mFeature.put(splits[1], "");
        }
    }

    private String adjustObjXpath(String s) {
        if (!s.endsWith("/")) {
            return s + "/";
        }
        return s;
    }

    private void getSynAllCont4Adapter(StringBuilder sb, List<TableDesc> tbs, List<String> adptAttrList) {
        ArrayList<String> attrXpathList = new ArrayList<String>();
        for (TableDesc tb : tbs) {
            String objXpath = tb.getObjXpath();
            for (String col : tb.getAllCols()) {
                String relXpath = this.colName2RelXpath(col);
                String absXpath = TableDesc.getAbsXpathFromRelXpath(relXpath, objXpath);
                attrXpathList.add(absXpath);
            }
        }
        attrXpathList.addAll(adptAttrList);
        this.getSyncAllContentByAttrs(sb, attrXpathList);
    }

    private void getSyncAllContent(StringBuilder sb, List<TableDesc> tbs) {
        ArrayList<String> attrXpathList = new ArrayList<String>();
        for (TableDesc tb : tbs) {
            String objXpath = tb.getObjXpath();
            for (String col : tb.getAllCols()) {
                String relXpath = this.colName2RelXpath(col);
                String absXpath = TableDesc.getAbsXpathFromRelXpath(relXpath, objXpath);
                attrXpathList.add(absXpath);
            }
        }
        this.getSyncAllContentByAttrs(sb, attrXpathList);
    }

    private List<String> convertRelAttrXpath2ColNameList(List<String> attrs) {
        ArrayList<String> r = new ArrayList<String>();
        for (String attr : attrs) {
            String col = this.relXpath2ColName(attr);
            r.add(col);
        }
        return r;
    }

    private List<String> convertPropStr2ColNameList(List<String> props) {
        ArrayList<String> r = new ArrayList<String>();
        for (String prop : props) {
            String col = this.propStr2ColName(prop);
            r.add(col);
        }
        return r;
    }

    private List<TableDesc.ColType> getAttrTypes(List<String> typeStrs) {
        ArrayList<TableDesc.ColType> r = new ArrayList<TableDesc.ColType>();
        for (String ts : typeStrs) {
            int len;
            if (ts.startsWith("STR")) {
                len = this.getLenFromAttrTypeStr(ts);
                r.add(TableDesc.ColType.genSTR(len + 1));
                continue;
            }
            if (ts.startsWith("VARSTR")) {
                len = this.getLenFromAttrTypeStr(ts);
                r.add(TableDesc.ColType.genVARSTR(len));
                continue;
            }
            if (ts.equals("INT32")) {
                r.add(TableDesc.ColType.genINT32());
                continue;
            }
            this.logger.warn("unknow type(" + ts + "), default to DEFAULT_STR_LEN!");
            r.add(TableDesc.ColType.genVARSTR(DEFAULT_STR_LEN));
        }
        return r;
    }

    private int getLenFromAttrTypeStr(String s) {
        String[] as = s.split(":");
        if (as.length != 2) {
            this.logger.warn("unknow type(" + s + "), default to DEFAULT_STR_LEN!");
            return DEFAULT_STR_LEN;
        }
        return Integer.parseInt(as[1]);
    }

    static class XpathModeTree {
        public StringBuilder sb = new StringBuilder(1000);
        private XpathModeNode root = new XpathModeNode();

        XpathModeTree() {
        }

        public void addXpath(String absXpath) {
            String[] absXpathSplit = absXpath.split("/");
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < absXpathSplit.length; ++i) {
                if (absXpathSplit[i].equals("")) continue;
                names.add(absXpathSplit[i]);
            }
            XpathModeNode cursor = this.root;
            int nameNum = names.size();
            for (int i = 0; i < nameNum; ++i) {
                String name = (String)names.get(i);
                XpathModeNode t = this.existAtChild(name, cursor);
                if (t != null) {
                    cursor = t;
                    continue;
                }
                XpathModeNode upper = cursor;
                cursor = new XpathModeNode();
                cursor.name = name;
                if (i < nameNum - 1) {
                    if (upper.childs == null) {
                        upper.childs = new ArrayList<XpathModeNode>();
                    }
                    upper.childs.add(cursor);
                    continue;
                }
                if (upper.termChilds == null) {
                    upper.termChilds = new ArrayList<XpathModeNode>();
                }
                upper.termChilds.add(cursor);
            }
        }

        public void addPropStr(String propStr) {
        }

        public void genPkg() {
            if (this.root.termChilds != null) {
                for (XpathModeNode n : this.root.termChilds) {
                    this.genPkg(n, true);
                }
            }
            if (this.root.childs != null) {
                for (XpathModeNode n : this.root.childs) {
                    this.genPkg(n, true);
                }
            }
        }

        private XpathModeNode existAtChild(String name, XpathModeNode n) {
            XpathModeNode r = this.existAtChild(name, n.childs);
            if (r == null) {
                r = this.existAtChild(name, n.termChilds);
            }
            return r;
        }

        private XpathModeNode existAtChild(String name, List<XpathModeNode> ns) {
            if (ns == null) {
                return null;
            }
            for (XpathModeNode c : ns) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            return null;
        }

        private void genPkg(XpathModeNode n, boolean nameSpace) {
            if (n.termChilds == null && n.childs == null) {
                this.sb.append("<");
                this.sb.append(n.name);
                if (nameSpace) {
                    this.sb.append(" ");
                    this.sb.append(PolicyQuery1Cfg1DB.NETCONF_NAMESPACE);
                }
                this.sb.append("/>");
                return;
            }
            this.sb.append("<");
            this.sb.append(n.name);
            if (nameSpace) {
                this.sb.append(" ");
                this.sb.append(PolicyQuery1Cfg1DB.NETCONF_NAMESPACE);
            }
            this.sb.append(">");
            if (n.termChilds != null) {
                for (XpathModeNode tc : n.termChilds) {
                    this.genPkg(tc, false);
                }
            }
            if (n.childs != null) {
                for (XpathModeNode c : n.childs) {
                    this.genPkg(c, false);
                }
            }
            this.sb.append("</");
            this.sb.append(n.name);
            this.sb.append(">");
        }

        class XpathModeNode {
            String name;
            List<XpathModeNode> childs;
            List<XpathModeNode> termChilds;

            XpathModeNode() {
            }
        }
    }
}

