/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.service.impl;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.service.DevChange;
import java.util.List;
import org.slf4j.Logger;

public class DevChangeImpl
implements DevChange {
    private Logger logger = RunLogger.getRunLogger();

    @Override
    public void add(DevChange.DevInfo dev) {
        try {
            DevMgr.instance().addDev(dev);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("addDev error!" + e.toString());
        }
    }

    @Override
    public void del(DevChange.DevInfo dev) {
        try {
            DevMgr.instance().delDev(dev);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("delDev error!" + e.toString());
        }
    }

    @Override
    public List<DevConfig> constructCfgsWithDev(DevChange.DevIdentify devId) {
        try {
            return DevMgr.instance().getPersistDevCfg(devId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("constructCfgsWithDev error!" + e.toString());
            return null;
        }
    }

    @Override
    public DevConfig constructCfgsWithDev(DevChange.DevIdentify devId, int vrId) {
        try {
            List<DevConfig> devCfgs = this.constructCfgsWithDev(devId);
            if (null == devCfgs) {
                return null;
            }
            for (DevConfig devCfg : devCfgs) {
                if (vrId != devCfg.getVRId()) continue;
                return devCfg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("constructCfgsWithDev for one device error!" + e.toString());
        }
        return null;
    }

    @Override
    public void verChg(DevChange.DevInfo dev) {
        try {
            DevMgr.instance().verChg(dev);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("verChg error!" + e.toString());
        }
    }

    @Override
    public void forceSyncAllDev(DevChange.DevInfo dev) {
        try {
            DevMgr.instance().forceSyncAllDev(dev);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("forceSyncAllDev error!" + e.toString());
        }
    }

    @Override
    public void forceIncrSyncDev(DevChange.DevInfo dev) {
        try {
            DevMgr.instance().forceIncrSyncDev(dev);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("forceSyncAllDev error!" + e.toString());
        }
    }

    @Override
    public void init(List<DevChange.DevInfo> allDev) {
        try {
            DevMgr.instance().initDev(allDev);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("delAllCfg error!" + e.toString());
        }
    }
}

