/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.service.impl;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class DBStateMgr {
    private static DBStateMgr inst = null;
    private final String stateTbName = "tb__vmtdb_state";
    private final String infoTbName = "tb__vmtdb_info";
    private final String STATE_state = "state";
    private final String STATE_shared = "shared";
    private final String INFO_delState = "delState";
    private final String INFO_flowId = "flowId";
    private final String INFO_devStartTime = "devStartTime";
    private Map<String, String> stateCol2Types = new HashMap<String, String>();
    private Map<String, String> infoCol2Types = new HashMap<String, String>();
    private Logger logger = RunLogger.getRunLogger();

    public static synchronized DBStateMgr instance() {
        if (inst == null) {
            inst = new DBStateMgr();
            return inst;
        }
        return inst;
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("testdir" + File.separator + "DBStateMgr");
        if (dir.exists()) {
            File[] fs = dir.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    f.delete();
                }
            }
        } else {
            dir.mkdir();
        }
        class DB {
            DB() {
            }

            Connection cn() throws Exception {
                Connection cn = DriverManager.getConnection("jdbc:hsqldb:file:testdir/DBStateMgr/db_" + System.currentTimeMillis(), "SA", "");
                return cn;
            }
        }
        Connection cn = new DB().cn();
        Statement s = cn.createStatement();
        DBStateMgr mgr = DBStateMgr.instance();
        mgr.init(cn, s);
        Set<Map.Entry<String, String>> infoEns = mgr.infoCol2Types.entrySet();
        for (Map.Entry<String, String> entry : infoEns) {
            String col = entry.getKey();
            String v = mgr.getInfo(cn, s, col);
        }
        assert (mgr.getInfo(cn, s, "devStartTime") == null);
        assert (mgr.getInfo(cn, s, "flowId") == null);
        assert (mgr.getInfo(cn, s, "delState") == null);
        mgr.setInfo(cn, s, "devStartTime", "123");
        assert (mgr.getInfo(cn, s, "devStartTime").equals("123"));
        mgr.setInfo(cn, s, "flowId", "123456");
        assert (mgr.getInfo(cn, s, "flowId").equals("123456"));
        int state = mgr.getState(cn, s);
        assert (state == 1);
        assert (mgr.syncBegin(cn, s));
        state = mgr.getState(cn, s);
        assert (state == 2);
        assert (mgr.syncEnd(cn, s, true, 0, 0L));
        state = mgr.getState(cn, s);
        assert (state == 3);
        assert (mgr.shareAccess(cn, s));
        state = mgr.getState(cn, s);
        assert (state == 5);
        assert (mgr.shareRelease(cn, s));
        state = mgr.getState(cn, s);
        assert (state == 3);
        assert (mgr.shareAccess(cn, s));
        assert (mgr.shareAccess(cn, s));
        assert (mgr.shareRelease(cn, s));
        assert (mgr.shareRelease(cn, s));
        state = mgr.getState(cn, s);
        assert (state == 3);
        assert (mgr.lckAccess(cn, s));
        state = mgr.getState(cn, s);
        assert (state == 6);
        assert (mgr.lckRelease(cn, s, true, 0, 0L));
        state = mgr.getState(cn, s);
        assert (state == 3);
        assert (mgr.shareAccess(cn, s));
        assert (!mgr.lckAccess(cn, s));
        assert (!mgr.syncBegin(cn, s));
        assert (!mgr.syncEnd(cn, s, true, 0, 0L));
        assert (!mgr.lckAccess(cn, s));
        assert (mgr.shareAccess(cn, s));
        assert (mgr.shareRelease(cn, s));
        assert (mgr.shareRelease(cn, s));
        assert (mgr.lckAccess(cn, s));
        assert (!mgr.shareAccess(cn, s));
        assert (!mgr.lckAccess(cn, s));
        assert (!mgr.syncBegin(cn, s));
        assert (!mgr.syncEnd(cn, s, true, 0, 0L));
        assert (mgr.lckRelease(cn, s, true, 0, 0L));
        int shared = mgr.useShare(cn, s);
        assert (shared == 1);
        shared = mgr.relShare(cn, s);
        assert (shared == 0);
        shared = mgr.useShare(cn, s);
        shared = mgr.useShare(cn, s);
        shared = mgr.useShare(cn, s);
        assert (shared == 3);
        shared = mgr.relShare(cn, s);
        shared = mgr.relShare(cn, s);
        shared = mgr.relShare(cn, s);
        assert (shared == 0);
        mgr.del(cn, s);
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable ee) {
            System.out.println("success!");
        }
    }

    public void init(Connection cn, Statement s) throws Exception {
        cn.setAutoCommit(false);
        try {
            this.createTBNotCommit(cn, s, "tb__vmtdb_state", this.stateCol2Types);
            this.createTBNotCommit(cn, s, "tb__vmtdb_info", this.infoCol2Types);
            cn.commit();
        }
        catch (Exception e) {
            this.failedRollAndLog(cn, "DBStateMgr.init", e);
            throw e;
        }
    }

    public void del(Connection cn, Statement s) throws Exception {
        cn.setAutoCommit(false);
        try {
            this.setColNotCommit(cn, s, "tb__vmtdb_info", "delState", Integer.toString(10));
            cn.commit();
        }
        catch (Exception e) {
            String errMsg = e + "DBStateMgr.del failed, it's a bug!!!";
            System.err.println(errMsg);
            this.logger.error(errMsg);
        }
    }

    public boolean syncBegin(Connection cn, Statement s) throws Exception {
        try {
            if (!this.cleanCN(cn, "DBStateMgr.syncBegin")) {
                return false;
            }
            if (!this.canStateChg(cn, s, 1)) {
                return false;
            }
            this.setStateNotCommit(cn, s, 2);
            cn.commit();
        }
        catch (Exception e) {
            this.failedRollAndLog(cn, "DBStateMgr.syncBegin", e);
            throw e;
        }
        return true;
    }

    public boolean syncEnd(Connection cn, Statement s, boolean success, int flowId, long devStartTime) throws Exception {
        int to = success ? 3 : 4;
        try {
            if (!this.cleanCN(cn, "DBStateMgr.syncEnd")) {
                return false;
            }
            if (!this.canStateChg(cn, s, 2)) {
                return false;
            }
            this.setColNotCommit(cn, s, "tb__vmtdb_info", "flowId", Integer.toString(flowId));
            this.setColNotCommit(cn, s, "tb__vmtdb_info", "devStartTime", Long.toString(devStartTime));
            this.setStateNotCommit(cn, s, to);
            cn.commit();
            s.execute("CHECKPOINT");
        }
        catch (Exception e) {
            this.failedRollAndLog(cn, "DBStateMgr.syncEnd", e);
            throw e;
        }
        return true;
    }

    public boolean shareAccess(Connection cn, Statement s) throws Exception {
        try {
            if (!this.cleanCN(cn, "DBStateMgr.shareAccess")) {
                return false;
            }
            if (!this.canStateChg(cn, s, 3)) {
                return false;
            }
            int shared = this.useShare(cn, s);
            if (shared == 1) {
                this.setStateNotCommit(cn, s, 5);
            }
            cn.commit();
        }
        catch (Exception e) {
            this.failedRollAndLog(cn, "DBStateMgr.shareAccess", e);
            throw e;
        }
        return true;
    }

    public boolean shareRelease(Connection cn, Statement s) {
        try {
            if (!this.cleanCN(cn, "DBStateMgr.shareRelease")) {
                return false;
            }
            if (!this.canStateChg(cn, s, 4)) {
                return false;
            }
            int shared = this.relShare(cn, s);
            if (shared <= 0) {
                this.setStateNotCommit(cn, s, 3);
            }
            cn.commit();
        }
        catch (Exception e) {
            this.failedRollAndLog(cn, "DBStateMgr.shareRelease", e);
            return false;
        }
        return true;
    }

    public boolean lckAccess(Connection cn, Statement s) {
        try {
            if (!this.cleanCN(cn, "DBStateMgr.lckAccess")) {
                return false;
            }
            if (!this.canStateChg(cn, s, 5)) {
                return false;
            }
            this.setStateNotCommit(cn, s, 6);
            cn.commit();
        }
        catch (Exception e) {
            this.failedRollAndLog(cn, "DBStateMgr.lckAccess", e);
            return false;
        }
        return true;
    }

    public boolean lckRelease(Connection cn, Statement s, boolean success, int flowId, long devStartTime) {
        int to = success ? 3 : 4;
        try {
            if (!this.cleanCN(cn, "DBStateMgr.lckRelease")) {
                return false;
            }
            if (s == null) {
                s = cn.createStatement();
            }
            if (!this.canStateChg(cn, s, 6)) {
                return false;
            }
            if (flowId > 0) {
                this.setColNotCommit(cn, s, "tb__vmtdb_info", "flowId", Integer.toString(flowId));
            }
            if (devStartTime > 0L) {
                this.setColNotCommit(cn, s, "tb__vmtdb_info", "devStartTime", Long.toString(devStartTime));
            }
            this.setStateNotCommit(cn, s, to);
            cn.commit();
        }
        catch (Exception e) {
            this.failedRollAndLog(cn, "DBStateMgr.lckRelease", e);
            return false;
        }
        return true;
    }

    public void setInfo(Connection cn, Statement s, String infName, String value) throws Exception {
        this.setColNotCommit(cn, s, "tb__vmtdb_info", infName, value);
        cn.commit();
    }

    public String getInfo(Connection cn, Statement s, String infName) throws Exception {
        return this.getCol(cn, s, "tb__vmtdb_info", infName);
    }

    public boolean isDBSyncOK(Connection cn, Statement s) throws Exception {
        return this.getState(cn, s) == 3;
    }

    public int getDBState(Connection cn, Statement s) throws Exception {
        return this.getState(cn, s);
    }

    private void failedRollAndLog(Connection cn, String desc, Exception e) {
        String errMsg = "DBStateMgr.lckRelease failed! cn=" + cn + ",desc=" + desc + "\n" + e;
        try {
            cn.rollback();
        }
        catch (Exception ee) {
            errMsg = errMsg + "\nrollback failed!\n" + ee;
        }
        this.logger.error(errMsg);
        System.err.println(errMsg);
    }

    private boolean cleanCN(Connection cn, String desc) {
        try {
            cn.setAutoCommit(!cn.getAutoCommit());
            cn.setAutoCommit(false);
        }
        catch (Exception e) {
            String dbUrl = "";
            try {
                dbUrl = cn.getMetaData().getURL();
            }
            catch (Exception ee) {
                // empty catch block
            }
            String errMsg = e + "\ncleanCN failed at " + desc + "!cn=" + cn + ", dbUrl=" + dbUrl;
            System.err.println(errMsg);
            this.logger.error(errMsg);
            return false;
        }
        return true;
    }

    private boolean canStateChg(Connection cn, Statement s, int op) throws Exception {
        StringBuilder lockSql = new StringBuilder();
        lockSql.append("LOCK TABLE ");
        lockSql.append(this.stateTbName);
        lockSql.append(" WRITE");
        s.execute(lockSql.toString());
        boolean ret = true;
        int curState = this.getState(cn, s);
        if (curState == 1) {
            if (op != 1) {
                ret = false;
            }
        } else if (curState == 2) {
            if (op != 2) {
                ret = false;
            }
        } else if (curState == 3) {
            if (op != 5 && op != 3) {
                ret = false;
            }
        } else if (curState == 6) {
            if (op != 6) {
                ret = false;
            }
        } else if (curState == 5) {
            if (op != 4 && op != 3) {
                ret = false;
            }
        } else if (curState == 4) {
            ret = false;
        } else {
            String errMsg = "canStateChg: unkown db state!!! it's a bug! state=" + curState;
            this.logger.error(errMsg);
            System.err.println(errMsg);
        }
        if (!ret) {
            String warnMsg = "syncBegin: db state change is not permited, curState=" + curState + ",op=" + op;
            this.logger.warn(warnMsg);
            System.out.println(warnMsg);
            return false;
        }
        return true;
    }

    private void setStateNotCommit(Connection cn, Statement s, int state) throws Exception {
        this.setColNotCommit(cn, s, "tb__vmtdb_state", "state", Integer.toString(state));
    }

    private int getState(Connection cn, Statement s) throws Exception {
        String str = this.getCol(cn, s, "tb__vmtdb_state", "state");
        if (str != null && !str.equals("null")) {
            return Integer.parseInt(str);
        }
        return 1;
    }

    private int useShare(Connection cn, Statement s) throws Exception {
        String v = this.getCol(cn, s, "tb__vmtdb_state", "shared");
        int getShare = 0;
        if (v != null && !v.equals("null")) {
            getShare = Integer.parseInt(v);
        }
        this.setColNotCommit(cn, s, "tb__vmtdb_state", "shared", Integer.toString(++getShare));
        return getShare;
    }

    private int relShare(Connection cn, Statement s) throws Exception {
        String v = this.getCol(cn, s, "tb__vmtdb_state", "shared");
        int getShare = 0;
        if (v != null && !v.equals("null")) {
            getShare = Integer.parseInt(v);
        }
        this.setColNotCommit(cn, s, "tb__vmtdb_state", "shared", Integer.toString(--getShare));
        return getShare;
    }

    private void createTBNotCommit(Connection cn, Statement s, String tbName, Map<String, String> colTypes) throws Exception {
        StringBuilder sqlCreate = new StringBuilder();
        sqlCreate.append("CREATE TABLE ");
        sqlCreate.append(tbName);
        sqlCreate.append("(");
        Set<Map.Entry<String, String>> cols = colTypes.entrySet();
        Iterator<Map.Entry<String, String>> it = cols.iterator();
        sqlCreate.append("idx INTEGER");
        while (it.hasNext()) {
            Map.Entry<String, String> col = it.next();
            sqlCreate.append(",");
            sqlCreate.append(col.getKey());
            sqlCreate.append(" ");
            sqlCreate.append(col.getValue());
        }
        sqlCreate.append(")");
        s.execute(sqlCreate.toString());
        String sqlAddLine = "INSERT INTO " + tbName + " (idx) VALUES(0)";
        s.execute(sqlAddLine);
    }

    private void setColNotCommit(Connection cn, Statement s, String tbName, String col, String value) throws Exception {
        if (s == null) {
            s = cn.createStatement();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tbName);
        sql.append(" SET ");
        sql.append(col);
        sql.append("=");
        sql.append(value);
        int result = s.executeUpdate(sql.toString());
        if (result != 1) {
            String errMsg = "updateCol err result=" + result;
            throw new PersistenceException(errMsg);
        }
    }

    private String getCol(Connection cn, Statement s, String tbName, String col) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(col);
        sql.append(" FROM ");
        sql.append(tbName);
        ResultSet rst = s.executeQuery(sql.toString());
        rst.next();
        return rst.getString(1);
    }

    private DBStateMgr() {
        this.stateCol2Types.put("state", "INTEGER");
        this.stateCol2Types.put("shared", "INTEGER");
        this.infoCol2Types.put("delState", "INTEGER");
        this.infoCol2Types.put("flowId", "INTEGER");
        this.infoCol2Types.put("devStartTime", "INTEGER");
    }

    public static class Oper {
        public static final int syncBegin = 1;
        public static final int syncEnd = 2;
        public static final int shareAccess = 3;
        public static final int shareRelease = 4;
        public static final int lckAccess = 5;
        public static final int lckRelease = 6;
        public static final int del = 7;
    }

    public static class State {
        public static final int db_ok = 1;
        public static final int db_syncing = 2;
        public static final int db_syncok = 3;
        public static final int db_dataunkown = 4;
        public static final int db_syncok_shared = 5;
        public static final int db_syncok_locked = 6;
        public static final int db_deling = 10;
    }
}

