/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.service.impl;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.debug.TimeRecStack;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.domain.PageQueryHandle;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.domain.PreciseQueryCondition;
import com.huawei.vmf.qat.persistence.domain.QueryCondition;
import com.huawei.vmf.qat.persistence.domain.RowData;
import com.huawei.vmf.qat.persistence.domain.TableDesc;
import com.huawei.vmf.qat.persistence.service.DBCommonOper;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.impl.ConnectionPoolMgr;
import com.huawei.vmf.qat.persistence.service.impl.DBStateMgr;
import com.huawei.vmf.qat.persistence.service.impl.PolicyQuery1Cfg1DB;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class DBCommonOper1Cfg1DB
implements DBCommonOper {
    public static String DBFILE_DIR = "vmtDB";
    public static int MAX_LINE_MEMORY = 1000;
    private static char FIXED_STR_END = (char)46;
    private static String DBURL_IDFILE_SUFFIX = ".hw";
    public int flowId = 0;
    public long devStartTime = 0L;
    private Logger logger = RunLogger.getRunLogger();
    private boolean isDebug = false;
    private volatile boolean isUseLastDBUrl = false;
    private volatile boolean forceUseLastDBUrl = false;
    private volatile boolean syncBeginButNotEnd = false;
    private String lastDBUrl = "";
    private boolean oneMode = false;
    private Connection lastCon = null;
    private ConnectionPoolMgr<Connection> poolMgr = ConnectionPoolMgr.instance();

    public static void main(String[] args) throws Exception {
        PolicyMgr.PNP_DIR = ".\\testdir\\pnpp";
        DBFILE_DIR = ".\\testdir\\testdb";
        PolicyMgr.instance().refreshPolicy();
        DBCommonOper1Cfg1DB db = new DBCommonOper1Cfg1DB();
        PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
        PolicyQuery.DTV dtv = new PolicyQuery.DTV("NE5000E", "V800R003C00SPC300");
        List<TableDesc> ts = pq.getTableDesc(dtv, "/ifm/interfaces/interface");
        assert (ts.size() == 1);
        TableDesc tbDesc = ts.get(0);
        DevChange.DevIdentify devIdent = new DevChange.DevIdentify("1.1.1.1", 0x300036);
        DevConfig cfg = DevConfig.newVRConfig(devIdent, 0);
        db.addCfg(cfg);
        db.syncBegin(cfg);
        assert (db.cfg2DBUrl(cfg, false) != null);
        db.addTB(cfg, tbDesc);
        RowData rowData = new RowData();
        String ifName = "Ethernet 1/1/1";
        rowData.cvs.put(pq.relXpath2ColName("ifName"), ifName);
        rowData.cvs.put(pq.relXpath2ColName("phyType"), "1");
        String desc = "\\\\a";
        rowData.cvs.put(pq.relXpath2ColName("description"), desc);
        db.addRow(cfg, tbDesc, rowData);
        int num = db.getRowNum(cfg, tbDesc, new PreciseQueryCondition());
        assert (num == 1);
        List<RowData> rows = db.getAllRows(cfg, tbDesc, new PreciseQueryCondition());
        assert (rows.size() == 1);
        assert (rows.get((int)0).cvs.get(pq.relXpath2ColName("ifName")).equals(ifName));
        assert (rows.get((int)0).cvs.get(pq.relXpath2ColName("description")).equals(desc));
        db.drpTB(cfg, tbDesc);
        db.addTB(cfg, tbDesc);
        db.addRows(cfg, tbDesc, rows);
        PreciseQueryCondition cond = new PreciseQueryCondition();
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(pq.relXpath2ColName("ifName"));
        cond.resetSelCols(cols);
        rows = db.getAllRows(cfg, tbDesc, cond);
        assert (rows.size() == 1);
        assert (rows.get((int)0).cvs.get(pq.relXpath2ColName("phyType")) == null);
        HashMap<String, String> match = new HashMap<String, String>();
        match.put(pq.relXpath2ColName("ifName"), "-unkown");
        cond.or.add(match);
        rows = db.getAllRows(cfg, tbDesc, cond);
        assert (rows.size() == 0);
        db.delRowByKey(cfg, tbDesc, ifName);
        rows = db.getAllRows(cfg, tbDesc, new PreciseQueryCondition());
        assert (rows.size() == 0);
        db.addRow(cfg, tbDesc, rowData);
        String mdfDesc = "modify description!";
        String mdfPhyType = "2";
        rowData.cvs.put(pq.relXpath2ColName("description"), mdfDesc);
        rowData.cvs.put(pq.relXpath2ColName("phyType"), mdfPhyType);
        db.mdfRow(cfg, tbDesc, rowData);
        rows = db.getAllRows(cfg, tbDesc, new QueryCondition());
        assert (rows.size() == 1);
        assert (rows.get((int)0).cvs.get(pq.relXpath2ColName("description")).equals(mdfDesc));
        assert (rows.get((int)0).cvs.get(pq.relXpath2ColName("phyType")).equals(mdfPhyType));
        String mdfDesc2 = "22modify description!";
        String mdfPhyType2 = "22";
        rowData.cvs.put(pq.relXpath2ColName("description"), mdfDesc2);
        rowData.cvs.put(pq.relXpath2ColName("phyType"), mdfPhyType2);
        rows.clear();
        rows.add(rowData);
        db.mdfRows(cfg, tbDesc, rows);
        db.drpTB(cfg, tbDesc);
        db.addTB(cfg, tbDesc);
        class TestGetNext {
            final /* synthetic */ PolicyQuery val$pq;

            TestGetNext(PolicyQuery policyQuery) {
                this.val$pq = policyQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void t(DBCommonOper1Cfg1DB db, DevConfig cfg, TableDesc tbDesc, RowData rowData, int total, int pageSize) throws Exception {
                for (int i = 0; i < total; ++i) {
                    rowData.cvs.put(this.val$pq.relXpath2ColName("ifName"), "Ethernet 1/1/1." + i);
                    db.addRow(cfg, tbDesc, rowData);
                }
                PreciseQueryCondition cond = new PreciseQueryCondition(pageSize);
                ArrayList<RowData> rt = new ArrayList<RowData>();
                PageQueryHandle handle = db.getPageHandle(cfg, tbDesc, cond);
                try {
                    boolean ret = db.getNextPageRows(handle, rt);
                    if (total < pageSize) {
                        assert (rt.size() == total);
                    } else if (total == pageSize) {
                        assert (rt.size() == total);
                    } else if (total > pageSize) {
                        assert (rt.size() == pageSize);
                        while (ret) {
                            ret = db.getNextPageRows(handle, rt);
                        }
                        assert (rt.size() == total);
                    }
                }
                finally {
                    db.closePageHandle(handle);
                }
            }
        }
        TestGetNext getnext = new TestGetNext(pq);
        getnext.t(db, cfg, tbDesc, rowData, 51, 50);
        db.drpTB(cfg, tbDesc);
        db.addTB(cfg, tbDesc);
        getnext.t(db, cfg, tbDesc, rowData, 10, 10);
        db.drpTB(cfg, tbDesc);
        db.addTB(cfg, tbDesc);
        getnext.t(db, cfg, tbDesc, rowData, 5, 2);
        db.drpTB(cfg, tbDesc);
        db.addTB(cfg, tbDesc);
        getnext.t(db, cfg, tbDesc, rowData, 5, 11);
        db.syncEnd(cfg, true, 0, 0L);
        db.delCfg(cfg);
        try {
            Thread.sleep(1000 * ConnectionPoolMgr.DELAY_DEL_TIMER * 2);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable e) {
            System.out.println("success!");
        }
    }

    public static void init() {
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
            File dbDir = new File(DBFILE_DIR);
            if (dbDir.exists() || !dbDir.mkdir()) {
                // empty if block
            }
            DBCommonOper1Cfg1DB.setDelConnectionBackCallToPoolMgr();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String dbUrl2FnPrefix(String dbUrl) {
        int start = dbUrl.lastIndexOf(File.separator);
        String fnPrefix = dbUrl.substring(start + 1);
        return fnPrefix;
    }

    public static void checkpoint(Connection cn, Statement s) throws Exception {
        if (s == null) {
            s = cn.createStatement();
        }
        s.execute("CHECKPOINT DEFRAG");
        cn.commit();
    }

    protected static void setDelConnectionBackCallToPoolMgr() {
        ConnectionPoolMgr.instance().setDelConnectionBackCall(new HSQLDBDelConBackCall());
    }

    private static DevChange.DevIdentify getDevIdentifyFromDBUrl(String dbUrl) {
        String fnPrefix = DBCommonOper1Cfg1DB.dbUrl2FnPrefix(dbUrl);
        String[] splitDBUrl = fnPrefix.split(",");
        if (splitDBUrl.length < 2 || !splitDBUrl[0].startsWith("ip=") || !splitDBUrl[1].startsWith("devId=")) {
            return null;
        }
        String ip = splitDBUrl[0].substring(3);
        String devIdStr = splitDBUrl[1].substring(6);
        int devId = 0;
        try {
            devId = Integer.parseInt(devIdStr);
        }
        catch (Exception e) {
            return null;
        }
        return new DevChange.DevIdentify(ip, devId);
    }

    private static String judgeDBDirByDevIdentify(DevChange.DevIdentify id) {
        String ip = id.getIp();
        if (ip != null && !ip.equals("")) {
            return DBCommonOper1Cfg1DB.judgeDBDirByIpHashCode(ip.hashCode());
        }
        int devId = id.getDevID();
        if (devId != 0) {
            return DBCommonOper1Cfg1DB.judgeDBDirByDevId(devId);
        }
        return null;
    }

    private static String judgeDBDirByDevId(int id) {
        return DBCommonOper1Cfg1DB.judgeDBDirByIpHashCode(id);
    }

    private static String judgeDBDirByIpHashCode(int id) {
        StringBuilder sb = new StringBuilder();
        int MODE = 4096;
        int BULKS = 8456502;
        int bulkId = id % 8456502;
        int level1Id = bulkId / 4096;
        int level2Id = bulkId % 4096;
        sb.append(DBFILE_DIR);
        sb.append(File.separator);
        sb.append(level1Id);
        sb.append(File.separator);
        sb.append(level2Id);
        File level1Dir = new File(DBFILE_DIR + File.separator + level1Id);
        if (!level1Dir.exists() && !level1Dir.mkdir()) {
            return null;
        }
        File level2Dir = new File(DBFILE_DIR + File.separator + level1Id + File.separator + level2Id);
        if (!level2Dir.exists() && !level2Dir.mkdir()) {
            return null;
        }
        return sb.toString();
    }

    @Override
    public void useLastDBUrl(boolean isUse) {
        this.isUseLastDBUrl = isUse;
    }

    @Override
    public final void addCfg(DevConfig cfg) throws PersistenceException {
        String dbUrl = this.cfg2DBUrl(cfg, true);
        Connection cn = null;
        try {
            this.lastCon = cn = this.newConAndAdd2Pool(dbUrl, false);
            if (!this.cleanCN(dbUrl, cn, "addCfg")) {
                throw new PersistenceException("cleanCN failed!");
            }
            Statement s = cn.createStatement();
            this.initTargetDB(cn, s);
            DBStateMgr.instance().init(cn, s);
            cn.commit();
        }
        catch (Exception e) {
            String errMsg = e + "addCfg: new db failed! dbUrl=" + dbUrl + ",cn=" + cn;
            System.err.println(errMsg);
            this.logger.error(errMsg);
            throw new PersistenceException(errMsg);
        }
        finally {
            this.releaseRes(dbUrl, cn, null, null, "addCfg");
        }
        String idFileName = DBCommonOper1Cfg1DB.dbUrl2FnPrefix(dbUrl);
        String dbdir = DBCommonOper1Cfg1DB.judgeDBDirByDevIdentify(cfg.getIdentify());
        File f = new File(dbdir + File.separator + idFileName + DBURL_IDFILE_SUFFIX);
        try {
            f.createNewFile();
        }
        catch (Exception e) {
            this.poolMgr.delAllConnection(dbUrl);
            String errMsg = e + "\naddCfg: open connection error! exception message:\ndbUrl=" + dbUrl;
            this.logger.error(errMsg);
            System.err.println(errMsg);
            throw new PersistenceException(errMsg);
        }
        this.logger.info("addCfg: cfg=" + cfg + ", dbUrl=" + dbUrl);
    }

    @Override
    public final void delCfg(DevConfig cfg) throws PersistenceException {
        String dbUrl = this.cfg2DBUrl(cfg, false);
        if (dbUrl == null) {
            return;
        }
        Connection cn = null;
        Statement s = null;
        try {
            this.poolMgr.delAllConnection(dbUrl);
        }
        catch (Exception e) {
            String errMsg = e + "\ndelCfg failed! dbUrl=" + dbUrl;
            this.logger.error(errMsg);
            throw new PersistenceException(errMsg);
        }
        finally {
            this.releaseRes(dbUrl, cn, s, null, "delCfg");
        }
        this.logger.info("delCfg: cfg=" + cfg + ", dbUrl=" + dbUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncBegin(DevConfig cfg) {
        this.forceUseLastDBUrl = true;
        String dbUrl = this.cfg2DBUrl(cfg, false);
        boolean r = false;
        Connection cn = null;
        Statement s = null;
        try {
            cn = this.getConnection(dbUrl);
            if (!this.cleanCN(dbUrl, cn, "syncBegin")) {
                throw new PersistenceException("cleanCN failed!");
            }
            s = cn.createStatement();
            r = DBStateMgr.instance().syncBegin(cn, s);
            cn.commit();
            this.releaseRes(dbUrl, cn, s, null, "syncBegin");
        }
        catch (Exception e) {
            try {
                String errMsg = e + "\nsyncBegin failed! dbUrl=" + dbUrl + ",cn=" + cn;
                System.err.println(errMsg);
                this.logger.error(errMsg);
                this.releaseRes(dbUrl, cn, s, null, "syncBegin");
            }
            catch (Throwable throwable) {
                this.releaseRes(dbUrl, cn, s, null, "syncBegin");
                throw throwable;
            }
        }
        if (!r) {
            this.forceUseLastDBUrl = false;
        } else {
            this.syncBeginButNotEnd = true;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean syncEnd(DevConfig cfg, boolean success, int flowId, long devStartTime) {
        String dbUrl = this.cfg2DBUrl(cfg, false);
        if (dbUrl == null) {
            String errMsg = "syncEnd: there is no db of cfg, cfg=" + cfg + ",success=" + success + ",flowId=" + flowId + ",devStartTime=" + devStartTime;
            this.logger.error(errMsg);
            System.err.println(errMsg);
            return false;
        }
        boolean r = false;
        Connection cn = null;
        Statement s = null;
        try {
            cn = this.getConnection(dbUrl);
            if (!this.cleanCN(dbUrl, cn, "syncEnd")) {
                throw new PersistenceException("cleanCN failed!");
            }
            s = cn.createStatement();
            r = DBStateMgr.instance().syncEnd(cn, s, success, flowId, devStartTime);
            cn.commit();
            this.forceUseLastDBUrl = false;
            this.releaseRes(dbUrl, cn, s, null, "syncBegin");
        }
        catch (Exception e) {
            try {
                String errMsg = e + "\nsyncEnd failed!!! cn=" + cn + ",s=" + s + ",r=" + r + ",dbUrl=" + dbUrl + "success=" + success + ",flowId=" + flowId + ",devStartTime=" + devStartTime;
                System.err.println(errMsg);
                this.logger.error(errMsg);
                this.forceUseLastDBUrl = false;
                this.releaseRes(dbUrl, cn, s, null, "syncBegin");
            }
            catch (Throwable throwable) {
                this.forceUseLastDBUrl = false;
                this.releaseRes(dbUrl, cn, s, null, "syncBegin");
                throw throwable;
            }
        }
        this.syncBeginButNotEnd = false;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getDevBaseInfo(DevConfig cfg) {
        String dbUrl = this.cfg2DBUrl(cfg, false);
        String strInfo = "";
        Connection cn = null;
        Statement s = null;
        try {
            cn = this.getConnection(dbUrl);
            if (!this.cleanCN(dbUrl, cn, "getDevBaseInfo")) {
                throw new PersistenceException("cleanCN failed!");
            }
            s = cn.createStatement();
            strInfo = DBStateMgr.instance().getInfo(cn, s, "flowId");
            cn.commit();
            this.forceUseLastDBUrl = false;
            this.releaseRes(dbUrl, cn, s, null, "getDevBaseInfo");
        }
        catch (Exception e) {
            try {
                String errMsg = e + "\ngetDevBaseInfo failed!!! cn=" + cn + ",s=" + s + ",strInfo=" + strInfo + ",dbUrl=" + dbUrl + ",cfg=" + cfg;
                System.err.println(errMsg);
                this.logger.error(errMsg);
                this.forceUseLastDBUrl = false;
                this.releaseRes(dbUrl, cn, s, null, "getDevBaseInfo");
            }
            catch (Throwable throwable) {
                this.forceUseLastDBUrl = false;
                this.releaseRes(dbUrl, cn, s, null, "getDevBaseInfo");
                throw throwable;
            }
        }
        this.syncBeginButNotEnd = false;
        return strInfo;
    }

    @Override
    public final void addTB(DevConfig cfg, TableDesc tbDesc) throws PersistenceException {
        this._addTB(cfg, tbDesc, true);
    }

    @Override
    public final void laddTB(DevConfig cfg, TableDesc tbDesc) throws PersistenceException {
        this._addTB(cfg, tbDesc, false);
    }

    private void _addTB(DevConfig cfg, TableDesc tbDesc, boolean isShareAccess) throws PersistenceException {
        Statement s;
        Connection cn;
        String dbUrl;
        block9: {
            boolean result;
            block10: {
                TimeRecStack rc = TimeRecStack.getCurThreadRc();
                String rc_start_id = rc.start("addTB-all");
                rc.appendInfo(tbDesc.toString());
                dbUrl = this.cfg2DBUrl(cfg, false);
                cn = null;
                s = null;
                boolean canExe = false;
                result = false;
                try {
                    rc.start("getConn");
                    cn = this.getConnection(dbUrl);
                    rc.stop();
                    if (!this.cleanCN(dbUrl, cn, "_addTB")) {
                        throw new PersistenceException("cleanCN failed!");
                    }
                    s = cn.createStatement();
                    if (!this.syncBeginButNotEnd && !(canExe = isShareAccess ? DBStateMgr.instance().shareAccess(cn, s) : DBStateMgr.instance().lckAccess(cn, s))) {
                        throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + "dbUrl=" + dbUrl);
                    }
                    StringBuffer sql = this.genAddTbSql(tbDesc);
                    rc.start("exe sql");
                    s.execute(sql.toString());
                    cn.commit();
                    rc.stop();
                    result = true;
                    rc.stop2id(rc_start_id);
                    if (!canExe) break block9;
                    if (!isShareAccess) break block10;
                    DBStateMgr.instance().shareRelease(cn, s);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        String errMsg = e + "\naddTB failed!\ntbDesc=" + tbDesc + "\ncfg=" + cfg + "\ndbUrl=" + dbUrl + ",cn=" + cn;
                        this.logger.error(errMsg);
                        System.err.println(errMsg);
                        throw new PersistenceException(errMsg);
                    }
                    catch (Throwable throwable) {
                        rc.stop2id(rc_start_id);
                        if (canExe) {
                            if (isShareAccess) {
                                DBStateMgr.instance().shareRelease(cn, s);
                            } else {
                                DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
                            }
                        }
                        this.releaseRes(dbUrl, cn, s, null, "delCfg");
                        throw throwable;
                    }
                }
                break block9;
            }
            DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
        }
        this.releaseRes(dbUrl, cn, s, null, "delCfg");
        this.logger.info("addTB: cfg=" + cfg + ", tbDesc=" + tbDesc);
    }

    @Override
    public void drpTB(DevConfig cfg, TableDesc tbDesc) throws PersistenceException {
        this._drpTB(cfg, tbDesc, true);
    }

    @Override
    public void ldrpTB(DevConfig cfg, TableDesc tbDesc) throws PersistenceException {
        this._drpTB(cfg, tbDesc, false);
    }

    private void _drpTB(DevConfig cfg, TableDesc tbDesc, boolean isShareAccess) throws PersistenceException {
        Statement s;
        Connection cn;
        String dbUrl;
        block9: {
            boolean result;
            block10: {
                dbUrl = this.cfg2DBUrl(cfg, false);
                cn = null;
                s = null;
                boolean canExe = false;
                result = false;
                try {
                    cn = this.getConnection(dbUrl);
                    if (!this.cleanCN(dbUrl, cn, "_drpTB")) {
                        throw new PersistenceException("cleanCN failed!");
                    }
                    s = cn.createStatement();
                    if (!this.syncBeginButNotEnd && !(canExe = isShareAccess ? DBStateMgr.instance().shareAccess(cn, s) : DBStateMgr.instance().lckAccess(cn, s))) {
                        throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + "dbUrl=" + dbUrl);
                    }
                    String sql = this.genDrpTbSql(tbDesc);
                    s.execute(sql);
                    cn.commit();
                    result = true;
                    if (!canExe) break block9;
                    if (!isShareAccess) break block10;
                    DBStateMgr.instance().shareRelease(cn, s);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        String errMsg = e + "\ndrpTB failed! \ntbDesc=" + tbDesc + ",cn=" + cn + "dbUrl=" + dbUrl;
                        this.logger.error(errMsg);
                        System.err.println(errMsg);
                        throw new PersistenceException(errMsg);
                    }
                    catch (Throwable throwable) {
                        if (canExe) {
                            if (isShareAccess) {
                                DBStateMgr.instance().shareRelease(cn, s);
                            } else {
                                DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
                            }
                        }
                        this.releaseRes(dbUrl, cn, s, null, "drpTB");
                        throw throwable;
                    }
                }
                break block9;
            }
            DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
        }
        this.releaseRes(dbUrl, cn, s, null, "drpTB");
        this.logger.info("drpTB: cfg=" + cfg + ", tbDesc=" + tbDesc);
    }

    @Override
    public final void addRow(DevConfig cfg, TableDesc tbDesc, RowData rowData) throws PersistenceException {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        rows.add(rowData);
        this._addRows(cfg, tbDesc, rows, true);
    }

    @Override
    public final void laddRow(DevConfig cfg, TableDesc tbDesc, RowData rowData) throws PersistenceException {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        rows.add(rowData);
        this._addRows(cfg, tbDesc, rows, false);
    }

    @Override
    public final void addRows(DevConfig cfg, TableDesc tbDesc, List<RowData> rows) throws PersistenceException {
        this._addRows(cfg, tbDesc, rows, true);
    }

    @Override
    public final void laddRows(DevConfig cfg, TableDesc tbDesc, List<RowData> rows) throws PersistenceException {
        this._addRows(cfg, tbDesc, rows, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _addRows(DevConfig cfg, TableDesc tbDesc, List<RowData> rows, boolean isShareAccess) throws PersistenceException {
        String dbUrl = this.cfg2DBUrl(cfg, false);
        Connection cn = null;
        Statement s = null;
        boolean canExe = false;
        StringBuffer sql = new StringBuffer();
        int r = 0;
        try {
            cn = this.getConnection(dbUrl);
            if (!this.cleanCN(dbUrl, cn, "_addRows")) {
                throw new PersistenceException("cleanCN failed!");
            }
            s = cn.createStatement();
            if (!this.syncBeginButNotEnd && !(canExe = DBStateMgr.instance().shareAccess(cn, s))) {
                throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + "dbUrl=" + dbUrl);
            }
            cn.setAutoCommit(false);
            for (RowData rd : rows) {
                sql = this.genAddRowSql(tbDesc, rd);
                r = s.executeUpdate(sql.toString());
                if (r == 1) continue;
                throw new PersistenceException("");
            }
            cn.commit();
            if (canExe) {
                DBStateMgr.instance().shareRelease(cn, s);
            }
        }
        catch (PersistenceException e) {
            try {
                throw e;
                catch (Exception e2) {
                    StringBuffer errMsg = new StringBuffer();
                    errMsg.append(e2);
                    int closed = 0;
                    try {
                        closed = cn.isClosed() ? 1 : 0;
                    }
                    catch (Exception ee) {
                        closed = -1;
                    }
                    errMsg.append("\naddRows failed! r=" + r + ",dbUrl=" + dbUrl + ",cn=" + cn + ",closed=" + closed + "\nlastSql=" + sql + "\ntbDesc=" + tbDesc + "\nrows:");
                    this.logger.error(errMsg.toString());
                    System.err.println(errMsg);
                    Iterator<RowData> i$ = rows.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            throw new PersistenceException(errMsg.toString());
                        }
                        RowData rowData = i$.next();
                        this.logger.error(rowData.toString());
                        System.err.println(rowData.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                if (canExe) {
                    DBStateMgr.instance().shareRelease(cn, s);
                }
                this.releaseRes(dbUrl, cn, s, null, "addRows");
                throw throwable;
            }
        }
        this.releaseRes(dbUrl, cn, s, null, "addRows");
        this.logger.info("addRows: dbUrl=" + dbUrl + ", tbDesc=" + tbDesc + ", rows:");
        if (this.logger.isDebugEnabled()) {
            for (RowData rowData : rows) {
                this.logger.debug(rowData.toString());
            }
        }
    }

    @Override
    public final void delRowByKey(DevConfig cfg, TableDesc tbDesc, String key) throws PersistenceException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key);
        this.delRowByKeys(cfg, tbDesc, keys);
    }

    @Override
    public final void ldelRowByKey(DevConfig cfg, TableDesc tbDesc, String key) throws PersistenceException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key);
        this.ldelRowByKeys(cfg, tbDesc, keys);
    }

    @Override
    public final void delRowByKeys(DevConfig cfg, TableDesc tbDesc, List<String> keys) throws PersistenceException {
        this._delRowByKeys(cfg, tbDesc, keys, true);
    }

    @Override
    public final void ldelRowByKeys(DevConfig cfg, TableDesc tbDesc, List<String> keys) throws PersistenceException {
        this._delRowByKeys(cfg, tbDesc, keys, false);
    }

    private void _delRowByKeys(DevConfig cfg, TableDesc tbDesc, List<String> keys, boolean isShareAccess) throws PersistenceException {
        Statement s;
        Connection cn;
        String dbUrl;
        block12: {
            boolean result;
            block13: {
                dbUrl = this.cfg2DBUrl(cfg, false);
                cn = null;
                s = null;
                boolean canExe = false;
                int r = 1;
                StringBuffer sql = new StringBuffer();
                result = false;
                try {
                    cn = this.getConnection(dbUrl);
                    if (!this.cleanCN(dbUrl, cn, "_delRowByKeys")) {
                        throw new PersistenceException("cleanCN failed!");
                    }
                    s = cn.createStatement();
                    if (!this.syncBeginButNotEnd && !(canExe = isShareAccess ? DBStateMgr.instance().shareAccess(cn, s) : DBStateMgr.instance().lckAccess(cn, s))) {
                        throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + "dbUrl=" + dbUrl);
                    }
                    sql = this.genDelRowByKeySql(tbDesc, keys);
                    r = s.executeUpdate(sql.toString());
                    if (r < 1) {
                        throw new PersistenceException("");
                    }
                    cn.commit();
                    result = true;
                    if (!canExe) break block12;
                    if (!isShareAccess) break block13;
                    DBStateMgr.instance().shareRelease(cn, s);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        StringBuffer errMsg = new StringBuffer();
                        errMsg.append(e);
                        errMsg.append("\ndelRowByKeys failed! r=" + r + ",dbUrl=" + dbUrl + ",cn=" + cn + "\ntbDesc=" + tbDesc + "\nkey=");
                        for (String k : keys) {
                            errMsg.append(k + ",");
                        }
                        errMsg.append("\nsql=");
                        errMsg.append(sql.toString());
                        this.logger.error(errMsg.toString());
                        System.err.println(errMsg);
                        throw new PersistenceException(errMsg.toString());
                    }
                    catch (Throwable throwable) {
                        if (canExe) {
                            if (isShareAccess) {
                                DBStateMgr.instance().shareRelease(cn, s);
                            } else {
                                DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
                            }
                        }
                        this.releaseRes(dbUrl, cn, s, null, "delRowByKeys");
                        throw throwable;
                    }
                }
                break block12;
            }
            DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
        }
        this.releaseRes(dbUrl, cn, s, null, "delRowByKeys");
        StringBuffer sb = new StringBuffer(50);
        sb.append("[");
        for (String k : keys) {
            sb.append(k);
            sb.append(",");
        }
        sb.append("]");
        this.logger.info("delRowByKeys: cfg=" + cfg + ", tbDesc=" + tbDesc + ", keys:" + sb);
    }

    @Override
    public final void mdfRow(DevConfig cfg, TableDesc tbDesc, RowData rowData) throws PersistenceException {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        rows.add(rowData);
        this.mdfRows(cfg, tbDesc, rows);
    }

    @Override
    public final void lmdfRow(DevConfig cfg, TableDesc tbDesc, RowData rowData) throws PersistenceException {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        rows.add(rowData);
        this.lmdfRows(cfg, tbDesc, rows);
    }

    @Override
    public final void mdfRows(DevConfig cfg, TableDesc tbDesc, List<RowData> rows) throws PersistenceException {
        this._mdfRows(cfg, tbDesc, rows, true);
    }

    @Override
    public final void lmdfRows(DevConfig cfg, TableDesc tbDesc, List<RowData> rows) throws PersistenceException {
        this._mdfRows(cfg, tbDesc, rows, false);
    }

    private void _mdfRows(DevConfig cfg, TableDesc tbDesc, List<RowData> rows, boolean isShareAccess) throws PersistenceException {
        Statement s;
        Connection cn;
        String dbUrl;
        block13: {
            boolean result;
            block14: {
                dbUrl = this.cfg2DBUrl(cfg, false);
                cn = null;
                s = null;
                boolean canExe = false;
                int r = 0;
                StringBuffer sql = null;
                result = false;
                try {
                    cn = this.getConnection(dbUrl);
                    if (!this.cleanCN(dbUrl, cn, "_mdfRows")) {
                        throw new PersistenceException("cleanCN failed!");
                    }
                    s = cn.createStatement();
                    if (!this.syncBeginButNotEnd && !(canExe = isShareAccess ? DBStateMgr.instance().shareAccess(cn, s) : DBStateMgr.instance().lckAccess(cn, s))) {
                        throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + ",dbUrl=" + dbUrl);
                    }
                    for (RowData rowData : rows) {
                        sql = this.genMdfRowSql(tbDesc, rowData);
                        r = s.executeUpdate(sql.toString());
                        if (r == 1) continue;
                        throw new PersistenceException("");
                    }
                    cn.commit();
                    result = true;
                    if (!canExe) break block13;
                    if (!isShareAccess) break block14;
                    DBStateMgr.instance().shareRelease(cn, s);
                }
                catch (Exception e) {
                    try {
                        StringBuffer errMsg = new StringBuffer();
                        errMsg.append("mdfRows failed! last r=" + r + ",dbUrl=" + dbUrl + ",cn=" + cn);
                        errMsg.append("\ntbDesc=");
                        errMsg.append(tbDesc);
                        errMsg.append("\nlast sql=");
                        errMsg.append(sql);
                        for (RowData rd : rows) {
                            errMsg.append('\n');
                            errMsg.append(rd);
                        }
                        this.logger.error(errMsg.toString());
                        System.err.println(errMsg);
                        throw new PersistenceException(errMsg.toString());
                    }
                    catch (Throwable throwable) {
                        if (canExe) {
                            if (isShareAccess) {
                                DBStateMgr.instance().shareRelease(cn, s);
                            } else {
                                DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
                            }
                        }
                        this.releaseRes(dbUrl, cn, s, null, "mdfRows");
                        throw throwable;
                    }
                }
                break block13;
            }
            DBStateMgr.instance().lckRelease(cn, s, result, this.flowId, this.devStartTime);
        }
        this.releaseRes(dbUrl, cn, s, null, "mdfRows");
        this.logger.info("delRowByKeys: cfg=" + cfg + ", tbDesc=" + tbDesc);
        if (this.logger.isDebugEnabled()) {
            for (RowData rd : rows) {
                this.logger.debug(rd.toString());
            }
        }
    }

    @Override
    public final List<RowData> getAllRows(DevConfig cfg, TableDesc tbDesc, QueryCondition cond) throws PersistenceException {
        ResultSet rst;
        Statement s;
        Connection cn;
        ArrayList<RowData> r;
        String dbUrl;
        block8: {
            this.logger.info("begin getAllRows: cfg=" + cfg + ", tbDesc=" + tbDesc);
            dbUrl = this.cfg2DBUrl(cfg, false);
            r = new ArrayList<RowData>();
            if (null == dbUrl) {
                return r;
            }
            this.preProcessCondition(tbDesc, cond);
            cn = null;
            s = null;
            boolean canExe = false;
            rst = null;
            StringBuffer sql = null;
            try {
                cn = this.getConnection(dbUrl);
                s = cn.createStatement();
                if (!(this.isDebug || this.syncBeginButNotEnd || (canExe = DBStateMgr.instance().shareAccess(cn, s)))) {
                    throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + ",dbUrl=" + dbUrl);
                }
                this.beforeConnectionQuery(s);
                sql = this.genGetAllRowSql(tbDesc, cond);
                rst = s.executeQuery(sql.toString());
                while (rst.next()) {
                    RowData rd = this.getRowDataFromRst(tbDesc, rst, cond);
                    r.add(rd);
                }
                if (!canExe) break block8;
                DBStateMgr.instance().shareRelease(cn, s);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    String errMsg = e + "\ngetAllRows failed! dbUrl=" + dbUrl + ",cn=" + cn + "\ntbDesc=" + tbDesc + "\ncond=" + cond + "\nsql=" + sql;
                    this.logger.error(errMsg);
                    System.err.println(errMsg);
                    throw new PersistenceException(errMsg);
                }
                catch (Throwable throwable) {
                    if (canExe) {
                        DBStateMgr.instance().shareRelease(cn, s);
                    }
                    this.releaseRes(dbUrl, cn, s, rst, "getAllRows");
                    throw throwable;
                }
            }
        }
        this.releaseRes(dbUrl, cn, s, rst, "getAllRows");
        this.logger.info("end getAllRows: cfg=" + cfg + ", tbDesc=" + tbDesc);
        return r;
    }

    @Override
    public final int getRowNum(DevConfig cfg, TableDesc tbDesc, QueryCondition cond) throws PersistenceException {
        ResultSet rst;
        Statement s;
        Connection cn;
        int r;
        String dbUrl;
        block6: {
            dbUrl = this.cfg2DBUrl(cfg, false);
            r = 0;
            this.preProcessCondition(tbDesc, cond);
            cn = null;
            s = null;
            boolean canExe = false;
            rst = null;
            try {
                cn = this.getConnection(dbUrl);
                s = cn.createStatement();
                if (!(this.isDebug || this.syncBeginButNotEnd || (canExe = DBStateMgr.instance().shareAccess(cn, s)))) {
                    throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + ",dbUrl=" + dbUrl);
                }
                StringBuffer sql = this.genGetRowNumSql(tbDesc, cond);
                rst = s.executeQuery(sql.toString());
                rst.next();
                String rStr = rst.getString(1);
                r = Integer.parseInt(rStr);
                if (!canExe) break block6;
                DBStateMgr.instance().shareRelease(cn, s);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    String errMsg = e + "\ngetRowNum failed!\ntbDesc=" + tbDesc + ",cn=" + cn + ",dbUrl=" + dbUrl + "\ncond=" + cond;
                    this.logger.debug(errMsg);
                    throw new PersistenceException(errMsg);
                }
                catch (Throwable throwable) {
                    if (canExe) {
                        DBStateMgr.instance().shareRelease(cn, s);
                    }
                    this.releaseRes(dbUrl, cn, s, rst, "getRowNum");
                    throw throwable;
                }
            }
        }
        this.releaseRes(dbUrl, cn, s, rst, "getRowNum");
        this.logger.info("getRowNum: cfg=" + cfg + ", tbDesc=" + tbDesc);
        return r;
    }

    @Override
    public final PageQueryHandle getPageHandle(DevConfig cfg, TableDesc tbDesc, QueryCondition cond) throws PersistenceException {
        String dbUrl = this.cfg2DBUrl(cfg, false);
        this.preProcessCondition(tbDesc, cond);
        Connection cn = null;
        Statement s = null;
        boolean canExe = false;
        ResultSet rst = null;
        try {
            cn = this.getConnection(dbUrl);
            s = cn.createStatement();
            if (!(this.isDebug || this.syncBeginButNotEnd || (canExe = DBStateMgr.instance().shareAccess(cn, s)))) {
                throw new PersistenceException("db busy, cann't exe this action!,cn=" + cn + ",dbUrl=" + dbUrl);
            }
            this.beforeConnectionQuery(s);
            StringBuffer sql = this.genGetAllRowSql(tbDesc, cond);
            rst = s.executeQuery(sql.toString());
            PageQueryHandleImpl r = new PageQueryHandleImpl(dbUrl, cn, s, rst, tbDesc, cond);
            return r;
        }
        catch (Throwable e) {
            if (canExe) {
                DBStateMgr.instance().shareRelease(cn, s);
            }
            this.releaseRes(dbUrl, cn, s, null, "getPageHandle");
            String errMsg = e + "\ngetPageHandle releaseRes failed!\ndbUrl=" + dbUrl + ",cn=" + cn + "\ntbDesc=" + tbDesc + "\ncond=" + cond;
            this.logger.debug(errMsg);
            System.err.println(errMsg);
            throw new PersistenceException(errMsg);
        }
    }

    @Override
    public final void closePageHandle(PageQueryHandle handle) throws PersistenceException {
        PageQueryHandleImpl hd = (PageQueryHandleImpl)handle;
        try {
            try {
                Statement s = hd.cn.createStatement();
                if (!this.isDebug && !this.syncBeginButNotEnd) {
                    DBStateMgr.instance().shareRelease(hd.cn, s);
                }
            }
            catch (SQLException e) {
                String errMsg = "closePageHandle: DBStateMgr.instance().shareRelease(hd.cn, s);,cn=" + hd.cn + ",dbUrl=" + hd.dbUrl;
                System.err.println(errMsg);
                this.logger.error(errMsg);
            }
            this.releaseRes(hd.dbUrl, hd.cn, hd.s, hd.rst, "closePageHandle");
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e + "\nclosePageHandle failed!" + ",cn=" + hd.cn + ",dbUrl=" + hd.dbUrl;
            this.logger.debug(errMsg);
            throw new PersistenceException(errMsg);
        }
    }

    @Override
    public final boolean getNextPageRows(PageQueryHandle handle, List<RowData> rt) throws PersistenceException {
        PageQueryHandleImpl hd = (PageQueryHandleImpl)handle;
        try {
            ResultSet rst = hd.rst;
            int PAGE_SIZE = hd.getPageSize();
            int idx = 0;
            while (rst.next()) {
                RowData rd = this.getRowDataFromRst(hd.tbDesc, hd.rst, hd.cond);
                rt.add(rd);
                if (++idx < PAGE_SIZE) continue;
                break;
            }
            hd.incPageIdx();
            return idx >= PAGE_SIZE;
        }
        catch (Exception e) {
            String errMsg = e + "\ngetNextPageRows failed!" + ",cn=" + hd.cn + ",dbUrl=" + hd.dbUrl;
            this.logger.debug(errMsg);
            System.err.println(errMsg);
            throw new PersistenceException(errMsg);
        }
    }

    @Override
    public final String cfg2DBInfo(DevConfig cfg) {
        return this.cfg2DBUrl(cfg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean persistAll(boolean force, boolean haltPersist) {
        boolean ret = true;
        if (haltPersist) {
            this.poolMgr.halt();
        }
        if (!force) {
            ret = this.poolMgr.closeAllCon();
        } else {
            ConnectionPoolMgr<Connection> connectionPoolMgr = this.poolMgr;
            synchronized (connectionPoolMgr) {
                Map<String, List<ConnectionPoolMgr.ConData<Connection>>> infos = this.poolMgr.getInfo();
                Set<String> dbUrls = infos.keySet();
                for (String dbUrl : dbUrls) {
                    try {
                        Connection cn = this.newCon(dbUrl, true);
                        cn.createStatement().execute("SHUTDOWN");
                        cn.close();
                    }
                    catch (Exception e) {
                        String errMsg = e + "\nforce persist failed!dbUrl=" + dbUrl;
                        System.err.println(errMsg);
                        this.logger.error(errMsg);
                        ret = false;
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public final void enterOneMode() {
        this.oneMode = true;
    }

    @Override
    public final void leaveOneMode() {
        this.oneMode = false;
        this.releaseRes(this.lastDBUrl, this.lastCon, null, null, "leaveOneMode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lckCfg(DevConfig cfg) {
        String dbUrl = this.cfg2DBUrl(cfg, false);
        Connection cn = null;
        Statement s = null;
        boolean locked = false;
        try {
            this.enterOneMode();
            cn = this.getConnection(dbUrl);
            if (!this.cleanCN(dbUrl, cn, "lckCfg")) {
                throw new PersistenceException("cleanCN failed!");
            }
            s = cn.createStatement();
            locked = DBStateMgr.instance().lckAccess(cn, s);
            if (!locked) {
                this.leaveOneMode();
            }
            this.releaseRes(dbUrl, cn, s, null, "lckCfg");
        }
        catch (Exception e) {
            try {
                String errMsg = "lckCfg failed! dbUrl=" + dbUrl;
                this.logger.error(errMsg);
                System.err.println(errMsg);
                if (!locked) {
                    this.leaveOneMode();
                }
                this.releaseRes(dbUrl, cn, s, null, "lckCfg");
            }
            catch (Throwable throwable) {
                if (!locked) {
                    this.leaveOneMode();
                }
                this.releaseRes(dbUrl, cn, s, null, "lckCfg");
                throw throwable;
            }
        }
        return locked;
    }

    @Override
    public boolean relCfg(DevConfig cfg, boolean opResult) {
        if (this.lastCon == null || !this.oneMode) {
            return true;
        }
        boolean r = false;
        Statement s = null;
        try {
            s = this.lastCon.createStatement();
            r = DBStateMgr.instance().lckRelease(this.lastCon, s, opResult, this.flowId, this.devStartTime);
        }
        catch (Exception e) {
            String errMsg = "relCfg failed! cfg=" + cfg;
            this.logger.error(errMsg);
            System.err.println(errMsg);
        }
        this.leaveOneMode();
        return r;
    }

    public final void delShadowDB() {
    }

    @Override
    public List<DevConfig> getUnConsistentCfg(boolean recover) {
        ArrayList<DevConfig> r = new ArrayList<DevConfig>();
        List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
        for (DevChange.DevInfo dev : devs) {
            List<DevConfig> allCfg = DevMgr.instance().getPersistDevCfg(dev.devIdentify);
            for (DevConfig cfg : allCfg) {
                boolean isConsist = this.checkConsist(cfg);
                if (isConsist) continue;
                String warnMsg = "debug-info: cfg<" + cfg + "> is not consistence, try to recover!";
                System.out.println(warnMsg);
                this.logger.error(warnMsg);
                if (this.recover(cfg)) {
                    warnMsg = "\tGood! recover success.";
                    System.out.println(warnMsg);
                    this.logger.error(warnMsg);
                    continue;
                }
                warnMsg = "\tbad luck! recover failed.";
                System.out.println(warnMsg);
                this.logger.error(warnMsg);
                r.add(cfg);
            }
        }
        if (r.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("getUnConsistentCfg! the following cfg is not consistent:");
            for (DevConfig cfg : r) {
                sb.append("\n\t");
                sb.append(cfg);
            }
            this.logger.info(sb.toString());
        } else {
            this.logger.info("getUnConsistentCfg, all cfg is consistent!");
        }
        return r;
    }

    @Override
    public boolean checkDevConsist(DevChange.DevIdentify dv) {
        ArrayList<DevConfig> r = new ArrayList<DevConfig>();
        List<DevConfig> allCfg = DevMgr.instance().getPersistDevCfg(dv);
        for (DevConfig cfg : allCfg) {
            boolean isConsist = this.checkConsist(cfg);
            if (isConsist) continue;
            r.add(cfg);
        }
        if (r.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("checkDevConsist! the following cfg is not consistent:");
            for (DevConfig cfg : r) {
                sb.append("\n\t");
                sb.append(cfg);
            }
            this.logger.info(sb.toString());
            return false;
        }
        this.logger.info("checkDevConsist, all cfg is consistent!");
        return true;
    }

    public void setDebugMode(boolean isDebug) {
        this.isDebug = isDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConsist(DevConfig cfg) {
        boolean r = false;
        String dbUrl = this.cfg2DBUrl(cfg, false);
        Connection cn = null;
        Statement s = null;
        try {
            cn = this.getConnection(dbUrl);
            s = cn.createStatement();
            r = DBStateMgr.instance().isDBSyncOK(cn, s);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e + "\ncheckConsist failed! \n,cn=" + cn + "dbUrl=" + dbUrl;
            this.logger.error(errMsg);
            System.err.println(errMsg);
        }
        finally {
            this.releaseRes(dbUrl, cn, s, null, "checkConsist");
        }
        return r;
    }

    protected void initTargetDB(Connection cn, Statement s) throws Exception {
        s.execute("SET FILES WRITE DELAY 6000 MILLIS");
        s.execute("SET FILES BACKUP INCREMENT FALSE");
        s.execute("SET FILES LOG FALSE");
        s.execute("SET DATABASE DEFAULT TABLE TYPE CACHED");
        s.execute("SET DATABASE DEFAULT RESULT MEMORY ROWS 1000");
        s.execute("SET FILES CACHE ROWS 500");
    }

    protected void beforeConnectionQuery(Statement s) throws Exception {
        s.execute("SET SESSION RESULT MEMORY ROWS " + MAX_LINE_MEMORY);
    }

    protected String cfg2DBUrl(DevConfig cfg, boolean isCreate) {
        return this.cfg2DBUrlEx(cfg, isCreate, null);
    }

    protected String cfg2DBUrlEx(DevConfig cfg, boolean isCreate, List<String> dbUrlShadows) {
        String[] fns;
        String minSuffix;
        StringBuilder dbUrl = new StringBuilder(50);
        String dbdir = DBCommonOper1Cfg1DB.judgeDBDirByDevIdentify(cfg.getIdentify());
        if (dbdir == null) {
            String errMsg = "cfg2DBUrl: get dbdir failed!!! cfg=" + cfg;
            System.err.println(errMsg);
            this.logger.error(errMsg);
            return null;
        }
        dbUrl.append("jdbc:hsqldb:file:" + dbdir + File.separator + cfg);
        if (isCreate) {
            this.appendSuffix(dbUrl, DBSuffixMgr.gen());
            this.lastDBUrl = dbUrl.toString();
            return this.lastDBUrl;
        }
        if (!this.lastDBUrl.equals("") && (this.isUseLastDBUrl || this.forceUseLastDBUrl) && this.lastDBUrl.contains(cfg.toString())) {
            return this.lastDBUrl;
        }
        String maxSuffix = minSuffix = "0000000000000000";
        File dbDirFile = new File(dbdir);
        for (String fn : fns = dbDirFile.list()) {
            String[] splits = fn.split("\\+");
            if (splits.length != 3) continue;
            String suffix = splits[1];
            if (dbUrlShadows != null) {
                StringBuilder shadowSb = new StringBuilder();
                shadowSb.append((CharSequence)dbUrl);
                this.appendSuffix(shadowSb, suffix);
                dbUrlShadows.add(shadowSb.toString());
            }
            if (!fn.endsWith(DBURL_IDFILE_SUFFIX) || !fn.startsWith(cfg.toString()) || maxSuffix.compareTo(suffix) >= 0) continue;
            maxSuffix = suffix;
        }
        if (maxSuffix.equals(minSuffix)) {
            return null;
        }
        this.appendSuffix(dbUrl, maxSuffix);
        this.lastDBUrl = dbUrl.toString();
        return this.lastDBUrl;
    }

    protected Connection newCon(String dbUrl, boolean forceUseExist) throws Exception {
        String option = ";shutdown=true" + (forceUseExist ? ";ifexists=true" : "");
        return DriverManager.getConnection(dbUrl + option, "SA", "");
    }

    protected List<String> dbUrl2Files(String dbUrl) {
        ArrayList<String> r = new ArrayList<String>();
        String fnPrefix = DBCommonOper1Cfg1DB.dbUrl2FnPrefix(dbUrl);
        r.add(fnPrefix + DBURL_IDFILE_SUFFIX);
        r.add(fnPrefix + ".lck");
        r.add(fnPrefix + ".data");
        r.add(fnPrefix + ".lobs");
        r.add(fnPrefix + ".script");
        r.add(fnPrefix + ".properties");
        r.add(fnPrefix + ".log");
        r.add(fnPrefix + ".backup");
        return r;
    }

    protected boolean delDBFiles(String dbUrl) {
        DevChange.DevIdentify id = DBCommonOper1Cfg1DB.getDevIdentifyFromDBUrl(dbUrl);
        if (id == null) {
            String errMsg = "receive error dburl while delete db file!!! dbUrl=" + dbUrl;
            this.logger.error(errMsg);
            System.err.println(errMsg);
            return false;
        }
        String dbdir = DBCommonOper1Cfg1DB.judgeDBDirByDevIdentify(id);
        if (dbdir == null) {
            return false;
        }
        boolean r = true;
        List<String> fnList = this.dbUrl2Files(dbUrl);
        for (String fn : fnList) {
            File file = new File(dbdir + File.separator + fn);
            if (!file.exists() || file.delete()) continue;
            r = false;
            String errMsg = "HSQLDBDelConBackCall del db file failed! fn=" + fn + ", dbdir=" + dbdir;
            System.err.println(errMsg);
            this.logger.error(errMsg);
            return false;
        }
        return r;
    }

    private boolean recover(DevConfig cfg) {
        return false;
    }

    private void ipStrHashCodeTest() throws Exception {
        long TOTAL = 4228250625L;
        long MAX = 500L;
        long BULKS = 8456501L;
        HashMap<Long, Long> hash = new HashMap<Long, Long>();
        for (long i = 0L; i < 4228250625L; ++i) {
            String cfg = Get.ip();
            long code = Math.abs(cfg.hashCode());
            Long elmNum = (Long)hash.get(code %= 8456501L);
            if (elmNum == null) {
                hash.put(code, new Long(1L));
            } else {
                hash.put(code, new Long(elmNum + 1L));
            }
            if (i % 999999L != 0L) continue;
            System.out.println((float)i / 4.2282506E9f);
        }
        System.out.println("total=" + new Long(4228250625L) + ", MAX=" + new Long(500L) + ", bulks=" + hash.size());
        HashMap<Long, Long> overs = new HashMap<Long, Long>();
        Set bulks = hash.entrySet();
        for (Map.Entry bulk : bulks) {
            long size = (Long)bulk.getValue();
            if (size <= 500L) continue;
            long m = size / 500L;
            Long num = (Long)overs.get(m);
            if (num == null) {
                overs.put(m, new Long(1L));
                continue;
            }
            overs.put(m, new Long(num + 1L));
        }
        Set os = overs.entrySet();
        for (Map.Entry o : os) {
            System.out.println("M=" + o.getKey() + ", NUM=" + o.getValue());
        }
    }

    private boolean cleanCN(String dbUrl, Connection cn, String desc) {
        try {
            cn.setAutoCommit(!cn.getAutoCommit());
            cn.setAutoCommit(false);
        }
        catch (Exception e) {
            String errMsg = e + "\ncleanCN failed at " + desc + "!cn=" + cn + ", dbUrl=" + dbUrl;
            System.err.println(errMsg);
            this.logger.error(errMsg);
            return false;
        }
        return true;
    }

    private void appendSuffix(StringBuilder dbUrl, String suffix) {
        dbUrl.append(".+");
        dbUrl.append(suffix);
        dbUrl.append("+.");
    }

    private StringBuffer genAddRowSql(TableDesc tbDesc, RowData rowData) {
        StringBuffer sb = new StringBuffer(300);
        StringBuffer cols = new StringBuffer(100);
        StringBuffer values = new StringBuffer(100);
        Map<String, TableDesc.ColType> colInfos = tbDesc.getColInfos();
        Set<String> colSet = rowData.cvs.keySet();
        boolean first = true;
        for (String col : colSet) {
            CharSequence v;
            TableDesc.ColType colType = colInfos.get(col);
            if (colType == null) {
                this.logger.warn("maybe a a error! col(" + col + ") does not exist int table(" + tbDesc.getName() + ")!");
                continue;
            }
            if (colType.type == TableDesc.ColType.TYPE.STR || colType.type == TableDesc.ColType.TYPE.VARSTR) {
                if (!first) {
                    cols.append(",");
                    values.append(",");
                }
                v = new StringBuilder();
                ((StringBuilder)v).append("'");
                ((StringBuilder)v).append(this.normalstr2Sqlstr(rowData.cvs.get(col), colType.type));
                ((StringBuilder)v).append("'");
                cols.append(col);
                values.append(v);
                first = false;
                continue;
            }
            v = rowData.cvs.get(col);
            if (((String)v).equals("")) continue;
            if (!first) {
                cols.append(",");
                values.append(",");
            }
            values.append((String)v);
            cols.append(col);
            first = false;
        }
        sb.append("INSERT INTO " + tbDesc.getName() + " (" + cols + ") VALUES(" + values + ")");
        values = null;
        cols = null;
        return sb;
    }

    private StringBuffer genAddTbSql(TableDesc tbDesc) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("CREATE TABLE " + tbDesc.getName() + " (");
        int colNum = tbDesc.getAllCols().size();
        for (int idx = 0; idx < colNum; ++idx) {
            if (idx != 0) {
                sb.append(",");
            }
            TableDesc.ColType ct = tbDesc.getColType(idx);
            if (ct.type == TableDesc.ColType.TYPE.INT32) {
                sb.append(tbDesc.getColName(idx) + " INT");
                continue;
            }
            if (ct.type == TableDesc.ColType.TYPE.STR) {
                sb.append(tbDesc.getColName(idx) + " CHAR(" + ct.len + ")");
                continue;
            }
            if (ct.type == TableDesc.ColType.TYPE.VARSTR) {
                sb.append(tbDesc.getColName(idx) + " VARCHAR(" + ct.len + ")");
                continue;
            }
            sb.append(tbDesc.getColName(idx) + " VARCHAR(" + PolicyQuery1Cfg1DB.DEFAULT_STR_LEN + ")");
        }
        List<String> tbKeys = tbDesc.getKeys();
        if (tbKeys != null) {
            int keyNum = tbKeys.size();
            sb.append(",PRIMARY KEY (");
            for (int idx = 0; idx < keyNum; ++idx) {
                if (idx != 0) {
                    sb.append(",");
                }
                sb.append(tbKeys.get(idx));
            }
            sb.append(")");
        }
        sb.append(")");
        return sb;
    }

    private StringBuffer genDelRowByKeySql(TableDesc tbDesc, List<String> keys) {
        int tbKeyNum;
        StringBuffer sb = new StringBuffer(50);
        sb.append("DELETE FROM ");
        sb.append(tbDesc.getName());
        PreciseQueryCondition cond = new PreciseQueryCondition();
        HashMap<String, String> match = new HashMap<String, String>();
        List<String> tbKeys = tbDesc.getKeys();
        if (tbKeys.size() == 0) {
            if (keys != null && keys.size() != 0) {
                this.logger.warn("the talbe has no key, but query condition contain key!");
            }
            return new StringBuffer();
        }
        int queryKeyNum = keys.size();
        if (queryKeyNum > (tbKeyNum = tbKeys.size())) {
            this.logger.warn("queryKeyNum > tbKeyNum!");
        }
        for (int idx = 0; idx < queryKeyNum && idx < tbKeyNum; ++idx) {
            match.put(tbKeys.get(idx), keys.get(idx));
        }
        cond.or.add(match);
        sb.append(this.genWhereSql(tbDesc, cond));
        return sb;
    }

    private String genDrpTbSql(TableDesc tbDesc) {
        return "DROP TABLE " + tbDesc.getName();
    }

    private StringBuffer genGetAllRowSql(TableDesc tbDesc, QueryCondition cond) {
        this.logger.info("begin genGetAllRowSql, tbDesc=" + tbDesc);
        StringBuffer sb = new StringBuffer(100);
        sb.append("SELECT ");
        StringBuffer selColSql = this.genSelColSql(cond);
        sb.append(selColSql);
        sb.append(" FROM ");
        sb.append(tbDesc.getName());
        if (cond instanceof PreciseQueryCondition) {
            sb.append(this.genWhereSql(tbDesc, (PreciseQueryCondition)cond));
        }
        this.logger.info("end genGetAllRowSql, tbDesc=" + tbDesc);
        return sb;
    }

    private StringBuffer genGetRowNumSql(TableDesc tbDesc, QueryCondition cond) {
        StringBuffer sb = new StringBuffer("SELECT COUNT(*) FROM ");
        sb.append(tbDesc.getName());
        if (cond instanceof PreciseQueryCondition) {
            sb.append(this.genWhereSql(tbDesc, (PreciseQueryCondition)cond));
        }
        return sb;
    }

    private StringBuffer genMdfRowSql(TableDesc tbDesc, RowData rowData) throws PersistenceException {
        if (rowData.cvs.size() == 0) {
            String errMsg = "no rowData int genMdfRowSql!";
            throw new PersistenceException(errMsg);
        }
        StringBuffer sb = new StringBuffer(100);
        Map<String, TableDesc.ColType> colInfos = tbDesc.getColInfos();
        List<String> keys = tbDesc.getKeys();
        PreciseQueryCondition cond = new PreciseQueryCondition();
        HashMap<String, String> match = new HashMap<String, String>();
        for (String key : keys) {
            String value = rowData.cvs.get(key);
            if (value == null) {
                String errMsg = "genMdfRowSql can only support modify by key! but key(" + key + ") is not in rowdata";
                throw new PersistenceException(errMsg);
            }
            match.put(key, value);
        }
        cond.addMatchCond(match);
        StringBuffer whereSql = this.genWhereSql(tbDesc, cond);
        sb.append("UPDATE ");
        sb.append(tbDesc.getName());
        sb.append(" SET ");
        Set<String> cols = rowData.cvs.keySet();
        int idx = 0;
        for (String col : cols) {
            TableDesc.ColType colType = colInfos.get(col);
            if (null == colType) {
                this.logger.warn("maybe a error! col(" + col + ") does not exist int table(" + tbDesc.getName() + ")!");
                continue;
            }
            if (idx != 0) {
                sb.append(",");
            }
            sb.append(col);
            sb.append('=');
            String colValue = rowData.cvs.get(col);
            if (colType.type == TableDesc.ColType.TYPE.STR || colType.type == TableDesc.ColType.TYPE.VARSTR) {
                sb.append('\'');
                colValue = this.normalstr2Sqlstr(colValue, colType.type);
                sb.append(colValue);
                sb.append('\'');
            } else {
                sb.append(colValue);
            }
            ++idx;
        }
        sb.append(whereSql);
        return sb;
    }

    private StringBuffer genSelColSql(QueryCondition cond) {
        StringBuffer r = new StringBuffer(100);
        int idx = 0;
        for (String col : cond.getSelCols()) {
            if (idx != 0) {
                r.append(",");
            }
            r.append(col);
            ++idx;
        }
        return r;
    }

    private StringBuffer genWhereSql(TableDesc tbDesc, PreciseQueryCondition cond) {
        PreciseQueryCondition cd = cond;
        StringBuffer sb = new StringBuffer(100);
        sb.append(" WHERE ");
        Map<String, TableDesc.ColType> colInfos = tbDesc.getColInfos();
        boolean firstOr = true;
        for (Map<String, String> orCond : cd.or) {
            Set<String> cols = orCond.keySet();
            if (cols == null) continue;
            if (!firstOr) {
                sb.append(" OR ");
            }
            boolean firstAndCol = true;
            StringBuilder sbOneOr = new StringBuilder();
            sbOneOr.append("(");
            for (String col : cols) {
                TableDesc.ColType colType = colInfos.get(col);
                if (null == colType) continue;
                String v = this.normalstr2Sqlstr(orCond.get(col), colType.type);
                if (colType.type == TableDesc.ColType.TYPE.STR || colType.type == TableDesc.ColType.TYPE.VARSTR) {
                    if (!firstAndCol) {
                        sbOneOr.append(" AND ");
                    }
                    sbOneOr.append(col);
                    sbOneOr.append("='");
                    sbOneOr.append(v);
                    sbOneOr.append("'");
                    firstAndCol = false;
                    continue;
                }
                if (v.equals("")) continue;
                if (!firstAndCol) {
                    sbOneOr.append(" AND ");
                }
                sbOneOr.append(col);
                sbOneOr.append("=");
                sbOneOr.append(v);
                firstAndCol = false;
            }
            sbOneOr.append(")");
            if (firstAndCol) continue;
            sb.append((CharSequence)sbOneOr);
            firstOr = false;
        }
        return !firstOr ? sb : new StringBuffer();
    }

    private RowData getRowDataFromRst(TableDesc tbDesc, ResultSet rst, QueryCondition cond) throws Exception {
        RowData r = new RowData();
        Map<String, TableDesc.ColType> colInfos = tbDesc.getColInfos();
        for (String col : cond.getSelCols()) {
            TableDesc.ColType.TYPE t = colInfos.get((Object)col).type;
            String value = rst.getString(col);
            value = null == value ? "" : this.sqlstr2Normalstr(value, t);
            r.cvs.put(col, value);
        }
        return r;
    }

    private String normalstr2Sqlstr(String normal, TableDesc.ColType.TYPE t) {
        int normalLen = normal.length();
        StringBuffer sb = new StringBuffer(normalLen + 20);
        for (int idx = 0; idx < normalLen; ++idx) {
            char c = normal.charAt(idx);
            if (c == '\'') {
                sb.append('\\');
            }
            sb.append(c);
        }
        if (t == TableDesc.ColType.TYPE.STR) {
            sb.append(FIXED_STR_END);
        }
        return sb.toString();
    }

    private String sqlstr2Normalstr(String sqlstr, TableDesc.ColType.TYPE t) {
        if (t == TableDesc.ColType.TYPE.STR) {
            int idx = sqlstr.lastIndexOf(FIXED_STR_END);
            return sqlstr.substring(0, idx);
        }
        return sqlstr;
    }

    private void preProcessCondition(TableDesc tbDesc, QueryCondition cond) {
        List<String> cols = cond.getSelCols();
        if (cols == null || cols.size() == 0) {
            cond.resetSelCols(tbDesc.getAllCols());
        }
    }

    private boolean releaseRes(String dbUrl, Connection cn, Statement s, ResultSet rst, String when) {
        try {
            if (rst != null) {
                rst.close();
            }
            if (s != null) {
                s.close();
            }
            if (!this.oneMode && cn != null) {
                this.poolMgr.releaseConnection(dbUrl, cn);
                if (this.lastCon == cn) {
                    this.lastCon = null;
                }
                cn.commit();
                cn.setAutoCommit(true);
            }
            return true;
        }
        catch (Throwable e) {
            String errMsg = e + "\nreleaseRes failed! dbUrl=" + dbUrl + "\n\twhen=" + when;
            System.err.println(errMsg);
            this.logger.error(errMsg);
            return false;
        }
    }

    private Connection getConnection(String dbUrl) throws PersistenceException {
        if (this.oneMode && this.lastCon != null) {
            return this.lastCon;
        }
        Connection cn = this.poolMgr.getConnection(dbUrl);
        if (cn != null) {
            String info = "debugInfo: get a connection(" + cn + ") dbUrl=" + dbUrl;
            this.logger.info(info);
            this.lastCon = cn;
            return this.lastCon;
        }
        this.lastCon = this.newConAndAdd2Pool(dbUrl, true);
        return this.lastCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection newConAndAdd2Pool(String dbUrl, boolean forceUseExist) throws PersistenceException {
        Connection cn = null;
        boolean occupied = this.poolMgr.occupyOneSlot(true, 2000L);
        if (occupied) {
            int times = 6;
            Exception lastE = null;
            do {
                try {
                    cn = this.newCon(dbUrl, forceUseExist);
                }
                catch (Exception e) {
                    lastE = e;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
            } while (cn == null && --times > 0);
            if (cn == null) {
                this.poolMgr.putCon2Slot(dbUrl, null);
                String errMsg = "\ncreate a connection failed! dbUrl=" + dbUrl + ",forceUseExist=" + forceUseExist + ", last exp is:\n" + lastE;
                throw new PersistenceException(errMsg);
            }
            String info = "debugInfo: create a connection(" + cn + ") dbUrl=" + dbUrl + ",forceUseExist=" + forceUseExist;
            this.logger.info(info);
            ConnectionPoolMgr.instance().logCn(dbUrl, cn, "new");
            ConnectionPoolMgr<Connection> connectionPoolMgr = this.poolMgr;
            synchronized (connectionPoolMgr) {
                this.poolMgr.putCon2Slot(dbUrl, cn);
                cn = this.poolMgr.getConnection(dbUrl);
                return cn;
            }
        }
        throw new PersistenceException("db connection pool is full!");
    }

    static {
        DBCommonOper1Cfg1DB.init();
    }

    private static final class PageQueryHandleImpl
    extends PageQueryHandle {
        public String dbUrl;
        public Connection cn;
        public QueryCondition cond;
        public ResultSet rst;
        public Statement s;
        public TableDesc tbDesc;

        public PageQueryHandleImpl(String dbUrl, Connection cn, Statement s, ResultSet rst, TableDesc tbDesc, QueryCondition cond) {
            this.cond = cond;
            this.rst = rst;
            this.dbUrl = dbUrl;
            this.tbDesc = tbDesc;
            this.s = s;
            this.cn = cn;
        }

        @Override
        public int getPageSize() {
            return this.cond.getPageSize();
        }

        public void incPageIdx() {
            ++this.nextPageIdx;
        }
    }

    private static class DBSuffixMgr {
        private static volatile long dbSuffix = System.currentTimeMillis();

        private DBSuffixMgr() {
        }

        public static synchronized String gen() {
            StringBuffer sb = new StringBuffer(16);
            String cur = Long.toHexString(dbSuffix);
            int len = cur.length();
            for (int i = 0; i < 16 - len; ++i) {
                sb.append("0");
            }
            sb.append(cur);
            ++dbSuffix;
            return sb.toString();
        }
    }

    protected static class HSQLDBDelConBackCall
    implements ConnectionPoolMgr.DBBackCallFromConPool<Connection> {
        private Logger logger = RunLogger.getRunLogger();

        protected HSQLDBDelConBackCall() {
        }

        @Override
        public boolean shutdownDB(String dbUrl, Connection cn) {
            DBCommonOper1Cfg1DB db = new DBCommonOper1Cfg1DB();
            int poolSize = 0;
            try {
                if (cn == null) {
                    poolSize = ConnectionPoolMgr.instance().incPoolSize();
                    cn = db.newConAndAdd2Pool(dbUrl, true);
                }
                cn.createStatement().execute("SHUTDOWN");
            }
            catch (Exception e) {
                String errMsg = e + "\nHSQLDBDelConBackCall: shutdowndb failed! dbUrl=" + dbUrl + ",poolSize=" + poolSize;
                this.logger.error(errMsg);
                System.err.println(errMsg);
                return false;
            }
            return true;
        }

        @Override
        public boolean delCnFromPoolCB(String dbUrl, Connection cn) {
            try {
                cn.commit();
                cn.close();
            }
            catch (Exception e) {
                String errMsg = e + "\n";
                int closed = -1;
                int valid = -1;
                try {
                    int n = closed = cn.isClosed() ? 1 : 0;
                    valid = closed == 1 ? 0 : (cn.isValid(5) ? 1 : 0);
                }
                catch (Exception ee) {
                    errMsg = ee + "\n";
                }
                errMsg = errMsg + "\nHSQLDBDelConBackCall failed! closed=" + closed + ",valid=" + valid + ",cn=" + cn + ",dbUrl=" + dbUrl;
                System.err.println(errMsg);
                this.logger.error(errMsg);
                return closed == 1 || valid == 0;
            }
            return true;
        }

        @Override
        public boolean delDBCB(String dbUrl) {
            DBCommonOper1Cfg1DB db = new DBCommonOper1Cfg1DB();
            return db.delDBFiles(dbUrl);
        }
    }

    private static class Get {
        static long i = 1L;
        static long j = 1L;
        static long k = 1L;
        static long kk = 1L;

        private Get() {
        }

        static String ip() {
            String r = kk + "." + k + "." + j + "." + i;
            if (++i > 255L) {
                i = 1L;
                ++j;
            }
            if (j > 255L) {
                j = 1L;
                ++k;
            }
            if (k > 255L) {
                k = 1L;
                ++kk;
            }
            return r;
        }
    }
}

