/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.service.impl;

import com.huawei.vmf.qat.common.log.RunLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionPoolMgr<ConType> {
    private volatile int MAX_CONNECTION = 10;
    public static int DELAY_DEL_TIMER = 2;
    private static Object instance;
    private Random random = new Random(System.currentTimeMillis());
    private Logger logger = RunLogger.getRunLogger();
    private Logger persistLog = LoggerFactory.getLogger((String)"persist_pool_inout");
    private Map<String, List<ConData<ConType>>> cfg2Con = new HashMap<String, List<ConData<ConType>>>();
    private DBBackCallFromConPool<ConType> delConBackCall = null;
    private final Map<String, List<ConData<ConType>>> deletedDBIDMap = Collections.synchronizedMap(new HashMap());
    private final DelayDelDBConnectionThread<ConType> delDBConThread = new DelayDelDBConnectionThread<ConType>(this.deletedDBIDMap);
    private volatile boolean forbitAnyGet = false;

    public static void main(String[] args) {
        ConnectionPoolMgr<Integer> mgr = ConnectionPoolMgr.instance();
        if (ConnectionPoolMgr.instance() != mgr) {
            assert (false);
            return;
        }
        class DelStub
        implements DBBackCallFromConPool<Integer> {
            DelStub() {
            }

            @Override
            public boolean delCnFromPoolCB(String id, Integer i) {
                return true;
            }

            @Override
            public boolean delDBCB(String dbUrl) {
                return true;
            }

            @Override
            public boolean shutdownDB(String id, Integer cn) {
                return false;
            }
        }
        mgr.setDelConnectionBackCall(new DelStub());
        mgr.add2ConnectionPool("test", 1);
        mgr.add2ConnectionPool("test", 2);
        mgr.add2ConnectionPool("test", 3);
        Integer a = (Integer)mgr.getConnection("test");
        Integer b = (Integer)mgr.getConnection("test");
        Integer c = (Integer)mgr.getConnection("test");
        mgr.releaseConnection("test", b);
        Integer d = (Integer)mgr.getConnection("test");
        int max_con = mgr.MAX_CONNECTION;
        for (int i = 0; i < max_con * 2; ++i) {
            mgr.add2ConnectionPool("test", i);
        }
        assert (mgr.cfg2Con.get("test").size() == max_con);
        mgr.delAllConnection("test");
        Integer e = (Integer)mgr.getConnection("test");
        assert (a.equals(1));
        assert (b.equals(2));
        assert (c.equals(3));
        assert (d.equals(2));
        assert (e == null);
        for (int i = 0; i < max_con * 2; ++i) {
            mgr.add2ConnectionPool("test", i);
        }
        assert (mgr.cfg2Con.get("test") == null);
        mgr.releaseConnection("test", a);
        mgr.releaseConnection("test", c);
        mgr.releaseConnection("test", d);
        try {
            Thread.sleep(1000 * DELAY_DEL_TIMER * 2);
        }
        catch (Exception _) {
            // empty catch block
        }
        assert (mgr.deletedDBIDMap.size() == 0 && mgr.cfg2Con.size() == 0);
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable ee) {
            System.out.println("success!");
        }
    }

    public static synchronized <ConType> ConnectionPoolMgr<ConType> instance() {
        if (instance == null) {
            instance = new ConnectionPoolMgr<ConType>();
        }
        return (ConnectionPoolMgr)instance;
    }

    public synchronized int getPoolSize() {
        return this.MAX_CONNECTION;
    }

    public synchronized void setPoolSize(int sz) {
        this.MAX_CONNECTION = sz;
    }

    public synchronized int incPoolSize() {
        return ++this.MAX_CONNECTION;
    }

    public synchronized int decPoolSize() {
        return --this.MAX_CONNECTION;
    }

    public synchronized boolean isPoolFull() {
        return this.calcConNum(true) >= this.MAX_CONNECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean occupyOneSlot(boolean wait, long time) {
        boolean waited = false;
        while (true) {
            ConnectionPoolMgr connectionPoolMgr = this;
            synchronized (connectionPoolMgr) {
                if (this.calcConNum(false) < this.MAX_CONNECTION) {
                    this.decPoolSize();
                    return true;
                }
                if (waited) {
                    return false;
                }
                try {
                    this.wait(time);
                }
                catch (Exception e) {
                    // empty catch block
                }
                waited = true;
            }
        }
    }

    public synchronized void putCon2Slot(String id, ConType cn) {
        this.incPoolSize();
        if (cn != null) {
            this.add2ConnectionPool(id, cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean add2ConnectionPool(String id, ConType cn) {
        Map<String, List<ConData<ConType>>> map = this.deletedDBIDMap;
        synchronized (map) {
            if (this.deletedDBIDMap.containsKey(id)) {
                List<ConData<ConType>> cnList = this.deletedDBIDMap.get(id);
                if (cnList == null) {
                    cnList = new ArrayList<ConData<ConType>>();
                    this.deletedDBIDMap.put(id, cnList);
                }
                ConData<ConType> cd = new ConData<ConType>(cn);
                cnList.add(cd);
                this.logCn(id, cn, "add2");
                return true;
            }
        }
        if (this.isPoolFull() && !this.remove1Connection()) {
            return false;
        }
        List<ConData<ConType>> cnList = this.cfg2Con.get(id);
        if (cnList == null) {
            cnList = new ArrayList<ConData<ConType>>();
            this.cfg2Con.put(id, cnList);
        }
        cnList.add(new ConData<ConType>(cn));
        this.logCn(id, cn, "add");
        return true;
    }

    public synchronized ConType getConnection(String id) {
        if (this.forbitAnyGet) {
            return null;
        }
        List<ConData<ConType>> cdList = this.cfg2Con.get(id);
        if (cdList == null) {
            return null;
        }
        for (ConData<ConType> cd : cdList) {
            if (cd.hasFetchedOut) continue;
            cd.hasFetchedOut = true;
            this.logCn(id, cd.cn, "get");
            return cd.cn;
        }
        return null;
    }

    public synchronized void releaseConnection(String id, ConType cn) {
        List<ConData<ConType>> cdList = this.cfg2Con.get(id);
        if (cdList != null) {
            for (ConData<ConType> cd : cdList) {
                if (cd.cn != cn) continue;
                cd.hasFetchedOut = false;
                this.logCn(id, cd.cn, "rel");
                this.notify();
                return;
            }
        }
        if ((cdList = this.deletedDBIDMap.get(id)) != null) {
            for (ConData<ConType> cd : cdList) {
                if (cd.cn != cn) continue;
                cd.hasFetchedOut = false;
                this.logCn(id, cd.cn, "reld");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delAllConnection(String id) {
        List<ConData<ConType>> cnList = this.cfg2Con.remove(id);
        Map<String, List<ConData<ConType>>> map = this.deletedDBIDMap;
        synchronized (map) {
            List<ConData<ConType>> oldList = this.deletedDBIDMap.get(id);
            if (oldList != null) {
                if (cnList != null) {
                    oldList.addAll(cnList);
                }
            } else if (cnList != null) {
                this.deletedDBIDMap.put(id, cnList);
            }
            this.deletedDBIDMap.notify();
        }
    }

    public synchronized void setDelConnectionBackCall(DBBackCallFromConPool<ConType> p) {
        this.delConBackCall = p;
        this.delDBConThread.delConBackCall = p;
        if (this.delDBConThread.getState() == Thread.State.NEW) {
            this.delDBConThread.start();
        }
    }

    public void logCn(String id, ConType cn, String act) {
        this.persistLog.debug("_" + act + "_" + cn.toString() + "_" + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeAllCon() {
        while (this.randomRemove1Connection()) {
        }
        if (this.calcConNum(true) != 0) {
            return false;
        }
        Map<String, List<ConData<ConType>>> map = this.deletedDBIDMap;
        synchronized (map) {
        }
        return true;
    }

    public synchronized void halt() {
        this.forbitAnyGet = true;
    }

    public synchronized void unhalt() {
        this.forbitAnyGet = false;
    }

    public synchronized Map<String, List<ConData<ConType>>> getInfo() {
        HashMap<String, List<ConData<ConType>>> r = new HashMap<String, List<ConData<ConType>>>();
        Set<Map.Entry<String, List<ConData<ConType>>>> entrys = this.cfg2Con.entrySet();
        for (Map.Entry<String, List<ConData<ConType>>> entry : entrys) {
            ArrayList cnList = new ArrayList();
            cnList.addAll(entry.getValue());
            r.put(entry.getKey(), cnList);
        }
        r.putAll(this.cfg2Con);
        return r;
    }

    public synchronized Map<String, List<ConData<ConType>>> getDelInfo() {
        HashMap<String, List<ConData<ConType>>> r = new HashMap<String, List<ConData<ConType>>>();
        Set<Map.Entry<String, List<ConData<ConType>>>> entrys = this.deletedDBIDMap.entrySet();
        for (Map.Entry<String, List<ConData<ConType>>> entry : entrys) {
            ArrayList cnList = new ArrayList();
            if (entry.getValue() != null) {
                cnList.addAll(entry.getValue());
            }
            r.put(entry.getKey(), cnList);
        }
        r.putAll(this.deletedDBIDMap);
        return r;
    }

    public synchronized void logConPoolInfo() {
        Map<String, List<ConData<ConType>>> cfg2cnList = ConnectionPoolMgr.instance().getInfo();
        this.logger.warn("cfg\tconnect-number\tnum(used)");
        int totalFetchedOut = 0;
        Set<Map.Entry<String, List<ConData<ConType>>>> entrys = cfg2cnList.entrySet();
        for (Map.Entry<String, List<ConData<ConType>>> entry : entrys) {
            int numFetchedOut = 0;
            List<ConData<ConType>> cnList = entry.getValue();
            for (ConData<ConType> cn : cnList) {
                if (!cn.hasFetchedOut) continue;
                ++numFetchedOut;
            }
            totalFetchedOut += numFetchedOut;
            this.logger.warn(entry.getKey() + "\t" + entry.getValue().size() + "\t" + numFetchedOut);
        }
        this.logger.warn("\n");
        Map<String, List<ConData<ConType>>> delcfg2cnList = ConnectionPoolMgr.instance().getDelInfo();
        this.logger.warn("delcfg\tconnect-number\tnum(used)");
        entrys = delcfg2cnList.entrySet();
        int totalDelFetchedOut = 0;
        for (Map.Entry<String, List<ConData<ConType>>> entry : entrys) {
            int numFetchedOut = 0;
            List<ConData<ConType>> cnList = entry.getValue();
            for (ConData<ConType> cn : cnList) {
                if (!cn.hasFetchedOut) continue;
                ++numFetchedOut;
            }
            totalDelFetchedOut += numFetchedOut;
            this.logger.warn(entry.getKey() + "\t" + entry.getValue().size() + "\t" + numFetchedOut);
        }
        this.logger.warn("\n");
        this.logger.warn("summary:");
        this.logger.warn("\tpool: allcn-NUM(" + cfg2cnList.size() + ")\tused(" + totalFetchedOut + ")");
        this.logger.warn("\tdelpool: allcn-NUM(" + delcfg2cnList.size() + ")\tused(" + totalDelFetchedOut + ")");
        Thread.State s = ConnectionPoolMgr.instance().getDelThreadState();
        String warnMsg = "The persist delthread of connection pool is <" + (Object)((Object)s) + ">";
        this.logger.warn(warnMsg);
        System.out.println(warnMsg);
    }

    public synchronized Thread.State getDelThreadState() {
        return this.delDBConThread.getState();
    }

    private boolean remove1Connection() {
        return this.randomRemove1Connection();
    }

    private boolean randomRemove1Connection() {
        Set<String> cfgs = this.cfg2Con.keySet();
        Object[] keys = cfgs.toArray();
        int keys_size = keys.length;
        int idx = Math.abs(this.random.nextInt());
        int checkedNum = 0;
        while (checkedNum++ < keys_size) {
            List<ConData<ConType>> cnList = this.cfg2Con.get(keys[idx %= keys_size]);
            Iterator<ConData<ConType>> itr = cnList.iterator();
            while (itr.hasNext()) {
                boolean isLastCon;
                ConData<ConType> cd = itr.next();
                if (cd.hasFetchedOut) continue;
                itr.remove();
                boolean bl = isLastCon = cnList.size() == 0;
                if (isLastCon) {
                    this.cfg2Con.remove(keys[idx]);
                }
                this.logCn(keys[idx].toString(), cd.cn, "close");
                class RDRM
                extends Thread {
                    final String id;
                    final ConType cn;
                    final DBBackCallFromConPool<ConType> delConBackCall;

                    RDRM(String id, ConType cn, DBBackCallFromConPool<ConType> delConBackCall) {
                        this.cn = cn;
                        this.delConBackCall = delConBackCall;
                        this.id = id;
                    }

                    @Override
                    public void run() {
                        this.setName("Persist_RDRM_cn_" + System.currentTimeMillis());
                        boolean r = false;
                        int times = 30;
                        while (!(r = this.delConBackCall.delCnFromPoolCB(this.id, this.cn))) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (--times > 0) continue;
                        }
                        if (!r) {
                            String errMsg = this.getName() + " process failed!!! cn=" + this.cn;
                            ConnectionPoolMgr.this.logger.error(errMsg);
                            System.err.println(errMsg);
                        }
                    }
                }
                new RDRM(keys[idx].toString(), cd.cn, this.delConBackCall).start();
                return true;
            }
            ++idx;
        }
        this.logger.debug("random remove 1 connection failed! size=" + keys_size);
        return false;
    }

    private int calcConNum(boolean allOrGet) {
        int total = 0;
        Iterator<List<ConData<ConType>>> itr = this.cfg2Con.values().iterator();
        if (!allOrGet) {
            while (itr.hasNext()) {
                List<ConData<ConType>> cnList = itr.next();
                for (ConData<ConType> cn : cnList) {
                    if (!cn.hasFetchedOut) continue;
                    ++total;
                }
            }
        } else {
            while (itr.hasNext()) {
                List<ConData<ConType>> cnList = itr.next();
                total += cnList.size();
            }
        }
        return total;
    }

    private ConnectionPoolMgr() {
    }

    private static class DelayDelDBConnectionThread<ConType>
    extends Thread {
        public Map<String, List<ConData<ConType>>> deletedDBIDList;
        public DBBackCallFromConPool<ConType> delConBackCall;

        public DelayDelDBConnectionThread(Map<String, List<ConData<ConType>>> deletedDBIDList) {
            this.setName("Persist_DelayDelDBConn");
            this.deletedDBIDList = deletedDBIDList;
            this.setDaemon(true);
        }

        private Map<String, List<ConData<ConType>>> getOne() {
            Set<Map.Entry<String, List<ConData<ConType>>>> entrys = this.deletedDBIDList.entrySet();
            Iterator<Map.Entry<String, List<ConData<ConType>>>> i$ = entrys.iterator();
            if (i$.hasNext()) {
                Map.Entry<String, List<ConData<ConType>>> entry = i$.next();
                List<ConData<ConType>> cnList = entry.getValue();
                entry.setValue(new ArrayList());
                HashMap<String, List<ConData<ConType>>> r = new HashMap<String, List<ConData<ConType>>>();
                r.put(entry.getKey(), cnList);
                return r;
            }
            return null;
        }

        private void appendOne(Map.Entry<String, List<ConData<ConType>>> entry) {
            List<ConData<ConType>> cnList = this.deletedDBIDList.get(entry.getKey());
            if (cnList == null) {
                cnList = new ArrayList<ConData<ConType>>();
                this.deletedDBIDList.put(entry.getKey(), cnList);
            }
            if (entry.getValue() != null) {
                cnList.addAll((Collection)entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int entryNum = 0;
                Map<String, List<ConData<ConType>>> map = this.deletedDBIDList;
                synchronized (map) {
                    entryNum = this.deletedDBIDList.size();
                }
                for (int trys = 0; trys < entryNum; ++trys) {
                    Map.Entry<String, List<ConData<ConType>>> entry;
                    Map<String, List<ConData<ConType>>> map2 = this.deletedDBIDList;
                    synchronized (map2) {
                        if (this.deletedDBIDList.size() == 0) {
                            try {
                                this.deletedDBIDList.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                        Map<String, List<ConData<ConType>>> one = this.getOne();
                        entry = one.entrySet().iterator().next();
                    }
                    ArrayList<ConData<ConType>> fetchedOutCdList = new ArrayList<ConData<ConType>>();
                    ArrayList<ConData<ConType>> freeCdList = new ArrayList<ConData<ConType>>();
                    String id = entry.getKey();
                    List<ConData<ConType>> cdList = entry.getValue();
                    if (cdList != null) {
                        for (ConData<ConType> cd : cdList) {
                            if (cd.hasFetchedOut) {
                                fetchedOutCdList.add(cd);
                                continue;
                            }
                            freeCdList.add(cd);
                        }
                    }
                    int numCon = freeCdList.size();
                    for (int i = 0; i < numCon; ++i) {
                        ConData cd = (ConData)freeCdList.get(i);
                        ConnectionPoolMgr.instance().logCn(id, cd.cn, "del");
                        ConnectionPoolMgr.instance().delConBackCall.delCnFromPoolCB(id, cd.cn);
                    }
                    if (fetchedOutCdList.size() == 0) {
                        if (!this.delConBackCall.delDBCB(id)) continue;
                        Map<String, List<ConData<ConType>>> map3 = this.deletedDBIDList;
                        synchronized (map3) {
                            this.deletedDBIDList.remove(id);
                            continue;
                        }
                    }
                    entry.setValue(fetchedOutCdList);
                    Map<String, List<ConData<ConType>>> map4 = this.deletedDBIDList;
                    synchronized (map4) {
                        this.appendOne(entry);
                        continue;
                    }
                }
                try {
                    Thread.sleep(1000 * DELAY_DEL_TIMER);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public static class ConData<ConType> {
        public volatile ConType cn;
        public volatile boolean hasFetchedOut = false;

        public ConData(ConType cn) {
            this.cn = cn;
        }
    }

    public static interface DBBackCallFromConPool<ConType> {
        public boolean delCnFromPoolCB(String var1, ConType var2);

        public boolean delDBCB(String var1);

        public boolean shutdownDB(String var1, ConType var2);
    }
}

