/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.domain;

import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableDesc {
    private List<String> cols = new ArrayList<String>();
    private List<ColType> colTypes = new ArrayList<ColType>();
    private List<Constrain> conss = new ArrayList<Constrain>();
    private String name;

    public static void main(String[] args) throws Exception {
        PolicyQuery plq = Activator.svcFactory.getPolicyQueryService();
        TableDesc tb = new TableDesc();
        ArrayList<String> tbCols = new ArrayList<String>();
        ArrayList<ColType> tbColTypes = new ArrayList<ColType>();
        tb.setName(plq.xpath2TbNamePrefix("/a/b/c/"));
        tbCols.add(plq.relXpath2ColName("../pKey"));
        tbColTypes.add(ColType.genINT32());
        tbCols.add(plq.relXpath2ColName("attr1"));
        tbColTypes.add(ColType.genINT32());
        tbCols.add(plq.relXpath2ColName("attr2"));
        tbColTypes.add(ColType.genINT32());
        tbCols.add(plq.relXpath2ColName("key"));
        tbColTypes.add(ColType.genINT32());
        tb.addCols(tbCols, tbColTypes);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(plq.relXpath2ColName("../pKey"));
        keys.add(plq.relXpath2ColName("key"));
        tb.addKey(keys);
        String pKey = tb.getColNameByAbsXpath("/a/b/pKey");
        assert (pKey.equals(plq.relXpath2ColName("../pKey")));
        assert (tb.getKeysAbsXpath().get(0).equals("/a/b/pKey"));
        assert (tb.getKeysAbsXpath().get(1).equals("/a/b/c/key"));
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable e) {
            System.out.println("success!");
        }
    }

    public static String getRelXpathOfParentObj(String relXpath, String objXpath) {
        String relStr = "../";
        int idx = relXpath.lastIndexOf("../") + "../".length();
        return relXpath.substring(idx);
    }

    public static String getParentObj(String relXpath, String objXpath) {
        int lastNotNull;
        int dotDotNum = 0;
        String[] splitRelXpath = relXpath.split("/");
        int i = 0;
        while (i < splitRelXpath.length) {
            if (!splitRelXpath[i].equals("..")) {
                // empty if block
            }
            ++i;
            ++dotDotNum;
        }
        String[] splitObjXpath = objXpath.split("/");
        for (lastNotNull = splitObjXpath.length - 1; lastNotNull >= 0 && dotDotNum > 0; --lastNotNull) {
            if (splitObjXpath[lastNotNull].equals("")) continue;
            --dotDotNum;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        for (int i2 = 0; i2 <= lastNotNull; ++i2) {
            if (splitObjXpath[i2].equals("")) continue;
            sb.append(splitObjXpath[i2]);
            sb.append('/');
        }
        return sb.toString();
    }

    public static String getRelXpathFromAbsXpath(String absXpath, String objXpath) {
        int i;
        if (absXpath.startsWith(objXpath)) {
            return absXpath.substring(objXpath.length());
        }
        String[] splitAbsS = absXpath.split("/");
        String[] splitObjS = objXpath.split("/");
        for (int idx = 0; idx < splitAbsS.length && idx < splitObjS.length && splitAbsS[idx].equals(splitObjS[idx]); ++idx) {
        }
        StringBuilder sb = new StringBuilder(30);
        for (i = idx; i < splitObjS.length; ++i) {
            if (splitObjS[i].equals("")) continue;
            sb.append("../");
        }
        for (i = idx; i < splitAbsS.length; ++i) {
            if (splitAbsS[i].equals("")) continue;
            sb.append(splitAbsS[i]);
            sb.append('/');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String getAbsXpathFromRelXpath(String relXpath, String objXpath) {
        int i;
        int lastNotNull;
        String[] splitRelS = relXpath.split("/");
        int dotDotNum = 0;
        int firstNotDot = 0;
        while (firstNotDot < splitRelS.length && splitRelS[firstNotDot].equals("..")) {
            ++firstNotDot;
            ++dotDotNum;
        }
        StringBuilder sb = new StringBuilder();
        String[] splitObjS = objXpath.split("/");
        for (lastNotNull = splitObjS.length - 1; lastNotNull >= 0 && dotDotNum > 0; --lastNotNull) {
            if (splitObjS[lastNotNull].equals("")) continue;
            --dotDotNum;
        }
        sb.append('/');
        for (i = 0; i <= lastNotNull; ++i) {
            if (splitObjS[i].equals("")) continue;
            sb.append(splitObjS[i]);
            sb.append('/');
        }
        for (i = firstNotDot; i < splitRelS.length; ++i) {
            if (splitRelS[i].equals("")) continue;
            sb.append(splitRelS[i]);
            sb.append('/');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void addKey(List<String> cols) throws PersistenceException {
        this.conss.clear();
        Map<String, String> t = this.lst2Map(this.cols);
        Constrain constrain = new Constrain(Constrain.Type.KEY);
        for (String k : cols) {
            if (!t.containsKey(k)) {
                throw new PersistenceException("key is not all in cols. key=" + k);
            }
            constrain.cols.add(k);
        }
        this.conss.add(constrain);
    }

    public void addCols(List<String> cols, List<ColType> colTypes) throws PersistenceException {
        if (cols.size() != colTypes.size()) {
            throw new PersistenceException("col.size != colsTypes.size");
        }
        HashMap<String, String> t = new HashMap<String, String>();
        for (String c : this.cols) {
            t.put(c, "");
        }
        int len = cols.size();
        for (int idx = 0; idx < len; ++idx) {
            String c = cols.get(idx);
            ColType ct = colTypes.get(idx);
            if (t.containsKey(cols.get(idx))) {
                throw new PersistenceException("col [" + c + "] dunpliment");
            }
            this.cols.add(c);
            this.colTypes.add(ct);
            t.put(c, "");
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isContainCols(List<String> cols) {
        HashMap t = new HashMap();
        for (String c : cols) {
            if (t.containsKey(c)) continue;
            return false;
        }
        return true;
    }

    public List<String> getAllCols() {
        ArrayList<String> r = new ArrayList<String>();
        for (String c : this.cols) {
            r.add(c);
        }
        return r;
    }

    public String getColNameByAbsXpath(String absXpath) {
        PolicyQuery ply = Activator.svcFactory.getPolicyQueryService();
        String objXpath = this.getObjXpath();
        String relXpath = TableDesc.getRelXpathFromAbsXpath(absXpath, objXpath);
        String colName = ply.relXpath2ColName(relXpath);
        for (String col : this.cols) {
            if (!col.equals(colName)) continue;
            return col;
        }
        return null;
    }

    public String getColName(int idx) {
        return this.cols.get(idx);
    }

    public ColType getColType(int idx) {
        return this.colTypes.get(idx);
    }

    public Map<String, ColType> getColInfos() {
        HashMap<String, ColType> r = new HashMap<String, ColType>();
        int num = this.cols.size();
        for (int idx = 0; idx < num; ++idx) {
            r.put(this.cols.get(idx), (ColType)this.colTypes.get(idx).clone());
        }
        return r;
    }

    public List<Constrain> getAllConstrains() {
        ArrayList<Constrain> r = new ArrayList<Constrain>();
        for (Constrain cons : this.conss) {
            r.add(cons);
        }
        return r;
    }

    public String getName() {
        return this.name;
    }

    public String getObjXpath() {
        PolicyQuery ply = Activator.svcFactory.getPolicyQueryService();
        return ply.tbName2Xpath(this.name);
    }

    public List<String> getKeys() {
        return this.getKeys(false);
    }

    public List<String> getKeysAbsXpath() {
        return this.getKeys(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("[tableName=");
        sb.append(this.name);
        sb.append(",cols(");
        int colNum = this.cols.size();
        for (int idx = 0; idx < colNum; ++idx) {
            sb.append(this.cols.get(idx));
            sb.append("=");
            sb.append(this.colTypes.get(idx));
            sb.append(",");
        }
        sb.append("),Constrains(");
        for (Constrain cons : this.conss) {
            sb.append(cons);
            sb.append(",");
        }
        sb.append(")]");
        return sb.toString();
    }

    private Map<String, String> lst2Map(List<String> lst) {
        HashMap<String, String> r = new HashMap<String, String>();
        for (String c : lst) {
            r.put(c, "");
        }
        return r;
    }

    private List<String> getKeys(boolean wantAbsXpath) {
        PolicyQuery ply = Activator.svcFactory.getPolicyQueryService();
        Constrain keyConstrain = null;
        for (Constrain cons : this.conss) {
            if (cons.t != Constrain.Type.KEY) continue;
            keyConstrain = cons;
            break;
        }
        if (keyConstrain == null || keyConstrain.cols.size() == 0) {
            return null;
        }
        ArrayList<String> r = new ArrayList<String>();
        for (String key : keyConstrain.cols) {
            if (wantAbsXpath) {
                String relXpathOfKey = ply.colName2RelXpath(key);
                String objXpath = this.getObjXpath();
                String absKey = TableDesc.getAbsXpathFromRelXpath(relXpathOfKey, objXpath);
                r.add(absKey);
                continue;
            }
            r.add(key);
        }
        return r;
    }

    public static final class ColType
    implements Cloneable {
        public TYPE type;
        public int len;

        public static ColType genINT32() {
            ColType ct = new ColType();
            ct.type = TYPE.INT32;
            return ct;
        }

        public static ColType genSTR(int len) {
            ColType ct = new ColType();
            ct.type = TYPE.STR;
            ct.len = len;
            return ct;
        }

        public static ColType genVARSTR(int len) {
            ColType ct = new ColType();
            ct.type = TYPE.VARSTR;
            ct.len = len;
            return ct;
        }

        private ColType() {
        }

        private ColType(TYPE type, int len) {
            this.type = type;
            this.len = len;
        }

        public Object clone() {
            return new ColType(this.type, this.len);
        }

        public String toString() {
            return "[" + (Object)((Object)this.type) + "," + this.len + "]";
        }

        public static enum TYPE {
            INT32,
            STR,
            VARSTR;

        }
    }

    public static class Constrain {
        public Type t;
        public List<String> cols = new ArrayList<String>();

        public Constrain(Type t) {
            this.t = t;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append((Object)this.t);
            sb.append(",(");
            for (String col : this.cols) {
                sb.append(col);
                sb.append(",");
            }
            sb.append(")]");
            return sb.toString();
        }

        public static enum Type {
            KEY;

        }
    }
}

