/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.domain;

import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class QueryCondition {
    private List<String> selCols;
    private int pageSize = 50;

    public QueryCondition(List<String> cols) throws PersistenceException {
        this.construct(cols);
    }

    public QueryCondition(List<String> cols, int pageSize) throws PersistenceException {
        this.construct(cols);
        this.pageSize = pageSize;
    }

    public QueryCondition() {
    }

    public QueryCondition(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<String> getSelCols() {
        if (this.selCols == null) {
            return null;
        }
        ArrayList<String> r = new ArrayList<String>();
        for (String c : this.selCols) {
            r.add(c);
        }
        return r;
    }

    public List<String> resetSelCols(List<String> cols) {
        List<String> old = this.selCols;
        this.selCols = cols;
        return old;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("pageSize=");
        sb.append(this.pageSize);
        sb.append(",selectCols[");
        for (String c : this.selCols) {
            sb.append(c);
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    private void construct(List<String> cols) throws PersistenceException {
        if (cols.size() == 0) {
            throw new PersistenceException("query condition has no selCols");
        }
        this.selCols = new ArrayList<String>();
        HashMap t = new HashMap();
        for (String c : cols) {
            if (!t.containsKey(c)) {
                throw new PersistenceException("dunplement selCol [" + c + "]");
            }
            this.selCols.add(c);
        }
    }
}

