/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.domain;

import com.huawei.vmf.qat.persistence.service.DevChange;
import java.util.ArrayList;
import java.util.List;

public final class DevConfig
implements Cloneable {
    private final List<ConfigId> cfgIds = new ArrayList<ConfigId>();
    private DevChange.DevIdentify devIdentify;

    public DevConfig(DevChange.DevIdentify devInent) {
        this.devIdentify = new DevChange.DevIdentify(devInent);
    }

    public static DevConfig newVRConfig(DevChange.DevIdentify devInent, int vrId) {
        DevConfig cfg = new DevConfig(devInent);
        cfg.cfgIds.add(new ConfigId("vr", "" + vrId));
        return cfg;
    }

    public Object clone() {
        DevConfig r = new DevConfig(this.devIdentify);
        for (ConfigId cfgId : this.cfgIds) {
            r.cfgIds.add(new ConfigId(cfgId.name, cfgId.v));
        }
        r.devIdentify = new DevChange.DevIdentify(this.devIdentify.getIp(), this.devIdentify.getDevID());
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DevConfig)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public String getCfgIdxValue(String id) {
        for (ConfigId cfgId : this.cfgIds) {
            if (!cfgId.name.equals(id)) continue;
            return cfgId.v;
        }
        return "";
    }

    public DevChange.DevIdentify getIdentify() {
        return this.devIdentify;
    }

    public int getVRId() {
        return Integer.parseInt(this.getCfgIdxValue("vr"));
    }

    public int hashCode() {
        return this.devIdentify.getIp().hashCode() + this.devIdentify.getDevID();
    }

    public String toString() {
        StringBuffer r = new StringBuffer(100);
        r.append(this.devIdentify.toString());
        for (ConfigId ci : this.cfgIds) {
            r.append("," + ci.name + "=" + ci.v);
        }
        return r.toString();
    }

    public static class ConfigId {
        public String name;
        public String v;

        public ConfigId(String name, String v) {
            this.name = name;
            this.v = v;
        }
    }
}

