/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.devmgr;

import com.huawei.vmf.common.pnp.constants.PnpConstants;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public final class PolicyMgr {
    public static String FTP_PARAMETERS = PnpConstants.FTP_PARAMETERS;
    public static String PNP_DIR = PnpConstants.PNP_DIR;
    private static String CACHED_DIR = "default" + File.separator + "cached";
    private static PolicyMgr inst;
    private Logger logger = RunLogger.getRunLogger();
    private Map<PolicyQuery.DTV, DevPolicy> policies = new HashMap<PolicyQuery.DTV, DevPolicy>();

    private PolicyMgr() {
        this.cacheDTVPolicyFromPNPP();
        this.cacheDTVPolicyFromNM();
    }

    public static synchronized PolicyMgr instance() {
        if (inst != null) {
            return inst;
        }
        inst = new PolicyMgr();
        return inst;
    }

    public static void main(String[] args) throws Exception {
        PNP_DIR = ".\\testdir\\pnpp";
        PolicyMgr pm = PolicyMgr.instance();
        pm.refreshPolicy();
        DevMgr.instance().initDev(new ArrayList<DevChange.DevInfo>());
        assert (pm.policies.size() == 2);
        PolicyQuery.DTV dtv = new PolicyQuery.DTV("NE5000E", "V800R003C00SPC300");
        assert (pm.getPolicy(dtv) != null);
        ObjPolicy op = pm.getPolicy((PolicyQuery.DTV)dtv).xpath2Policy.get("/ifm/interfaces/interface/");
        assert (op.keys.size() == 1);
        assert (op.cfgAttrs.size() == 3);
        ObjPolicy op2 = pm.getPolicy((PolicyQuery.DTV)dtv).xpath2Policy.get("/ifm/interfaces2/interface/");
        assert (op2.keys.size() == 1);
        assert (op2.cfgAttrs.size() == 3);
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable e) {
            System.out.println("success!");
        }
        pm.cacheDTVPolicyFromPNPP(dtv);
    }

    public synchronized void cacheDTVPolicy(PolicyQuery.DTV dtv) {
        if (this.policies.get(dtv) != null) {
            return;
        }
        this.cacheDTVPolicyFromPNPP(dtv);
        this.cacheDTVPolicyFromNM(dtv);
    }

    public synchronized void cacheDTVPolicyFromNM() {
    }

    public synchronized void cacheDTVPolicyFromPNPP() {
        ArrayList<PolicyQuery.DTV> dtvs = new ArrayList<PolicyQuery.DTV>();
        File pnpDir = new File(PNP_DIR);
        File[] neTypeDirs = pnpDir.listFiles();
        if (neTypeDirs == null) {
            return;
        }
        for (File neTypeDir : neTypeDirs) {
            File[] neVerDirs = neTypeDir.listFiles();
            if (neVerDirs == null) continue;
            for (File neVerDir : neVerDirs) {
                PolicyQuery.DTV dtv = new PolicyQuery.DTV(neTypeDir.getName(), neVerDir.getName());
                dtvs.add(dtv);
            }
        }
        for (PolicyQuery.DTV dtv : dtvs) {
            this.cacheDTVPolicyFromPNPP(dtv);
        }
    }

    public synchronized DevPolicy getPolicy(PolicyQuery.DTV dtv) {
        return this.policies.get(dtv);
    }

    public synchronized void refreshPolicy() {
        this.policies.clear();
        this.cacheDTVPolicyFromPNPP();
        this.cacheDTVPolicyFromNM();
    }

    public synchronized Map<PolicyQuery.DTV, DevPolicy> getPolicy() {
        HashMap<PolicyQuery.DTV, DevPolicy> r = new HashMap<PolicyQuery.DTV, DevPolicy>();
        r.putAll(this.policies);
        return r;
    }

    private void cacheDTVPolicyFromFile(PolicyQuery.DTV dtv, String fn) {
        Document doc;
        try {
            SAXReader r = new SAXReader();
            doc = r.read(fn);
        }
        catch (Exception e) {
            this.logger.error("read policy file failed! " + fn, (Throwable)e);
            return;
        }
        String objNodeXpath = "/cached/objects/object";
        List objNodes = doc.selectNodes(objNodeXpath);
        for (Node objNode : objNodes) {
            ArrayList<String> cfgAttrs = new ArrayList<String>();
            ArrayList<String> cfgAttrTypes = new ArrayList<String>();
            ArrayList<String> props = new ArrayList<String>();
            ArrayList<String> propTypes = new ArrayList<String>();
            String objXpath = ((Element)objNode).elementText("xpath");
            if (!objXpath.endsWith("/")) {
                objXpath = objXpath + "/";
            }
            List attrNodes = objNode.selectNodes("./cfgAttrs/cfgAttr");
            for (Node attrNode : attrNodes) {
                String attrXpath = ((Element)attrNode).elementText("xpath");
                String attrType = ((Element)attrNode).elementText("type");
                cfgAttrs.add(attrXpath);
                cfgAttrTypes.add(attrType);
                List propNodes = attrNode.selectNodes("./props/prop");
                if (null == propNodes || propNodes.size() <= 0) continue;
                for (Node propNode : propNodes) {
                    String propName = ((Element)propNode).elementText("name");
                    String propType = ((Element)propNode).elementText("type");
                    String propStr = ObjPolicy.constructProp(attrXpath, propName);
                    props.add(propStr);
                    propTypes.add(propType);
                }
            }
            List keyNodes = objNode.selectNodes("./keys/key");
            ArrayList<String> keys = new ArrayList<String>();
            for (Node keyNode : keyNodes) {
                String keyXpath = ((Element)keyNode).getTextTrim();
                keys.add(keyXpath);
            }
            try {
                DevPolicy dp = this.policies.get(dtv);
                if (dp == null) {
                    dp = new DevPolicy();
                    this.policies.put(dtv, dp);
                }
                ObjPolicy objpl = new ObjPolicy(objXpath, cfgAttrs, cfgAttrTypes, props, propTypes, keys);
                dp.xpath2Policy.put(objXpath, objpl);
                this.policies.put(dtv, dp);
            }
            catch (Exception e) {
                this.logger.debug("add policy error :" + e);
            }
        }
    }

    private void cacheDTVPolicyFromNM(PolicyQuery.DTV dtv) {
    }

    private void cacheDTVPolicyFromPNPP(PolicyQuery.DTV dtv) {
        String cachedFileDir = PNP_DIR + File.separator + dtv.type + File.separator + dtv.ver + File.separator + CACHED_DIR;
        File file = new File(cachedFileDir);
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) continue;
            this.cacheDTVPolicyFromFile(dtv, f.getPath());
        }
    }

    public static class ObjPolicy {
        public static final String PROPERTY_SPLITSTR = "]";
        public final List<String> cfgAttrs;
        public final List<String> cfgAttrTypes;
        public final List<String> props;
        public final List<String> propTypes;
        public final List<String> keys;
        public final String xpath;

        public static String getPropName(String propStr) {
            String[] split = propStr.split(PROPERTY_SPLITSTR);
            if (split == null || split.length < 2) {
                return null;
            }
            return split[1];
        }

        public static String getPropXpath(String propStr) {
            return propStr.split(PROPERTY_SPLITSTR)[0];
        }

        public static String constructProp(String xpath, String propName) {
            return xpath + PROPERTY_SPLITSTR + propName;
        }

        public ObjPolicy(String xpath, List<String> cfgAttrs, List<String> cfgAttrTypes, List<String> props, List<String> propTypes, List<String> keys) throws PersistenceException {
            this.xpath = xpath;
            if (cfgAttrs.size() == 0 && props.size() == 0) {
                throw new PersistenceException("Policy(xpath=" + xpath + ") with no cfgAttr");
            }
            this.cfgAttrs = cfgAttrs;
            this.cfgAttrTypes = cfgAttrTypes;
            this.props = props;
            this.propTypes = propTypes;
            this.keys = keys;
        }
    }

    public static class DevPolicy {
        public Map<String, ObjPolicy> xpath2Policy = new HashMap<String, ObjPolicy>();
    }
}

