/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.devmgr;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.debug.TimeRecStack;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.domain.PersistenceException;
import com.huawei.vmf.qat.persistence.domain.TableDesc;
import com.huawei.vmf.qat.persistence.service.DBCommonOper;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.impl.DBCommonOper1Cfg1DB;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import com.huawei.vmf.qat.persistence.syncdata.alone.Stub;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class DevMgr {
    private static DevMgr inst;
    private Map<DevChange.DevIdentify, DevChange.DevInfo> identify2info = new HashMap<DevChange.DevIdentify, DevChange.DevInfo>();
    private volatile boolean isInited = false;
    private Logger logger = RunLogger.getRunLogger();
    private PolicyQuery policyQry = Activator.svcFactory.getPolicyQueryService();

    public static synchronized DevMgr instance() {
        if (inst != null) {
            return inst;
        }
        inst = new DevMgr();
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDev(DevChange.DevInfo dev) throws PersistenceException {
        TimeRecStack rc = TimeRecStack.getCurThreadRc();
        String rc_start_id = rc.start("DevMgr.addDev");
        try {
            if ("independent".equals(System.getProperty("deploymentMode"))) {
                while (!this.isInited) {
                    try {
                        Thread.sleep(1000L);
                        this.logger.debug("wait for DevMgr inited!");
                    }
                    catch (Exception e) {}
                }
            }
            DevMgr devMgr = this;
            synchronized (devMgr) {
                block12: {
                    rc.start("check-identify");
                    if (!this.identify2info.containsKey(dev.devIdentify)) break block12;
                    this.logger.debug("add dumplement device! new=" + dev + ",old=" + this.identify2info.get(dev.devIdentify));
                    rc.stop();
                    return;
                }
                rc.stop();
                rc.start("cache-policy");
                PolicyMgr.instance().cacheDTVPolicy(new PolicyQuery.DTV(dev.neType, dev.ver));
                this.identify2info.put(dev.devIdentify, new DevChange.DevInfo(dev));
                rc.stop();
                rc.start("put-to-sub");
                Stub.instance().addDev(dev);
                rc.stop();
            }
        }
        finally {
            rc.stop2id(rc_start_id);
        }
    }

    public synchronized void delDev(DevChange.DevInfo dev) throws PersistenceException {
        Stub.instance().delDev(dev);
        DBCommonOper1Cfg1DB db = new DBCommonOper1Cfg1DB();
        db.useLastDBUrl(false);
        this.identify2info.remove(dev.devIdentify);
        db.delCfg(DevConfig.newVRConfig(dev.devIdentify, 0));
    }

    public synchronized void forceSyncAllDev(DevChange.DevInfo dev) throws PersistenceException {
        Stub.instance().forceSyncAll(dev);
    }

    public synchronized void forceIncrSyncDev(DevChange.DevInfo dev) throws PersistenceException {
        Stub.instance().forceIncrSync(dev);
    }

    public synchronized List<DevConfig> getPersistDevCfg(DevChange.DevIdentify devId) {
        List<DevConfig> ret = new ArrayList<DevConfig>();
        DevChange.DevInfo dev = this.identify2info.get(devId);
        if (dev == null && (devId.getDevID() == 0 || devId.getIp().equals(""))) {
            dev = this.getDevByIPORDevID(devId);
        }
        if (null != dev) {
            ret = this.constructCfgsFromDev(dev);
        }
        return ret;
    }

    public synchronized DevChange.DevInfo getDevByIPORDevID(DevChange.DevIdentify devId) {
        if (devId.getDevID() == 0 && devId.getIp().equals("")) {
            return null;
        }
        Set<Map.Entry<DevChange.DevIdentify, DevChange.DevInfo>> entrys = this.identify2info.entrySet();
        for (Map.Entry<DevChange.DevIdentify, DevChange.DevInfo> entry : entrys) {
            DevChange.DevIdentify k = entry.getKey();
            if ((devId.getIp().equals("") || !k.getIp().equals(devId.getIp())) && (devId.getDevID() == 0 || k.getDevID() != devId.getDevID())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean isPersistDevCfg(DevConfig cfg) {
        return cfg.getVRId() == 0;
    }

    public synchronized PolicyQuery.DTV getDTVByIdentify(DevChange.DevIdentify devIdentify) {
        DevChange.DevInfo dev = this.identify2info.get(devIdentify);
        if (dev == null && (devIdentify.getDevID() == 0 || devIdentify.getIp().equals(""))) {
            dev = this.getDevByIPORDevID(devIdentify);
        }
        if (dev == null) {
            return null;
        }
        return new PolicyQuery.DTV(dev.neType, dev.ver);
    }

    public synchronized void initDev(List<DevChange.DevInfo> devs) throws PersistenceException {
        HashMap<DevChange.DevIdentify, DevChange.DevInfo> identify2InfoNew = new HashMap<DevChange.DevIdentify, DevChange.DevInfo>();
        for (DevChange.DevInfo d : devs) {
            if (!this.identify2info.containsKey(d.devIdentify)) {
                PolicyMgr.instance().cacheDTVPolicy(new PolicyQuery.DTV(d.neType, d.ver));
                Stub.instance().addDev(d);
                if (!"independent".equals(System.getProperty("deploymentMode"))) {
                    AloneDeploySchedule.addDevToDevMap(d, -1, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK);
                }
            }
            identify2InfoNew.put(d.devIdentify, new DevChange.DevInfo(d));
        }
        for (DevChange.DevIdentify devIdentify : this.identify2info.keySet()) {
            if (identify2InfoNew.containsKey(devIdentify)) continue;
            this.delAllCfg(this.identify2info.get(devIdentify));
            DevChange.DevInfo dev = this.identify2info.get(devIdentify);
            Stub.instance().delDev(dev);
        }
        this.identify2info = identify2InfoNew;
        this.isInited = true;
    }

    public synchronized void verChg(DevChange.DevInfo dev) throws PersistenceException {
        this.delDev(dev);
        this.addDev(dev);
    }

    public synchronized List<DevChange.DevInfo> getAllDev() {
        ArrayList<DevChange.DevInfo> ret = new ArrayList<DevChange.DevInfo>();
        Set<Map.Entry<DevChange.DevIdentify, DevChange.DevInfo>> entrys = this.identify2info.entrySet();
        for (Map.Entry<DevChange.DevIdentify, DevChange.DevInfo> entry : entrys) {
            ret.add(entry.getValue());
        }
        return ret;
    }

    public synchronized void addCfgTbs(PolicyQuery.DTV dtv, DevConfig cfg, DBCommonOper db) throws PersistenceException {
        List<TableDesc> tbs = this.policyQry.getTableDesc(dtv);
        if (tbs == null) {
            return;
        }
        db.useLastDBUrl(true);
        for (TableDesc tb : tbs) {
            db.addTB(cfg, tb);
        }
    }

    public synchronized void delAllCfg(DevChange.DevInfo dev) throws PersistenceException {
        DBCommonOper1Cfg1DB db = new DBCommonOper1Cfg1DB();
        db.useLastDBUrl(false);
        List<DevConfig> cfgList = this.getPersistDevCfg(dev.devIdentify);
        for (DevConfig cfg : cfgList) {
            db.delCfg(cfg);
        }
    }

    private DevMgr() {
    }

    private List<DevConfig> constructCfgsFromDev(DevChange.DevInfo dev) {
        ArrayList<DevConfig> ret = new ArrayList<DevConfig>();
        DevChange.DevIdentify devId = new DevChange.DevIdentify(dev.devIdentify.getIp(), dev.devIdentify.getDevID());
        DevConfig devCfg = DevConfig.newVRConfig(devId, 0);
        ret.add(devCfg);
        return ret;
    }
}

