/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.debug;

import com.huawei.vmf.qat.persistence.debug.TimeRec;
import com.huawei.vmf.qat.persistence.debug.TimeRecStackCI;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.osgi.framework.console.CommandInterpreter;

public class TimeRecStack {
    private static Map<Thread, TimeRecStack> th2Rc = new HashMap<Thread, TimeRecStack>();
    private String desc;
    private PrintStream p;
    private int startLevel;
    private Stack<TimeRec> recStack = new Stack();
    private Map<String, TimeRec> id2Rec = new HashMap<String, TimeRec>();
    private List<TimeRec> recs = new ArrayList<TimeRec>();
    private boolean isPrint = false;

    public static TimeRecStack getNullStack() {
        return new TimeRecStack("", null, 0, false);
    }

    public static TimeRecStack getCiPrintStack(CommandInterpreter ci) {
        TimeRecStackCI rc = new TimeRecStackCI(ci);
        rc.setPrint(true);
        return rc;
    }

    public static synchronized void addCurThreadRc(TimeRecStack rc) {
        th2Rc.put(Thread.currentThread(), rc);
    }

    public static synchronized void delCurThreadRc() {
        th2Rc.remove(Thread.currentThread());
    }

    public static synchronized TimeRecStack getCurThreadRc() {
        TimeRecStack rc = th2Rc.get(Thread.currentThread());
        if (rc == null) {
            rc = TimeRecStack.getNullStack();
        }
        return rc;
    }

    public TimeRecStack(String desc, PrintStream p, int startLevel) {
        this.desc = desc;
        this.p = p;
        this.startLevel = startLevel;
    }

    public TimeRecStack(String desc, PrintStream p, int startLevel, boolean isPrint) {
        this.desc = desc;
        this.p = p;
        this.startLevel = startLevel;
        this.isPrint = isPrint;
    }

    public String start(String id) {
        if (this.id2Rec.containsKey(id)) {
            id = id + "__samerdid_" + System.currentTimeMillis();
        }
        TimeRec r = new TimeRec();
        r.id = id;
        r.level = this.startLevel++;
        r.start = System.currentTimeMillis();
        this.id2Rec.put(id, r);
        this.recs.add(r);
        this.recStack.push(r);
        this.space(id);
        this.print("start record [" + id + "]\n");
        return id;
    }

    public TimeRec stop() {
        TimeRec r = null;
        try {
            r = this.recStack.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
        r.end = System.currentTimeMillis();
        this.space(r.id);
        this.print("stop  record [time=" + (r.end - r.start) + "(ms)] [" + r.id + "(" + r.info + ")]\n");
        --this.startLevel;
        return r;
    }

    public void stop2id(String id) {
        TimeRec r;
        while ((r = this.stop()) != null && !r.id.equals(id)) {
        }
    }

    public void appendInfo(String info) {
        TimeRec r = (TimeRec)this.recStack.get(this.recStack.size() - 1);
        if (r.info == null) {
            r.info = info;
            return;
        }
        r.info = r.info + ":" + info;
    }

    public void setPrint(boolean b) {
        this.isPrint = b;
    }

    public ArrayList<TimeRec> getAllRecs() {
        ArrayList<TimeRec> ret = new ArrayList<TimeRec>();
        for (TimeRec r : this.recs) {
            ret.add(r.clone());
        }
        return ret;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isPrint() {
        return this.isPrint;
    }

    protected void print(String s) {
        if (this.isPrint() && this.p != null) {
            this.p.print(s);
        }
    }

    private void space(String id) {
        int level = this.id2Rec.get((Object)id).level;
        while (level-- > 0) {
            this.print("    ");
        }
    }
}

