/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.debug;

import com.huawei.vmf.qat.persistence.debug.PerfArgs;
import com.huawei.vmf.qat.persistence.debug.TimeRec;
import com.huawei.vmf.qat.persistence.debug.TimeRecStack;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TimeRecAerage {
    private List<TimeRecStack> ss = new ArrayList<TimeRecStack>();
    private PrintStream p;

    public static void testPerf(Object o, String methodName, int times, PrintStream p, int level) {
        Class[] parameterTypes = new Class[]{TimeRecStack.class};
        Method m = null;
        try {
            m = o.getClass().getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        PerfArgs annot = m.getAnnotation(PerfArgs.class);
        if (annot != null) {
            times = annot.times();
        }
        System.err.println("\n" + o.getClass().getName() + "." + m.getName() + ": times=" + times + " begin...");
        TimeRecAerage trAvg = new TimeRecAerage(p);
        for (int i = 0; i < times; ++i) {
            TimeRecStack tr = new TimeRecStack(o.getClass().getName() + "." + methodName, p, level, false);
            trAvg.putStack(tr);
            try {
                m.invoke(o, tr);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                trAvg.ss.remove(trAvg.ss.size() - 1);
            }
        }
        trAvg.printAvg();
        p.flush();
    }

    public static void testPerf(Class<?> testClass, int times, PrintStream p, int level) {
        Method[] ms;
        Object o = null;
        try {
            o = testClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (Method m : ms = o.getClass().getMethods()) {
            String name = m.getName();
            if (!name.startsWith("test")) continue;
            TimeRecAerage.testPerf(o, name, times, p, level);
        }
    }

    public TimeRecAerage(PrintStream p) {
        this.p = p;
    }

    public void putStack(TimeRecStack s) {
        this.ss.add(s);
    }

    public void printAvg() {
        if (this.ss.size() == 0) {
            return;
        }
        List<TimeRec> avgRecs = this.getAvgRecs();
        if (avgRecs.size() == 0) {
            return;
        }
        this.space(avgRecs.get((int)0).level);
        this.p.println("TIMES(" + this.ss.get(0).getDesc() + "): " + this.ss.size());
        for (TimeRec r : avgRecs) {
            this.space(r.level);
            this.p.println("[" + r.id + "(" + r.info + ")], average time=" + (r.end - r.start) + "(ms)");
        }
    }

    private void space(int level) {
        while (level-- > 0) {
            this.p.print("    ");
        }
    }

    private List<TimeRec> getAvgRecs() {
        ArrayList<TimeRec> avgRecs = this.ss.get(0).getAllRecs();
        int totalStack = this.ss.size();
        int totalRecPerStack = avgRecs.size();
        for (int i = 1; i < totalStack; ++i) {
            ArrayList<TimeRec> oneStack = this.ss.get(i).getAllRecs();
            for (int j = 0; j < totalRecPerStack; ++j) {
                ((TimeRec)avgRecs.get((int)j)).start += ((TimeRec)oneStack.get((int)j)).start;
                ((TimeRec)avgRecs.get((int)j)).end += ((TimeRec)oneStack.get((int)j)).end;
            }
        }
        for (TimeRec r : avgRecs) {
            r.start /= (long)totalStack;
            r.end /= (long)totalStack;
        }
        return avgRecs;
    }
}

