/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence.debug;

import com.huawei.vmf.common.ftpagent.FtpInfo;
import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.datadefination.RpcErrorInfo;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.CommunicationArgumentMgr;
import com.huawei.vmf.netconf.service.IRpc;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.NetconfAbility;
import com.huawei.vmf.netconf.session.SessionPool;
import com.huawei.vmf.qat.persistence.Activator;
import com.huawei.vmf.qat.persistence.debug.TimeRecStack;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.domain.DevConfig;
import com.huawei.vmf.qat.persistence.domain.QueryCondition;
import com.huawei.vmf.qat.persistence.domain.RowData;
import com.huawei.vmf.qat.persistence.domain.TableDesc;
import com.huawei.vmf.qat.persistence.service.DBCommonOper;
import com.huawei.vmf.qat.persistence.service.DevChange;
import com.huawei.vmf.qat.persistence.service.PolicyQuery;
import com.huawei.vmf.qat.persistence.service.SyncData;
import com.huawei.vmf.qat.persistence.service.impl.ConnectionPoolMgr;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import com.huawei.vmf.qat.persistence.syncdata.alone.GetFtpSftpParam;
import com.huawei.vmf.qat.persistence.syncdata.alone.Stub;
import com.huawei.vmf.qat.persistence.syncdata.alone.SynAllDevTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.springframework.util.FileCopyUtils;

public class PersistCmd
implements CommandProvider {
    private static final String DEBUGDIR = "debug";
    List<TestThread> rtestThreadsQuery = new ArrayList<TestThread>();
    List<TestThread> rtestThreadsRcDb = new ArrayList<TestThread>();

    public PersistCmd() {
        File debugDir = new File(DEBUGDIR);
        if (!debugDir.exists()) {
            debugDir.mkdir();
        }
    }

    public void _adddev(CommandInterpreter ci) {
        try {
            this.adddev(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _adNdev(CommandInterpreter ci) {
        try {
            this.adNdev(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
        finally {
            TimeRecStack.delCurThreadRc();
        }
    }

    public void _deldev(CommandInterpreter ci) {
        try {
            this.deldev(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _deNdev(CommandInterpreter ci) {
        try {
            this.deNdev(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _fsync(CommandInterpreter ci) {
        try {
            this.fsync(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _gfsz(CommandInterpreter ci) {
        try {
            this.gfsz(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _idevs(CommandInterpreter ci) {
        try {
            this.idevs(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _isync(CommandInterpreter ci) {
        try {
            this.isync(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _pcn(CommandInterpreter ci) {
        try {
            this.pcn(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _pdev(CommandInterpreter ci) {
        try {
            this.pdev(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _pdi(CommandInterpreter ci) {
        try {
            this.pdi(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _ppl(CommandInterpreter ci) {
        try {
            this.ppl(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _ptb(CommandInterpreter ci) {
        try {
            this.ptb(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _pwd(CommandInterpreter ci) {
        try {
            this.pwd(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public synchronized void _rcdb(CommandInterpreter ci) {
        try {
            this.rcdb(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _rcNdb(CommandInterpreter ci) {
        try {
            this.rcNdb(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _rpc(CommandInterpreter ci) {
        try {
            this.rpc(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _rpl(CommandInterpreter ci) {
        try {
            this.rpl(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _sps(CommandInterpreter ci) {
        try {
            this.sps(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _stprt(CommandInterpreter ci) {
        try {
            this.stprt(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _stpsync(CommandInterpreter ci) {
        try {
            this.stpsync(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _sttrt(CommandInterpreter ci) {
        try {
            this.sttrt(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _sttsync(CommandInterpreter ci) {
        try {
            this.sttsync(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _ccs(CommandInterpreter ci) {
        try {
            this.ccs(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public void _pss(CommandInterpreter ci) {
        try {
            this.pss(ci);
        }
        catch (Throwable e) {
            ci.printStackTrace(e);
        }
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("the following are VMT persistence debug commands.\n");
        buffer.append("\tpdev - print all device\n");
        buffer.append("\tptb - print all table of <ip> <tbName>\n");
        buffer.append("\trpl - refresh persistence policy\n");
        buffer.append("\tfsync - (vmt-independency)force full-sync <ip>\n");
        buffer.append("\tisync - (vmt-independency)force inc-sync <ip>\n");
        buffer.append("\trpc - send a rpc package to <ip> and print reply\n");
        buffer.append("\tgfsz - get full sync zip from ne\n");
        buffer.append("\trcdb - reconstruct the DB of the ne.\n");
        buffer.append("\tsttrt - start random test.\n");
        buffer.append("\tstprt - stop random test.\n");
        buffer.append("\tsttsync - start sync task.\n");
        buffer.append("\tstpsync - stop sync task.\n");
        buffer.append("\tppl - print all persist policies.\n");
        buffer.append("\tidevs - remove all device.\n");
        buffer.append("\tadddev - add a device.\n");
        buffer.append("\tdeldev - del a device.\n");
        buffer.append("\tlds - load a debug commond script to execute.\n");
        buffer.append("\tadNdev - batch add some devices.\n");
        buffer.append("\tdeNdev - batch del some devices.\n");
        buffer.append("\tpcn - print the data of connection pool.\n");
        buffer.append("\tpdi - print specify device infomation.\n");
        buffer.append("\tsps - set db connection pool size.\n");
        buffer.append("\tccs - check consistence of db.\n");
        buffer.append("\tpss - persist all data to disk.\n");
        buffer.append("\n");
        return buffer.toString();
    }

    private void ccs(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        DBCommonOper db = Activator.svcFactory.getDBCommonOperService();
        long t1 = System.currentTimeMillis();
        List<DevConfig> cfgs = db.getUnConsistentCfg(false);
        long t2 = System.currentTimeMillis();
        ci.println((Object)("\tChecked " + DevMgr.instance().getAllDev().size() + " devices."));
        ci.println((Object)("\tConsumed " + (t2 - t1) / 1000L + " seconds!\n"));
        if (cfgs.size() != 0) {
            ci.println((Object)"the following are unconsistent cfg.");
            for (DevConfig cfg : cfgs) {
                ci.println((Object)("\t" + cfg + ", dbUrl=" + db.cfg2DBInfo(cfg)));
            }
            ci.println((Object)("\ttotal:" + cfgs.size()));
        } else {
            ci.println((Object)"all cfg is consistent!");
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: demo <ip>");
        } else {
            ci.println((Object)"success!");
        }
    }

    private synchronized void adddev(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        String neType = ci.nextArgument();
        String version = ci.nextArgument();
        String ip = ci.nextArgument();
        if (neType == null || version == null || ip == null) {
            wantTip = true;
        } else {
            DevChange.DevInfo dev = new DevChange.DevInfo(new DevChange.DevIdentify(ip, 0), neType, version);
            DevChange dc = Activator.svcFactory.getDevChangeService();
            dc.add(dev);
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: adddev <neType> <version> <ip>");
            ci.println((Object)"\tneType: neType of the device, ex: NE5000E");
            ci.println((Object)"\tversion: version of the device, ex: V800R005C00");
            ci.println((Object)"\t\t neType and version of the device must match with PNPP dir.");
            ci.println((Object)"\tip: the device of the ip");
        }
    }

    private synchronized void adNdev(CommandInterpreter ci) {
        boolean wantTip;
        boolean success;
        block14: {
            success = true;
            wantTip = false;
            String neType = ci.nextArgument();
            if (neType == null || neType.equals("")) {
                wantTip = true;
            } else {
                String version = ci.nextArgument();
                if (version == null || version.equals("")) {
                    wantTip = true;
                } else {
                    String prefix = ci.nextArgument();
                    if (prefix == null || prefix.equals("")) {
                        wantTip = true;
                    } else {
                        String numStr = ci.nextArgument();
                        if (numStr == null || numStr.equals("")) {
                            wantTip = true;
                        } else {
                            int num = 0;
                            try {
                                num = Integer.parseInt(numStr);
                            }
                            catch (Exception e) {
                                ci.print((Object)"<num> argument is not a number!");
                                success = false;
                                break block14;
                            }
                            for (int i = 0; i < num; ++i) {
                                DevChange.DevInfo dev = new DevChange.DevInfo(new DevChange.DevIdentify(prefix + i, 0), neType, version);
                                DevChange dc = Activator.svcFactory.getDevChangeService();
                                dc.add(dev);
                            }
                        }
                    }
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: adNdev <neType> <version> <name_prefix> <num>");
        } else {
            ci.println((Object)"success!");
        }
    }

    private synchronized void deldev(CommandInterpreter ci) {
        boolean wantTip;
        boolean success;
        block6: {
            success = true;
            wantTip = false;
            String ip = ci.nextArgument();
            try {
                int i = Integer.parseInt(ip);
                List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
                if (i >= devs.size() || i < 0) {
                    ci.println((Object)("index of " + i + " illegle!, please use 'pdev' command check first."));
                    success = false;
                    break block6;
                }
                DevChange.DevInfo dev = devs.get(i);
                ip = dev.devIdentify.getIp();
            }
            catch (Exception e) {
                // empty catch block
            }
            DevChange.DevInfo dev = DevMgr.instance().getDevByIPORDevID(new DevChange.DevIdentify(ip, 0));
            DevChange dc = Activator.svcFactory.getDevChangeService();
            dc.del(dev);
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: deldev < <ip> | <index> >");
            ci.println((Object)"\tip: the device of the ip to delete");
        } else {
            ci.println((Object)"success!");
        }
    }

    private synchronized void deNdev(CommandInterpreter ci) {
        boolean wantTip;
        boolean success;
        block7: {
            String[] range;
            success = true;
            wantTip = false;
            String rangeStr = ci.nextArgument();
            if (rangeStr != null && (range = rangeStr.split("-")).length == 2) {
                int frist = 0;
                int second = 0;
                try {
                    frist = Integer.parseInt(range[0]);
                    second = Integer.parseInt(range[1]);
                }
                catch (Exception e) {
                    success = false;
                    break block7;
                }
                List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
                DevChange dc = Activator.svcFactory.getDevChangeService();
                for (int i = frist; i < second; ++i) {
                    dc.del(devs.get(i));
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: deNdev <index-range>");
            ci.println((Object)"\tindex-range: for example 0-10, the device [0,10)will be deleted!");
        } else {
            ci.println((Object)"success!");
        }
    }

    private synchronized void fsync(CommandInterpreter ci) throws Exception {
        boolean success = true;
        boolean wantTip = false;
        String ip = ci.nextArgument();
        if (ip == null || ip.equals("")) {
            wantTip = true;
        } else {
            ci.println((Object)"unimplement!!!");
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: fsync <ip>");
        }
    }

    private synchronized void gfsz(CommandInterpreter ci) {
        String ftpDir;
        boolean wantTip;
        boolean success;
        block20: {
            success = true;
            wantTip = false;
            GetFtpSftpParam getFtp = new GetFtpSftpParam();
            FtpInfo ftpInfo = getFtp.getFtpInfo();
            ftpDir = ftpInfo.getServerVmfRootPath();
            String ip = ci.nextArgument();
            if (ip == null || ip.equals("")) {
                wantTip = true;
            } else {
                try {
                    int i = Integer.parseInt(ip);
                    List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
                    if (i >= devs.size() || i < 0) {
                        ci.println((Object)("index of " + i + " illegle!, please use 'pdev' command check first."));
                        success = false;
                        break block20;
                    }
                    ip = devs.get((int)i).devIdentify.getIp();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String to = ci.nextArgument();
                int timeout = 0;
                try {
                    timeout = Integer.parseInt(to);
                }
                catch (Exception e) {
                    ci.println((Object)"timeout argument has wrong format, please use digital!");
                    success = false;
                    break block20;
                }
                HashMap<String, String> oldFiles = new HashMap<String, String>();
                File[] files = new File(ftpDir).listFiles();
                if (files != null) {
                    for (File f : files) {
                        oldFiles.put(f.getName(), "");
                    }
                }
                DevChange.DevIdentify devId = new DevChange.DevIdentify(ip, 0);
                DevChange.DevInfo dev = DevMgr.instance().getDevByIPORDevID(devId);
                long start = System.currentTimeMillis();
                success = new SynAllDevTask().getSyncZipFromNe(dev);
                long end1 = System.currentTimeMillis();
                String fn = "";
                boolean getted = false;
                long send1 = 0L;
                long send2 = 0L;
                block7: while (timeout > 0) {
                    int INTERVAL = 50;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    timeout -= 50;
                    File[] newfiles = new File(ftpDir).listFiles();
                    if (newfiles == null) continue;
                    for (File f : newfiles) {
                        fn = f.getName();
                        if (oldFiles.get(fn) != null) continue;
                        if (fn.endsWith(".hw!")) {
                            send1 = System.currentTimeMillis();
                            continue;
                        }
                        send2 = System.currentTimeMillis();
                        getted = true;
                        continue block7;
                    }
                }
                long end2 = System.currentTimeMillis();
                ci.println((Object)(end1 - start + " ms[time from rpc send to reply received]"));
                if (getted) {
                    if (send1 == 0L) {
                        ci.println((Object)"<50 ms[time of ftp-put]");
                    } else {
                        ci.println((Object)(send2 - send1 + " ms[time of ftp-put]"));
                    }
                    ci.println((Object)(end2 - start + " ms[time from rpc send to syncZipFile received]"));
                    ci.println((Object)("getted! [" + fn + "] at " + ftpDir));
                } else {
                    ci.println((Object)"timeout!");
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"get sync full zip file from ne.");
            ci.println((Object)"USAGE: gfsz < <ip> | <index> > <timeout>");
            ci.println((Object)"\t ip is the ne you want to get from.");
            ci.println((Object)"\t index is the number returned by 'pdev' commond.");
            ci.println((Object)"\t the unit of timeout is 100ms.");
            ci.println((Object)"\t index is the number returned by 'pdev' commond.");
            ci.println((Object)"\t zip file is at the following directory :");
            ci.println((Object)("\t\t" + ftpDir));
        }
    }

    private synchronized void idevs(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        DevChange dc = Activator.svcFactory.getDevChangeService();
        dc.init(new ArrayList<DevChange.DevInfo>());
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: idevs");
        } else {
            ci.println((Object)"success!");
        }
    }

    private synchronized void isync(CommandInterpreter ci) throws Exception {
        boolean success = true;
        boolean wantTip = false;
        String ip = ci.nextArgument();
        if (ip == null || ip.equals("")) {
            wantTip = true;
        } else {
            ci.println((Object)"unimplement!!!");
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: fsync <ip>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void pcn(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        ConnectionPoolMgr connectionPoolMgr = ConnectionPoolMgr.instance();
        synchronized (connectionPoolMgr) {
            Map cfg2cnList = ConnectionPoolMgr.instance().getInfo();
            ci.println((Object)"cfg\tconnect-number\tnum(used)");
            int totalFetchedOut = 0;
            Set entrys = cfg2cnList.entrySet();
            for (Map.Entry entry : entrys) {
                int numFetchedOut = 0;
                List cnList = entry.getValue();
                for (ConnectionPoolMgr.ConData cn : cnList) {
                    if (!cn.hasFetchedOut) continue;
                    ++numFetchedOut;
                }
                totalFetchedOut += numFetchedOut;
                ci.println((Object)(entry.getKey() + "\t" + entry.getValue().size() + "\t" + numFetchedOut));
            }
            ci.println();
            Map delcfg2cnList = ConnectionPoolMgr.instance().getDelInfo();
            ci.println((Object)"delcfg\tconnect-number\tnum(used)");
            entrys = delcfg2cnList.entrySet();
            int totalDelFetchedOut = 0;
            for (Map.Entry entry : entrys) {
                int numFetchedOut = 0;
                List cnList = entry.getValue();
                for (ConnectionPoolMgr.ConData cn : cnList) {
                    if (!cn.hasFetchedOut) continue;
                    ++numFetchedOut;
                }
                totalDelFetchedOut += numFetchedOut;
                ci.println((Object)(entry.getKey() + "\t" + entry.getValue().size() + "\t" + numFetchedOut));
            }
            ci.println();
            ci.println((Object)"summary:");
            ci.println((Object)("\tpool: allcn-NUM(" + cfg2cnList.size() + ")\tused(" + totalFetchedOut + ")"));
            ci.println((Object)("\tdelpool: allcn-NUM(" + delcfg2cnList.size() + ")\tused(" + totalDelFetchedOut + ")"));
            ci.println((Object)("\ndel thread state is <" + (Object)((Object)ConnectionPoolMgr.instance().getDelThreadState()) + ">"));
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: pcn");
        }
    }

    private synchronized void pdev(CommandInterpreter ci) throws Exception {
        List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
        ci.println((Object)"index\tdev-info\tflowId");
        int num = devs.size();
        for (int i = 0; i < num; ++i) {
            Integer flowIdObj = -1;
            if (AloneDeploySchedule.mDevAll.get(devs.get(i)) != null) {
                flowIdObj = AloneDeploySchedule.mDevAll.get(devs.get(i)).getFlowID();
            }
            ci.println((Object)(i + "\t" + devs.get(i) + "\t" + flowIdObj));
        }
        ci.println((Object)("\ntotal:" + num));
    }

    private void pdi(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        String ip = ci.nextArgument();
        if (ip == null || ip.equals("")) {
            wantTip = true;
        } else {
            DevChange.DevIdentify id = new DevChange.DevIdentify(ip, 0);
            PolicyQuery.DTV dtv = DevMgr.instance().getDTVByIdentify(id);
            if (dtv == null) {
                ci.println((Object)"the device is not exist now!");
                success = false;
            } else {
                List<DevConfig> cfgs = DevMgr.instance().getPersistDevCfg(id);
                DBCommonOper db = Activator.svcFactory.getDBCommonOperService();
                ci.println((Object)("device type: " + dtv.type));
                ci.println((Object)("device version: " + dtv.ver));
                for (DevConfig cfg : cfgs) {
                    String dbInfo = db.cfg2DBInfo(cfg);
                    ci.println((Object)("\tdburl: " + dbInfo));
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: pdi <ip>");
        } else {
            ci.println((Object)"success!");
        }
    }

    private synchronized void ppl(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        Map<PolicyQuery.DTV, PolicyMgr.DevPolicy> dtv2Policy = PolicyMgr.instance().getPolicy();
        for (Map.Entry<PolicyQuery.DTV, PolicyMgr.DevPolicy> e : dtv2Policy.entrySet()) {
            ci.println((Object)("neType=" + e.getKey().type + ",version=" + e.getKey().ver + ", xpathList:"));
            for (String xpath : e.getValue().xpath2Policy.keySet()) {
                ci.println((Object)("\t" + xpath));
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: ppl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ptb(CommandInterpreter ci) {
        boolean wantTip;
        boolean success;
        block23: {
            success = true;
            wantTip = false;
            try {
                String ip = ci.nextArgument();
                boolean printState = false;
                if (ip.equals("-s")) {
                    printState = true;
                    ip = ci.nextArgument();
                }
                String xpath = ci.nextArgument();
                if (ip == null || ip.equals("")) {
                    wantTip = true;
                    break block23;
                }
                try {
                    int i = Integer.parseInt(ip);
                    List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
                    if (i >= devs.size() || i < 0) {
                        ci.println((Object)("index of " + i + " illegle!, please use 'pdev' command check first."));
                        success = false;
                        break block23;
                    }
                    ip = devs.get((int)i).devIdentify.getIp();
                }
                catch (Exception e) {
                    // empty catch block
                }
                TableDesc stateTb = new TableDesc();
                stateTb.setName("tb__vmtdb_state");
                ArrayList<String> cols = new ArrayList<String>();
                ArrayList<TableDesc.ColType> cts = new ArrayList<TableDesc.ColType>();
                cols.add("state");
                cols.add("shared");
                cts.add(TableDesc.ColType.genINT32());
                cts.add(TableDesc.ColType.genINT32());
                stateTb.addCols(cols, cts);
                DevChange.DevIdentify devId = new DevChange.DevIdentify(ip, 0);
                PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
                DBCommonOper db = Activator.svcFactory.getDBCommonOperService();
                List<TableDesc> ts = null;
                if (xpath == null || xpath.equals("")) {
                    DevChange.DevInfo dev = DevMgr.instance().getDevByIPORDevID(devId);
                    ts = pq.getTableDesc(new PolicyQuery.DTV(dev.neType, dev.ver));
                } else {
                    ts = pq.getTableDesc(devId, xpath);
                }
                if (printState) {
                    ts.add(stateTb);
                }
                if (ts.size() == 0) {
                    wantTip = true;
                    ci.println((Object)"the object of xpath has not been persisted, or none has been persisted!");
                    break block23;
                }
                List<DevConfig> cfgs = DevMgr.instance().getPersistDevCfg(devId);
                for (DevConfig cfg : cfgs) {
                    ci.println((Object)("[VRID=" + cfg.getVRId() + "]"));
                    for (TableDesc tb : ts) {
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(DEBUGDIR + File.separator + tb.getName());
                            long start = System.currentTimeMillis();
                            List<RowData> rows = db.getAllRows(cfg, tb, new QueryCondition());
                            long end = System.currentTimeMillis();
                            out.write(("total: " + rows.size() + "\ttime=(" + (end - start) + "ms)\n").getBytes());
                            for (String col : tb.getAllCols()) {
                                out.write((col + "\t").getBytes());
                            }
                            out.write("\n".getBytes());
                            for (RowData rd : rows) {
                                for (String col : tb.getAllCols()) {
                                    out.write((rd.cvs.get(col) + "\t").getBytes());
                                }
                                out.write("\n".getBytes());
                            }
                        }
                        catch (Exception e) {
                            ci.printStackTrace((Throwable)e);
                            success = false;
                        }
                        finally {
                            if (out == null) continue;
                            out.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                ci.printStackTrace((Throwable)e);
                success = false;
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: ptb [-s] <ip> <xpath>");
            ci.println((Object)"\t please use pdev commond to get all device information.");
            ci.println((Object)"\t -s print DB state TB first if having this flag");
            ci.println((Object)"\t xpath is schema xpath of persisted object in pnpdir/default/cached directory.");
            ci.println((Object)"\t all data will be put to files in PWD/debug directory.");
            ci.println((Object)"\t use pwd to display the path of PWD.");
        }
    }

    private synchronized void pwd(CommandInterpreter ci) {
        ci.println((Object)System.getProperty("user.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rcdb(CommandInterpreter ci) throws Exception {
        boolean wantTip;
        boolean success;
        block30: {
            success = true;
            wantTip = false;
            String ip = ci.nextArgument();
            if (ip == null || ip.equals("")) {
                ci.println((Object)"no <ip> or <index argument.");
                wantTip = true;
            } else {
                DevChange.DevInfo dev = null;
                try {
                    int i = Integer.parseInt(ip);
                    List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
                    if (i >= devs.size() || i < 0) {
                        ci.println((Object)("index of " + i + " illegle!, please use 'pdev' command check first."));
                        success = false;
                        break block30;
                    }
                    dev = devs.get(i);
                    ip = dev.devIdentify.getIp();
                }
                catch (Exception e) {
                    dev = DevMgr.instance().getDevByIPORDevID(new DevChange.DevIdentify(ip, 0));
                }
                if (dev == null) {
                    ci.println((Object)"error, the device is not exist now!");
                    success = false;
                } else {
                    DevChange.DevIdentify devId = new DevChange.DevIdentify(ip, 0);
                    List<DevConfig> cfgs = DevMgr.instance().getPersistDevCfg(devId);
                    String dir = ci.nextArgument();
                    if (dir == null) {
                        ci.println((Object)"no input <xmldir> argument.");
                        wantTip = true;
                    } else {
                        File fdir = new File(dir);
                        File[] files = fdir.listFiles();
                        HashMap ft2fList = new HashMap();
                        for (File file : files) {
                            if (file.isDirectory()) continue;
                            String fn = file.getName();
                            String[] splitFn = fn.split("_");
                            String fetureName = splitFn[0];
                            String seq = splitFn[4];
                            seq = seq.split("\\.")[0];
                            HashMap<Integer, File> lst = (HashMap<Integer, File>)ft2fList.get(fetureName);
                            if (lst == null) {
                                lst = new HashMap<Integer, File>();
                                ft2fList.put(fetureName, lst);
                            }
                            int idx = Integer.parseInt(seq);
                            lst.put(idx - 1, file);
                        }
                        ArrayList<File> files2 = new ArrayList<File>();
                        Set entrys = ft2fList.entrySet();
                        for (Map.Entry entry : entrys) {
                            Map lst = (Map)entry.getValue();
                            int len = lst.size();
                            for (int i = 0; i < len; ++i) {
                                File f = (File)lst.get(i);
                                files2.add(f);
                            }
                        }
                        class SyncResult {
                            long devStartTime = 0L;
                            int flowId = 0;
                            boolean success = false;

                            SyncResult() {
                            }
                        }
                        HashMap<DevConfig, SyncResult> rstList = new HashMap<DevConfig, SyncResult>();
                        FileOutputStream infileList = null;
                        try {
                            File fileList = new File(DEBUGDIR + File.separator + "flist.txt");
                            infileList = new FileOutputStream(fileList);
                            HashMap<DevConfig, SyncData> cfg2Sync = new HashMap<DevConfig, SyncData>();
                            for (DevConfig cfg : cfgs) {
                                SyncData sync = Activator.svcFactory.getSyncDataService();
                                cfg2Sync.put(cfg, sync);
                                SyncResult rst = new SyncResult();
                                rstList.put(cfg, rst);
                                rst.success = sync.reNewCfgDB(cfg);
                                if (!rst.success) break;
                                rst.success = sync.syncBegin(cfg);
                                if (!rst.success) break;
                                rst.success = sync.createTable(cfg);
                                if (rst.success) continue;
                                break;
                            }
                            if (files2 != null) {
                                for (File file : files2) {
                                    if (file.isDirectory()) continue;
                                    FileInputStream in = new FileInputStream(file);
                                    infileList.write((file.getName() + "\n").getBytes());
                                    for (DevConfig cfg : cfgs) {
                                        SyncData sync = (SyncData)cfg2Sync.get(cfg);
                                        SyncResult rst = (SyncResult)rstList.get(cfg);
                                        if (!rst.success) continue;
                                        rst.success = sync.syncAllFromStream(cfg, in);
                                        if (rst.success) continue;
                                        ci.println((Object)"put data into db failed!");
                                        ci.println((Object)"please check the PNPP/default/cahced config file, make sure the name and type of the elment is correct!");
                                        success = false;
                                        AloneDeploySchedule.addDevToDevMap(dev, 0, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_FAILED);
                                    }
                                }
                            }
                            for (DevConfig cfg : cfgs) {
                                SyncResult rst = (SyncResult)rstList.get(cfg);
                                SyncData sync = (SyncData)cfg2Sync.get(cfg);
                                if (rst.success) {
                                    sync.syncEnd(cfg, rst.success, rst.flowId, rst.devStartTime);
                                    continue;
                                }
                                sync.syncEnd(cfg, rst.success, -1, -1L);
                            }
                            if (success) {
                                AloneDeploySchedule.addDevToDevMap(dev, 0, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK);
                            } else {
                                AloneDeploySchedule.addDevToDevMap(dev, 0, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_FAILED);
                            }
                        }
                        catch (Exception e) {
                            ci.printStackTrace((Throwable)e);
                            success = false;
                        }
                        finally {
                            if (infileList != null) {
                                infileList.close();
                            }
                        }
                        if (success) {
                            AloneDeploySchedule.addDevToDevMap(dev, 1, AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK);
                        }
                    }
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: rcdb < <ip> | <index> > <xmldir>");
            ci.println((Object)"\t ip is the ne you want to get from.");
            ci.println((Object)"\t index is the number returned by 'pdev' commond.");
            ci.println((Object)"\t xmldir contains the full syncdata XML files.");
            ci.println((Object)"\t\t NOTE: dir can't contains subdir and dirName must not contain space!");
        }
    }

    private synchronized void rcNdb(CommandInterpreter ci) throws Exception {
        boolean wantTip;
        boolean success;
        block17: {
            String[] range;
            success = true;
            wantTip = false;
            String rangeStr = ci.nextArgument();
            if (rangeStr != null && (range = rangeStr.split("-")).length == 2) {
                int first = 0;
                int second = 0;
                try {
                    first = Integer.parseInt(range[0]);
                    second = Integer.parseInt(range[1]);
                }
                catch (Exception e) {
                    success = false;
                    break block17;
                }
                final String dir = ci.nextArgument();
                if (dir == null) {
                    ci.println((Object)"no input <xmldir> argument.");
                    wantTip = true;
                } else {
                    int threadNum = 1;
                    String threadNumStr = ci.nextArgument();
                    if (threadNumStr != null) {
                        try {
                            threadNum = Integer.parseInt(threadNumStr);
                        }
                        catch (Exception e) {
                            ci.println((Object)"<threadNum> argument must be number.");
                            wantTip = true;
                            break block17;
                        }
                        if (threadNum <= 0) {
                            ci.println((Object)"<threadNum> argument must be >0 .");
                            wantTip = true;
                        }
                    }
                    long t1 = System.currentTimeMillis();
                    class RCDBThread
                    extends Thread {
                        CommandInterpreter ci;
                        int first;
                        int idxThread;
                        int numThread;
                        PlnNum plnNum;
                        int second;

                        RCDBThread(PlnNum plnNum, CommandInterpreter ci, int first, int second, int numThread, int idxThread) {
                            this.numThread = numThread;
                            this.idxThread = idxThread;
                            this.first = first;
                            this.second = second;
                            this.ci = ci;
                            class PlnNum {
                                private CommandInterpreter ci;
                                private volatile int i = 0;

                                public PlnNum(CommandInterpreter ci) {
                                    this.ci = ci;
                                }

                                public synchronized void p(String str) {
                                    if (this.i != 0 && this.i % 5 == 0) {
                                        this.ci.print((Object)"\n");
                                    }
                                    this.ci.print((Object)str);
                                    ++this.i;
                                }
                            }
                            this.plnNum = plnNum;
                            this.setName("Persist_RCDBThread_" + idxThread);
                        }

                        @Override
                        public void run() {
                            long t1;
                            long t2 = t1 = System.currentTimeMillis();
                            int i = 0;
                            for (int devIdx = this.idxThread + this.first; devIdx < this.second; devIdx += this.numThread) {
                                SimpleCmdArg arg = new SimpleCmdArg(this.ci);
                                arg.args.add(Integer.toString(devIdx));
                                arg.args.add(dir);
                                try {
                                    PersistCmd.this.rcdb(arg);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    System.err.println("rcdb failed! idxThread=" + this.idxThread + ",idxDev=" + devIdx);
                                }
                                if ((i + 1) % 10 == 0 || devIdx + this.numThread >= this.second) {
                                    t2 = System.currentTimeMillis();
                                    this.plnNum.p("[th" + this.idxThread + ":" + (i + 1) + "=" + (t2 - t1) + "]");
                                    t1 = t2;
                                }
                                ++i;
                            }
                        }
                    }
                    ArrayList<RCDBThread> ths = new ArrayList<RCDBThread>();
                    PlnNum plnNum = new PlnNum(ci);
                    for (int i = 0; i < threadNum; ++i) {
                        RCDBThread th = new RCDBThread(plnNum, ci, first, second, threadNum, i);
                        th.start();
                        ths.add(th);
                    }
                    while (ths.size() != 0) {
                        ArrayList<Thread> intThs = new ArrayList<Thread>();
                        for (Thread thread : ths) {
                            try {
                                thread.join();
                            }
                            catch (InterruptedException e) {
                                ci.println((Object)("join " + thread.getName() + " failed! try again later!"));
                                intThs.add(thread);
                            }
                        }
                        ths = intThs;
                    }
                    long t2 = System.currentTimeMillis();
                    ci.println();
                    ci.println((Object)("total : " + (second - first)));
                    ci.println((Object)("total time is: " + (t2 - t1) / 1000L + "s"));
                    ci.println((Object)("per   time is: " + (t2 - t1) / (long)(second - first) + "ms"));
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: rcNdb <ip> <xmldir> <threadNum>");
        } else {
            ci.println((Object)"success!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rpc(CommandInterpreter ci) {
        boolean wantTip;
        boolean success;
        block35: {
            success = true;
            wantTip = false;
            ISession session = null;
            FileOutputStream replyOut = null;
            FileInputStream reqIn = null;
            try {
                String ip = ci.nextArgument();
                if (ip == null || ip.equals("")) {
                    wantTip = true;
                    break block35;
                }
                try {
                    int i = Integer.parseInt(ip);
                    List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
                    if (i >= devs.size() || i < 0) {
                        ci.println((Object)("index of " + i + " illegle!, please use 'pdev' command check first."));
                        success = false;
                        break block35;
                    }
                    ip = devs.get((int)i).devIdentify.getIp();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String to = ci.nextArgument();
                int timeout = 0;
                try {
                    timeout = Integer.parseInt(to);
                }
                catch (Exception e) {
                    ci.println((Object)"timeout argument has wrong format, please use digital!");
                    success = false;
                    break block35;
                }
                final long rpcTimeout = timeout;
                String attrArg = ci.nextArgument();
                if (attrArg == null) {
                    attrArg = "";
                }
                final String attrText = attrArg;
                CommunicateArg arg = CommunicationArgumentMgr.getCommunicateArg((String)ip);
                if (arg == null) {
                    ci.println((Object)"you must open the nemgr of the ne first.");
                    success = false;
                } else {
                    reqIn = new FileInputStream(DEBUGDIR + File.separator + "rpc.xml");
                    ByteArrayOutputStream out = new ByteArrayOutputStream(reqIn.available());
                    FileCopyUtils.copy((InputStream)reqIn, (OutputStream)out);
                    final String rpcStr = out.toString();
                    IRpc rpcPkg = new IRpc(){

                        public boolean capable(NetconfAbility abilityVolumn) {
                            return false;
                        }

                        public String getContent() {
                            return null;
                        }

                        public Integer getLrID() {
                            return null;
                        }

                        public long getTimeout() {
                            return 1000L * rpcTimeout;
                        }

                        public Integer getVrID() {
                            return null;
                        }

                        public boolean isKeepAlive() {
                            return false;
                        }

                        public void setKeepAlive(boolean keepAlive) {
                        }

                        public void setTimeout(long timeout) {
                        }

                        public String toCommand(int messageID) throws NetconfException {
                            return "<rpc message-id=\"" + messageID + " " + attrText + " \" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">" + rpcStr + "</rpc>";
                        }

                        public String toLogCommand(int messageID) throws NetconfException {
                            return this.toCommand(messageID);
                        }
                    };
                    session = SessionPool.getSession((String)Thread.currentThread().getName(), (CommunicateArg)arg, (boolean)false, null);
                    if (session == null) {
                        ci.println((Object)"get netconf session failed!");
                        ci.println((Object)"the possible reasons:");
                        ci.println((Object)"\t1. the ne has not been added to VMT.");
                        ci.println((Object)"\t2. the nemgr of the ne has not been opened.");
                        ci.println((Object)"\t3. the communicate argument maybe wrong.");
                        success = false;
                    } else {
                        long start = System.currentTimeMillis();
                        IRpcReply reply = session.synSend(rpcPkg);
                        long end = System.currentTimeMillis();
                        if (reply.getErrorInfos() == null) {
                            int msgId = reply.getMessageID();
                            Integer followId = reply.getFlowID();
                            Integer lrId = reply.getLrID();
                            Integer vrId = reply.getVrID();
                            Integer setId = reply.getSetID();
                            String r = reply.getContent();
                            if (r == null) {
                                r = "<ok/>";
                            }
                            replyOut = new FileOutputStream(DEBUGDIR + File.separator + "reply.xml");
                            replyOut.write(("msgId=" + msgId + "\n").getBytes());
                            if (followId != null) {
                                replyOut.write(("followId=" + followId + "\n").getBytes());
                            }
                            if (lrId != null) {
                                replyOut.write(("lrId=" + lrId + "\n").getBytes());
                            }
                            if (vrId != null) {
                                replyOut.write(("vrId=" + vrId + "\n").getBytes());
                            }
                            if (setId != null) {
                                replyOut.write(("setId=" + setId + "\n").getBytes());
                            }
                            FileCopyUtils.copy((InputStream)new ByteArrayInputStream(r.getBytes()), (OutputStream)replyOut);
                            ci.println((Object)("execute successed! time=" + (end - start) + " ms"));
                        } else {
                            System.err.println("ERROR! " + (end - start) + " ms");
                            for (RpcErrorInfo err : reply.getErrorInfos()) {
                                System.err.println("\t" + err.getErrMsg());
                            }
                            System.err.println("\nplease check the rpc package!");
                        }
                    }
                }
            }
            catch (Exception e) {
                ci.printStackTrace((Throwable)e);
                success = false;
            }
            finally {
                try {
                    if (session != null) {
                        SessionPool.releaseSession(session);
                    }
                    if (replyOut != null) {
                        replyOut.close();
                    }
                    if (reqIn != null) {
                        reqIn.close();
                    }
                }
                catch (Exception e) {
                    ci.printStackTrace((Throwable)e);
                    success = false;
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: rpc < <ip> | <index> > <timeout> [<rpcAttrString>]");
            ci.println((Object)"\t ip is the ne you want to rpc.");
            ci.println((Object)"\t index is the number returned by 'pdev' commond.");
            ci.println((Object)"\t unit of timeout is second.");
            ci.println((Object)"\t rpcAttrString is rpc attribute and value, example:");
            ci.println((Object)"\t\t hwcontext=\"\"\n");
            ci.println((Object)"\t rpc package must be at rpc.xml.");
            ci.println((Object)"\t\t the infomation of operator and content level should be filled");
            ci.println((Object)"\t\t the info of rpc should not be filled!!!\n");
            ci.println((Object)"\t reply is been put at reply.xml");
            ci.println((Object)"\n\t rpc.xml and reply.xml must be at PWD/debug directory!");
            ci.println((Object)"\t use pwd to see the PWD directory.");
        }
    }

    private synchronized void rpl(CommandInterpreter ci) throws Exception {
        PolicyMgr.instance().refreshPolicy();
    }

    private void sps(CommandInterpreter ci) {
        boolean wantTip;
        boolean success;
        block9: {
            success = true;
            wantTip = false;
            String szStr = ci.nextArgument();
            if (szStr == null || szStr.equals("")) {
                wantTip = true;
            } else {
                int sz = 0;
                try {
                    sz = Integer.parseInt(szStr);
                }
                catch (Exception e) {
                    wantTip = true;
                    break block9;
                }
                if (sz <= 0) {
                    wantTip = true;
                } else {
                    ConnectionPoolMgr.instance().setPoolSize(sz);
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: sps <size>");
            ci.println((Object)"\tsize: must be >0");
        } else {
            ci.println((Object)"success!");
        }
    }

    private synchronized void stprt(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        class StopThread {
            StopThread() {
            }

            boolean s(List<TestThread> threads, CommandInterpreter ci) {
                for (TestThread rtestThread : threads) {
                    rtestThread.q = true;
                }
                ArrayList<TestThread> toJoinThreads = new ArrayList<TestThread>(threads);
                ArrayList<TestThread> interThreads = new ArrayList<TestThread>();
                while (true) {
                    for (TestThread rtestThread : toJoinThreads) {
                        try {
                            rtestThread.join(5000L);
                            Thread.State state = rtestThread.getState();
                            if (state != Thread.State.TERMINATED) {
                                ci.println((Object)("stop " + rtestThread.getName() + " failed! state=" + (Object)((Object)state)));
                                interThreads.add(rtestThread);
                                continue;
                            }
                            ci.println((Object)("stop " + rtestThread.getName() + " success!"));
                        }
                        catch (InterruptedException e) {
                            interThreads.add(rtestThread);
                            ci.println((Object)("interrupted while stopping " + rtestThread.getName() + "!"));
                        }
                    }
                    if (interThreads.size() == 0) break;
                    ci.println((Object)"stop test threads again!");
                    toJoinThreads = interThreads;
                    interThreads = new ArrayList();
                }
                threads.clear();
                if (interThreads.size() == 0) {
                    return true;
                }
                ci.println((Object)"stop same thread failed!");
                ci.println((Object)"you should use reexcecute again!");
                return false;
            }
        }
        if (new StopThread().s(this.rtestThreadsQuery, ci)) {
            ci.println((Object)"stop all query thread success!");
        }
        if (new StopThread().s(this.rtestThreadsRcDb, ci)) {
            ci.println((Object)"stop all rcdb thread success!");
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: stprt <time>");
            ci.println((Object)"\ttime: every thread wait [time] at most to stop!");
            ci.println((Object)"\t\tunit is second");
            ci.println((Object)"\t\tthe default value is 5");
        }
    }

    private synchronized void stpsync(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        Stub.instance().stopAllThread();
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: stpsync");
        }
    }

    private synchronized void pss(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        boolean force = false;
        String forceArg = ci.nextArgument();
        if (forceArg != null && forceArg.equals("force")) {
            force = true;
        }
        long persit_start = System.currentTimeMillis();
        DBCommonOper db = Activator.svcFactory.getDBCommonOperService();
        boolean ret = db.persistAll(force, false);
        long persit_end = System.currentTimeMillis();
        if (ret) {
            ci.println((Object)"\tsuccess!");
        } else {
            ci.println((Object)"\tfailed!");
        }
        ci.println((Object)("\npersist action comsume time " + (persit_end - persit_start) / 1000L + " seconds"));
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: pss [force]");
            ci.println((Object)"\tforce : force to persist data.");
            ci.println((Object)"\t\tdefault is not force.");
        }
    }

    private synchronized void sttrt(CommandInterpreter ci) {
        boolean wantTip;
        boolean success;
        block13: {
            success = true;
            wantTip = false;
            if (this.rtestThreadsQuery.size() != 0) {
                ci.println((Object)"you must use stprt command first to stop all querytest thread!");
                ci.println((Object)("the following test query threads(" + this.rtestThreadsQuery.size() + ") is running!"));
                for (TestThread th : this.rtestThreadsQuery) {
                    ci.println((Object)th.getName());
                }
            } else if (this.rtestThreadsRcDb.size() != 0) {
                ci.println((Object)"you must use stprt command first to stop all rcdbtest thread!");
                ci.println((Object)("the following test rcdb threads(" + this.rtestThreadsRcDb.size() + ") is running!"));
                for (TestThread th : this.rtestThreadsRcDb) {
                    ci.println((Object)th.getName());
                }
            } else {
                String numThreadStr = ci.nextArgument();
                if (numThreadStr == null || numThreadStr.equals("")) {
                    wantTip = true;
                } else {
                    int numThread = 0;
                    try {
                        numThread = Integer.parseInt(numThreadStr);
                    }
                    catch (Exception e) {
                        ci.println((Object)"num ARG error!");
                        wantTip = true;
                        break block13;
                    }
                    for (int i = 0; i < numThread; ++i) {
                        QueryTestThread rtestThread = new QueryTestThread(ci);
                        rtestThread.setName("Persist_Radom_QueryTest_" + i);
                        rtestThread.start();
                        this.rtestThreadsQuery.add(rtestThread);
                        RcDbTestThread rt = new RcDbTestThread(ci);
                        rt.setName("Persist_Radom_RcDbTest_" + i);
                        rt.start();
                        this.rtestThreadsRcDb.add(rt);
                    }
                }
            }
        }
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: sttrt <num>");
            ci.println((Object)"\tnum: test Thread number, must >0");
        }
    }

    private synchronized void sttsync(CommandInterpreter ci) {
        boolean success = true;
        boolean wantTip = false;
        Stub.instance().startAllThread();
        if (!success || wantTip) {
            if (!success) {
                ci.println((Object)"execute commond failed!\n");
            }
            ci.println((Object)"USAGE: sttsync");
        }
    }

    private abstract class TestThread
    extends Thread {
        protected final CommandInterpreter ci;
        protected volatile boolean q = false;

        public TestThread(CommandInterpreter ci) {
            this.ci = ci;
        }

        @Override
        public void run() {
            while (!this.q) {
                this.process();
            }
        }

        protected abstract void process();
    }

    private static class SimpleCmdArg
    implements CommandInterpreter {
        public List<String> args = new ArrayList<String>();
        public int nextIdx = 0;
        final CommandInterpreter ci;

        public SimpleCmdArg(CommandInterpreter ci) {
            this.ci = ci;
        }

        public Object execute(String arg0) {
            return null;
        }

        public String nextArgument() {
            if (this.nextIdx < this.args.size()) {
                return this.args.get(this.nextIdx++);
            }
            return null;
        }

        public void print(Object arg0) {
            this.ci.print(arg0);
        }

        public void printBundleResource(Bundle arg0, String arg1) {
            this.ci.printBundleResource(arg0, arg1);
        }

        public void printDictionary(Dictionary arg0, String arg1) {
            this.ci.printDictionary(arg0, arg1);
        }

        public void println() {
            this.ci.println();
        }

        public void println(Object arg0) {
            this.ci.println(arg0);
        }

        public void printStackTrace(Throwable arg0) {
            this.ci.printStackTrace(arg0);
        }
    }

    private class RcDbTestThread
    extends TestThread {
        Random random;

        public RcDbTestThread(CommandInterpreter ci) {
            super(ci);
            this.random = new Random();
        }

        @Override
        protected void process() {
            List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
            int num = devs.size();
            int i = this.random.nextInt();
            i = Math.abs(i);
            DevChange.DevInfo dev = devs.get(i %= num);
            SimpleCmdArg arg = new SimpleCmdArg(this.ci);
            arg.args.add("" + i);
            arg.args.add(PersistCmd.DEBUGDIR + File.separator + "ne5k_v8r6c00");
            try {
                PersistCmd.this.rcdb(arg);
                this.ci.println((Object)("rcdb(" + dev.devIdentify + ")"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class QueryTestThread
    extends TestThread {
        Random random;

        public QueryTestThread(CommandInterpreter ci) {
            super(ci);
            this.random = new Random();
        }

        @Override
        protected void process() {
            List<DevChange.DevInfo> devs = DevMgr.instance().getAllDev();
            if (devs.size() == 0) {
                return;
            }
            DBCommonOper db = Activator.svcFactory.getDBCommonOperService();
            PolicyQuery pq = Activator.svcFactory.getPolicyQueryService();
            int i = Math.abs(this.random.nextInt());
            DevChange.DevInfo dev = devs.get(i % devs.size());
            AloneDeploySchedule.DevMapInfo mInfo = AloneDeploySchedule.mDevAll.get(dev);
            if (mInfo == null || mInfo.getSyncStatus() != AloneDeploySchedule.SYNC_STATUS_ENUM.SYNC_OK.intValue()) {
                return;
            }
            List<DevConfig> cfgs = DevMgr.instance().getPersistDevCfg(dev.devIdentify);
            List<TableDesc> tbs = pq.getTableDesc(new PolicyQuery.DTV(dev.neType, dev.ver));
            for (DevConfig cfg : cfgs) {
                try {
                    for (TableDesc tb : tbs) {
                        db.getAllRows(cfg, tb, new QueryCondition());
                        if (!this.q) continue;
                        break;
                    }
                    this.ci.println((Object)("query(" + dev.devIdentify + ")"));
                }
                catch (Exception e) {
                    this.ci.printStackTrace((Throwable)e);
                }
                if (!this.q) continue;
                break;
            }
        }
    }
}

