/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.persistence;

import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.persistence.devmgr.DevMgr;
import com.huawei.vmf.qat.persistence.devmgr.PolicyMgr;
import com.huawei.vmf.qat.persistence.service.DBCommonOper;
import com.huawei.vmf.qat.persistence.service.ServiceFactory;
import com.huawei.vmf.qat.persistence.service.impl.ConnectionPoolMgr;
import com.huawei.vmf.qat.persistence.service.impl.DBCommonOper1Cfg1DB;
import com.huawei.vmf.qat.persistence.service.impl.DBStateMgr;
import com.huawei.vmf.qat.persistence.service.impl.PolicyQuery1Cfg1DB;
import com.huawei.vmf.qat.persistence.service.impl.ServiceFactoryImpl;
import com.huawei.vmf.qat.persistence.syncdata.RDScan;
import com.huawei.vmf.qat.persistence.syncdata.SyncDataImpl;
import com.huawei.vmf.qat.persistence.syncdata.alone.AloneDeploySchedule;
import com.huawei.vmf.qat.persistence.syncdata.alone.GetSerialNumTask;
import com.huawei.vmf.qat.persistence.syncdata.alone.Stub;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;

public class Activator
implements BundleActivator {
    public static BundleContext ctx;
    public static ServiceFactoryImpl svcFactory;
    private static ServiceRegistration svcFactoryReg;
    private static ServiceRegistration debugSvcReg;
    private Logger logger = RunLogger.getRunLogger();

    public static void main(String[] args) throws Exception {
        System.setProperty("deploymentMode", "independent");
        AloneDeploySchedule.isAutoStartThread = false;
        ArrayList<Class> testAll = new ArrayList<Class>();
        testAll.add(PolicyQuery1Cfg1DB.class);
        testAll.add(PolicyMgr.class);
        testAll.add(ConnectionPoolMgr.class);
        testAll.add(DBCommonOper1Cfg1DB.class);
        testAll.add(RDScan.class);
        testAll.add(SyncDataImpl.class);
        testAll.add(GetSerialNumTask.class);
        testAll.add(DBStateMgr.class);
        for (Class clz : testAll) {
            Method m = clz.getMethod("main", String[].class);
            if (m == null) continue;
            Object[] as = new Object[]{null};
            m.invoke(null, as);
        }
        Stub.instance().stopAllThread();
        try {
            assert (false);
            System.out.println("please add -ea option to VM argument!");
        }
        catch (Throwable e) {
            System.out.println("all success!");
        }
    }

    public void start(BundleContext context) throws Exception {
        ctx = context;
        PolicyMgr.instance();
        DevMgr.instance();
        try {
            Object debugCmd = Class.forName("com.huawei.vmf.qat.persistence.debug.PersistCmd").newInstance();
            debugSvcReg = context.registerService(CommandProvider.class.getName(), debugCmd, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        DBCommonOper1Cfg1DB db = new DBCommonOper1Cfg1DB();
        db.delShadowDB();
        svcFactoryReg = context.registerService(ServiceFactory.class.getName(), (Object)svcFactory, null);
        this.logger.info("persistence bundler started!");
    }

    public void stop(BundleContext context) throws Exception {
        svcFactoryReg.unregister();
        if (debugSvcReg != null) {
            debugSvcReg.unregister();
        }
        Stub.instance().stopAllThread();
        this.persistDB();
    }

    private void persistDB() {
        DBCommonOper db = svcFactory.getDBCommonOperService();
        int times = 10;
        boolean r = false;
        while (!(r = db.persistAll(false, true))) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (--times > 0) continue;
        }
        if (!r) {
            String warnMsg = "\npersistence bunlde use force close db style to stop!\nthere maybe some non-consist db!\n";
            this.logger.warn(warnMsg);
            r = db.persistAll(true, true);
        }
        if (!r) {
            this.logger.warn("persist all db failed!!!");
            ConnectionPoolMgr.instance().logConPoolInfo();
        }
        this.logger.info("right! persistence bundler stopped success!");
    }

    static {
        svcFactory = new ServiceFactoryImpl();
        debugSvcReg = null;
    }
}

